/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.codecoverage.ui.internal.launch;

import com.ibm.debug.pdt.codecoverage.internal.core.CCUtilities;
import com.ibm.debug.pdt.codecoverage.ui.internal.launch.CodeCoverageLastAction;
import com.ibm.debug.pdt.codecoverage.ui.internal.launch.Labels;
import java.util.Map;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.common.NotDefinedException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.contexts.DebugContextEvent;
import org.eclipse.debug.ui.contexts.IDebugContextListener;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.commands.IElementUpdater;
import org.eclipse.ui.menus.UIElement;

public class CodeCoverageLastHandler
extends AbstractHandler
implements IElementUpdater,
IPropertyChangeListener,
IDebugContextListener {
    private static final CodeCoverageLastAction fAction = new CodeCoverageLastAction();
    private static final String COMMAND_ID = "com.ibm.debug.pdt.commands.CodeCoverageLast";

    public CodeCoverageLastHandler() {
        DebugUITools.getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this);
        DebugUITools.getDebugContextManager().addDebugContextListener((IDebugContextListener)this);
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        fAction.run(null);
        return null;
    }

    public void updateElement(final UIElement element, Map arg1) {
        IWorkbench workbench = PlatformUI.getWorkbench();
        ICommandService commandService = (ICommandService)workbench.getService(ICommandService.class);
        if (commandService == null) {
            return;
        }
        Command command = commandService.getCommand(COMMAND_ID);
        String newDescription = fAction.getDescription();
        try {
            if (!command.getDescription().equals(newDescription)) {
                command.define(command.getName(), newDescription, command.getCategory());
            }
        }
        catch (NotDefinedException e) {
            CCUtilities.log((Throwable)e);
        }
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                element.setTooltip(CodeCoverageLastHandler.this.getTooltipText());
                element.setText(fAction.getText());
            }
        });
    }

    private String getTooltipText() {
        String launchName = "";
        ILaunchConfiguration config = DebugUIPlugin.getDefault().getLaunchConfigurationManager().getFilteredLastLaunch("com.ibm.debug.launch.pdt.coverage");
        if (config != null) {
            launchName = config.getName();
        }
        String label = Labels.COMPILED_CODE_COVERAGE;
        if (launchName == null || launchName.trim().length() <= 0) {
            launchName = "";
        }
        return NLS.bind((String)Labels.CodeCoverageHistoryAction_0, (Object)label, (Object)launchName);
    }

    private void update() {
        IWorkbench workbench = PlatformUI.getWorkbench();
        ICommandService commandService = (ICommandService)workbench.getService(ICommandService.class);
        if (commandService != null) {
            Command command = commandService.getCommand(COMMAND_ID);
            commandService.refreshElements(command.getId(), null);
        }
    }

    public void propertyChange(PropertyChangeEvent event) {
        this.update();
    }

    public void debugContextChanged(DebugContextEvent event) {
        this.update();
    }

    public void dispose() {
        super.dispose();
        fAction.dispose();
        DebugUITools.getPreferenceStore().removePropertyChangeListener((IPropertyChangeListener)this);
        DebugUITools.getDebugContextManager().removeDebugContextListener((IDebugContextListener)this);
    }
}

