/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.codecoverage.ui.internal.launch;

import com.ibm.debug.pdt.codecoverage.core.results.ICCConstants;
import com.ibm.debug.pdt.codecoverage.internal.core.CCParams;
import com.ibm.debug.pdt.codecoverage.internal.core.Messages;
import com.ibm.debug.pdt.codecoverage.internal.core.utilities.CCCoreUtilities;
import com.ibm.debug.pdt.codecoverage.internal.core.utilities.CCStartupKeyGenerator;
import com.ibm.debug.pdt.codecoverage.internal.ui.resultsview.dialog.CCFilterEditDialog;
import com.ibm.debug.pdt.codecoverage.ui.internal.launch.CCResultsViewUtils;
import com.ibm.debug.pdt.codecoverage.ui.internal.launch.CodeCoverageCompositeListener;
import com.ibm.debug.pdt.codecoverage.ui.internal.launch.Labels;
import com.ibm.debug.pdt.internal.ui.AbstractDebugComposite;
import com.ibm.ftt.ui.rse.utils.RSESelectRemoteFolderDialog;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.osgi.util.NLS;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFile;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class CodeCoverageComposite
extends AbstractDebugComposite
implements SelectionListener,
ModifyListener {
    private static final boolean fIsPDFReportSupported = Platform.getBundle((String)"com.ibm.commoncomponents.codecoverage.core.exporters") != null;
    private final CodeCoverageCompositeListener fListener;
    protected String fLineFilterLabel;
    protected String fFunctionFilterLabel;
    protected Button fLineFilterButton;
    protected Button fFunctionFilterButton;
    protected Button fIgnoreErrors;
    protected Button fGenPDF;
    protected Label fRootLabel;
    protected Text fRootText;
    protected Button fRootBrowseRemoteButton;
    protected Button fRootBrowseWorkspaceButton;
    protected Button fFilterListBrowseButton;
    protected Button fFilterListCheckBox;
    protected Button fFilterListEditButton;
    protected Text fTestCaseText;
    protected Text fTagText;
    protected Text fFilterListField;
    protected Label fTagLabel;
    protected Label fTestLabel;
    protected Composite fOptionsComposite;
    protected Group fAdditionalGroup;
    protected Group fCoverageLevelGroup;
    private String fErrorMessage;
    private String fWarningMessage;
    private boolean fEnableEditFilter = true;
    private boolean fShowFilterList = true;
    protected final CCStartupKeyGenerator fGenerator = new CCStartupKeyGenerator();

    public CodeCoverageComposite(Composite parent, int style, CodeCoverageCompositeListener listener) {
        this(parent, style, listener, false);
    }

    public CodeCoverageComposite(Composite parent, int style, CodeCoverageCompositeListener listener, boolean overrideEnhancedCC) {
        super(parent, style);
        GridLayoutFactory.fillDefaults().applyTo((Composite)this);
        this.fListener = listener;
        this.initializeLabels();
        this.createCoverageLevelGroup();
        this.createOptionsGroup();
    }

    public CodeCoverageComposite(Composite parent, int style, CodeCoverageCompositeListener listener, boolean editFilter, boolean isNewPropertyGroup) {
        super(parent, style);
        this.fEnableEditFilter = editFilter;
        this.fShowFilterList = isNewPropertyGroup;
        GridLayoutFactory.fillDefaults().applyTo((Composite)this);
        this.fListener = listener;
        this.initializeLabels();
        this.createCoverageLevelGroup();
        this.createOptionsGroup();
    }

    protected void initializeLabels() {
        this.fLineFilterLabel = Labels.CodeCoverageTab_linel_level;
        this.fFunctionFilterLabel = Labels.CodeCoverageTab_function_level;
    }

    protected Composite createCoverageLevelGroup() {
        this.fCoverageLevelGroup = new Group((Composite)this, 0);
        this.fCoverageLevelGroup.setText(Labels.CodeCoverageTab_codeCoverageLevel);
        this.fCoverageLevelGroup.setLayout((Layout)new GridLayout(3, false));
        this.fCoverageLevelGroup.setLayoutData((Object)new GridData(4, 0, true, false));
        this.fLineFilterButton = new Button((Composite)this.fCoverageLevelGroup, 16);
        GridDataFactory.swtDefaults().span(3, 1).applyTo((Control)this.fLineFilterButton);
        this.fLineFilterButton.setText(this.fLineFilterLabel);
        this.fLineFilterButton.addSelectionListener((SelectionListener)this);
        this.fLineFilterButton.setSelection(true);
        this.fFunctionFilterButton = new Button((Composite)this.fCoverageLevelGroup, 16);
        GridDataFactory.swtDefaults().span(3, 1).applyTo((Control)this.fFunctionFilterButton);
        this.fFunctionFilterButton.setText(this.fFunctionFilterLabel);
        this.fFunctionFilterButton.addSelectionListener((SelectionListener)this);
        return this.fCoverageLevelGroup;
    }

    protected void createOptionsGroup() {
        this.fOptionsComposite = new Composite((Composite)this, 0);
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(this.fOptionsComposite);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.fOptionsComposite);
        this.createAdditionalOptions(this.fOptionsComposite);
    }

    protected void createAdditionalOptions(Composite codeCoverageLaunchPageComposite) {
        this.fAdditionalGroup = new Group(codeCoverageLaunchPageComposite, 0);
        this.fAdditionalGroup.setText(Labels.Additional);
        int numCols = this.fEnableEditFilter ? 4 : 3;
        GridLayoutFactory.swtDefaults().numColumns(numCols).applyTo((Composite)this.fAdditionalGroup);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.fAdditionalGroup);
        this.fIgnoreErrors = new Button((Composite)this.fAdditionalGroup, 32);
        this.fIgnoreErrors.setText(Labels.Ignore_errors);
        this.fIgnoreErrors.addSelectionListener((SelectionListener)this);
        GridDataFactory.fillDefaults().span(numCols, 1).applyTo((Control)this.fIgnoreErrors);
        this.fGenPDF = new Button((Composite)this.fAdditionalGroup, 32);
        this.fGenPDF.setText(Labels.Generate_PDF);
        this.fGenPDF.addSelectionListener((SelectionListener)this);
        this.fGenPDF.setEnabled(fIsPDFReportSupported);
        GridDataFactory.fillDefaults().span(4, 1).applyTo((Control)this.fGenPDF);
        if (this.fShowFilterList) {
            this.fFilterListCheckBox = new Button((Composite)this.fAdditionalGroup, 32);
            GridDataFactory.swtDefaults().applyTo((Control)this.fFilterListCheckBox);
            this.fFilterListCheckBox.setText(Labels.CodeCoverageFilterList);
            this.fFilterListCheckBox.addSelectionListener((SelectionListener)this);
            this.fFilterListField = new Text((Composite)this.fAdditionalGroup, 2052);
            this.fFilterListField.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
            this.fFilterListField.setToolTipText(Labels.CodeCoverageFilterListTooltip);
            this.fFilterListField.setEnabled(this.fFilterListCheckBox.getSelection());
            this.fFilterListField.addModifyListener((ModifyListener)this);
            this.fFilterListBrowseButton = new Button((Composite)this.fAdditionalGroup, 8);
            this.fFilterListBrowseButton.setText(Labels.CodeCoverageTab_browseButton);
            this.fFilterListBrowseButton.setEnabled(this.fFilterListCheckBox.getSelection());
            this.fFilterListBrowseButton.addSelectionListener((SelectionListener)this);
            GridDataFactory.fillDefaults().applyTo((Control)this.fFilterListBrowseButton);
            if (this.fEnableEditFilter) {
                this.fFilterListEditButton = new Button((Composite)this.fAdditionalGroup, 8);
                this.fFilterListEditButton.setText(Labels.CoverageFilter_Edit_button);
                this.fFilterListEditButton.setEnabled(this.enableEditFilterButton());
                this.fFilterListEditButton.addSelectionListener((SelectionListener)this);
                GridDataFactory.fillDefaults().applyTo((Control)this.fFilterListEditButton);
            }
        }
        if (this.fEnableEditFilter) {
            this.fRootLabel = new Label((Composite)this.fAdditionalGroup, 0);
            this.fRootLabel.setText(Labels.CodeCoverageRoot);
            this.fRootText = new Text((Composite)this.fAdditionalGroup, 2048);
            this.fRootText.setToolTipText(Labels.CodeCoverageRootTooltip);
            this.fRootText.addModifyListener((ModifyListener)this);
            GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.fRootText);
            this.fRootBrowseWorkspaceButton = new Button((Composite)this.fAdditionalGroup, 8);
            this.fRootBrowseWorkspaceButton.setText(Labels.CodeCoverageTab_browseWorkspaceButton);
            this.fRootBrowseWorkspaceButton.addSelectionListener((SelectionListener)this);
            GridDataFactory.fillDefaults().applyTo((Control)this.fRootBrowseWorkspaceButton);
            this.fRootBrowseRemoteButton = new Button((Composite)this.fAdditionalGroup, 8);
            this.fRootBrowseRemoteButton.setText(Labels.CodeCoverageTab_browseRemoteButton);
            this.fRootBrowseRemoteButton.addSelectionListener((SelectionListener)this);
            GridDataFactory.fillDefaults().applyTo((Control)this.fRootBrowseRemoteButton);
        }
        this.fTestLabel = new Label((Composite)this.fAdditionalGroup, 0);
        this.fTestLabel.setText(Labels.TestCaseID);
        this.fTestCaseText = new Text((Composite)this.fAdditionalGroup, 2048);
        GridDataFactory.fillDefaults().grab(true, false).span(numCols - 1, 1).applyTo((Control)this.fTestCaseText);
        this.fTestCaseText.addModifyListener((ModifyListener)this);
        this.fTagLabel = new Label((Composite)this.fAdditionalGroup, 0);
        this.fTagLabel.setText(Labels.Tags);
        this.fTagText = new Text((Composite)this.fAdditionalGroup, 2048);
        GridDataFactory.fillDefaults().grab(true, false).span(numCols - 1, 1).applyTo((Control)this.fTagText);
        this.fTagText.addModifyListener((ModifyListener)this);
    }

    protected void enableFields() {
        if (this.fShowFilterList) {
            boolean isFilterListChecked = this.fFilterListCheckBox.getSelection();
            this.fFilterListField.setEnabled(isFilterListChecked);
            this.fFilterListBrowseButton.setEnabled(isFilterListChecked);
            if (this.fEnableEditFilter) {
                this.fFilterListEditButton.setEnabled(this.enableEditFilterButton());
            }
        }
        if (this.fEnableEditFilter) {
            this.fRootLabel.setEnabled(true);
            this.fRootText.setEnabled(true);
            this.fRootBrowseRemoteButton.setEnabled(true);
            this.fRootBrowseWorkspaceButton.setEnabled(true);
        }
    }

    private boolean enableEditFilterButton() {
        if (this.fFilterListCheckBox != null && this.fFilterListCheckBox.getSelection()) {
            return this.isValidfilterListFile();
        }
        return false;
    }

    private boolean isValidfilterListFile() {
        String filePath = this.fFilterListField.getText();
        String validFilePath = "(\\/([^/]*))+.txt";
        String operSys = System.getProperty("os.name");
        if (operSys.toLowerCase().contains("win")) {
            validFilePath = "([a-zA-Z]:)(\\\\[^<>:\\\"\\\\//|?*]+)+txt";
        }
        return filePath.matches(validFilePath);
    }

    private boolean isValidRoot(String root) {
        if (!root.startsWith("/") && root.contains("/")) {
            return false;
        }
        return !root.contains("..");
    }

    protected void handleFilterListBrowse() {
        String pathname = this.fFilterListField.getText();
        FileDialog fd = new FileDialog(this.getShell());
        if (pathname == null || pathname.trim().isEmpty()) {
            fd.setFilterPath(CCResultsViewUtils.getDefaultResultsPath(".").toOSString());
        } else {
            fd.setFileName(pathname);
        }
        String newFile = fd.open();
        if (newFile != null && !newFile.isEmpty()) {
            this.fFilterListField.setText(newFile);
        }
    }

    protected void handleRootRemoteBrowse() {
        RSESelectRemoteFolderDialog d = new RSESelectRemoteFolderDialog(this.getShell(), true, false, false, false, true);
        d.setTitle(Labels.CodeCoverageTab_browseRemoteTitle);
        d.setMessage(Labels.CodeCoverageTab_browseRemoteDialog);
        d.addViewerFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElem, Object elem) {
                return !(elem instanceof IRemoteFile) || ((IRemoteFile)elem).isDirectory();
            }
        });
        if (d.open() == 0) {
            Object member = d.getOutputObject();
            String path = member.toString();
            path = ((IRemoteFile)member).getAbsolutePath();
            this.fRootText.setText(path);
        }
    }

    protected void handleRootWorkspaceBrowse() {
        ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(this.getShell(), (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new WorkbenchContentProvider()){

            protected TreeViewer doCreateTreeViewer(Composite parent, int style) {
                TreeViewer viewer = new TreeViewer(new Tree(parent, style));
                viewer.addFilter(new ViewerFilter(){

                    public boolean select(Viewer viewer, Object parentElement, Object element) {
                        return element instanceof IFolder || element instanceof IProject;
                    }
                });
                return viewer;
            }
        };
        dialog.setInput((Object)ResourcesPlugin.getWorkspace().getRoot());
        dialog.setTitle(Labels.CodeCoverageTab_browseWorkspaceTitle);
        dialog.setMessage(Labels.CodeCoverageTab_browseWorkspaceDialog);
        if (dialog.open() == 0) {
            Object folder = dialog.getFirstResult();
            this.fRootText.setText(((IResource)folder).getName());
        }
    }

    protected void handleBrowseEvent(Widget widget) {
        if (widget == this.fFilterListBrowseButton) {
            this.handleFilterListBrowse();
        } else if (widget == this.fRootBrowseRemoteButton) {
            this.handleRootRemoteBrowse();
        } else if (widget == this.fRootBrowseWorkspaceButton) {
            this.handleRootWorkspaceBrowse();
        }
    }

    public void widgetSelected(SelectionEvent event) {
        this.updateGenerator(event.widget);
        this.handleBrowseEvent(event.widget);
        if (event.widget == this.fFilterListEditButton && this.isValidfilterListFile()) {
            CCFilterEditDialog dialog = new CCFilterEditDialog(this.getShell(), this.fFilterListField.getText());
            dialog.addUpdateFilterFilePathListener(new CCFilterEditDialog.IUpdateFilterFilePathListener(){

                public void updateFilterListField(String newPath) {
                    CodeCoverageComposite.this.fFilterListField.setText(newPath);
                }
            });
            dialog.open();
        }
        this.enableFields();
        if (this.fListener != null) {
            this.fListener.widgetSelected(event);
        }
    }

    public void widgetDefaultSelected(SelectionEvent event) {
        this.updateGenerator(event.widget);
        this.handleBrowseEvent(event.widget);
        this.enableFields();
        if (this.fListener != null) {
            this.fListener.widgetDefaultSelected(event);
        }
    }

    public void modifyText(ModifyEvent event) {
        this.updateGenerator(event.widget);
        this.enableFields();
        if (this.fListener != null) {
            this.fListener.modifyText(event);
        }
    }

    protected void updateGenerator(Widget widget) {
        if (widget == this.fGenPDF || widget == null) {
            this.fGenerator.setGenPDF(this.fGenPDF.getSelection());
        }
        if (widget == this.fIgnoreErrors || widget == null) {
            this.fGenerator.setIgnoreError(this.fIgnoreErrors.getSelection());
        }
        if (widget == this.fLineFilterButton || widget == this.fFunctionFilterButton || widget == null) {
            this.fGenerator.setCCLevel(this.getCodeCoverageLevel());
        }
        if (this.fFilterListCheckBox != null && (widget == this.fFilterListCheckBox || widget == null) || this.fFilterListField != null && (widget == this.fFilterListField || widget == null)) {
            this.fGenerator.setFilter(this.fFilterListCheckBox.getSelection() ? this.fFilterListField.getText() : null);
        }
        if (widget == this.fTestCaseText || widget == null) {
            this.fGenerator.setTestId(this.fTestCaseText.getText());
        }
        if (widget == this.fTagText || widget == null) {
            this.fGenerator.setTestTags(this.fTagText.getText());
        }
        if ((widget == this.fRootText || widget == null) && this.fRootText != null) {
            this.fGenerator.setRoot(this.fRootText.getText());
        }
    }

    public void validateFields() {
        this.fErrorMessage = null;
        if (this.fFilterListCheckBox != null && this.fFilterListCheckBox.getSelection() && !this.isValidfilterListFile()) {
            this.fErrorMessage = Messages.CRRDG7130;
        }
        if (this.fRootText != null && !this.fRootText.getText().isEmpty() && !this.isValidRoot(this.fRootText.getText().trim())) {
            this.fErrorMessage = NLS.bind((String)Messages.CRRDG7163, (Object)this.fRootText.getText());
        }
    }

    public String getErrorMessage() {
        return this.fErrorMessage;
    }

    public String getWarningMessage() {
        return this.fWarningMessage;
    }

    public void setWarningMessage(String message) {
        this.fWarningMessage = message;
    }

    public void initializeOptions(boolean isIgnoringErrors, String testId, String tag, String root, boolean isPDF) {
        this.fIgnoreErrors.setSelection(isIgnoringErrors);
        if (testId != null) {
            this.fTestCaseText.setText(testId);
        }
        if (tag != null) {
            this.fTagText.setText(tag);
        }
        if (this.fRootText != null && root != null) {
            this.fRootText.setText(root);
        }
        this.fGenPDF.setSelection(isPDF);
    }

    public void initializeFilter(boolean isFilterListEnabled, String filterPath) {
        if (this.fShowFilterList) {
            this.fFilterListCheckBox.setSelection(isFilterListEnabled);
            this.fFilterListField.setEnabled(isFilterListEnabled);
            this.fFilterListField.setText(filterPath);
            this.fFilterListBrowseButton.setEnabled(isFilterListEnabled);
            if (this.fEnableEditFilter) {
                this.fFilterListEditButton.setEnabled(this.enableEditFilterButton());
            }
        }
    }

    protected ICCConstants.COVERAGE_LEVEL getCodeCoverageLevel() {
        if (this.fFunctionFilterButton.getSelection()) {
            return ICCConstants.COVERAGE_LEVEL.FUNCTION;
        }
        return ICCConstants.COVERAGE_LEVEL.LINE;
    }

    public void initializeLevel(String levelAttr) {
        ICCConstants.COVERAGE_LEVEL level = ICCConstants.COVERAGE_LEVEL.valueOf((String)levelAttr);
        this.fFunctionFilterButton.setSelection(level == ICCConstants.COVERAGE_LEVEL.FUNCTION);
        this.fLineFilterButton.setSelection(level == ICCConstants.COVERAGE_LEVEL.LINE);
    }

    public String getStartupKey() {
        return this.fGenerator.generateStartupKey();
    }

    public void initializeFromStartupKey(String startupKey) {
        String root;
        String tag;
        String testCase;
        startupKey = CCStartupKeyGenerator.stripStartupKeyPrefix((String)startupKey);
        CCParams properties = new CCParams();
        CCCoreUtilities.processStartupkey((String)startupKey, (CCParams)properties);
        String level = properties.getProperty("cclevel");
        if (level == null) {
            this.fLineFilterButton.setSelection(true);
            this.fFunctionFilterButton.setSelection(false);
        } else if (level.equals(ICCConstants.COVERAGE_LEVEL.FUNCTION.toString())) {
            this.fFunctionFilterButton.setSelection(true);
            this.fLineFilterButton.setSelection(false);
        } else {
            this.fLineFilterButton.setSelection(true);
            this.fFunctionFilterButton.setSelection(false);
        }
        this.fGenPDF.setSelection(properties.getProperty("ccGeneratePDF", false));
        this.fIgnoreErrors.setSelection(properties.getProperty("ignoreerrors", false));
        String filterList = null;
        if (properties.getProperty("moduleexcludelist") != null) {
            filterList = properties.getProperty("moduleexcludelist");
            this.setWarningMessage(Messages.CRRDG7153);
        }
        if (filterList != null) {
            this.fFilterListField.setText(filterList);
            this.showCCFilterControls(true);
        }
        if ((testCase = properties.getProperty("testid")) != null) {
            this.fTestCaseText.setText(testCase);
        }
        if ((tag = properties.getProperty("tag")) != null) {
            this.fTagText.setText(tag);
        }
        if (this.fRootText != null && (root = properties.getProperty("root")) != null) {
            this.fRootText.setText(root);
        }
        this.updateGenerator(null);
    }

    private void showCCFilterControls(boolean value) {
        this.fFilterListField.setVisible(value);
        this.fFilterListField.setEnabled(value);
        this.fFilterListCheckBox.setVisible(value);
        this.fFilterListCheckBox.setSelection(value);
        this.fFilterListBrowseButton.setVisible(value);
        this.fFilterListBrowseButton.setEnabled(value);
    }

    public Control getWarningControl() {
        return this.fFilterListCheckBox;
    }
}

