/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.codecoverage.internal.ui.dcc.model;

import com.ibm.debug.pdt.codecoverage.core.results.ICCFile;
import com.ibm.debug.pdt.codecoverage.core.results.importers.CCImportException;
import com.ibm.debug.pdt.codecoverage.core.results.importers.ICCImportFile;
import com.ibm.debug.pdt.codecoverage.internal.core.CCData;
import com.ibm.debug.pdt.codecoverage.internal.core.CCProcessEventListener;
import com.ibm.debug.pdt.codecoverage.internal.core.CCUtilities;
import com.ibm.debug.pdt.codecoverage.internal.core.events.CCEvent;
import com.ibm.debug.pdt.codecoverage.internal.core.events.CCEventCoverageChange;
import com.ibm.debug.pdt.codecoverage.internal.core.events.CCEventManager;
import com.ibm.debug.pdt.codecoverage.internal.core.results.importers.CCImportUtilities;
import com.ibm.debug.pdt.codecoverage.internal.ui.dcc.DCCUtilities;
import com.ibm.debug.pdt.codecoverage.internal.ui.dcc.Messages;
import com.ibm.debug.pdt.internal.core.PDTDebugTarget;
import com.ibm.debug.pdt.internal.core.model.ProcessEvent;
import com.ibm.debug.pdt.internal.core.model.ProcessStoppedEvent;
import com.ibm.debug.pdt.internal.core.model.ThreadAddedEvent;
import com.ibm.debug.pdt.internal.epdc.EStdNumberList;
import java.util.HashSet;
import org.eclipse.debug.core.model.IDebugTarget;

public class DCCProcessEventListener
extends CCProcessEventListener {
    public DCCProcessEventListener(CCData data) {
        super(data);
    }

    public void processStopped(ProcessStoppedEvent event) {
    }

    public void threadAdded(ThreadAddedEvent event) {
    }

    public void addLines(EStdNumberList[] executableLines, EStdNumberList[] hitLines) {
        ICCImportFile ccFile;
        EStdNumberList line;
        HashSet<ICCImportFile> changedFiles = new HashSet<ICCImportFile>();
        EStdNumberList[] eStdNumberListArray = executableLines;
        int n = executableLines.length;
        int n2 = 0;
        while (n2 < n) {
            line = eStdNumberListArray[n2];
            ccFile = this.fData.getCCFile(line);
            if (ccFile != null) {
                try {
                    ccFile.addLines(CCImportUtilities.getLines((String)line.getLinesAttribute()));
                    changedFiles.add(ccFile);
                }
                catch (CCImportException e) {
                    CCUtilities.log((Throwable)e);
                }
            }
            ++n2;
        }
        eStdNumberListArray = hitLines;
        n = hitLines.length;
        n2 = 0;
        while (n2 < n) {
            line = eStdNumberListArray[n2];
            ccFile = this.fData.getCCFile(line);
            if (ccFile != null) {
                try {
                    int testId = this.fData.getTestCaseID();
                    ccFile.addHitLines(testId, CCImportUtilities.getLines((String)line.getLinesAttribute()));
                    changedFiles.add(ccFile);
                }
                catch (CCImportException e) {
                    CCUtilities.log((Throwable)e);
                }
            }
            ++n2;
        }
        if (!changedFiles.isEmpty()) {
            CCEventManager.getInstance().notify((CCEvent)new CCEventCoverageChange(this.fData, changedFiles.toArray(new ICCFile[changedFiles.size()])));
        }
    }

    protected void handleProcessEnded(ProcessEvent event) {
        if (this.fData.getResults() != null) {
            this.fData.getResults().addMessage(Messages.CRRDG9201, new String[0]);
        }
        super.handleProcessEnded(event);
        IDebugTarget debugTarget = event.getProcess().getDebugTarget();
        if (debugTarget instanceof PDTDebugTarget) {
            DCCUtilities.getInstance().removeCCDebugTarget((PDTDebugTarget)debugTarget);
        }
    }
}

