/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.codecoverage.internal.ui.dcc.dialog;

import com.ibm.debug.pdt.codecoverage.internal.ui.dcc.Labels;
import com.ibm.debug.pdt.internal.ui.dialogs.DebugTrayDialog;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class DCCSetParametersDialog
extends DebugTrayDialog {
    private String fProgramName;
    private Text fTestIDField;
    private Text fTagsField;
    private String fTestID;
    private String fTags;

    public DCCSetParametersDialog(Shell shell, String programName) {
        super(shell);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.fProgramName = programName;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(Labels.SET_CODE_COVERAGE_PARAMETERS);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        Composite entryContainer = new Composite(composite, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        entryContainer.setLayout((Layout)layout);
        entryContainer.setLayoutData((Object)new GridData(768));
        Label testIdLabel = new Label(entryContainer, 0);
        testIdLabel.setText(Labels.TEST_ID_LABEL);
        this.fTestIDField = new Text(entryContainer, 2048);
        this.fTestIDField.setLayoutData((Object)new GridData(768));
        if (this.fProgramName != null && !this.fProgramName.isEmpty()) {
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy_MM_dd_HHmmss_SSSS");
            String dateString = dateFormat.format(new Date(System.currentTimeMillis()));
            this.fTestIDField.setText(this.fProgramName + "_" + dateString);
        }
        Label tagLabel = new Label(entryContainer, 0);
        tagLabel.setText(Labels.TAGS_LABEL);
        this.fTagsField = new Text(entryContainer, 2048);
        this.fTagsField.setLayoutData((Object)new GridData(768));
        DCCSetParametersDialog.applyDialogFont((Control)composite);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.getShell(), "com.ibm.debug.pdt.codecoverage.ui.dcc.dcc_set_parameter_dialog");
        return composite;
    }

    protected void okPressed() {
        this.fTestID = this.fTestIDField.getText();
        this.fTags = this.fTagsField.getText();
        super.okPressed();
    }

    public String getTestID() {
        return this.fTestID != null ? this.fTestID : "";
    }

    public String getTags() {
        return this.fTags != null ? this.fTags : "";
    }
}

