/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.codecoverage.internal.core.results.converters.compiled.dt;

import com.ibm.debug.pdt.codecoverage.core.results.CCResultsFactory;
import com.ibm.debug.pdt.codecoverage.core.results.ICCFlowPoint;
import com.ibm.debug.pdt.codecoverage.core.results.ICCResult;
import com.ibm.debug.pdt.codecoverage.core.results.ICCTreeItem;
import com.ibm.debug.pdt.codecoverage.core.results.exporters.CCExportException;
import com.ibm.debug.pdt.codecoverage.core.results.exporters.CCExporterFactory;
import com.ibm.debug.pdt.codecoverage.core.results.exporters.ICCExporter;
import com.ibm.debug.pdt.codecoverage.core.results.exporters.ICCExporterInfo;
import com.ibm.debug.pdt.codecoverage.core.results.importers.CCDuplicateFlowPointException;
import com.ibm.debug.pdt.codecoverage.core.results.importers.CCImportException;
import com.ibm.debug.pdt.codecoverage.core.results.importers.ICCImportFile;
import com.ibm.debug.pdt.codecoverage.core.results.importers.ICCImportFlowPoint;
import com.ibm.debug.pdt.codecoverage.core.results.importers.ICCImportFlowPointParent;
import com.ibm.debug.pdt.codecoverage.core.results.importers.ICCImportModule;
import com.ibm.debug.pdt.codecoverage.core.results.importers.ICCImportPart;
import com.ibm.debug.pdt.codecoverage.core.results.importers.ICCImportResult;
import com.ibm.debug.pdt.codecoverage.core.results.importers.ICCImportTestcase;
import com.ibm.debug.pdt.codecoverage.internal.core.CCUtilities;
import com.ibm.debug.pdt.codecoverage.internal.core.results.converters.compiled.ICCConvertErrorMessages;
import com.ibm.debug.pdt.codecoverage.internal.core.results.importers.CCImportUtilities;
import com.ibm.debug.pdt.codecoverage.internal.core.results.parsers.ICCLanguageEntryPoint;
import com.ibm.debug.pdt.codecoverage.internal.core.results.parsers.ICCLanguageParser;
import com.ibm.debug.pdt.codecoverage.internal.core.results.parsers.ParserEntryPointUtils;
import com.ibm.debug.pdt.internal.core.util.PDTCoreUtils;
import com.ibm.debug.pdt.internal.epdc.IEPDCConstants;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.StringTokenizer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DebugToolCodeCoverageConverter {
    private static final String CC_CONVERSION_END = "</CCConversion>";
    private static final String CC_CONVERSION = "<CCConversion>";
    private static final String CDATA = "<![CDATA[";
    private static final String DAY = "DAY";
    private static final String DD_MMYY = "ddMMyy";
    private static final String DD_MMYYYY = "ddMMyyyy";
    private static final String DTCODECOVERAGEFILE = "DTCODECOVERAGEFILE";
    private static final String E_CDATA = "]]>";
    private static final String E_STMT = "</STMT>";
    private static final String H_HMMSS = "HHmmss";
    private static final String HOURS = "HOURS";
    private static final String LOADMODULE = "LOADMODULE";
    private static final String MINUTES = "MINUTES";
    private static final String MONTH = "MONTH";
    private static final String RUNDATE = "RUNDATE";
    private static final String RUNTIME = "RUNTIME";
    private static final String SCHEMA_LANGUAGE = "http://java.sun.com/xml/jaxp/properties/schemaLanguage";
    private static final String SECONDS = "SECONDS";
    private static final String STMT = "<STMT>";
    private static final String W3C_SCHEMA = "http://www.w3.org/2001/XMLSchema";
    private static final String XML = "<?XML";
    private static final String XML_EXTENSION = ".xml";
    private static final String YEAR = "YEAR";
    private static final String INVALID_XML_CHARS = "[^\t\r\n -\ud7ff\ue000-\ufffd\ud800\udc00-\udbff\udfff]";
    private static final String fPluginVersion = Platform.getBundle((String)"com.ibm.debug.pdt.codecoverage.rdz.ui").getVersion().toString();
    private static final String MARKEDSTMTS = "MARKEDSTMTS";
    private static final String UNEXECUTED = "UNEXECUTED";
    private static final String EXTNAME = "EXTNAME";
    private static final String PROGRAMDSNAME = "PROGRAMDSNAME";
    private static final String MEMBERNAME = "MEMBERNAME";
    private static final String COMPILATIONUNIT = "COMPILATIONUNIT";
    private static final String EXECUTED = "EXECUTED";
    private static final String CSECT = "CSECT";
    private static final String PROGRAMDSTYPE = "PROGRAMDSTYPE";
    private ICCImportTestcase fTestCase;
    private ICCImportResult fResult = CCResultsFactory.getInstance().createResult();
    private boolean fTimeSet;
    private boolean fDateSet;

    public DebugToolCodeCoverageConverter(String inputFileName, ICCConvertErrorMessages messages) throws CCExportException {
        this.fResult.setName(inputFileName);
        File file = new File(inputFileName);
        this.fResult.setName(file.getName());
        int idx = file.getName().lastIndexOf(46);
        if (idx > 1) {
            this.fResult.setName(file.getName().substring(0, idx));
        }
        this.parse(inputFileName);
    }

    protected final void finalize() {
    }

    private String cleanupInputFile(String inputFileName) throws CCExportException {
        File path = new File(inputFileName);
        File newFile = null;
        FileInputStream fis = null;
        FileOutputStream fos = null;
        String eol = System.getProperty("line.separator");
        try {
            try {
                newFile = File.createTempFile(path.getName(), XML_EXTENSION);
                fis = new FileInputStream(inputFileName);
                fos = new FileOutputStream(newFile);
                BufferedReader r = new BufferedReader(new InputStreamReader((InputStream)fis, Charset.defaultCharset()));
                BufferedWriter w = new BufferedWriter(new OutputStreamWriter((OutputStream)fos, Charset.defaultCharset()));
                boolean xmlFound = false;
                boolean CCConversionAdded = false;
                while (r.ready()) {
                    Object line = r.readLine();
                    if (line == null) continue;
                    if (((String)(line = ((String)line).trim())).toUpperCase().startsWith(XML)) {
                        if (xmlFound) continue;
                        line = ((String)line).toLowerCase();
                        xmlFound = true;
                    } else if (((String)line).startsWith(STMT) && ((String)line).endsWith(E_STMT) && !((String)line).substring(STMT.length()).startsWith(CDATA)) {
                        line = "<STMT><![CDATA[" + ((String)line).substring(STMT.length(), ((String)line).length() - E_STMT.length()) + "]]></STMT>";
                    }
                    line = ((String)line).replaceAll(INVALID_XML_CHARS, " ");
                    if (!xmlFound && !CCConversionAdded) {
                        w.write(CC_CONVERSION);
                        w.write(eol);
                        CCConversionAdded = true;
                    }
                    w.write((String)line);
                    w.write(eol);
                    if (CCConversionAdded) continue;
                    w.write(CC_CONVERSION);
                    w.write(eol);
                    CCConversionAdded = true;
                }
                if (CCConversionAdded) {
                    w.write(CC_CONVERSION_END);
                    w.write(eol);
                }
                r.close();
                w.close();
            }
            catch (Throwable e) {
                throw new CCExportException(e);
            }
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException iOException) {}
            }
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException iOException) {}
            }
        }
        return newFile.getAbsolutePath();
    }

    protected String getEngineKey() {
        return "ydy";
    }

    protected String getEngineVersion() {
        return "Imported Debug Tool Code Coverage - version unknown";
    }

    private void parse(Node item) throws Exception {
        NodeList children = item.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            Node child = children.item(i);
            String name = child.getNodeName();
            if (name.equals(RUNDATE)) {
                this.parseDate(child);
            } else if (name.equals(RUNTIME)) {
                this.parseTime(child);
            } else if (name.equals(LOADMODULE)) {
                String mName = this.getModuleName(child);
                ICCImportModule module = (ICCImportModule)this.fResult.getModule(mName);
                if (module == null) {
                    module = this.fResult.createModule(mName);
                    module.setDebuggable();
                }
                this.addFiles(module, child);
            }
            ++i;
        }
    }

    private void addFiles(ICCImportModule module, Node item) throws Exception {
        NodeList children = item.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            Node child = children.item(i);
            String name = child.getNodeName();
            if (name.equals(COMPILATIONUNIT)) {
                this.addfile(module, child);
            }
            ++i;
        }
    }

    private void addfile(ICCImportModule module, Node item) throws Exception {
        ICCImportFile file = null;
        NodeList children = item.getChildNodes();
        Object fName = null;
        int i = 0;
        while (i < children.getLength()) {
            Node child = children.item(i);
            String name = child.getNodeName();
            if (name.equals(PROGRAMDSNAME)) {
                fName = child.getTextContent();
            } else if (name.equals(CSECT)) {
                this.parsePart(child, file, module);
            } else if (name.equals(PROGRAMDSTYPE) && fName != null) {
                int language = this.getLanguage(child);
                if (!((String)fName).endsWith(this.getExtension(language))) {
                    fName = (String)fName + this.getExtension(language);
                }
                if ((file = (ICCImportFile)this.fResult.getFile((String)fName)) == null) {
                    file = this.fResult.createFile((String)fName);
                }
                file.setLanguage(language);
            }
            ++i;
        }
    }

    private int getLanguage(Node node) throws CCExportException {
        try {
            int language = Integer.parseInt(node.getTextContent());
            switch (language) {
                case 1: 
                case 4: {
                    return 6;
                }
                case 2: {
                    return 4;
                }
                case 5: {
                    return 1;
                }
            }
            return 0;
        }
        catch (NumberFormatException e) {
            throw new CCExportException((Throwable)e);
        }
    }

    private void parsePart(Node item, ICCImportFile file, ICCImportModule module) throws Exception {
        ICCImportPart part = null;
        NodeList children = item.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            Node child = children.item(i);
            String name = child.getNodeName();
            if (name.equals(EXTNAME)) {
                String pName = child.getTextContent();
                part = (ICCImportPart)this.fResult.getPart(pName);
                if (part == null) {
                    part = this.fResult.createPart(pName, module);
                    part.setDebuggable();
                }
                part.addFile(file);
                if (file.getFlowPoint(part.getName()) == null) {
                    file.createFlowPoint(part.getName(), 1);
                }
            } else if (name.equals(EXECUTED)) {
                this.addExecuted(file, child);
            } else if (name.equals(UNEXECUTED)) {
                this.addUnExecuted(file, child);
            } else if (name.equals(MARKEDSTMTS)) {
                this.saveTempFile(file, child);
            }
            ++i;
        }
    }

    void saveTempFile(ICCImportFile file, Node item) throws Exception {
        BufferedWriter writer = null;
        String newLine = System.getProperty("line.separator");
        File tempFile = null;
        try {
            tempFile = File.createTempFile(file.getName(), this.getExtension(file));
            tempFile.deleteOnExit();
            file.setFile(tempFile);
            writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(tempFile), "UTF-8"));
            NodeList children = item.getChildNodes();
            int i = 0;
            while (i < children.getLength()) {
                Node child = children.item(i);
                String name = child.getNodeName();
                if (name.equals("STMT")) {
                    String line = child.getTextContent();
                    line = line.length() > 15 ? line.substring(15) : "";
                    writer.write(line);
                    writer.write(newLine);
                }
                ++i;
            }
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException iOException) {}
            }
        }
        this.loadParsedEntryPoints(tempFile, file);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void loadParsedEntryPoints(File file, ICCImportFile ccFile) {
        FileInputStream fileStream = null;
        try {
            try {
                fileStream = new FileInputStream(file);
                ICCLanguageParser parser = ParserEntryPointUtils.getParser((int)ccFile.getLanguage());
                if (parser == null) return;
                parser.parse((InputStream)fileStream, "UTF-8");
                ICCLanguageEntryPoint[] iCCLanguageEntryPointArray = parser.getEntryPoints();
                int n = iCCLanguageEntryPointArray.length;
                int n2 = 0;
                while (n2 < n) {
                    ICCLanguageEntryPoint entryPoint = iCCLanguageEntryPointArray[n2];
                    if (this.validateEntryPoint(entryPoint)) {
                        try {
                            int fpFirstLine = entryPoint.getLine();
                            int fpLastLine = entryPoint.getLastLine();
                            ICCImportFlowPointParent parent = CCImportUtilities.findParent((ICCImportFile)ccFile, (int)fpFirstLine, (int)fpLastLine);
                            ICCImportFlowPoint fp = (ICCImportFlowPoint)ccFile.getFlowPoint(entryPoint.getEntryPoint());
                            if (fp == null) {
                                fp = ccFile.createFlowPoint(entryPoint.getEntryPoint(), entryPoint.getLine());
                                if (parent != null) {
                                    fp.setParent((ICCTreeItem)parent);
                                }
                            }
                            fp.setLastLine(entryPoint.getLastLine());
                            fp.setFirstLine(entryPoint.getLine());
                            fp.setType(entryPoint.getType());
                        }
                        catch (CCDuplicateFlowPointException e) {
                            if (e.getExistingFlowPoint() instanceof ICCImportFlowPoint) {
                                ICCImportFlowPoint fn = (ICCImportFlowPoint)e.getExistingFlowPoint();
                                fn.setFirstLine(entryPoint.getLine());
                                fn.setLastLine(entryPoint.getLastLine());
                            }
                            ccFile.addMessage(e.getEncodedMessage(), new String[0]);
                        }
                    }
                    ++n2;
                }
                return;
            }
            catch (IOException e) {
                CCUtilities.log((Throwable)e);
                if (fileStream == null) return;
                try {
                    ((InputStream)fileStream).close();
                    return;
                }
                catch (IOException iOException) {}
                return;
            }
            catch (CCImportException e) {
                ccFile.addMessage(e.getEncodedMessage(), new String[0]);
                CCUtilities.log((Throwable)e);
                if (fileStream == null) return;
                try {
                    ((InputStream)fileStream).close();
                    return;
                }
                catch (IOException iOException) {}
                return;
            }
        }
        finally {
            if (fileStream != null) {
                try {
                    ((InputStream)fileStream).close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private boolean validateEntryPoint(ICCLanguageEntryPoint entryPoint) {
        if (entryPoint == null || entryPoint.getEntryPoint() == null || entryPoint.getEntryPoint().isEmpty()) {
            return false;
        }
        return entryPoint.getLine() != 0;
    }

    private String getExtension(ICCImportFile file) {
        return this.getExtension(file.getLanguage());
    }

    private String getExtension(int language) {
        switch (language) {
            case 6: {
                return ".cob";
            }
            case 1: {
                return ".c";
            }
            case 4: {
                return ".pli";
            }
        }
        return ".txt";
    }

    void addUnExecuted(ICCImportFile file, Node item) throws CCImportException {
        this.addLineNumber(file, item, false);
        this.updateFunction(file);
    }

    void addExecuted(ICCImportFile file, Node item) throws CCImportException {
        this.addLineNumber(file, item, true);
        this.updateFunction(file);
    }

    private void updateFunction(ICCImportFile file) {
        ICCFlowPoint[] iCCFlowPointArray = file.getFlowPoints();
        int n = iCCFlowPointArray.length;
        int n2 = 0;
        while (n2 < n) {
            ICCFlowPoint f = iCCFlowPointArray[n2];
            this.updateLines((ICCImportFlowPoint)f, file.getLines(false));
            ++n2;
        }
    }

    public void updateLines(ICCImportFlowPoint f, Integer[] lines) {
        if (lines.length > 0) {
            f.setFirstLine(lines[0].intValue());
            f.setLastLine(lines[lines.length - 1].intValue());
        }
    }

    private void addLineNumber(ICCImportFile file, Node item, boolean hit) throws CCImportException {
        StringTokenizer st = new StringTokenizer(item.getTextContent());
        ArrayList<Integer> lines = new ArrayList<Integer>();
        while (st.hasMoreTokens()) {
            String lineNum = st.nextToken();
            int idx = lineNum.indexOf(46);
            if (idx > -1) {
                lineNum = lineNum.substring(0, idx);
            }
            lines.add(Integer.parseInt(lineNum));
        }
        Integer[] linesArray = lines.toArray(new Integer[lines.size()]);
        file.addLines(linesArray);
        if (hit) {
            file.addHitLines(this.getTestCaseID(), linesArray);
        }
    }

    private String getModuleName(Node item) {
        NodeList children = item.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            Node child = children.item(i);
            String name = child.getNodeName();
            if (name.equals(MEMBERNAME)) {
                return child.getTextContent();
            }
            ++i;
        }
        return "";
    }

    protected void parse(String inputFileName) throws CCExportException {
        String cleanFile = this.cleanupInputFile(inputFileName);
        FileInputStream fis = null;
        try {
            try {
                DocumentBuilderFactory factory = PDTCoreUtils.getSecureDocumentBuilderFactory();
                factory.setValidating(false);
                factory.setAttribute(SCHEMA_LANGUAGE, W3C_SCHEMA);
                DocumentBuilder docBuilder = factory.newDocumentBuilder();
                fis = new FileInputStream(cleanFile);
                Document coverageDoc = docBuilder.parse(fis);
                NodeList list = coverageDoc.getElementsByTagName(DTCODECOVERAGEFILE);
                int i = 0;
                while (i < list.getLength()) {
                    this.parse(list.item(i));
                    ++i;
                }
            }
            catch (Exception e) {
                throw new CCExportException((Throwable)e);
            }
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private void parseDate(Node item) throws CCExportException {
        if (!this.fDateSet) {
            String year = null;
            String month = null;
            String day = null;
            NodeList children = item.getChildNodes();
            int i = 0;
            while (i < children.getLength()) {
                Node child = children.item(i);
                String name = child.getNodeName();
                if (name.equals(YEAR)) {
                    year = child.getTextContent();
                } else if (name.equals(MONTH)) {
                    month = child.getTextContent();
                } else if (name.endsWith(DAY)) {
                    day = child.getTextContent();
                }
                ++i;
            }
            SimpleDateFormat format = new SimpleDateFormat(year.length() == 4 ? DD_MMYYYY : DD_MMYY);
            SimpleDateFormat output = new SimpleDateFormat("YYYMMDD");
            try {
                this.fResult.setName(this.fResult.getName() + "_" + output.format(new Date(format.parse(day + month + year).getTime())));
                this.fDateSet = true;
            }
            catch (ParseException e) {
                throw new CCExportException((Throwable)e);
            }
        }
    }

    private void parseTime(Node item) throws CCExportException {
        if (!this.fTimeSet) {
            String hours = null;
            String minutes = null;
            String seconds = null;
            NodeList children = item.getChildNodes();
            int i = 0;
            while (i < children.getLength()) {
                Node child = children.item(i);
                String name = child.getNodeName();
                if (name.equals(HOURS)) {
                    hours = child.getTextContent();
                } else if (name.equals(MINUTES)) {
                    minutes = child.getTextContent();
                } else if (name.endsWith(SECONDS)) {
                    seconds = child.getTextContent();
                }
                ++i;
            }
            SimpleDateFormat format = new SimpleDateFormat(H_HMMSS);
            SimpleDateFormat output = new SimpleDateFormat("HHMMSS");
            try {
                this.fResult.setName(this.fResult.getName() + "_" + output.format(new Date(format.parse(hours + minutes + seconds).getTime())));
                this.fTimeSet = true;
            }
            catch (ParseException e) {
                throw new CCExportException((Throwable)e);
            }
        }
    }

    public String importCodeCoverageData(String path) throws CCExportException {
        ICCExporter exporter = CCExporterFactory.getInstance().getExporter("CCRESULT");
        IPath fullPath = new Path(path).append(this.fResult.getName());
        ICCExporterInfo info = exporter.exportResult((ICCResult)this.fResult, null, fullPath.toOSString(), true);
        return info.getDestination();
    }

    public int getTestCaseID() {
        if (this.fTestCase == null) {
            try {
                this.fTestCase = this.fResult.createTestcase(this.fResult.getName(), IEPDCConstants.PLATFORM_HDW_String[4]);
                this.fTestCase.setLevel(this.fResult.getLevel());
                this.fTestCase.setEngineKey(this.getEngineKey());
                this.fTestCase.setProperty("pluginVersion", (Object)fPluginVersion);
                this.fTestCase.setProperty("engineVersion", (Object)this.getEngineVersion());
                this.fResult.setProperty("pluginVersion", (Object)fPluginVersion);
                this.fResult.setProperty("engineVersion", (Object)this.getEngineVersion());
            }
            catch (CCImportException e) {
                return -1;
            }
        }
        return this.fTestCase.getID();
    }
}

