/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.animatedstep;

import com.ibm.debug.pdt.internal.animatedstep.AnimatedStepAction;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IStartup;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWindowListener;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.UIJob;

public class EarlyStartup
implements IStartup,
IWindowListener,
IPartListener {
    private static AnimatedStepAction fAction;

    public void earlyStartup() {
        this.registerWithToolBar();
    }

    public static AnimatedStepAction getAction() {
        return fAction;
    }

    private void registerWithToolBar() {
        IWorkbench workBench = PlatformUI.getWorkbench();
        workBench.addWindowListener((IWindowListener)this);
        IWorkbenchWindow[] windows = workBench.getWorkbenchWindows();
        int i = 0;
        while (i < windows.length) {
            windows[i].getPartService().addPartListener((IPartListener)this);
            final IWorkbenchPage[] pages = windows[i].getPages();
            workBench.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    int j = 0;
                    while (j < pages.length) {
                        IViewPart part = pages[j].findView("org.eclipse.debug.ui.DebugView");
                        if (part != null) {
                            EarlyStartup.this.registerAction(part);
                            break;
                        }
                        ++j;
                    }
                }
            });
            ++i;
        }
    }

    private void registerAction(final IViewPart part) {
        new UIJob("Register toolbar"){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                IToolBarManager toolBarManager = part.getViewSite().getActionBars().getToolBarManager();
                if (fAction == null) {
                    fAction = new AnimatedStepAction();
                }
                if (toolBarManager.find(fAction.getId()) == null) {
                    toolBarManager.appendToGroup("stepGroup", (IAction)fAction);
                    toolBarManager.update(true);
                }
                return Status.OK_STATUS;
            }
        }.schedule();
    }

    public void windowActivated(IWorkbenchWindow window) {
    }

    public void windowClosed(IWorkbenchWindow window) {
        window.getPartService().removePartListener((IPartListener)this);
    }

    public void windowDeactivated(IWorkbenchWindow window) {
    }

    public void windowOpened(IWorkbenchWindow window) {
        window.getPartService().addPartListener((IPartListener)this);
    }

    public void partActivated(IWorkbenchPart part) {
    }

    public void partBroughtToTop(IWorkbenchPart part) {
    }

    public void partClosed(IWorkbenchPart part) {
    }

    public void partDeactivated(IWorkbenchPart part) {
    }

    public void partOpened(IWorkbenchPart part) {
        if (part.getSite().getId().equals("org.eclipse.debug.ui.DebugView")) {
            this.registerAction((IViewPart)part);
        }
    }
}

