/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.idebug.engine;

import com.ibm.debug.idebug.engine.EnginePlugin;
import com.ibm.debug.idebug.engine.PiclEngineLauncher;
import java.io.BufferedInputStream;
import java.io.InputStream;

public class EngineProcess {
    protected Process _process = null;
    protected Thread _errorStreamThread = null;
    protected Thread _outputStreamThread = null;
    protected Thread _engineMonitorThread = null;

    public EngineProcess(Process process) throws IllegalArgumentException {
        if (process == null) {
            throw new IllegalArgumentException();
        }
        this._process = process;
        this.initializeThreads();
    }

    protected void initializeThreads() {
        this._errorStreamThread = new Thread(new InputStreamReader(this._process.getErrorStream()));
        this._errorStreamThread.start();
        this._outputStreamThread = new Thread(new InputStreamReader(this._process.getInputStream()));
        this._outputStreamThread.start();
        this._engineMonitorThread = new Thread(new EngineProcessMonitor(this));
        this._engineMonitorThread.start();
    }

    public Process getProcess() {
        return this._process;
    }

    protected static class EngineProcessMonitor
    implements Runnable {
        EngineProcess _engine = null;

        public EngineProcessMonitor(EngineProcess e) {
            this._engine = e;
        }

        @Override
        public void run() {
            try {
                if (!PiclEngineLauncher._engines.contains(this._engine)) {
                    PiclEngineLauncher._engines.add(this._engine);
                }
                if (this._engine._process != null) {
                    this._engine._process.waitFor();
                }
                if (PiclEngineLauncher._engines.contains(this._engine)) {
                    PiclEngineLauncher._engines.remove(this._engine);
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    protected static class InputStreamReader
    implements Runnable {
        BufferedInputStream stream = null;

        public InputStreamReader(InputStream in) {
            this.stream = new BufferedInputStream(in);
        }

        @Override
        public void run() {
            try {
                while (this.stream.read() != -1) {
                }
            }
            catch (Exception e) {
                EnginePlugin.logError(e);
            }
        }
    }
}

