/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.daemon.internal.ui;

import com.ibm.debug.daemon.internal.core.DaemonMessages;
import com.ibm.debug.daemon.internal.ui.PortUtility;
import org.eclipse.osgi.util.NLS;

public class PortValidator {
    public static String validate(String portString) {
        int portStringLength = (portString = portString.replaceAll("[ ]", "")).length();
        if (portStringLength == 0) {
            return DaemonMessages.CRRDG1130;
        }
        StringBuffer buffer = new StringBuffer();
        boolean inRange = false;
        int rangeStart = 0;
        int rangeEnd = 0;
        int i = 0;
        while (i < portString.length()) {
            int prevCh = 32;
            char ch = portString.charAt(i);
            if (i > 0) {
                prevCh = portString.charAt(i - 1);
            }
            switch (ch) {
                case ',': {
                    if (prevCh == 44 || prevCh == 45) {
                        return DaemonMessages.CRRDG1126;
                    }
                    if (PortValidator.validPortNumber(buffer.toString()) < 0) {
                        return DaemonMessages.CRRDG1128;
                    }
                    buffer.setLength(0);
                    inRange = false;
                    if (i != portStringLength - 1) break;
                    return DaemonMessages.CRRDG1129;
                }
                case '-': {
                    if (prevCh == 45 || prevCh == 44) {
                        return DaemonMessages.CRRDG1126;
                    }
                    if (!inRange && (rangeStart = PortValidator.validPortNumber(buffer.toString())) < 0) {
                        return DaemonMessages.CRRDG1128;
                    }
                    buffer.setLength(0);
                    inRange = true;
                    if (i != portStringLength - 1) break;
                    return DaemonMessages.CRRDG1131;
                }
                default: {
                    if (Character.isDigit(ch)) {
                        buffer.append(ch);
                        if (inRange) {
                            rangeEnd = PortValidator.validPortNumber(buffer.toString());
                            if (rangeEnd < 0) {
                                return DaemonMessages.CRRDG1128;
                            }
                            if (i != portStringLength - 1 || rangeStart < rangeEnd) break;
                            return NLS.bind((String)DaemonMessages.CRRDG1127, (Object)String.valueOf(rangeEnd), (Object)String.valueOf(rangeStart));
                        }
                        if (PortValidator.validPortNumber(buffer.toString()) >= 0) break;
                        return DaemonMessages.CRRDG1128;
                    }
                    return NLS.bind((String)DaemonMessages.CRRDG1125, (Object)String.valueOf(ch));
                }
            }
            ++i;
        }
        return null;
    }

    public static String portsConflict(String port1Text, String port2Text) {
        Integer[] ports1 = PortUtility.getPorts((String)port1Text);
        Integer[] ports2 = PortUtility.getPorts((String)port2Text);
        String errorMsg = null;
        if (ports1.length == 1 && ports2.length == 1 && ports1[0].intValue() == ports2[0].intValue()) {
            errorMsg = "error";
        }
        return errorMsg;
    }

    private static int validPortNumber(String port) {
        int portNumber;
        try {
            portNumber = Integer.parseInt(port);
        }
        catch (NumberFormatException e) {
            return -1;
        }
        if (portNumber < 0 || portNumber > 65535) {
            return -1;
        }
        return portNumber;
    }
}

