/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.daemon.internal.ui;

import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

public class FontReflowUtil {
    public static void installListeners(final ScrolledComposite sc) {
        final FontReflowListener listener = new FontReflowListener(sc);
        sc.getParent().addListener(9, (Listener)listener);
        Display.getCurrent().addListener(39, (Listener)listener);
        sc.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                sc.getParent().removeListener(9, (Listener)listener);
                Display.getCurrent().removeListener(39, (Listener)listener);
            }
        });
    }

    private static class FontReflowListener
    implements Listener {
        private boolean fSettingsChanged;
        private ScrolledComposite fSc;

        public FontReflowListener(ScrolledComposite sc) {
            this.fSc = sc;
        }

        public void handleEvent(Event event) {
            if (this.fSettingsChanged && event.type == 9) {
                Point cSize = this.fSc.getContent().computeSize(-1, -1);
                this.fSc.setMinSize(cSize);
                this.fSc.getParent().layout(true);
                this.fSettingsChanged = false;
            } else if (event.type == 39) {
                this.fSettingsChanged = true;
            }
        }
    }
}

