/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.daemon.internal.ui;

import com.ibm.debug.daemon.CoreDaemon;
import com.ibm.debug.daemon.internal.ui.DaemonUtils;
import java.io.File;
import java.net.URL;
import java.util.HashMap;
import javax.crypto.spec.PBEKeySpec;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IProduct;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.equinox.security.storage.ISecurePreferences;
import org.eclipse.equinox.security.storage.SecurePreferencesFactory;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class DebugDaemonPlugin
extends AbstractUIPlugin {
    public static final String STANDALONE_APPLICATION_ID = "com.ibm.debug.idebug.platform.IdebugApplication";
    public static final String DAEMON_PORT = "DaemonPort";
    public static final String SECURE_DAEMON_PORT = "SecureDaemonPort";
    public static final String DAEMON_STARTUP_STATE = "DaemonStartupState";
    public static final String SECURE_DAEMON_STARTUP_STATE = "SecureDaemonStartupState";
    public static final String SAVE_AS_DEFAULT_DAEMON_PORT = "SaveAsDefaultDaemonPort";
    public static final String KEYSTORE_FILE = "KeyStoreFile";
    public static final String AUTH_KEYSTORE_FILE = "AuthKeyStoreFile";
    public static final String REUSE_KEYSTORE_FILE = "ReuseKeyStoreFile";
    public static final String UIDAEMON_ENABLED = "UIDaemonEnabled";
    public static final String SECUREDAEMON_ENABLED = "SecureDaemonEnabled";
    public static final String PREF_MAX_PARAM_BUFFER_SIZE = "MaxParameterBufferSize";
    public static final int DEFAULT_MAX_PARAM_BUFFER_SIZE = 32000;
    public static final String PLUGIN_ID = "com.ibm.debug.daemon.ui";
    public static final String PREFERENCE_PLUGIN_ID = "com.ibm.debug.daemon";
    private static final String DEFAULT_PASSWORD_SECURE_PREFERENCES = "changeit";
    private static final String SECURE_PREFERENCES_FILE_NAME = "securePreferences.properties";
    private static Object fPluginLock = new Object();
    private static DebugDaemonPlugin instance;
    private static boolean fLogging;
    private static ILog fLogFile;
    private IPreferencesService fPreferencesService;
    private static ISecurePreferences fSecurePreferences;
    private static File fSecurePreferencesDataFile;

    static {
        fLogging = false;
        fLogFile = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DebugDaemonPlugin() {
        Object object = fPluginLock;
        synchronized (object) {
            instance = this;
        }
        this.fPreferencesService = Platform.getPreferencesService();
    }

    public static Bundle getPluginBundle() {
        return Platform.getBundle((String)PLUGIN_ID);
    }

    public static DebugDaemonPlugin getInstance() {
        return instance;
    }

    public void stop(BundleContext context) throws Exception {
        try {
            IEclipsePreferences pref = InstanceScope.INSTANCE.getNode(PREFERENCE_PLUGIN_ID);
            pref.putBoolean(DAEMON_STARTUP_STATE, CoreDaemon.isListening());
            pref.putBoolean(SECURE_DAEMON_STARTUP_STATE, CoreDaemon.isListeningSecure());
            pref.flush();
            CoreDaemon.stopListening();
            CoreDaemon.stopListeningSecure();
        }
        finally {
            super.stop(context);
        }
    }

    public static boolean isRunningStandalone() {
        String applicationId;
        IProduct product = Platform.getProduct();
        String string = applicationId = product != null ? product.getApplication() : null;
        return applicationId != null && applicationId.equals(STANDALONE_APPLICATION_ID);
    }

    public static void displayError(String titleStr, String msgStr) {
        final String title = titleStr;
        final String msg = msgStr;
        DaemonUtils.getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                MessageDialog.openError((Shell)DaemonUtils.getShell(), (String)title, (String)msg);
            }
        });
    }

    public static void log(String message) {
        DebugDaemonPlugin.log(message, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void log(String message, Exception e) {
        Object object = fPluginLock;
        synchronized (object) {
            if (fLogFile == null) {
                fLogFile = DebugDaemonPlugin.getInstance().getLog();
            }
        }
        fLogFile.log((IStatus)new Status(1, PLUGIN_ID, message, (Throwable)e));
    }

    public boolean getStartupState() {
        return this.fPreferencesService.getBoolean(PREFERENCE_PLUGIN_ID, DAEMON_STARTUP_STATE, false, null);
    }

    public boolean getStartupStateSecure() {
        return this.fPreferencesService.getBoolean(PREFERENCE_PLUGIN_ID, SECURE_DAEMON_STARTUP_STATE, false, null);
    }

    public String getSecurePortPreference() {
        return this.fPreferencesService.getString(PREFERENCE_PLUGIN_ID, SECURE_DAEMON_PORT, "8002", null);
    }

    public String getPortPreference() {
        return this.fPreferencesService.getString(PREFERENCE_PLUGIN_ID, DAEMON_PORT, "8001", null);
    }

    public boolean uiDaemonEnabled() {
        return this.fPreferencesService.getBoolean(PREFERENCE_PLUGIN_ID, UIDAEMON_ENABLED, true, null);
    }

    public boolean secureDaemonEnabled() {
        return this.fPreferencesService.getBoolean(PREFERENCE_PLUGIN_ID, SECUREDAEMON_ENABLED, false, null);
    }

    public int getMaxParameterBufferSize() {
        return this.fPreferencesService.getInt(PREFERENCE_PLUGIN_ID, PREF_MAX_PARAM_BUFFER_SIZE, 32000, null);
    }

    public String getKeyStoreFileName() {
        return this.fPreferencesService.getString(PREFERENCE_PLUGIN_ID, KEYSTORE_FILE, "", null);
    }

    public String getAuthKeyStoreFileName() {
        if (this.isReuseKeystore()) {
            if (this.secureDaemonEnabled()) {
                return this.getKeyStoreFileName();
            }
            return this.getAuthKeyStoreFileNamePref();
        }
        return this.getAuthKeyStoreFileNamePref();
    }

    String getAuthKeyStoreFileNamePref() {
        return this.fPreferencesService.getString(PREFERENCE_PLUGIN_ID, AUTH_KEYSTORE_FILE, "", null);
    }

    protected boolean isReuseKeystore() {
        return this.fPreferencesService.getBoolean(PREFERENCE_PLUGIN_ID, REUSE_KEYSTORE_FILE, false, null);
    }

    public char[] getKeyStorePassword(String keyStoreFileName) {
        if (keyStoreFileName == null || keyStoreFileName.trim().length() <= 0) {
            return "".toCharArray();
        }
        return DaemonUtils.getPasswordFromSecureStorage(DebugDaemonPlugin.getInstance().getSecurePreferences(), "keystore_password");
    }

    public char[] getAuthKeyStorePassword(String keyStoreFileName) {
        if (this.isReuseKeystore()) {
            if (this.secureDaemonEnabled()) {
                return this.getKeyStorePassword(keyStoreFileName);
            }
            return this.getAuthKeyStorePasswordPref(keyStoreFileName);
        }
        return this.getAuthKeyStorePasswordPref(keyStoreFileName);
    }

    char[] getAuthKeyStorePasswordPref(String keyStoreFileName) {
        if (keyStoreFileName == null || keyStoreFileName.trim().length() <= 0) {
            return "".toCharArray();
        }
        return DaemonUtils.getPasswordFromSecureStorage(DebugDaemonPlugin.getInstance().getSecurePreferences(), "auth_keystore_password");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ISecurePreferences getSecurePreferences() {
        Object object = fPluginLock;
        synchronized (object) {
            if (fSecurePreferences == null) {
                HashMap<String, Object> options = new HashMap<String, Object>();
                options.put("org.eclipse.equinox.security.storage.defaultPassword", new PBEKeySpec(DEFAULT_PASSWORD_SECURE_PREFERENCES.toString().toCharArray()));
                options.put("org.eclipse.equinox.security.storage.promptUser", true);
                try {
                    fSecurePreferencesDataFile = new File(this.getStateLocation().toOSString() + File.separator + SECURE_PREFERENCES_FILE_NAME);
                    fSecurePreferences = SecurePreferencesFactory.open((URL)fSecurePreferencesDataFile.toURI().toURL(), options).node(PREFERENCE_PLUGIN_ID);
                }
                catch (Exception e) {
                    DebugDaemonPlugin.log("", e);
                }
            }
        }
        return fSecurePreferences;
    }

    public void start(BundleContext context) throws Exception {
        String test;
        super.start(context);
        if (this.isDebugging() && (test = Platform.getDebugOption((String)"com.ibm.debug.daemon.ui/debug")) != null && test.equalsIgnoreCase("true")) {
            fLogging = true;
        }
    }

    public static boolean isLogging() {
        return fLogging;
    }
}

