/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.daemon.internal.ui;

import com.ibm.debug.daemon.CoreDaemon;
import com.ibm.debug.daemon.internal.core.DaemonLabels;
import com.ibm.debug.daemon.internal.ui.DaemonUtils;
import com.ibm.debug.daemon.internal.ui.DebugDaemonPreferencePage;
import com.ibm.debug.daemon.internal.ui.FontReflowUtil;
import com.ibm.debug.daemon.internal.ui.PortUtility;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.Enumeration;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.preference.IPreferenceNode;
import org.eclipse.jface.preference.IPreferencePage;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.preference.PreferenceManager;
import org.eclipse.jface.preference.PreferenceNode;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class DebugDaemonAction
extends Action
implements IMenuCreator {
    Menu fMenu;
    private ImageDescriptor buttonUp;
    private ImageDescriptor buttonDown;
    private Image iButtonUp;
    private Image iButtonDown;
    public static final String ACTION_ID = "DebugDaemonActionID";

    DebugDaemonAction() {
        this.setId(ACTION_ID);
        this.buttonUp = DaemonUtils.getImageDescriptor("full/elcl16/lstnrdisabled_tsk.png");
        this.buttonDown = DaemonUtils.getImageDescriptor("full/elcl16/lstnrenabled_tsk.png");
        this.setImageDescriptor(this.buttonUp);
        this.setMenuCreator(this);
        try {
            DaemonUtils.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    DebugDaemonAction.this.updateButtonState(DebugDaemonAction.this.isChecked());
                }
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void dispose() {
        if (this.iButtonUp != null) {
            this.iButtonUp.dispose();
            this.iButtonUp = null;
        }
        if (this.iButtonDown != null) {
            this.iButtonDown.dispose();
            this.iButtonDown = null;
        }
    }

    public Menu getMenu(Control parent) {
        if (this.fMenu != null) {
            this.fMenu.dispose();
        }
        this.fMenu = new ThisMenuCreator().getMenu(parent);
        this.fillMenu(this.fMenu);
        return this.fMenu;
    }

    public Menu getMenu(Menu parent) {
        if (this.fMenu != null) {
            this.fMenu.dispose();
        }
        this.fMenu = new ThisMenuCreator().getMenu(parent);
        this.fillMenu(this.fMenu);
        return this.fMenu;
    }

    private String getMenuDaemonStatusUIText() {
        if (CoreDaemon.isListening()) {
            return NLS.bind((String)DaemonLabels.DaemonAction_isListening, (Object)Integer.toString(CoreDaemon.getCurrentPort()));
        }
        return NLS.bind((String)DaemonLabels.DaemonAction_startListening, (Object)PortUtility.getPortPreference());
    }

    private String getMenuDaemonStatusSecureText() {
        if (CoreDaemon.isListeningSecure()) {
            return NLS.bind((String)DaemonLabels.DaemonAction_isListeningSecure, (Object)Integer.toString(CoreDaemon.getCurrentPortSecure()));
        }
        return NLS.bind((String)DaemonLabels.DaemonAction_startListeningSecure, (Object)PortUtility.getSecurePortPreference());
    }

    private String getMenuDaemonActionUIText() {
        if (CoreDaemon.isListening()) {
            return NLS.bind((String)DaemonLabels.DaemonAction_stopListening, (Object)Integer.toString(CoreDaemon.getCurrentPort()));
        }
        return NLS.bind((String)DaemonLabels.DaemonAction_startListening, (Object)PortUtility.getPortPreference());
    }

    private String getMenuDaemonActionSecureText() {
        if (CoreDaemon.isListeningSecure()) {
            return NLS.bind((String)DaemonLabels.DaemonAction_stopListeningSecure, (Object)Integer.toString(CoreDaemon.getCurrentPortSecure()));
        }
        return NLS.bind((String)DaemonLabels.DaemonAction_startListeningSecure, (Object)PortUtility.getSecurePortPreference());
    }

    private Image getCurrentDaemonIcon() {
        if (CoreDaemon.isListening()) {
            if (this.iButtonUp == null) {
                this.iButtonUp = this.buttonUp.createImage();
            }
            return this.iButtonUp;
        }
        if (this.iButtonDown == null) {
            this.iButtonDown = this.buttonDown.createImage();
        }
        return this.iButtonDown;
    }

    private Image getCurrentSecureDaemonIcon() {
        if (CoreDaemon.isListeningSecure()) {
            if (this.iButtonUp == null) {
                this.iButtonUp = this.buttonUp.createImage();
            }
            return this.iButtonUp;
        }
        if (this.iButtonDown == null) {
            this.iButtonDown = this.buttonDown.createImage();
        }
        return this.iButtonDown;
    }

    private void fillMenu(Menu m) {
        boolean uiDaemonEnabled = PortUtility.uiDaemonEnabled();
        boolean secureDaemonEnabled = PortUtility.secureDaemonEnabled();
        this.fillMenuDaemonStatus(m, uiDaemonEnabled, secureDaemonEnabled);
        this.fillMenuDaemonAction(m, uiDaemonEnabled, secureDaemonEnabled);
        this.fillMenuChangePort(m, uiDaemonEnabled, secureDaemonEnabled);
        this.fillMenuGetIP(m, uiDaemonEnabled, secureDaemonEnabled);
    }

    public void runWithEvent(Event event) {
        boolean uiDaemonEnabled = PortUtility.uiDaemonEnabled();
        boolean secureDaemonEnabled = PortUtility.secureDaemonEnabled();
        if (uiDaemonEnabled && secureDaemonEnabled) {
            this.valueChangedBoth(!CoreDaemon.isListening() || !CoreDaemon.isListeningSecure());
            return;
        }
        if (uiDaemonEnabled) {
            this.valueChanged(!CoreDaemon.isListening());
            return;
        }
        if (secureDaemonEnabled) {
            this.valueChangedSecure(!CoreDaemon.isListeningSecure());
        }
    }

    private void valueChanged(boolean isChecked) {
        if (isChecked) {
            CoreDaemon.startListening(true);
            this.updateButtonState();
        } else {
            CoreDaemon.stopListening();
            this.updateButtonState();
        }
    }

    private void valueChangedSecure(boolean isChecked) {
        if (isChecked) {
            CoreDaemon.startListeningSecure(true);
            this.updateButtonState();
        } else {
            CoreDaemon.stopListeningSecure();
            this.updateButtonState();
        }
    }

    private void valueChangedBoth(boolean isChecked) {
        if (isChecked) {
            boolean ok = CoreDaemon.startListening(true);
            if (ok && !(ok = CoreDaemon.startListeningSecure(true))) {
                CoreDaemon.stopListening();
            }
            this.updateButtonState();
        } else {
            CoreDaemon.stopListening();
            CoreDaemon.stopListeningSecure();
            this.updateButtonState();
        }
    }

    public void updateButtonState(boolean isChecked) {
        if (isChecked) {
            this.setImageDescriptor(this.buttonDown);
        } else {
            this.setImageDescriptor(this.buttonUp);
        }
        this.updateToolTipText();
    }

    public void updateButtonState() {
        boolean isChecked = this.isChecked();
        this.updateButtonState(isChecked);
    }

    protected static String getToolTipText(boolean isChecked) {
        if (isChecked) {
            String result = "";
            if (CoreDaemon.isListening() && CoreDaemon.isListeningSecure()) {
                result = NLS.bind((String)DaemonLabels.DaemonAction_isListeningBothTooltip, (Object)CoreDaemon.getCurrentPort(), (Object)CoreDaemon.getCurrentPortSecure());
                return result;
            }
            if (CoreDaemon.isListening()) {
                result = NLS.bind((String)DaemonLabels.DaemonAction_isListeningTooltip, (Object)Integer.toString(CoreDaemon.getCurrentPort()));
            } else if (CoreDaemon.isListeningSecure()) {
                result = NLS.bind((String)DaemonLabels.DaemonAction_isListeningSecureTooltip, (Object)Integer.toString(CoreDaemon.getCurrentPortSecure()));
            }
            return result;
        }
        boolean uiDaemonEnabled = PortUtility.uiDaemonEnabled();
        boolean secureDaemonEnabled = PortUtility.secureDaemonEnabled();
        String result = "";
        if (uiDaemonEnabled && secureDaemonEnabled) {
            result = NLS.bind((String)DaemonLabels.DaemonAction_notListeningBothTooltip, (Object)PortUtility.getPortPreference(), (Object)PortUtility.getSecurePortPreference());
        } else if (uiDaemonEnabled) {
            result = NLS.bind((String)DaemonLabels.DaemonAction_notListeningTooltip, (Object)PortUtility.getPortPreference());
        } else if (secureDaemonEnabled) {
            result = NLS.bind((String)DaemonLabels.DaemonAction_notListeningSecureTooltip, (Object)PortUtility.getSecurePortPreference());
        }
        return result;
    }

    void updateToolTipText() {
        this.setToolTipText(DebugDaemonAction.getToolTipText(this.isChecked()));
    }

    public boolean isChecked() {
        boolean uiDaemonEnabled = PortUtility.uiDaemonEnabled();
        boolean secureDaemonEnabled = PortUtility.secureDaemonEnabled();
        if (uiDaemonEnabled && secureDaemonEnabled) {
            return CoreDaemon.isListening() && CoreDaemon.isListeningSecure();
        }
        if (uiDaemonEnabled) {
            return CoreDaemon.isListening();
        }
        if (secureDaemonEnabled) {
            return CoreDaemon.isListeningSecure();
        }
        return false;
    }

    private void fillMenuDaemonStatus(Menu m, boolean uiDaemonEnabled, boolean secureDaemonEnabled) {
        if (uiDaemonEnabled && secureDaemonEnabled) {
            if (CoreDaemon.isListening() && CoreDaemon.isListeningSecure()) {
                MenuItem item1 = new MenuItem(m, 16);
                PlatformUI.getWorkbench().getHelpSystem().setHelp(item1, "com.ibm.debug.daemon.debug_daemon_action_menu_is_listening_message");
                item1.setText(NLS.bind((String)DaemonLabels.DaemonAction_isListeningBoth, (Object)Integer.toString(CoreDaemon.getCurrentPort()), (Object)CoreDaemon.getCurrentPortSecure()));
                item1.setSelection(true);
            }
            return;
        }
        if (uiDaemonEnabled) {
            if (CoreDaemon.isListening()) {
                MenuItem item1 = new MenuItem(m, 16);
                PlatformUI.getWorkbench().getHelpSystem().setHelp(item1, "com.ibm.debug.daemon.debug_daemon_action_menu_is_listening_message");
                item1.setText(this.getMenuDaemonStatusUIText());
                item1.setSelection(true);
            }
            return;
        }
        if (secureDaemonEnabled && CoreDaemon.isListeningSecure()) {
            MenuItem item1a = new MenuItem(m, 16);
            PlatformUI.getWorkbench().getHelpSystem().setHelp(item1a, "com.ibm.debug.daemon.debug_daemon_action_menu_is_listening_message");
            item1a.setText(this.getMenuDaemonStatusSecureText());
            item1a.setSelection(true);
        }
    }

    private void fillMenuDaemonAction(Menu m, boolean uiDaemonEnabled, boolean secureDaemonEnabled) {
        if (uiDaemonEnabled && secureDaemonEnabled) {
            String menuText = null;
            menuText = CoreDaemon.isListening() && CoreDaemon.isListeningSecure() ? NLS.bind((String)DaemonLabels.DaemonAction_stopListeningBoth, (Object)CoreDaemon.getCurrentPort(), (Object)CoreDaemon.getCurrentPortSecure()) : NLS.bind((String)DaemonLabels.DaemonAction_startListeningBoth, (Object)PortUtility.getPortPreference(), (Object)PortUtility.getSecurePortPreference());
            MenuItem item2 = new MenuItem(m, 0);
            item2.setText(menuText);
            item2.setImage(this.getCurrentDaemonIcon());
            item2.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    DebugDaemonAction.this.valueChangedBoth(!CoreDaemon.isListening() || !CoreDaemon.isListeningSecure());
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
            return;
        }
        if (uiDaemonEnabled) {
            MenuItem item2 = new MenuItem(m, 0);
            item2.setText(this.getMenuDaemonActionUIText());
            item2.setImage(this.getCurrentDaemonIcon());
            if (CoreDaemon.isListening()) {
                PlatformUI.getWorkbench().getHelpSystem().setHelp(item2, "com.ibm.debug.daemon.debug_daemon_action_menu_stop_listening");
            } else {
                PlatformUI.getWorkbench().getHelpSystem().setHelp(item2, "com.ibm.debug.daemon.debug_daemon_action_menu_start_listening");
            }
            item2.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    DebugDaemonAction.this.valueChanged(!CoreDaemon.isListening());
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
            return;
        }
        if (secureDaemonEnabled) {
            MenuItem item2 = new MenuItem(m, 0);
            item2.setText(this.getMenuDaemonActionSecureText());
            item2.setImage(this.getCurrentSecureDaemonIcon());
            if (CoreDaemon.isListeningSecure()) {
                PlatformUI.getWorkbench().getHelpSystem().setHelp(item2, "com.ibm.debug.daemon.debug_daemon_action_menu_stop_listening");
            } else {
                PlatformUI.getWorkbench().getHelpSystem().setHelp(item2, "com.ibm.debug.daemon.debug_daemon_action_menu_start_listening");
            }
            item2.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    DebugDaemonAction.this.valueChangedSecure(!CoreDaemon.isListeningSecure());
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
        }
    }

    private void fillMenuChangePort(Menu m, boolean uiDaemonEnabled, boolean secureDaemonEnabled) {
        MenuItem item3 = new MenuItem(m, 0);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(item3, "com.ibm.debug.daemon.debug_daemon_action_menu_change_port");
        item3.setText(DaemonLabels.DaemonAction_pulldownChangePort);
        item3.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                PreferenceManager prefMgr = new PreferenceManager();
                PreferenceNode node = new PreferenceNode("com.ibm.debug.daemon.DebugDaemonPreferencePage", (IPreferencePage)new DebugDaemonPreferencePage());
                prefMgr.addToRoot((IPreferenceNode)node);
                PreferenceDialog dialog = new PreferenceDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), prefMgr);
                dialog.open();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    private void fillMenuGetIP(Menu m, boolean uiDaemonEnabled, boolean secureDaemonEnabled) {
        if (this.isChecked()) {
            MenuItem item4 = new MenuItem(m, 0);
            PlatformUI.getWorkbench().getHelpSystem().setHelp(item4, "com.ibm.debug.daemon.debug_daemon_action_menu_workstation_ip");
            item4.setText(DaemonLabels.DaemonAction_pulldownGetIP);
            item4.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    new TrayDialog(DaemonUtils.getShell()){

                        protected void configureShell(Shell newShell) {
                            super.configureShell(newShell);
                            newShell.setText(DaemonLabels.DaemonAction_getIPDialogTitle);
                        }

                        protected Control createContents(Composite parent) {
                            ScrolledComposite scrolled = new ScrolledComposite(parent, 2816);
                            scrolled.setShowFocusedControl(true);
                            scrolled.setExpandHorizontal(true);
                            scrolled.setExpandVertical(true);
                            GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)scrolled);
                            Control contents = super.createContents((Composite)scrolled);
                            scrolled.setContent(contents);
                            scrolled.setMinSize(contents.computeSize(-1, -1));
                            FontReflowUtil.installListeners(scrolled);
                            return scrolled;
                        }

                        protected Control createDialogArea(Composite parent) {
                            Composite comp = (Composite)super.createDialogArea(parent);
                            String hostName = "localhost";
                            try {
                                hostName = InetAddress.getLocalHost().getCanonicalHostName();
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            Label l = new Label(comp, 0);
                            l.setText(hostName);
                            Table ipTable = new Table(comp, 67588);
                            ipTable.setLayoutData((Object)new GridData(4, 1, true, false));
                            ipTable.setHeaderVisible(true);
                            ipTable.setLinesVisible(true);
                            new TableColumn(ipTable, 131072).setText(DaemonLabels.DaemonAction_getIPDialogTitle);
                            new TableColumn(ipTable, 0);
                            try {
                                Enumeration<NetworkInterface> netInterfaces = NetworkInterface.getNetworkInterfaces();
                                while (netInterfaces.hasMoreElements()) {
                                    NetworkInterface netInterface = netInterfaces.nextElement();
                                    if (netInterface.isLoopback()) continue;
                                    Enumeration<InetAddress> addresses = netInterface.getInetAddresses();
                                    while (addresses.hasMoreElements()) {
                                        InetAddress addr = addresses.nextElement();
                                        if (addr.isLinkLocalAddress() || addr.isLoopbackAddress()) continue;
                                        TableItem ti = new TableItem(ipTable, 0);
                                        ti.setText(0, addr.getHostAddress());
                                        ti.setText(1, netInterface.getDisplayName());
                                    }
                                }
                            }
                            catch (Exception netInterfaces) {
                                // empty catch block
                            }
                            TableColumn[] cols = ipTable.getColumns();
                            int i = 0;
                            while (i < cols.length) {
                                cols[i].pack();
                                ++i;
                            }
                            boolean EDITCOLUMN = false;
                            final TableEditor tableEditor = new TableEditor(ipTable);
                            tableEditor.horizontalAlignment = 16384;
                            tableEditor.grabHorizontal = true;
                            tableEditor.minimumWidth = this.convertWidthInCharsToPixels(11);
                            final Text cellEditor = new Text((Composite)ipTable, 8);
                            ipTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

                                public void widgetSelected(SelectionEvent e) {
                                    TableItem tableItem = (TableItem)e.item;
                                    if (tableItem == null) {
                                        return;
                                    }
                                    cellEditor.setText(tableItem.getText(0));
                                    cellEditor.selectAll();
                                    cellEditor.setFocus();
                                    tableEditor.setEditor((Control)cellEditor, tableItem, 0);
                                }
                            });
                            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.getShell(), "com.ibm.debug.daemon.workstation_ip_dialog");
                            return parent;
                        }

                        protected int getShellStyle() {
                            return 0x10 | super.getShellStyle();
                        }

                        protected void createButtonsForButtonBar(Composite parent) {
                            this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
                        }
                    }.open();
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
        }
    }

    private static class ThisMenuCreator
    implements IMenuCreator {
        private Menu fMenu = null;

        public void dispose() {
        }

        public Menu getMenu(Control parent) {
            if (this.fMenu == null) {
                this.fMenu = new Menu(parent);
            }
            return this.fMenu;
        }

        public Menu getMenu(Menu parent) {
            if (this.fMenu == null) {
                this.fMenu = new Menu(parent);
            }
            return this.fMenu;
        }
    }
}

