/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.daemon.internal.ui;

import com.ibm.debug.daemon.internal.ui.DebugDaemonPlugin;
import java.net.URL;
import org.eclipse.equinox.security.storage.ISecurePreferences;
import org.eclipse.equinox.security.storage.StorageException;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;

public class DaemonUtils {
    private static URL ICON_BASE_URL = null;
    static final String PASSWORD_NODE = "keystore_password";
    static final String AUTH_PASSWORD_NODE = "auth_keystore_password";
    private static final String PASSWORD = "password";
    private static final String EMPTY_STRING = "";

    static {
        ICON_BASE_URL = DebugDaemonPlugin.getPluginBundle().getEntry("icons/");
    }

    public static Image getIcon(String filename) {
        try {
            ImageDescriptor ret = ImageDescriptor.createFromURL((URL)new URL(ICON_BASE_URL, filename));
            return ret.createImage();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static ImageDescriptor getImageDescriptor(String name) {
        try {
            return ImageDescriptor.createFromURL((URL)new URL(ICON_BASE_URL, name));
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static final Shell getShell() {
        final Shell[] shell = new Shell[1];
        final Display display = PlatformUI.getWorkbench().getDisplay();
        display.syncExec(new Runnable(){

            @Override
            public void run() {
                shell[0] = display.getActiveShell();
            }
        });
        return shell[0];
    }

    public static final Display getDisplay() {
        IWorkbench workbench = PlatformUI.getWorkbench();
        if (workbench != null) {
            return workbench.getDisplay();
        }
        return null;
    }

    static void addPasswordToSecureStorage(ISecurePreferences securePreferences, char[] keyStorePassword, String node) {
        ISecurePreferences thisNode = null;
        if (securePreferences.nodeExists(node)) {
            thisNode = securePreferences.node(node);
            thisNode.removeNode();
        }
        thisNode = securePreferences.node(node);
        try {
            thisNode.put(PASSWORD, String.valueOf(keyStorePassword), true);
        }
        catch (StorageException e) {
            DebugDaemonPlugin.log(EMPTY_STRING, (Exception)((Object)e));
        }
    }

    static char[] getPasswordFromSecureStorage(ISecurePreferences securePreferences, String node) {
        if (securePreferences.nodeExists(node)) {
            try {
                ISecurePreferences thisNode = securePreferences.node(node);
                return thisNode.get(PASSWORD, EMPTY_STRING).toCharArray();
            }
            catch (StorageException e) {
                DebugDaemonPlugin.log(EMPTY_STRING, (Exception)((Object)e));
            }
        }
        return EMPTY_STRING.toCharArray();
    }
}

