/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.breakpoints.stackpattern.ui.actions;

import com.ibm.debug.breakpoints.stackpattern.IStackPatternLanguageAdapter;
import com.ibm.debug.breakpoints.stackpattern.StackPatternUtils;
import com.ibm.debug.breakpoints.stackpattern.internal.SPMessages;
import com.ibm.debug.breakpoints.stackpattern.ui.actions.DisableStackPatternAction;
import com.ibm.debug.breakpoints.stackpattern.ui.actions.EnableStackPatternAction;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.ui.actions.RulerBreakpointAction;
import org.eclipse.jface.text.source.IVerticalRulerInfo;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.IUpdate;

public class RulerToggleStackPatternAction
extends RulerBreakpointAction
implements IUpdate {
    private IBreakpoint fBreakpoint;

    public RulerToggleStackPatternAction(ITextEditor editor, IVerticalRulerInfo info) {
        super(editor, info);
    }

    public void run() {
        if (this.fBreakpoint != null) {
            if (this.isStackPatternEnabled(this.fBreakpoint)) {
                DisableStackPatternAction.doDisableStackPatternAction(this.fBreakpoint);
            } else {
                EnableStackPatternAction.doEnableStackPatternAction(this.fBreakpoint);
            }
        }
    }

    public void update() {
        this.fBreakpoint = this.getBreakpoint();
        this.setEnabled(this.fBreakpoint != null);
        if (this.fBreakpoint != null) {
            if (this.isStackPatternEnabled(this.fBreakpoint)) {
                this.setText(SPMessages.getString("RulerToggleStackPatternAction_0"));
            } else {
                this.setText(SPMessages.getString("RulerToggleStackPatternAction_1"));
            }
        } else {
            this.setText(SPMessages.getString("RulerToggleStackPatternAction_0"));
        }
    }

    private boolean isStackPatternEnabled(IBreakpoint breakpoint) {
        IStackPatternLanguageAdapter languageAdapter = StackPatternUtils.getLanguageAdapter(breakpoint);
        return languageAdapter.isStackPatternEnabled(breakpoint);
    }
}

