/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.breakpoints.stackpattern.ui.actions;

import com.ibm.debug.breakpoints.stackpattern.IStackPatternLanguageAdapter;
import com.ibm.debug.breakpoints.stackpattern.StackPatternUtils;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.dialogs.PreferencesUtil;

public class EditStackPatternActionDelegate
implements IObjectActionDelegate {
    private ISelection fSelection;

    public void run(IAction action) {
        if (this.fSelection instanceof IStructuredSelection) {
            IStructuredSelection strucSel = (IStructuredSelection)this.fSelection;
            for (Object selection : strucSel) {
                if (!(selection instanceof IBreakpoint)) continue;
                IBreakpoint breakpoint = (IBreakpoint)selection;
                IStackPatternLanguageAdapter languageAdapter = StackPatternUtils.getLanguageAdapter(breakpoint);
                PreferenceDialog dialog = PreferencesUtil.createPropertyDialogOn((Shell)StackPatternUtils.getShell(), (IAdaptable)breakpoint, (String)languageAdapter.getPropertyPageID(), null, null);
                dialog.open();
            }
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.fSelection = selection;
        if (this.fSelection instanceof IStructuredSelection) {
            IStructuredSelection strucSel = (IStructuredSelection)this.fSelection;
            if (strucSel.size() != 1) {
                action.setEnabled(false);
            } else {
                action.setEnabled(true);
            }
        }
    }

    public void setActivePart(IAction action, IWorkbenchPart part) {
    }
}

