/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.breakpoints.stackpattern.ui;

import com.ibm.debug.breakpoints.stackpattern.IStackFrameImporter;
import com.ibm.debug.breakpoints.stackpattern.IStackPatternEntry;
import com.ibm.debug.breakpoints.stackpattern.IStackPatternLanguageAdapter;
import com.ibm.debug.breakpoints.stackpattern.StackPatternRoot;
import com.ibm.debug.breakpoints.stackpattern.StackPatternUtils;
import com.ibm.debug.breakpoints.stackpattern.internal.SPMessages;
import com.ibm.debug.breakpoints.stackpattern.internal.parser.StackPatternEntry;
import com.ibm.debug.breakpoints.stackpattern.internal.ui.SPUIBuilder;
import com.ibm.debug.breakpoints.stackpattern.internal.ui.SPUIReconciler;
import com.ibm.debug.breakpoints.stackpattern.ui.StackPatternImportDialog;
import com.ibm.debug.breakpoints.stackpattern.ui.actions.DisableStackPatternAction;
import com.ibm.debug.breakpoints.stackpattern.ui.actions.EnableStackPatternAction;
import com.ibm.debug.xmlui.api.XUIAttributeList;
import com.ibm.debug.xmlui.api.XUIParseException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PropertyPage;

public class StackPatternPropertiesPage
extends PropertyPage {
    private SPUIBuilder fBuilder;
    private SPUIReconciler fReconciler;
    private IBreakpoint fBreakpoint;
    private IStackPatternLanguageAdapter fLanguageAdapter;
    private ListViewer fStackPatternListViewer;
    private Button fEnableButton;
    private Button fImportButton;
    private Button fAppendButton;
    private Button fInsertButton;
    private Button fRemoveButton;
    private StackPatternEntry fOldSelection = null;
    private WidgetListener fListener = new WidgetListener();
    private StackPatternRoot fStackPatternRoot = new StackPatternRoot();

    protected Control createContents(Composite parent) {
        this.fBreakpoint = this.getBreakpoint();
        this.fLanguageAdapter = StackPatternUtils.getLanguageAdapter(this.fBreakpoint);
        this.fStackPatternRoot.setLanguageAdapter(this.fLanguageAdapter);
        URL url = this.fLanguageAdapter.getSchemaURL();
        try {
            this.fBuilder = new SPUIBuilder(url, this.fLanguageAdapter.getClass().getClassLoader());
            this.fReconciler = (SPUIReconciler)this.fBuilder.getReconciler();
        }
        catch (XUIParseException ex) {
            StackPatternUtils.logError((Exception)((Object)ex));
        }
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        composite.setLayout((Layout)layout);
        GridData gridData = new GridData(1808);
        composite.setLayoutData((Object)gridData);
        this.fEnableButton = new Button(composite, 32);
        this.fEnableButton.setText(SPMessages.getString("property_page_enable_stack_pattern_label"));
        this.fEnableButton.addSelectionListener((SelectionListener)this.fListener);
        Composite composite2 = new Composite(composite, 0);
        layout = new GridLayout();
        layout.numColumns = 2;
        composite2.setLayout((Layout)layout);
        composite2.setLayoutData((Object)new GridData(1808));
        this.createStackFramePane(composite2);
        this.initializeButtonStates();
        this.fBuilder.createContents(composite2);
        IBreakpoint breakpoint = this.getBreakpoint();
        if (breakpoint != null) {
            this.fReconciler.setPropertyPage(this);
            this.fReconciler.reconcileBreakpointStackPatterns(breakpoint);
        }
        IStackPatternEntry initialSelection = null;
        initialSelection = this.fStackPatternRoot.size() > 1 ? this.fStackPatternRoot.getStackPatternEntry(1) : this.fStackPatternRoot.getStackPatternEntry(0);
        StructuredSelection ss = new StructuredSelection((Object)initialSelection);
        this.fStackPatternListViewer.setSelection((ISelection)ss, true);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), "com.ibm.debug.breakpoints.stackpattern.stack_pattern_breakpoint_property_page");
        Dialog.applyDialogFont((Control)composite);
        return composite;
    }

    public void createInitialStackPatternList(StackPatternRoot root) {
        this.fStackPatternRoot = root;
        this.fStackPatternRoot.setLanguageAdapter(this.fLanguageAdapter);
        this.fStackPatternListViewer.setContentProvider((IContentProvider)this.fStackPatternRoot);
        if (this.fStackPatternRoot.size() > 0) {
            this.fStackPatternListViewer.refresh();
            this.fStackPatternListViewer.getList().select(0);
            StructuredSelection ss = new StructuredSelection((Object)this.fStackPatternRoot.getStackPatternEntry(0));
            this.fStackPatternListViewer.setSelection((ISelection)ss, true);
        }
    }

    private void initializeButtonStates() {
        IBreakpoint breakpoint = this.getBreakpoint();
        if (breakpoint != null) {
            this.fEnableButton.setSelection(this.fLanguageAdapter.isStackPatternEnabled(breakpoint));
        }
    }

    private Control createStackFramePane(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        container.setLayout((Layout)layout);
        GridData gridData = new GridData(1808);
        container.setLayoutData((Object)gridData);
        this.createStackPatternList(container);
        return container;
    }

    private Control createStackPatternList(Composite parent) {
        Label spLabel = new Label(parent, 0);
        spLabel.setText(SPMessages.getString("property_page_stack_pattern"));
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        container.setLayout((Layout)layout);
        GridData gridData = new GridData(1808);
        container.setLayoutData((Object)gridData);
        this.fStackPatternListViewer = new ListViewer(container, 2818);
        this.fStackPatternListViewer.setLabelProvider((IBaseLabelProvider)new StackPatternLabelProvider());
        this.fStackPatternListViewer.setContentProvider((IContentProvider)this.fStackPatternRoot);
        this.fStackPatternListViewer.setInput((Object)this);
        this.fStackPatternListViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ISelection selection = event.getSelection();
                if (selection instanceof IStructuredSelection) {
                    StackPatternEntry selectedEntry;
                    IStructuredSelection ss = (IStructuredSelection)selection;
                    Object firstElement = ss.getFirstElement();
                    if (firstElement instanceof StackPatternEntry && StackPatternPropertiesPage.this.fOldSelection != (selectedEntry = (StackPatternEntry)firstElement)) {
                        if (StackPatternPropertiesPage.this.fOldSelection != null && !StackPatternPropertiesPage.this.fOldSelection.isTopPatternEntry()) {
                            XUIAttributeList attributes = StackPatternPropertiesPage.this.fBuilder.getAttributes();
                            StackPatternPropertiesPage.this.fOldSelection.setAttributes(attributes);
                            StackPatternPropertiesPage.this.fStackPatternListViewer.refresh();
                        }
                        StackPatternPropertiesPage.this.fReconciler.reconcilePatternEntry(selectedEntry);
                        StackPatternPropertiesPage.this.fOldSelection = selectedEntry;
                    }
                    StackPatternPropertiesPage.this.updateButtonStatus(ss);
                }
            }
        });
        gridData = new GridData(1808);
        gridData.widthHint = 210;
        gridData.heightHint = 150;
        this.fStackPatternListViewer.getList().setLayoutData((Object)gridData);
        this.createButtonArea(container);
        return container;
    }

    private Control createButtonArea(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        container.setLayout((Layout)layout);
        GridData gridData = new GridData(768);
        container.setLayoutData((Object)gridData);
        this.fImportButton = new Button(container, 8);
        this.fImportButton.setText(SPMessages.getString("property_page_import_button"));
        gridData = new GridData(770);
        this.fImportButton.setLayoutData((Object)gridData);
        this.fImportButton.addSelectionListener((SelectionListener)this.fListener);
        this.fAppendButton = new Button(container, 8);
        this.fAppendButton.setText(SPMessages.getString("property_page_append_pattern_button"));
        gridData = new GridData(770);
        this.fAppendButton.setLayoutData((Object)gridData);
        this.fAppendButton.addSelectionListener((SelectionListener)this.fListener);
        this.fInsertButton = new Button(container, 8);
        this.fInsertButton.setText(SPMessages.getString("property_page_insert_pattern_button"));
        gridData = new GridData(770);
        this.fInsertButton.setLayoutData((Object)gridData);
        this.fInsertButton.addSelectionListener((SelectionListener)this.fListener);
        this.fRemoveButton = new Button(container, 8);
        this.fRemoveButton.setText(SPMessages.getString("property_page_remove_pattern_button"));
        gridData = new GridData(770);
        this.fRemoveButton.setLayoutData((Object)gridData);
        this.fRemoveButton.addSelectionListener((SelectionListener)this.fListener);
        return container;
    }

    public boolean performOk() {
        this.handleImplicitSave();
        String stackPattern = this.fLanguageAdapter.generateStackPatternString(this.fStackPatternRoot);
        this.fLanguageAdapter.setStackPatternAttribute(this.fBreakpoint, stackPattern);
        IBreakpoint breakpoint = this.getBreakpoint();
        if (breakpoint != null) {
            if (this.fEnableButton.getSelection()) {
                EnableStackPatternAction.doEnableStackPatternAction(breakpoint);
            } else {
                DisableStackPatternAction.doDisableStackPatternAction(breakpoint);
            }
        }
        return super.performOk();
    }

    protected void performDefaults() {
        super.performDefaults();
    }

    public IBreakpoint getBreakpoint() {
        IAdaptable element = this.getElement();
        if (element instanceof IBreakpoint) {
            return (IBreakpoint)element;
        }
        Object adapter = element.getAdapter(IBreakpoint.class);
        if (adapter instanceof IBreakpoint) {
            return (IBreakpoint)adapter;
        }
        return null;
    }

    public IStackPatternLanguageAdapter getLanguageAdapter() {
        return this.fLanguageAdapter;
    }

    private void handleImportButtonSelected() {
        IBreakpoint breakpoint = this.getBreakpoint();
        if (breakpoint == null) {
            return;
        }
        IThread[] threads = this.getThreadsSuspendedAtBreakpoint(breakpoint);
        boolean isImportFromCurrentThreadEnabled = threads.length > 0;
        StackPatternImportDialog.Result result = new StackPatternImportDialog.Result();
        StackPatternImportDialog dialog = new StackPatternImportDialog(this.getShell(), result, isImportFromCurrentThreadEnabled);
        if (dialog.open() == 0) {
            if (result.getImportSelection() == 1) {
                String stackTraceText = dialog.getText();
                this.importStackTrace(stackTraceText);
            } else if (threads.length > 0 && result.getImportSelection() == 0) {
                this.importStackFrames(threads[0]);
            }
        }
    }

    private void importStackTrace(String stackTraceText) {
        IStackFrameImporter importer = this.fLanguageAdapter.getStackFrameImporter();
        XUIAttributeList[] attributeLists = importer.importStackTrace(stackTraceText);
        if (attributeLists != null && attributeLists.length > 0) {
            this.fStackPatternRoot.clear();
            XUIAttributeList[] xUIAttributeListArray = attributeLists;
            int n = attributeLists.length;
            int n2 = 0;
            while (n2 < n) {
                XUIAttributeList attrList = xUIAttributeListArray[n2];
                String frameLabel = importer.getPatternLabel(attrList);
                StackPatternEntry patternEntry = new StackPatternEntry(frameLabel, this.fStackPatternRoot);
                if (attrList.size() > 0) {
                    patternEntry.setAttributes(attrList);
                }
                this.fStackPatternRoot.addStackPatternEntry(patternEntry);
                this.fBuilder.reconcileAttributes(attrList);
                ++n2;
            }
            this.fStackPatternListViewer.refresh();
            if (this.fStackPatternRoot.size() > 0) {
                StructuredSelection ss = new StructuredSelection((Object)this.fStackPatternRoot.getStackPatternEntry(0));
                this.fStackPatternListViewer.setSelection((ISelection)ss, true);
            }
        } else {
            ErrorDialog.openError((Shell)this.getShell(), (String)SPMessages.getString("import_dialog_importing_failed_title"), (String)SPMessages.getString("import_dialog_importing_failed_message"), (IStatus)new Status(2, "com.ibm.debug.breakpoints.stackpattern", SPMessages.getString("import_dialog_error_invalid_stack_trace")));
        }
    }

    private void importStackFrames(IThread thread) {
        try {
            IStackFrame[] frames = thread.getStackFrames();
            if (frames.length > 0) {
                this.fStackPatternRoot.clear();
            }
            IStackFrameImporter importer = this.fLanguageAdapter.getStackFrameImporter();
            int i = 0;
            while (i < frames.length) {
                IStackFrame frame = frames[i];
                String frameLabel = importer.getPatternLabel(frame);
                StackPatternEntry pattern = new StackPatternEntry(frameLabel, this.fStackPatternRoot);
                XUIAttributeList attributes = importer.getAttributes(frame);
                if (attributes.size() > 0) {
                    pattern.setAttributes(attributes);
                }
                this.fStackPatternRoot.addStackPatternEntry(pattern);
                this.fBuilder.reconcileAttributes(attributes);
                ++i;
            }
        }
        catch (DebugException frames) {
            // empty catch block
        }
        this.fStackPatternListViewer.refresh();
        if (this.fStackPatternRoot.size() > 0) {
            StructuredSelection ss = new StructuredSelection((Object)this.fStackPatternRoot.getStackPatternEntry(0));
            this.fStackPatternListViewer.setSelection((ISelection)ss, true);
        }
    }

    private void handleAppendPatternEntryButtonSelected() {
        StackPatternEntry patternEntry = new StackPatternEntry("*", this.fStackPatternRoot);
        this.fStackPatternRoot.addStackPatternEntry(patternEntry);
        this.fStackPatternListViewer.refresh();
        StructuredSelection ss = new StructuredSelection((Object)patternEntry);
        this.fStackPatternListViewer.setSelection((ISelection)ss, true);
        this.fBuilder.getReconciler().initializeDefaults();
    }

    private void handleInsertPatternEntryButtonSelected() {
        StackPatternEntry selectedPatternEntry = this.getSelectedPatternEntry();
        int currentIndex = this.fStackPatternRoot.indexOf(selectedPatternEntry);
        if (currentIndex >= 0) {
            StackPatternEntry patternEntry = new StackPatternEntry("*", this.fStackPatternRoot);
            this.fStackPatternRoot.addStackPatternEntry(currentIndex, patternEntry);
            this.fStackPatternListViewer.refresh();
            StructuredSelection ss = new StructuredSelection((Object)patternEntry);
            this.fStackPatternListViewer.setSelection((ISelection)ss, true);
            this.fBuilder.getReconciler().initializeDefaults();
        }
    }

    private StackPatternEntry getSelectedPatternEntry() {
        Object firstElement;
        ISelection selection = this.fStackPatternListViewer.getSelection();
        if (selection instanceof IStructuredSelection && (firstElement = ((IStructuredSelection)selection).getFirstElement()) instanceof StackPatternEntry) {
            return (StackPatternEntry)firstElement;
        }
        return null;
    }

    private void handleImplicitSave() {
        XUIAttributeList attributes = this.fBuilder.getAttributes();
        ISelection selection = this.fStackPatternListViewer.getSelection();
        if (selection instanceof IStructuredSelection) {
            Object firstSelection = ((IStructuredSelection)selection).getFirstElement();
            if (firstSelection instanceof StackPatternEntry) {
                StackPatternEntry patternEntry = (StackPatternEntry)firstSelection;
                if (!patternEntry.isTopPatternEntry()) {
                    patternEntry.setAttributes(attributes);
                }
            } else if (attributes.size() > 0) {
                StackPatternEntry patternEntry = new StackPatternEntry("*", this.fStackPatternRoot);
                patternEntry.setAttributes(attributes);
                this.fStackPatternRoot.addStackPatternEntry(patternEntry);
            }
            this.fStackPatternListViewer.refresh();
        }
        this.removeDuplicateSeparators();
    }

    private void handleRemovePatternEntryButtonSelected() {
        ISelection selection = this.fStackPatternListViewer.getSelection();
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection ss = (IStructuredSelection)selection;
            Iterator it = ss.iterator();
            int numSelection = ss.size();
            int selectionIndex = -1;
            while (it.hasNext()) {
                StackPatternEntry patternEntry;
                Object item = it.next();
                if (!(item instanceof StackPatternEntry) || (patternEntry = (StackPatternEntry)item).isTopPatternEntry()) continue;
                if (numSelection == 1) {
                    selectionIndex = this.fStackPatternRoot.indexOf(patternEntry);
                }
                this.fStackPatternRoot.remove(patternEntry);
            }
            this.fStackPatternListViewer.refresh();
            IStackPatternEntry newSelection = null;
            newSelection = numSelection == 1 ? (this.fStackPatternRoot.size() > selectionIndex ? this.fStackPatternRoot.getStackPatternEntry(selectionIndex) : this.fStackPatternRoot.getStackPatternEntry(this.fStackPatternRoot.size() - 1)) : (this.fStackPatternRoot.size() > 1 ? this.fStackPatternRoot.getStackPatternEntry(1) : this.fStackPatternRoot.getStackPatternEntry(0));
            if (newSelection != null) {
                ss = new StructuredSelection((Object)newSelection);
                this.fStackPatternListViewer.setSelection((ISelection)ss, true);
            } else {
                this.fBuilder.getReconciler().initializeDefaults();
            }
        }
    }

    private IThread[] getThreadsSuspendedAtBreakpoint(IBreakpoint targetBreakpoint) {
        IDebugTarget[] targets = DebugPlugin.getDefault().getLaunchManager().getDebugTargets();
        ArrayList<IThread> suspendedThreads = new ArrayList<IThread>();
        IDebugTarget[] iDebugTargetArray = targets;
        int n = targets.length;
        int n2 = 0;
        while (n2 < n) {
            IDebugTarget target = iDebugTargetArray[n2];
            try {
                IThread[] threads;
                IThread[] iThreadArray = threads = target.getThreads();
                int n3 = threads.length;
                int n4 = 0;
                while (n4 < n3) {
                    IThread thread = iThreadArray[n4];
                    if (thread.isSuspended()) {
                        IBreakpoint[] breakpoints;
                        IBreakpoint[] iBreakpointArray = breakpoints = thread.getBreakpoints();
                        int n5 = breakpoints.length;
                        int n6 = 0;
                        while (n6 < n5) {
                            IBreakpoint breakpoint = iBreakpointArray[n6];
                            if (breakpoint == targetBreakpoint) {
                                suspendedThreads.add(thread);
                                break;
                            }
                            ++n6;
                        }
                    }
                    ++n4;
                }
            }
            catch (DebugException debugException) {
                // empty catch block
            }
            ++n2;
        }
        return suspendedThreads.toArray(new IThread[suspendedThreads.size()]);
    }

    private void updateButtonStatus(IStructuredSelection ss) {
        int numSelection = ss.size();
        if (numSelection == 1) {
            StackPatternEntry selectedEntry = (StackPatternEntry)ss.getFirstElement();
            this.fImportButton.setEnabled(true);
            this.fAppendButton.setEnabled(true);
            if (selectedEntry.isTopPatternEntry()) {
                this.fInsertButton.setEnabled(false);
                this.fRemoveButton.setEnabled(false);
                this.fReconciler.setEnabledAllControls(false);
            } else {
                this.fInsertButton.setEnabled(true);
                this.fRemoveButton.setEnabled(true);
                this.fReconciler.setEnabledAllControls(true);
            }
        } else {
            this.fImportButton.setEnabled(false);
            this.fAppendButton.setEnabled(false);
            this.fInsertButton.setEnabled(false);
            this.fRemoveButton.setEnabled(true);
        }
    }

    private void removeDuplicateSeparators() {
        IStackPatternEntry firstSeparator = null;
        int i = 0;
        while (i < this.fStackPatternRoot.size()) {
            IStackPatternEntry pattern = this.fStackPatternRoot.getStackPatternEntry(i);
            if (pattern.isSeparator()) {
                if (firstSeparator == null) {
                    firstSeparator = pattern;
                } else {
                    this.fStackPatternRoot.remove(i);
                    --i;
                }
            } else if (firstSeparator != null) {
                firstSeparator = null;
            }
            ++i;
        }
        this.fStackPatternListViewer.refresh();
    }

    static class StackPatternLabelProvider
    extends LabelProvider {
        StackPatternLabelProvider() {
        }

        public Image getImage(Object element) {
            return null;
        }

        public String getText(Object element) {
            if (element instanceof StackPatternEntry) {
                return ((StackPatternEntry)element).getName();
            }
            return null;
        }
    }

    private class WidgetListener
    implements SelectionListener {
        private WidgetListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            Object source = e.getSource();
            if (source == StackPatternPropertiesPage.this.fImportButton) {
                StackPatternPropertiesPage.this.handleImportButtonSelected();
            } else if (source == StackPatternPropertiesPage.this.fAppendButton) {
                StackPatternPropertiesPage.this.handleAppendPatternEntryButtonSelected();
            } else if (source == StackPatternPropertiesPage.this.fInsertButton) {
                StackPatternPropertiesPage.this.handleInsertPatternEntryButtonSelected();
            } else if (source == StackPatternPropertiesPage.this.fRemoveButton) {
                StackPatternPropertiesPage.this.handleRemovePatternEntryButtonSelected();
            }
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }
    }
}

