/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.breakpoints.stackpattern.internal.parser;

import com.ibm.debug.breakpoints.stackpattern.StackPatternRoot;
import com.ibm.debug.breakpoints.stackpattern.internal.parser.StackPatternEntry;
import com.ibm.debug.xmlui.api.XUIAttribute;
import com.ibm.debug.xmlui.api.XUIParseException;
import com.ibm.debug.xmlui.internal.parser.XUIAbstractParser;
import java.io.InputStream;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class StackPatternParser
extends XUIAbstractParser {
    public StackPatternRoot parse(InputStream stream) throws XUIParseException {
        Document dom = this.getDocument(stream);
        Element rootElement = dom.getDocumentElement();
        if (!this.nodeNameEquals(rootElement, "stack_patterns")) {
            throw new XUIParseException("Invalid pattern file: The root element must be a <stack_patterns> node.");
        }
        StackPatternRoot root = new StackPatternRoot();
        NodeList childNodes = rootElement.getChildNodes();
        int i = 0;
        while (i < childNodes.getLength()) {
            Node node = childNodes.item(i);
            short nodeType = node.getNodeType();
            if (nodeType == 1) {
                if (this.nodeNameEquals(node, "stack_pattern")) {
                    StackPatternEntry element = this.creatPatternElement((Element)node, root);
                    root.addStackPatternEntry(element);
                } else {
                    throw new XUIParseException("Only <stack_pattern> node is allowed in this context");
                }
            }
            ++i;
        }
        return root;
    }

    private StackPatternEntry creatPatternElement(Element node, StackPatternRoot root) throws XUIParseException {
        String name = node.getAttribute("name");
        StackPatternEntry pattern = new StackPatternEntry(name, root);
        String negateStr = node.getAttribute("negate");
        boolean isNegate = Boolean.parseBoolean(negateStr);
        if (isNegate) {
            pattern.setNegate(true);
        }
        NodeList childNodes = node.getChildNodes();
        int i = 0;
        while (i < childNodes.getLength()) {
            Node child = childNodes.item(i);
            short nodeType = child.getNodeType();
            if (nodeType == 1) {
                if (this.nodeNameEquals(child, "attribute")) {
                    XUIAttribute attribute = this.createAttributeElement((Element)child);
                    pattern.addAttribute(attribute);
                } else {
                    throw new XUIParseException("Only <setting> node is allowed in this context");
                }
            }
            ++i;
        }
        return pattern;
    }

    private XUIAttribute createAttributeElement(Element node) throws XUIParseException {
        String name = node.getAttribute("name");
        String value = node.getAttribute("value");
        XUIAttribute attribute = new XUIAttribute(name, value);
        return attribute;
    }
}

