/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.breakpoints.stackpattern.internal.parser;

import com.ibm.debug.breakpoints.stackpattern.IStackPatternEntry;
import com.ibm.debug.breakpoints.stackpattern.StackPatternRoot;
import com.ibm.debug.xmlui.api.XUIAttribute;
import com.ibm.debug.xmlui.api.XUIAttributeList;

public class StackPatternEntry
implements IStackPatternEntry {
    private boolean fIsNegate = false;
    private String fName;
    private StackPatternRoot fRoot;
    private XUIAttributeList fAttributes = new XUIAttributeList();

    public StackPatternEntry(String name, StackPatternRoot root) {
        this.fName = name;
        this.fRoot = root;
    }

    public String getName() {
        return this.fName;
    }

    public void setName(String name) {
        this.fName = name;
    }

    public void setNegate(boolean isNegate) {
        this.fIsNegate = isNegate;
    }

    @Override
    public boolean isNegate() {
        return this.fIsNegate;
    }

    public void addAttribute(XUIAttribute attribute) {
        this.fAttributes.addAttribute(attribute);
    }

    @Override
    public XUIAttributeList getAttributes() {
        return this.fAttributes;
    }

    public void setAttributes(XUIAttributeList attributes) {
        this.fAttributes = attributes;
        this.fName = this.fRoot.getLanguageAdapter().getStackFrameImporter().getPatternLabel(attributes);
    }

    @Override
    public boolean isTopPatternEntry() {
        return this.fRoot.indexOf(this) == 0;
    }

    @Override
    public boolean isSeparator() {
        return this.fName.equals("*");
    }

    @Override
    public int getIndex() {
        return this.fRoot.indexOf(this);
    }

    @Override
    public int getBottomIndex() {
        return this.fRoot.size() - this.fRoot.indexOf(this) - 1;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append('<');
        sb.append("stack_pattern");
        sb.append(' ');
        sb.append("name");
        sb.append("=\"");
        sb.append(this.fName);
        if (this.fIsNegate) {
            sb.append("\" ");
            sb.append("negate");
            sb.append("=\"true");
        }
        sb.append("\">\n");
        int i = 0;
        while (i < this.fAttributes.size()) {
            XUIAttribute attribute = this.fAttributes.getAttribute(i);
            String aStr = attribute.toString();
            sb.append(aStr);
            sb.append('\n');
            ++i;
        }
        sb.append("</stack_pattern>");
        return sb.toString();
    }
}

