/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.breakpoints.stackpattern;

import com.ibm.debug.breakpoints.stackpattern.IStackPatternEntry;
import com.ibm.debug.breakpoints.stackpattern.IStackPatternLanguageAdapter;
import com.ibm.debug.breakpoints.stackpattern.internal.parser.StackPatternEntry;
import java.util.ArrayList;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.Viewer;

public class StackPatternRoot
implements IStructuredContentProvider {
    private ArrayList<IStackPatternEntry> fPatternEntries = new ArrayList();
    private IStackPatternLanguageAdapter fLanguageAdapter;

    public StackPatternRoot() {
        this.fPatternEntries.add(new StackPatternEntry("-- Top --", this));
    }

    public void addStackPatternEntry(IStackPatternEntry pattern) {
        this.fPatternEntries.add(pattern);
    }

    public void addStackPatternEntry(int index, IStackPatternEntry pattern) {
        if (index > 0) {
            this.fPatternEntries.add(index, pattern);
        }
    }

    public IStackPatternEntry[] getStackPatternEntries() {
        return this.fPatternEntries.toArray(new IStackPatternEntry[this.fPatternEntries.size()]);
    }

    public void setLanguageAdapter(IStackPatternLanguageAdapter languageAdapter) {
        this.fLanguageAdapter = languageAdapter;
    }

    public IStackPatternLanguageAdapter getLanguageAdapter() {
        return this.fLanguageAdapter;
    }

    public IStackPatternEntry getStackPatternEntry(int index) {
        if (index >= 0 && index < this.fPatternEntries.size()) {
            return this.fPatternEntries.get(index);
        }
        return null;
    }

    public int size() {
        return this.fPatternEntries.size();
    }

    public int indexOf(IStackPatternEntry entry) {
        return this.fPatternEntries.indexOf(entry);
    }

    public IStackPatternEntry remove(int index) {
        if (index > 0 && index < this.fPatternEntries.size()) {
            return this.fPatternEntries.remove(index);
        }
        return null;
    }

    public boolean remove(IStackPatternEntry entry) {
        return this.fPatternEntries.remove(entry);
    }

    public Object[] getElements(Object inputElement) {
        return this.fPatternEntries.toArray();
    }

    public void clear() {
        this.fPatternEntries.clear();
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    public void dispose() {
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        IStackPatternEntry[] entries = this.getStackPatternEntries();
        int i = 1;
        while (i < entries.length) {
            IStackPatternEntry entry = entries[i];
            sb.append(entry.toString());
            sb.append('\n');
            ++i;
        }
        return sb.toString();
    }
}

