/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.breakpoints.stackpattern;

import com.ibm.debug.breakpoints.stackpattern.EvaluationContext;
import com.ibm.debug.breakpoints.stackpattern.IStackPatternConditionEvaluator;
import com.ibm.debug.breakpoints.stackpattern.IStackPatternEntry;
import com.ibm.debug.breakpoints.stackpattern.StackPatternEvaluationException;
import com.ibm.debug.breakpoints.stackpattern.StackPatternRoot;
import com.ibm.debug.breakpoints.stackpattern.StackPatternUtils;
import com.ibm.debug.xmlui.api.XUIAttributeList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.IThread;

public class StackPatternMatcher {
    private IStackPatternConditionEvaluator fEvaluator;

    public StackPatternMatcher(IStackPatternConditionEvaluator evaluator) {
        this.fEvaluator = evaluator;
    }

    public boolean match(IThread thread, StackPatternRoot patternRoot) throws StackPatternEvaluationException {
        IStackFrame[] frames = null;
        try {
            frames = thread.getStackFrames();
        }
        catch (DebugException e) {
            return false;
        }
        IStackPatternEntry[] patterns = patternRoot.getStackPatternEntries();
        ArrayList<IStackPatternEntry> absolutePatterns = this.getAbsoluteStackPatterns(Arrays.asList(patterns));
        int[] separatorIndexes = new int[]{};
        ArrayList<ArrayList<IStackPatternEntry>> relativeGroups = null;
        if (absolutePatterns.size() < patterns.length - 1 && (separatorIndexes = this.getSeparatorIndexes(Arrays.asList(patterns))).length >= 2) {
            relativeGroups = this.groupRelativeStackPatterns(Arrays.asList(patterns), separatorIndexes);
        }
        int i = 0;
        while (i < absolutePatterns.size()) {
            IStackPatternEntry pattern = absolutePatterns.get(i);
            IStackFrame targetFrame = this.getTargetStackFrameForAbsolutePattern(frames, pattern, separatorIndexes);
            if (targetFrame != null) {
                if (!this.matchStackFrame(targetFrame, pattern)) {
                    return false;
                }
            } else {
                return false;
            }
            ++i;
        }
        return relativeGroups == null || relativeGroups.size() <= 0 || this.matchRelativeGroups(frames, relativeGroups);
    }

    public boolean matchStackFrame(IStackFrame frame, IStackPatternEntry pattern) throws StackPatternEvaluationException {
        EvaluationContext context = new EvaluationContext(frame);
        XUIAttributeList attributes = pattern.getAttributes();
        boolean isNegate = pattern.isNegate();
        if (!this.fEvaluator.evaluate(context, attributes)) {
            return isNegate;
        }
        return !isNegate;
    }

    private IStackFrame getTargetStackFrameForAbsolutePattern(IStackFrame[] frames, IStackPatternEntry pattern, int[] separatorIndexes) {
        int bottomIndex;
        int index = pattern.getIndex();
        if (index >= frames.length) {
            return null;
        }
        if (separatorIndexes.length < 1) {
            return frames[index];
        }
        if (index < separatorIndexes[0]) {
            return frames[index];
        }
        if (index > separatorIndexes[separatorIndexes.length - 1] && (bottomIndex = pattern.getBottomIndex()) >= 0 && bottomIndex < frames.length - 1) {
            return frames[frames.length - 1 - bottomIndex];
        }
        return null;
    }

    private ArrayList<IStackPatternEntry> getAbsoluteStackPatterns(List<IStackPatternEntry> patterns) {
        if (patterns.size() <= 1) {
            return new ArrayList<IStackPatternEntry>();
        }
        ArrayList<IStackPatternEntry> result = new ArrayList<IStackPatternEntry>();
        boolean hasSeparator = false;
        int i = 1;
        while (i < patterns.size()) {
            IStackPatternEntry pattern = patterns.get(i);
            if (pattern.isSeparator()) {
                hasSeparator = true;
                break;
            }
            result.add(pattern);
            ++i;
        }
        if (hasSeparator) {
            int bottomIndex;
            int i2 = bottomIndex = patterns.size() - 1;
            while (i2 > 0) {
                IStackPatternEntry pattern = patterns.get(i2);
                if (pattern.isSeparator()) break;
                result.add(pattern);
                --i2;
            }
        }
        return result;
    }

    private int[] getSeparatorIndexes(List<IStackPatternEntry> patterns) {
        if (patterns.size() <= 1) {
            return new int[0];
        }
        ArrayList<Integer> separatorIndexes = new ArrayList<Integer>();
        int i = 1;
        while (i < patterns.size()) {
            IStackPatternEntry pattern = patterns.get(i);
            if (pattern.isSeparator()) {
                separatorIndexes.add(i);
            }
            ++i;
        }
        int[] retVal = new int[separatorIndexes.size()];
        int i2 = 0;
        while (i2 < retVal.length) {
            retVal[i2] = (Integer)separatorIndexes.get(i2);
            ++i2;
        }
        return retVal;
    }

    private ArrayList<ArrayList<IStackPatternEntry>> groupRelativeStackPatterns(List<IStackPatternEntry> patterns, int[] separatorIndexes) {
        if (separatorIndexes.length < 2) {
            return null;
        }
        ArrayList<ArrayList<IStackPatternEntry>> groups = new ArrayList<ArrayList<IStackPatternEntry>>();
        int i = 0;
        while (i < separatorIndexes.length - 1) {
            int endSeparatorIndex = separatorIndexes[i + 1];
            int startSeparatorIndex = separatorIndexes[i];
            if (endSeparatorIndex - startSeparatorIndex > 1) {
                ArrayList<IStackPatternEntry> currentGroup = new ArrayList<IStackPatternEntry>();
                int k = startSeparatorIndex + 1;
                while (k < endSeparatorIndex) {
                    currentGroup.add(patterns.get(k));
                    ++k;
                }
                groups.add(currentGroup);
            }
            ++i;
        }
        return groups;
    }

    private boolean matchRelativeGroups(IStackFrame[] frames, ArrayList<ArrayList<IStackPatternEntry>> relativeGroups) {
        ArrayList<IStackPatternEntry> firstGroup = relativeGroups.get(0);
        int startIndex = firstGroup.get(0).getIndex() - 1;
        return this.matchRelativeGroups(frames, startIndex, relativeGroups, 0);
    }

    private boolean matchRelativeGroups(IStackFrame[] frames, int startIndex, ArrayList<ArrayList<IStackPatternEntry>> relativeGroups, int startGroupIndex) {
        ArrayList<IStackPatternEntry> currentGroup = relativeGroups.get(startGroupIndex);
        if (currentGroup.size() == 0) {
            return false;
        }
        boolean isLastGroup = false;
        if (startGroupIndex == relativeGroups.size() - 1) {
            isLastGroup = true;
        }
        RelativeStackPatternMatcher relativeMatcher = new RelativeStackPatternMatcher(frames, startIndex, currentGroup);
        int nextMatch = -1;
        while ((nextMatch = relativeMatcher.nextMatch()) > 0) {
            if (isLastGroup) {
                return true;
            }
            int nextStartIndex = nextMatch + currentGroup.size();
            boolean nextMatchResult = this.matchRelativeGroups(frames, nextStartIndex, relativeGroups, startGroupIndex + 1);
            if (!nextMatchResult) continue;
            return true;
        }
        return false;
    }

    class RelativeStackPatternMatcher {
        private IStackFrame[] fFrames;
        private ArrayList<IStackPatternEntry> fPatterns;
        private int fCounter;

        public RelativeStackPatternMatcher(IStackFrame[] frames, int startIndex, ArrayList<IStackPatternEntry> patterns) {
            this.fFrames = frames;
            this.fPatterns = patterns;
            this.fCounter = startIndex;
        }

        /*
         * Unable to fully structure code
         */
        public int nextMatch() {
            if (this.fFrames.length - this.fCounter >= this.fPatterns.size()) ** GOTO lbl20
            return -1;
lbl-1000:
            // 1 sources

            {
                matched = true;
                i = 0;
                while (i < this.fPatterns.size()) {
                    try {
                        if (!StackPatternMatcher.this.matchStackFrame(this.fFrames[this.fCounter + i], this.fPatterns.get(i))) {
                            ++this.fCounter;
                            matched = false;
                            break;
                        }
                    }
                    catch (StackPatternEvaluationException ex) {
                        StackPatternUtils.logError(ex);
                        return -1;
                    }
                    ++i;
                }
                if (!matched) continue;
                retVal = this.fCounter++;
                return retVal;
lbl20:
                // 2 sources

                ** while (this.fCounter <= this.fFrames.length - this.fPatterns.size())
            }
lbl21:
            // 1 sources

            return -1;
        }
    }
}

