/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.breakpoints.stackpattern;

import com.ibm.debug.breakpoints.stackpattern.IStackPatternLanguageAdapter;
import com.ibm.debug.breakpoints.stackpattern.StackPatternEvaluationException;
import com.ibm.debug.breakpoints.stackpattern.StackPatternMatcher;
import com.ibm.debug.breakpoints.stackpattern.StackPatternRoot;
import com.ibm.debug.breakpoints.stackpattern.StackPatternUtils;
import com.ibm.debug.xmlui.api.XUIParseException;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.IThread;

public abstract class AbstractStackPatternLanguageAdapter
implements IStackPatternLanguageAdapter {
    public static final int SUSPEND = 1;
    public static final int DONT_SUSPEND = 2;
    public static final int DONT_CARE = 4;
    private String fModel;
    private StackPatternMatcher fPatternMatcher = null;

    @Override
    public void setModel(String model) {
        this.fModel = model;
    }

    @Override
    public String getModel() {
        return this.fModel;
    }

    private synchronized StackPatternMatcher getStackPatternMatcher() {
        if (this.fPatternMatcher == null) {
            this.fPatternMatcher = new StackPatternMatcher(this.getConditionEvaluator());
        }
        return this.fPatternMatcher;
    }

    @Override
    public StackPatternRoot parseStackPattern(IBreakpoint breakpoint) throws XUIParseException {
        return StackPatternUtils.parseStackPattern(breakpoint);
    }

    @Override
    public String generateStackPatternString(StackPatternRoot root) {
        return StackPatternUtils.getStackPatternXMLString(root);
    }

    @Override
    public void setStackPatternEnabled(IBreakpoint breakpoint, boolean enabled) {
        StackPatternUtils.setStackPatternEnabled(breakpoint, enabled);
    }

    public int breakpointHit(IThread thread, IBreakpoint breakpoint) {
        if (this.isStackPatternEnabled(breakpoint)) {
            StackPatternRoot root = null;
            try {
                root = this.parseStackPattern(breakpoint);
                if (root != null) {
                    root.setLanguageAdapter(this);
                }
            }
            catch (XUIParseException ex) {
                StackPatternUtils.logError((Exception)((Object)ex));
                return 4;
            }
            if (root != null) {
                try {
                    if (this.getStackPatternMatcher().match(thread, root)) {
                        return 1;
                    }
                    return 2;
                }
                catch (StackPatternEvaluationException e) {
                    return 4;
                }
            }
        }
        return 4;
    }
}

