/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.licensing.common.util;

import com.ibm.cic.licensing.common.util.LicenseStatus;
import com.ibm.cic.licensing.common.util.ProductInformation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ComponentInfo {
    private List<ProductInformation> products;
    LicenseStatus licStatus;
    private String componentName;
    private String componentVersion;
    private boolean isProductListSorted = false;
    private ProductInformation checkedOutProduct = null;

    public LicenseStatus getLicStatus() {
        return this.licStatus;
    }

    public void setLicStatus(LicenseStatus licStatus) {
        this.licStatus = licStatus;
    }

    public List<ProductInformation> getProducts() {
        if (!this.isProductListSorted) {
            Collections.sort(this.products);
            this.isProductListSorted = true;
        }
        return this.products;
    }

    public void setProducts(List<ProductInformation> products) {
        this.products = products;
    }

    public ComponentInfo(String name, String version, ProductInformation pi) {
        this.componentName = name;
        this.componentVersion = version;
        if (this.products == null) {
            this.products = new ArrayList<ProductInformation>();
        }
        this.addProduct(pi);
    }

    public void addProduct(ProductInformation pi) {
        this.products.add(pi);
        this.isProductListSorted = false;
    }

    public String toString() {
        return "ComponentInfo [ componentName=" + this.componentName + ", componentVersion=" + this.componentVersion + ", products=" + String.valueOf(this.products) + ", licStatus=" + String.valueOf(this.licStatus) + "]";
    }

    public String printCInfo() {
        return "ComponentInfo [ componentName=" + this.componentName + ", componentVersion=" + this.componentVersion + "]";
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.componentName == null ? 0 : this.componentName.hashCode());
        result = 31 * result + (this.componentVersion == null ? 0 : this.componentVersion.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ComponentInfo other = (ComponentInfo)obj;
        if (this.componentName == null ? other.componentName != null : !this.componentName.equals(other.componentName)) {
            return false;
        }
        return !(this.componentVersion == null ? other.componentVersion != null : !this.componentVersion.equals(other.componentVersion));
    }

    public void setProductCheckedOut(ProductInformation p) {
        this.checkedOutProduct = p;
    }

    public ProductInformation getProductCheckedOut() {
        return this.checkedOutProduct;
    }
}

