/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cdz.remote.debug.ui;

import com.ibm.cdz.remote.debug.IUniversalPDTLaunchConstants;
import com.ibm.cdz.remote.debug.PDTLaunchPlugin;
import com.ibm.cdz.remote.debug.UniversalPDTLaunchEnginePathPreference;
import com.ibm.cdz.remote.debug.ui.EnginePathsForm;
import com.ibm.ftt.debug.ui.Labels;
import java.util.ResourceBundle;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.files.ui.dialogs.SystemRemoteFileDialog;
import org.eclipse.rse.subsystems.files.core.model.RemoteFileUtility;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFile;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFileSubSystem;
import org.eclipse.rse.ui.SystemWidgetHelpers;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class UniversalPDTDebugTab
extends AbstractLaunchConfigurationTab
implements IUniversalPDTLaunchConstants {
    private static final String EMPTY = "";
    public static final int ID_IDX = 0;
    public static final int DT_IDX = 1;
    public static final int DBX_IDX = 2;
    private static final int SELECTION_ZOS_IDX = 0;
    private static final int SELECTION_DBX_IDX = 1;
    protected ResourceBundle stringsResourceBundle = PDTLaunchPlugin.getStringsResourceBundle();
    private Button automaticDebugEngineCheckBox;
    private Button specificDebugEngineCheckBox;
    private Text alternateDBXExecutableTextField;
    private Button debugEnginePathBrowseButton;
    private String dbxEnginePath = null;
    private EnginePathsForm dbxLibPathForm = null;
    private IHost systemConnection = null;
    private IPreferenceStore preferenceStore = null;
    private UniversalPDTLaunchEnginePathPreference enginePathPreference = null;
    private Combo engine;
    private Label engineLabel;
    private Group DBXGroup;

    public void createControl(Composite parent) {
        Composite debugComposite = new Composite(parent, 0);
        this.setControl((Control)debugComposite);
        GridLayout layout = new GridLayout();
        GridData data = new GridData(1808);
        data.horizontalSpan = 2;
        debugComposite.setLayout((Layout)layout);
        debugComposite.setLayoutData((Object)data);
        this.createVerticalSpacer(debugComposite, 4);
        Composite engineComposite = new Composite(debugComposite, 0);
        GridLayoutFactory.fillDefaults().numColumns(3).applyTo(engineComposite);
        this.engineLabel = new Label(engineComposite, 0);
        this.engineLabel.setText(Labels.ENGINE);
        this.engine = new Combo(engineComposite, 12);
        this.engine.add(Labels.ZDEBUG);
        this.engine.add("DBX");
        this.createVerticalSpacer(debugComposite, 4);
        this.DBXGroup = new Group(debugComposite, 0);
        this.DBXGroup.setText(Labels.DBX_OPTIONS);
        GridLayout topLayout = new GridLayout();
        data = new GridData(768);
        this.DBXGroup.setLayout((Layout)topLayout);
        this.DBXGroup.setLayoutData((Object)data);
        int hostCompositeNumberOfColumns = 2;
        Group debugEngineGroup = SystemWidgetHelpers.createGroupComposite((Composite)this.DBXGroup, (int)1, (String)this.stringsResourceBundle.getString("com.ibm.cdz.remote.debug.ui.tabs.debug.debugTab.groupTitleDebugEngine.label"));
        data = (GridData)debugEngineGroup.getLayoutData();
        data.horizontalSpan = hostCompositeNumberOfColumns;
        this.createVerticalSpacer((Composite)debugEngineGroup, 1);
        this.automaticDebugEngineCheckBox = SystemWidgetHelpers.createRadioButton((Composite)debugEngineGroup, null, (String)this.stringsResourceBundle.getString("com.ibm.cdz.remote.debug.ui.tabs.debug.debugTab.automaticDebugEngine.label"), (String)this.stringsResourceBundle.getString("com.ibm.cdz.remote.debug.ui.tabs.debug.debugTab.automaticDebugEngine.tooltip"));
        this.specificDebugEngineCheckBox = SystemWidgetHelpers.createRadioButton((Composite)debugEngineGroup, null, (String)this.stringsResourceBundle.getString("com.ibm.cdz.remote.debug.ui.tabs.debug.debugTab.specifyDebugEngine.label"), (String)this.stringsResourceBundle.getString("com.ibm.cdz.remote.debug.ui.tabs.debug.debugTab.specifyDebugEngine.tooltip"));
        this.createVerticalSpacer((Composite)debugEngineGroup, 1);
        Composite enginePathComposite = new Composite((Composite)debugEngineGroup, 0);
        GridLayout myLayout = new GridLayout();
        myLayout.numColumns = 2;
        myLayout.marginHeight = 0;
        myLayout.marginWidth = 0;
        enginePathComposite.setLayout((Layout)myLayout);
        GridData gd = new GridData(768);
        enginePathComposite.setLayoutData((Object)gd);
        Label alternateDebugEngineLabel = new Label(enginePathComposite, 0);
        alternateDebugEngineLabel.setText(this.stringsResourceBundle.getString("com.ibm.cdz.remote.debug.ui.tabs.debug.debugTab.pathOfDebugEngine.label"));
        gd = new GridData();
        gd.horizontalSpan = 2;
        alternateDebugEngineLabel.setLayoutData((Object)gd);
        this.alternateDBXExecutableTextField = new Text(enginePathComposite, 2052);
        gd = new GridData(768);
        this.alternateDBXExecutableTextField.setLayoutData((Object)gd);
        this.alternateDBXExecutableTextField.setToolTipText(this.stringsResourceBundle.getString("com.ibm.cdz.remote.debug.ui.tabs.debug.debugTab.pathOfDebugEngine.tooltip"));
        this.alternateDBXExecutableTextField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent evt) {
                UniversalPDTDebugTab.this.updateLaunchConfigurationDialog();
                UniversalPDTDebugTab.this.dbxEnginePath = UniversalPDTDebugTab.this.alternateDBXExecutableTextField.getText();
            }
        });
        this.debugEnginePathBrowseButton = this.createPushButton(enginePathComposite, this.stringsResourceBundle.getString("com.ibm.cdz.remote.debug.ui.browsePrompt"), null);
        this.debugEnginePathBrowseButton.setToolTipText(this.stringsResourceBundle.getString("com.ibm.cdz.remote.debug.ui.tabs.debug.mainTab.class.browse.tooltip"));
        this.debugEnginePathBrowseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                UniversalPDTDebugTab.this.browseDebugEnginePath();
            }
        });
        this.dbxLibPathForm = new EnginePathsForm(null, this.stringsResourceBundle.getString("com.ibm.cdz.remote.debug.ui.tabs.debug.debugTab.libPath"), this);
        this.dbxLibPathForm.createContents(enginePathComposite);
        this.createVerticalSpacer((Composite)this.DBXGroup, 2);
        SelectionAdapter selctionAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Widget sourceWidget = event.widget;
                if (sourceWidget == UniversalPDTDebugTab.this.engine) {
                    UniversalPDTDebugTab.this.enableDBX(UniversalPDTDebugTab.this.engine.getSelectionIndex() == 1);
                } else if (sourceWidget == UniversalPDTDebugTab.this.automaticDebugEngineCheckBox) {
                    UniversalPDTDebugTab.this.alternateDBXExecutableTextField.setEnabled(false);
                    UniversalPDTDebugTab.this.debugEnginePathBrowseButton.setEnabled(false);
                    UniversalPDTDebugTab.this.dbxLibPathForm.setEnabled(false);
                } else if (sourceWidget == UniversalPDTDebugTab.this.specificDebugEngineCheckBox) {
                    UniversalPDTDebugTab.this.alternateDBXExecutableTextField.setEnabled(true);
                    UniversalPDTDebugTab.this.debugEnginePathBrowseButton.setEnabled(true);
                    UniversalPDTDebugTab.this.dbxLibPathForm.setEnabled(true);
                }
                UniversalPDTDebugTab.this.updateLaunchConfigurationDialog();
            }
        };
        this.automaticDebugEngineCheckBox.addSelectionListener((SelectionListener)selctionAdapter);
        this.specificDebugEngineCheckBox.addSelectionListener((SelectionListener)selctionAdapter);
        this.engine.addSelectionListener((SelectionListener)selctionAdapter);
        SystemWidgetHelpers.setCompositeHelp((Composite)debugComposite, (String)"com.ibm.cdz.remote.debug.zosunix_adv");
    }

    protected void enableDBX(boolean flag) {
        this.DBXGroup.setEnabled(flag);
        this.alternateDBXExecutableTextField.setEnabled(flag);
        this.automaticDebugEngineCheckBox.setEnabled(flag);
        this.specificDebugEngineCheckBox.setEnabled(flag);
        this.alternateDBXExecutableTextField.setEnabled(flag && this.specificDebugEngineCheckBox.getSelection());
        this.debugEnginePathBrowseButton.setEnabled(flag && this.specificDebugEngineCheckBox.getSelection());
        this.dbxLibPathForm.setEnabled(flag);
    }

    protected void browseDebugEnginePath() {
        SystemRemoteFileDialog dlg = new SystemRemoteFileDialog(PDTLaunchPlugin.getActiveWorkbenchShell(), this.stringsResourceBundle.getString("com.ibm.cdz.remote.debug.ui.tabs.debug.debugTab.pathOfDebugEngineBrowse.label"), this.systemConnection);
        dlg.setNeedsProgressMonitor(true);
        dlg.setDefaultSystemConnection(this.systemConnection, true);
        String absolutePath = this.alternateDBXExecutableTextField.getText();
        if (absolutePath != null && absolutePath.length() > 0) {
            IRemoteFileSubSystem fs = RemoteFileUtility.getFileSubSystem((IHost)this.systemConnection);
            try {
                IRemoteFile selection = fs.getRemoteFileObject(absolutePath, (IProgressMonitor)new NullProgressMonitor());
                dlg.setPreSelection((Object)selection);
            }
            catch (Exception e) {
                PDTLaunchPlugin.logError((String)e.getMessage(), (Throwable)e);
            }
        }
        if (dlg.open() != 0) {
            return;
        }
        IRemoteFile result = (IRemoteFile)dlg.getSelectedObject();
        if (result == null) {
            return;
        }
        absolutePath = result.getAbsolutePath();
        this.alternateDBXExecutableTextField.setText(absolutePath);
    }

    public boolean isValid(ILaunchConfiguration config) {
        this.setErrorMessage(null);
        this.setMessage(null);
        if (this.engine.getSelectionIndex() == 1 && !this.automaticDebugEngineCheckBox.getSelection()) {
            if (this.dbxEnginePath == null || this.dbxEnginePath.length() == 0) {
                this.setErrorMessage(this.stringsResourceBundle.getString("com.ibm.cdz.remote.debug.ui.tabs.debug.debugTab.error.invalidDebugEnginePath"));
                this.alternateDBXExecutableTextField.setFocus();
                return false;
            }
            if (-1 != this.dbxEnginePath.indexOf(32)) {
                this.setErrorMessage(this.stringsResourceBundle.getString("com.ibm.cdz.remote.debug.ui.tabs.debug.debugTab.error.invalidDebugEnginePath"));
                this.alternateDBXExecutableTextField.setFocus();
                return false;
            }
        }
        return true;
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy config) {
        this.preferenceStore = PDTLaunchPlugin.getDefault().getPreferenceStore();
        String preferenceEnginePath = this.preferenceStore.getString("com.ibm.cdz.remote.debug.preference.engineGroup");
        if (preferenceEnginePath.equals("com.ibm.cdz.remote.debug.preference.engineSpecify")) {
            config.setAttribute("com.ibm.cdz.remote.debug.attr.AutoResolveDebugEnginePath", false);
        } else {
            config.setAttribute("com.ibm.cdz.remote.debug.attr.AutoResolveDebugEnginePath", true);
        }
        try {
            if (!config.hasAttribute("com.ibm.cdz.remote.debug.attr.ENGINE")) {
                config.setAttribute("com.ibm.cdz.remote.debug.attr.debugToolCompatibility", true);
                config.setAttribute("com.ibm.cdz.remote.debug.attr.ENGINE", 1);
            }
        }
        catch (CoreException e) {
            PDTLaunchPlugin.logError((String)e.getMessage(), (Throwable)e);
        }
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        try {
            boolean isAutoDebugEnginePath = configuration.getAttribute("com.ibm.cdz.remote.debug.attr.AutoResolveDebugEnginePath", true);
            if (isAutoDebugEnginePath) {
                this.automaticDebugEngineCheckBox.setSelection(true);
                this.specificDebugEngineCheckBox.setSelection(false);
                this.alternateDBXExecutableTextField.setEnabled(false);
                this.debugEnginePathBrowseButton.setEnabled(false);
            } else {
                this.automaticDebugEngineCheckBox.setSelection(false);
                this.specificDebugEngineCheckBox.setSelection(true);
                this.alternateDBXExecutableTextField.setEnabled(true);
                this.debugEnginePathBrowseButton.setEnabled(true);
            }
            String remoteDBXLocation = configuration.getAttribute("com.ibm.cdz.remote.debug.attr.DebugEnginePath", EMPTY);
            if (remoteDBXLocation.equals(EMPTY)) {
                String systemConnectionAliasName = configuration.getAttribute("com.ibm.etools.systems.launch.attr.SystemConnectionAliasName", EMPTY);
                String preferenceEnginePath = EMPTY;
                preferenceEnginePath = this.getPreferenceEnginePath(systemConnectionAliasName);
                if (preferenceEnginePath == null) {
                    this.alternateDBXExecutableTextField.setText(EMPTY);
                } else {
                    this.alternateDBXExecutableTextField.setText(preferenceEnginePath);
                }
            } else {
                this.alternateDBXExecutableTextField.setText(remoteDBXLocation);
            }
            String remoteDBXLibpath = configuration.getAttribute("com.ibm.cdz.remote.debug.attr.dbxLibPath", EMPTY);
            if (!remoteDBXLibpath.equals(EMPTY)) {
                String path = remoteDBXLibpath.replace(';', ',');
                this.dbxLibPathForm.setPaths(path);
                this.dbxLibPathForm.updatePaths();
            }
            this.dbxEnginePath = this.alternateDBXExecutableTextField.getText();
            int idx = 0;
            int defaultIdx = 1;
            if (configuration.hasAttribute("com.ibm.cdz.remote.debug.attr.ENGINE")) {
                idx = configuration.getAttribute("com.ibm.cdz.remote.debug.attr.ENGINE", defaultIdx);
            } else if (configuration.hasAttribute("com.ibm.cdz.remote.debug.attr.UseDebugTool")) {
                idx = configuration.getAttribute("com.ibm.cdz.remote.debug.attr.UseDebugTool", true) ? 1 : 2;
            }
            idx = idx == 2 ? 1 : 0;
            this.engine.select(idx);
            this.enableDBX(idx == 2);
        }
        catch (CoreException e) {
            this.setErrorMessage(this.stringsResourceBundle.getString("com.ibm.cdz.remote.debug.ui.msg.error.exception"));
            PDTLaunchPlugin.logError((String)"Failed to retrieve information from launch configuration", (Throwable)e);
            return;
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        int selection_index = this.engine.getSelectionIndex();
        int debugger_index = 0;
        if (selection_index == 0) {
            debugger_index = 1;
        } else if (selection_index == 1) {
            debugger_index = 2;
        }
        configuration.setAttribute("com.ibm.cdz.remote.debug.attr.ENGINE", debugger_index);
        boolean isAutoDebugEnginePath = this.automaticDebugEngineCheckBox.getSelection();
        if (isAutoDebugEnginePath) {
            configuration.setAttribute("com.ibm.cdz.remote.debug.attr.AutoResolveDebugEnginePath", true);
            configuration.setAttribute("com.ibm.cdz.remote.debug.attr.DebugEnginePath", EMPTY);
        } else {
            this.dbxEnginePath = this.alternateDBXExecutableTextField.getText();
            configuration.setAttribute("com.ibm.cdz.remote.debug.attr.AutoResolveDebugEnginePath", false);
            configuration.setAttribute("com.ibm.cdz.remote.debug.attr.DebugEnginePath", this.dbxEnginePath);
            String paths = this.dbxLibPathForm.getPaths().replace(',', ';');
            configuration.setAttribute("com.ibm.cdz.remote.debug.attr.dbxLibPath", paths);
        }
    }

    private String getPreferenceEnginePath(String systemConnectionAliasName) {
        return this.getEnginePathPreference().getPreferenceEnginePath(systemConnectionAliasName);
    }

    public void pathsUpdated() {
        this.updateLaunchConfigurationDialog();
    }

    private UniversalPDTLaunchEnginePathPreference getEnginePathPreference() {
        if (this.enginePathPreference == null) {
            this.enginePathPreference = new UniversalPDTLaunchEnginePathPreference(PDTLaunchPlugin.getDefault().getPreferenceStore());
        }
        return this.enginePathPreference;
    }

    public String getName() {
        return this.stringsResourceBundle.getString("com.ibm.cdz.remote.debug.ui.tabs.debug.debugTab.label");
    }

    public Image getImage() {
        return PDTLaunchPlugin.getDefault().getImage("com.ibm.cdz.remote.debug.full/obj16/tab_adv.icon");
    }

    public void systemConnectionUpdated(IHost newSystemConnection) {
        if (this.systemConnection != newSystemConnection) {
            this.systemConnection = newSystemConnection;
            this.dbxLibPathForm.setFileSubSystem(RemoteFileUtility.getFileSubSystem((IHost)this.systemConnection));
            if (this.alternateDBXExecutableTextField != null && this.alternateDBXExecutableTextField.isEnabled()) {
                String preferencedPath = this.getPreferenceEnginePath(this.systemConnection.getAliasName());
                if (preferencedPath != null) {
                    this.alternateDBXExecutableTextField.setText(preferencedPath);
                } else {
                    this.alternateDBXExecutableTextField.setText(EMPTY);
                }
            }
        }
    }
}

