/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.pa.ui.views.profiler;

import com.ibm.cics.pa.model.Column;
import com.ibm.cics.pa.model.PBKey;
import com.ibm.cics.pa.model.ProfilerPairing;
import com.ibm.cics.pa.model.definitions.ColumnDefinition;
import com.ibm.cics.pa.model.definitions.ProfilerLayout;
import com.ibm.cics.pa.ui.views.profiler.ProfileChartTimeSlice;
import com.ibm.cics.pa.ui.views.profiler.ProfileComposite;
import com.ibm.cics.pa.ui.views.profiler.ProfileView;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.List;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.FigureUtilities;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;

public class ProfileChart
extends Figure {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y04 (c) Copyright IBM Corp. 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Font fontArialSmall = new Font(null, "Arial", 8, 1);
    static final Font fontArialLarge = new Font(null, "Arial", 10, 1);
    private static final Color scaleColour = new Color((Device)Display.getCurrent(), new RGB(245, 245, 181));
    private static final int INTERVAL = 6;
    private static final int HALF_INTERVAL = Math.round(3.0f);
    private static final int SCALE_WIDTH = 40;
    private static final int GRADUATION = 5;
    private static final float roomFactor = 0.9f;
    private int records_datum1 = 0;
    private int records_datum2 = 0;
    private DateFormat dateFormatter = new SimpleDateFormat("yyyy-MM-dd");
    private DateFormat timeFormatter = new SimpleDateFormat("HH:mm:ss");
    private final int max_child_slices = 249;
    private final int halfway_slices = 125;
    private ProfileChartTimeSlice[] slices = new ProfileChartTimeSlice[249];
    private String textDate1 = "YYYY-MM-DD";
    private String textTime1 = "hh:mm:ss";
    private int halfText1;
    private int halfText2;
    private ProfileComposite feedBack;
    private ProfileView parent;
    private ProfilerPairing pairing;
    private List<ColumnDefinition> selectedDefinitions = Collections.emptyList();

    public ProfileChart(ProfileView profileView) {
        this.setBackgroundColor(ColorConstants.white);
        this.parent = profileView;
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
        if (this.pairing != null) {
            graphics.setForegroundColor(ColorConstants.darkGray);
            Dimension textDim1 = FigureUtilities.getStringExtents((String)this.textDate1, (Font)fontArialSmall);
            int span = textDim1.width / 6;
            ++span;
            this.halfText1 = textDim1.width / 2;
            graphics.setFont(fontArialSmall);
            Dimension textDim2 = FigureUtilities.getStringExtents((String)this.textTime1, (Font)fontArialSmall);
            this.halfText2 = textDim2.width / 2;
            graphics.setLineStyle(1);
            int x = this.getClientArea().width;
            int halfway = x / 2;
            graphics.setForegroundColor(ColorConstants.lightGray);
            graphics.drawLine(this.getClientArea().x + halfway - HALF_INTERVAL, this.getClientArea().y + 40, this.getClientArea().x + halfway - HALF_INTERVAL, this.getClientArea().y + 40 + this.getClientArea().height - 50);
            graphics.drawLine(this.getClientArea().x + halfway + HALF_INTERVAL, this.getClientArea().y + 40, this.getClientArea().x + halfway + HALF_INTERVAL, this.getClientArea().y + 40 + this.getClientArea().height - 50);
            graphics.setForegroundColor(ColorConstants.lightBlue);
            graphics.setBackgroundColor(scaleColour);
            graphics.fillRectangle(this.getClientArea().x, this.getClientArea().y, this.getClientArea().width, 40);
            graphics.fillRectangle(this.getClientArea().x, this.getClientArea().y + this.getClientArea().height - 40, this.getClientArea().width, 40);
            graphics.drawRectangle(this.getClientArea().x, this.getClientArea().y, this.getClientArea().width - 2, 40);
            graphics.drawRectangle(this.getClientArea().x, this.getClientArea().y + this.getClientArea().height - 40, this.getClientArea().width - 2, 39);
            graphics.setForegroundColor(ColorConstants.darkGray);
            if (this.isValidDatum1() && this.isValidDatum2()) {
                int centreDisplacement = 0;
                int previousXPosition = halfway;
                int nextXPosition = halfway;
                while (this.xLocationValid(previousXPosition, nextXPosition)) {
                    if (centreDisplacement == 0) {
                        graphics.setForegroundColor(ColorConstants.gray);
                        graphics.drawLine(previousXPosition - this.halfText1 - 2, 3, previousXPosition + this.halfText1 + 2, 3);
                        graphics.drawLine(previousXPosition - this.halfText1 - 2, 3, previousXPosition - this.halfText1 - 2, 27);
                        graphics.drawLine(previousXPosition + this.halfText1 + 2, 3, previousXPosition + this.halfText1 + 2, 27);
                        graphics.drawLine(previousXPosition - this.halfText1 - 2, 26, this.getClientArea().x + halfway - HALF_INTERVAL, this.getClientArea().y + 40);
                        graphics.drawLine(previousXPosition - this.halfText1 + textDim1.width + 2, 26, this.getClientArea().x + halfway + HALF_INTERVAL, this.getClientArea().y + 40);
                        graphics.drawLine(previousXPosition - this.halfText1 - 2, this.getClientArea().y + this.getClientArea().height - 5 + 2, previousXPosition + this.halfText1 + 2, this.getClientArea().y + this.getClientArea().height - 5 + 2);
                        graphics.drawLine(previousXPosition - this.halfText1 - 2, this.getClientArea().y + this.getClientArea().height - 25 - 2, previousXPosition - this.halfText1 - 2, this.getClientArea().y + this.getClientArea().height - 5 + 2);
                        graphics.drawLine(previousXPosition + this.halfText1 + 2, this.getClientArea().y + this.getClientArea().height - 25 - 2, previousXPosition + this.halfText1 + 2, this.getClientArea().y + this.getClientArea().height - 5 + 2);
                        graphics.drawLine(previousXPosition - this.halfText1 - 2, this.getClientArea().y + this.getClientArea().height - 25 - 2, this.getClientArea().x + halfway - HALF_INTERVAL, this.getClientArea().y + this.getClientArea().height - 40);
                        graphics.drawLine(previousXPosition - this.halfText1 + textDim1.width + 2, this.getClientArea().y + this.getClientArea().height - 25 - 2, this.getClientArea().x + halfway + HALF_INTERVAL, this.getClientArea().y + this.getClientArea().height - 40);
                    }
                    int j = 0;
                    while (j < 2) {
                        if (centreDisplacement == 0 || centreDisplacement % span == 0) {
                            this.addNotches(graphics, previousXPosition, nextXPosition, centreDisplacement);
                            if (j == 0) {
                                this.addDateLabels(graphics, previousXPosition, -centreDisplacement);
                            } else if (j == 1 && centreDisplacement > 1) {
                                this.addDateLabels(graphics, nextXPosition, centreDisplacement);
                            }
                        } else {
                            this.addSmallNotches(graphics, previousXPosition, nextXPosition, centreDisplacement);
                        }
                        ++j;
                    }
                    Rectangle rect = new Rectangle(halfway - HALF_INTERVAL + centreDisplacement * 6, this.getClientArea().y + 40, 6, this.getClientArea().height - 80);
                    PBKey key1 = this.pairing.getBaseBucket().getKeyAtLocation(this.records_datum1 + centreDisplacement);
                    PBKey key2 = this.pairing.getVariantBucket().getKeyAtLocation(this.records_datum2 + centreDisplacement);
                    this.slices[125 + centreDisplacement].setBounds(rect);
                    this.slices[125 + centreDisplacement].assignDateData(this.parent.getLayout(), key1, key1 == null ? null : this.pairing.getBaseBucket().getMetricsFor(key1), key2, key2 == null ? null : this.pairing.getVariantBucket().getMetricsFor(key2), this.selectedDefinitions);
                    rect = new Rectangle(halfway - HALF_INTERVAL - centreDisplacement * 6, this.getClientArea().y + 40, 6, this.getClientArea().height - 80);
                    this.slices[125 - centreDisplacement].setBounds(rect);
                    if (this.records_datum1 - centreDisplacement > 0) {
                        key1 = this.pairing.getBaseBucket().getKeyAtLocation(this.records_datum1 - centreDisplacement);
                        key2 = this.pairing.getVariantBucket().getKeyAtLocation(this.records_datum2 - centreDisplacement);
                        this.slices[125 - centreDisplacement].assignDateData(this.parent.getLayout(), key1, key1 == null ? null : this.pairing.getBaseBucket().getMetricsFor(key1), key2, key2 == null ? null : this.pairing.getVariantBucket().getMetricsFor(key2), this.selectedDefinitions);
                    }
                    ProfilerLayout currentLayout = this.parent.getLayout();
                    ColumnDefinition[] columnDefinitionArray = currentLayout.getDefinitions();
                    int n = columnDefinitionArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        int value_position;
                        ColumnDefinition definition = columnDefinitionArray[n2];
                        if (definition != ColumnDefinition.START_DATE && definition != ColumnDefinition.START_TIME && this.selectedDefinitions.contains(definition) && (value_position = ProfilerLayout.getPositionOf(definition)) > -1) {
                            double max = this.selectedDefinitions.size() == 1 ? this.pairing.getMaximumValue(value_position) : this.pairing.getMaximumValue(this.parent.getLayout());
                            graphics.setForegroundColor(Column.getFor(definition).getColor());
                            graphics.setLineWidth(2);
                            graphics.setLineStyle(1);
                            if (this.records_datum1 - centreDisplacement > 0 && this.records_datum1 - centreDisplacement < this.pairing.getBaseTotal()) {
                                graphics.drawLine(previousXPosition - 6, 40 + this.calculatePostion(this.getClientArea(), ((Number)this.pairing.getBaseBucket().getMetricsFor(this.pairing.getBaseBucket().getAllKeys()[this.records_datum1 - centreDisplacement - 1])[value_position]).doubleValue(), max), previousXPosition, 40 + this.calculatePostion(this.getClientArea(), ((Number)this.pairing.getBaseBucket().getMetricsFor(this.pairing.getBaseBucket().getAllKeys()[this.records_datum1 - centreDisplacement])[value_position]).doubleValue(), max));
                            }
                            if (this.records_datum1 + centreDisplacement > 0 && this.records_datum1 + centreDisplacement < this.pairing.getBaseTotal()) {
                                graphics.drawLine(nextXPosition - 6, 40 + this.calculatePostion(this.getClientArea(), ((Number)this.pairing.getBaseBucket().getMetricsFor(this.pairing.getBaseBucket().getAllKeys()[this.records_datum1 + centreDisplacement - 1])[value_position]).doubleValue(), max), nextXPosition, 40 + this.calculatePostion(this.getClientArea(), ((Number)this.pairing.getBaseBucket().getMetricsFor(this.pairing.getBaseBucket().getAllKeys()[this.records_datum1 + centreDisplacement])[value_position]).doubleValue(), max));
                            }
                            graphics.setLineStyle(3);
                            if (this.records_datum2 - centreDisplacement > 0 && this.records_datum2 - centreDisplacement < this.pairing.getVariantTotal()) {
                                graphics.drawLine(previousXPosition - 6, 40 + this.calculatePostion(this.getClientArea(), ((Number)this.pairing.getVariantBucket().getMetricsFor(this.pairing.getVariantBucket().getAllKeys()[this.records_datum2 - centreDisplacement - 1])[value_position]).doubleValue(), max), previousXPosition, 40 + this.calculatePostion(this.getClientArea(), ((Number)this.pairing.getVariantBucket().getMetricsFor(this.pairing.getVariantBucket().getAllKeys()[this.records_datum2 - centreDisplacement])[value_position]).doubleValue(), max));
                            }
                            if (this.records_datum2 + centreDisplacement > 0 && this.records_datum2 + centreDisplacement < this.pairing.getVariantTotal()) {
                                graphics.drawLine(nextXPosition - 6, 40 + this.calculatePostion(this.getClientArea(), ((Number)this.pairing.getVariantBucket().getMetricsFor(this.pairing.getVariantBucket().getAllKeys()[this.records_datum2 + centreDisplacement - 1])[value_position]).doubleValue(), max), nextXPosition, 40 + this.calculatePostion(this.getClientArea(), ((Number)this.pairing.getVariantBucket().getMetricsFor(this.pairing.getVariantBucket().getAllKeys()[this.records_datum2 + centreDisplacement])[value_position]).doubleValue(), max));
                            }
                        }
                        ++n2;
                    }
                    graphics.setLineStyle(1);
                    int xDisplacement = ++centreDisplacement * 6;
                    previousXPosition = halfway - xDisplacement;
                    nextXPosition = halfway + xDisplacement;
                }
            }
        }
    }

    private int calculatePostion(Rectangle clientArea, Double double1, Double max) {
        int oah = this.getClientArea().height - 80;
        return oah - Math.round(Math.round(double1 * (double)0.9f * (double)oah / max));
    }

    private void addDateLabels(Graphics graphics, int cPos, int centreDisplacement) {
        String time;
        String date;
        if (this.records_datum1 + centreDisplacement > -1 && this.records_datum1 + centreDisplacement < this.pairing.getBaseBucket().getSize()) {
            graphics.setForegroundColor(ColorConstants.gray);
            date = this.dateFormatter.format(this.pairing.getBaseBucket().getAllKeys()[this.records_datum1 + centreDisplacement].getDate());
            graphics.drawText(date, cPos - this.halfText1, 5);
            graphics.setForegroundColor(ColorConstants.darkGray);
            time = this.timeFormatter.format(this.pairing.getBaseBucket().getAllKeys()[this.records_datum1 + centreDisplacement].getTime());
            graphics.drawText(time, cPos - this.halfText2, 15);
        }
        if (this.records_datum2 + centreDisplacement > -1 && this.records_datum2 + centreDisplacement < this.pairing.getVariantBucket().getSize()) {
            graphics.setForegroundColor(ColorConstants.gray);
            date = this.dateFormatter.format(this.pairing.getVariantBucket().getAllKeys()[this.records_datum2 + centreDisplacement].getDate());
            graphics.drawText(date, cPos - this.halfText1, this.getClientArea().y + this.getClientArea().height - 15);
            time = this.timeFormatter.format(this.pairing.getVariantBucket().getAllKeys()[this.records_datum2 + centreDisplacement].getTime());
            graphics.setForegroundColor(ColorConstants.darkGray);
            graphics.drawText(time, cPos - this.halfText2, this.getClientArea().y + this.getClientArea().height - 25);
        }
    }

    private boolean xLocationValid(int previousXPosition, int nextXPosition) {
        return previousXPosition > this.getClientArea().y && nextXPosition < this.getClientArea().y + this.getClientArea().width;
    }

    private void addNotches(Graphics graphics, int previousXPosition, int nextXPosition, int centreDisplacement) {
        graphics.setForegroundColor(ColorConstants.lightBlue);
        graphics.drawLine(previousXPosition, this.getClientArea().y + 40 - 5 - 2, previousXPosition, this.getClientArea().y + 40);
        graphics.drawLine(previousXPosition, this.getClientArea().y + this.getClientArea().height - 40, previousXPosition, this.getClientArea().y + this.getClientArea().height - 33);
        graphics.drawLine(nextXPosition, this.getClientArea().y + 40 - 5 - 2, nextXPosition, this.getClientArea().y + 40);
        graphics.drawLine(nextXPosition, this.getClientArea().y + this.getClientArea().height - 40, nextXPosition, this.getClientArea().y + this.getClientArea().height - 33);
        graphics.drawLine(previousXPosition, this.getClientArea().y, previousXPosition, this.getClientArea().y + 5 - 2);
        graphics.drawLine(previousXPosition, this.getClientArea().y + this.getClientArea().height - 5 + 2, previousXPosition, this.getClientArea().y + this.getClientArea().height);
        graphics.drawLine(nextXPosition, this.getClientArea().y, nextXPosition, this.getClientArea().y + 5 - 2);
        graphics.drawLine(nextXPosition, this.getClientArea().y + this.getClientArea().height - 5 + 2, nextXPosition, this.getClientArea().y + this.getClientArea().height);
        if (centreDisplacement > 0) {
            graphics.setForegroundColor(ColorConstants.lightGray);
            graphics.setLineWidth(1);
            graphics.drawLine(previousXPosition, this.getClientArea().y + 40, previousXPosition, this.getClientArea().y + 40 + this.getClientArea().height - 80);
            graphics.drawLine(nextXPosition, this.getClientArea().y + 40, nextXPosition, this.getClientArea().y + 40 + this.getClientArea().height - 80);
        }
    }

    private void addSmallNotches(Graphics graphics, int previousXPosition, int nextXPosition, int centreDisplacement) {
        graphics.setForegroundColor(ColorConstants.lightBlue);
        graphics.setLineWidth(1);
        graphics.drawLine(previousXPosition, this.getClientArea().y + 40 - 5, previousXPosition, this.getClientArea().y + 40);
        graphics.drawLine(previousXPosition, this.getClientArea().y + this.getClientArea().height - 40, previousXPosition, this.getClientArea().y + this.getClientArea().height - 35);
        graphics.drawLine(nextXPosition, this.getClientArea().y + 40 - 5, nextXPosition, this.getClientArea().y + 40);
        graphics.drawLine(nextXPosition, this.getClientArea().y + this.getClientArea().height - 40, nextXPosition, this.getClientArea().y + this.getClientArea().height - 35);
    }

    private boolean isValidDatum1() {
        return this.pairing != null;
    }

    private boolean isValidDatum2() {
        return this.pairing != null;
    }

    public void buttonPressed(int options) {
        if ((options & 0x80) != 0) {
            if ((options & 0x4000) != 0) {
                if (this.records_datum1 > 0) {
                    --this.records_datum1;
                }
            } else if (this.records_datum1 < this.pairing.getBaseTotal() + 1) {
                ++this.records_datum1;
            }
        } else if ((options & 0x400) != 0) {
            if ((options & 0x4000) != 0) {
                if (this.records_datum2 > 0) {
                    --this.records_datum2;
                }
            } else if (this.records_datum2 < this.pairing.getVariantTotal() + 1) {
                ++this.records_datum2;
            }
        } else if ((options & 0x4000) != 0) {
            if (this.records_datum1 > 0) {
                --this.records_datum1;
            }
            if (this.records_datum2 > 0) {
                --this.records_datum2;
            }
        } else {
            if (this.records_datum1 < this.pairing.getBaseTotal() - 1) {
                ++this.records_datum1;
            }
            if (this.records_datum2 < this.pairing.getVariantTotal() - 1) {
                ++this.records_datum2;
            }
        }
        this.feedBack.updateFeedback(this.records_datum1, this.records_datum2, false);
        this.repaint();
    }

    public void sliceSelected(PBKey baseKey, PBKey variantKey) {
        int i = 0;
        while (i < this.pairing.getBaseTotal()) {
            if (this.pairing.getBaseBucket().getAllKeys()[i].equals(baseKey)) {
                this.records_datum1 = i;
            }
            ++i;
        }
        i = 0;
        while (i < this.pairing.getVariantTotal()) {
            if (this.pairing.getVariantBucket().getAllKeys()[i].equals(variantKey)) {
                this.records_datum2 = i;
            }
            ++i;
        }
        this.repaint();
    }

    public void reset() {
        this.records_datum1 = this.pairing.getBaseDisplacement();
        this.records_datum2 = this.pairing.getVariantDisplacement();
        this.feedBack.updateFeedback(this.records_datum1, this.records_datum2, false);
        this.repaint();
    }

    public void setContent(ProfilerPairing pairing, ProfileComposite profilerComposite, List<ColumnDefinition> list) {
        this.pairing = pairing;
        this.feedBack = profilerComposite;
        this.records_datum1 = pairing.getBaseDisplacement();
        this.records_datum2 = pairing.getVariantDisplacement();
        this.removeAll();
        int i = 0;
        while (i < this.slices.length) {
            ProfileChartTimeSlice slice;
            this.slices[i] = slice = new ProfileChartTimeSlice();
            this.add((IFigure)slice);
            ++i;
        }
        if (pairing.getBaseBucket().getKeyAtLocation(this.records_datum1) != null) {
            this.textDate1 = this.dateFormatter.format(pairing.getBaseBucket().getKeyAtLocation(this.records_datum1).getDate());
            this.textTime1 = this.timeFormatter.format(pairing.getBaseBucket().getKeyAtLocation(this.records_datum1).getTime());
            this.reset();
        }
        this.setSelectedDefinitions(list);
        this.feedBack.updateFeedback(this.records_datum1, this.records_datum2, false);
        this.repaint();
    }

    public void setSelectedDefinitions(List<ColumnDefinition> definitions) {
        this.selectedDefinitions = definitions;
        this.repaint();
    }
}

