/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.pa.ui.views.internal;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.common.util.StringUtil;
import com.ibm.cics.pa.model.Pie;
import com.ibm.cics.pa.model.definitions.ColumnDefinition;
import com.ibm.cics.pa.ui.editors.PieEditorItem;
import com.ibm.cics.pa.ui.views.PieEditorContentProvider;
import com.ibm.cics.pa.ui.views.internal.IPieViewVariance;
import java.util.Map;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.swt.graphics.Image;

public class PieViewVariance
implements IPieViewVariance {
    private static final Debug debug = new Debug(PieViewVariance.class);
    protected Pie model;
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y23 (c) Copyright IBM Corp. 2013 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public PieViewVariance(Pie model) {
        debug.enter("PieViewVariance", (Object)model);
        this.model = model;
        debug.exit("PieViewVariance");
    }

    @Override
    public void populateTreeViewer(TreeViewer viewer, Map<ColumnDefinition, Object> mapping, boolean includeFlag, boolean restricFlag) {
        String[] headers;
        debug.enter("populateTreeViewer");
        viewer.getTree().setVisible(false);
        String[] tooltips = headers = this.getHeaders();
        viewer.getTree().removeAll();
        while (viewer.getTree().getColumnCount() > 0) {
            viewer.getTree().getColumns()[0].dispose();
        }
        viewer.setContentProvider((IContentProvider)new PieEditorContentProvider(mapping));
        int i = 0;
        while (i < headers.length) {
            final int column = i;
            TreeViewerColumn treeViewerColumn = new TreeViewerColumn(viewer, 0);
            treeViewerColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

                public String getText(Object element) {
                    return ((PieEditorItem)element).getColumnValue(column);
                }

                public Image getImage(Object element) {
                    return null;
                }

                public String getToolTipText(Object element) {
                    if (column == 0 && ((PieEditorItem)element).getColumnDefinition() != null) {
                        return ((PieEditorItem)element).getColumnDefinition().getTooltip(null);
                    }
                    return null;
                }
            });
            ColumnViewerToolTipSupport.enableFor((ColumnViewer)viewer, (int)2);
            treeViewerColumn.getColumn().setText(headers[i]);
            treeViewerColumn.getColumn().setToolTipText(tooltips[i]);
            if (i == 0) {
                treeViewerColumn.getColumn().setWidth(350);
            } else {
                treeViewerColumn.getColumn().setWidth(StringUtil.hasContent((String)headers[i]) ? 125 : 0);
                treeViewerColumn.getColumn().setAlignment(131072);
            }
            ++i;
        }
        debug.exit("populateTreeViewer");
    }

    protected String[] getHeaders() {
        return new String[0];
    }
}

