/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.pa.ui.views;

import com.ibm.cics.pa.model.Column;
import com.ibm.cics.pa.model.definitions.ColumnAssociationMapper;
import com.ibm.cics.pa.model.definitions.ColumnContainment;
import com.ibm.cics.pa.model.definitions.ColumnDefinition;
import com.ibm.cics.pa.ui.Activator;
import com.ibm.cics.pa.ui.Messages;
import com.ibm.cics.pa.ui.editors.PieEditorItem;
import com.ibm.cics.pa.ui.utilities.DataTypeUtilities;
import java.util.Map;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.swt.graphics.Image;

public class PieTreeLabelProvider
extends ColumnLabelProvider {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y23 (c) Copyright IBM Corp. 2009, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static Image chartIcon = Activator.getDefault().getImage("pie");
    private int column;
    private Map<ColumnDefinition, Object> mapping;

    public PieTreeLabelProvider(Map<ColumnDefinition, Object> mapping, int column) {
        this.mapping = mapping;
        this.column = column;
    }

    public String getText(Object element) {
        String text = "";
        if (element instanceof PieEditorItem) {
            text = ((PieEditorItem)element).getColumnValue(this.column);
        } else if (this.column == 2) {
            ColumnDefinition counter = null;
            if (element instanceof ColumnContainment && ((ColumnContainment)element).getColumnRef().length == 0) {
                counter = ColumnAssociationMapper.getTimeToCount(((ColumnContainment)element).getPrimary());
            }
            if (counter != null && this.mapping.get(counter) != null) {
                text = String.valueOf(Messages.getString("CSVDataExtract.InnerBracket")) + DataTypeUtilities.getAsString(this.mapping.get(counter)) + Messages.getString("CSVDataExtract.OuterBracket");
            }
        }
        return text;
    }

    public String getToolTipText(Object element) {
        if (this.column == 0 && ((PieEditorItem)element).getColumnDefinition() != null) {
            return ((PieEditorItem)element).getColumnDefinition().getTooltip(null);
        }
        return null;
    }

    public Image getImage(Object element) {
        if (this.column == 0 && element instanceof PieEditorItem) {
            if (((PieEditorItem)element).getColumnDefinition() != null) {
                return Column.getFor(((PieEditorItem)element).getColumnDefinition()).getImage();
            }
            if (((PieEditorItem)element).getChartDefinition() != null) {
                return chartIcon;
            }
        }
        return null;
    }
}

