/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.pa.ui.views;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.dbfunc.command.Command;
import com.ibm.cics.dbfunc.command.EngineShell;
import com.ibm.cics.dbfunc.model.ColumnReference;
import com.ibm.cics.dbfunc.model.Comparator;
import com.ibm.cics.dbfunc.model.Direction;
import com.ibm.cics.dbfunc.model.PresentationFactory;
import com.ibm.cics.dbfunc.model.QueryElement;
import com.ibm.cics.dbfunc.ui.ScrollLimitManager;
import com.ibm.cics.eclipse.common.ViewHelper;
import com.ibm.cics.pa.model.AlertElement;
import com.ibm.cics.pa.model.ManifestRecord;
import com.ibm.cics.pa.model.NullRangeDateCaveat;
import com.ibm.cics.pa.model.definitions.ColumnDefinition;
import com.ibm.cics.pa.ui.Activator;
import com.ibm.cics.pa.ui.Messages;
import com.ibm.cics.pa.ui.remote.AlertsCommand;
import com.ibm.cics.pa.ui.remote.PAConnectionTracker;
import com.ibm.cics.pa.ui.utilities.FilterElement;
import com.ibm.cics.pa.ui.views.AlertsView;
import com.ibm.cics.pa.ui.views.Overview;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.logging.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.progress.IWorkbenchSiteProgressService;

public class PerformanceAlerts
extends AlertsView {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y23 (c) Copyright IBM Corp. 2008, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    static final Logger logger = Logger.getLogger("com.ibm.cics.pa.ui");
    private static final ColumnDefinition[] FIELDS = new ColumnDefinition[]{ColumnDefinition.START, ColumnDefinition.STOP, ColumnDefinition.APPLID, ColumnDefinition.TRAN, ColumnDefinition.TASKNO, ColumnDefinition.ALT_FIELD_NAME, ColumnDefinition.ALT_FIELD_VALUE, ColumnDefinition.THRESHOLD, ColumnDefinition.RES_NAME1, ColumnDefinition.RES_VALUE1, ColumnDefinition.RES_NAME2, ColumnDefinition.RES_VALUE2, ColumnDefinition.RES_NAME3, ColumnDefinition.RES_VALUE3, ColumnDefinition.SEQNO, ColumnDefinition.ALT_DEF_NAME};

    @Override
    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        this.viewer.getTree().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                if (!PerformanceAlerts.this.viewer.getSelection().isEmpty()) {
                    try {
                        IHandlerService handlerService = (IHandlerService)PerformanceAlerts.this.getSite().getService(IHandlerService.class);
                        AlertElement element = (AlertElement)((StructuredSelection)PerformanceAlerts.this.viewer.getSelection()).getFirstElement();
                        ManifestRecord record = ManifestRecord.getAlias(element.getTableAlias());
                        if (record != null && record.isPresent() && record.isPerformanceList()) {
                            handlerService.executeCommand("com.ibm.cics.pa.ui.performance.record", null);
                            return;
                        }
                        handlerService.executeCommand("com.ibm.cics.pa.ui.commands.spreadsheet", null);
                    }
                    catch (Exception ex) {
                        Debug.error((Logger)logger, (String)((Object)((Object)this)).getClass().getName(), (String)"createPartControl", (Throwable)ex);
                    }
                }
            }
        });
    }

    @Override
    public void tableSelected(ManifestRecord manifest) {
        Debug.enter((Logger)logger, (String)this.getClass().getName(), (String)"tableSelected");
        this.initialised = true;
        if (this.command != null && this.command.status() == -1) {
            this.command.cancel();
            ViewHelper.setStatusInformationMessage((IWorkbenchPart)this, (String)Messages.getString("RemoteEditorInput.SearchHalted1"));
            Debug.event((Logger)logger, (String)this.getClass().getName(), (String)"Overview Listener selectionChanged", (Object)"Cancelled already waiting command");
        } else if (this.command != null && this.command.status() == 0) {
            this.command.cancel();
            ViewHelper.setStatusInformationMessage((IWorkbenchPart)this, (String)Messages.getString("RemoteEditorInput.SearchHalted2"));
            Debug.event((Logger)logger, (String)this.getClass().getName(), (String)"A command already in progress");
            try {
                Thread.sleep(250L);
            }
            catch (InterruptedException e) {
                Debug.error((Logger)logger, (String)this.getClass().getName(), (String)"tableSelected", (Throwable)e);
            }
        }
        if (this.connected) {
            if (manifest != null) {
                this.currentManifest = manifest;
            }
            if (this.currentManifest != null && this.currentManifest.isPresent()) {
                this.scrollLimitManager = this.getScrollLimitManager();
                if (this.scrollLimitManager != null) {
                    this.scrollLimitManager.dispose();
                }
                this.initialiseBuckets();
                String newDescription = "";
                HashMap<String, Object> parameterMap = new HashMap<String, Object>();
                this.selection = PresentationFactory.getInstance().createSelectAllForTable(this.currentManifest.getName(), ":schema");
                ArrayList<String> whereByClause = new ArrayList<String>();
                if (Platform.getPreferencesService().getBoolean(Activator.getDefault().getBundle().getSymbolicName(), "com.ibm.cics.pa.ui.alert.critical", true, null)) {
                    whereByClause.add("Critical");
                }
                if (Platform.getPreferencesService().getBoolean(Activator.getDefault().getBundle().getSymbolicName(), "com.ibm.cics.pa.ui.alert.warning", true, null)) {
                    whereByClause.add("Warning");
                }
                if (Platform.getPreferencesService().getBoolean(Activator.getDefault().getBundle().getSymbolicName(), "com.ibm.cics.pa.ui.alert.information", true, null)) {
                    whereByClause.add("Info");
                }
                if (!whereByClause.isEmpty() && whereByClause.size() < 3) {
                    this.selection.appendCondition(ColumnDefinition.SEVERITY.getDBColumnRef(), this.currentManifest.getName(), ColumnDefinition.SEVERITY.getType(), Comparator.IN, whereByClause.toArray(), QueryElement.Predicate.AND, false);
                }
                if (this.filters != null && !this.filters.isEmpty()) {
                    Object aClause = null;
                    for (FilterElement element : this.filters) {
                        newDescription = String.valueOf(newDescription) + element.toString();
                        newDescription = String.valueOf(newDescription) + ',';
                        ColumnDefinition column = (ColumnDefinition)element.getColumn();
                        String attribute = element.getOperator();
                        boolean isNot = false;
                        Comparator comparator = Comparator.EQ;
                        if (!attribute.trim().equals("=")) {
                            if (attribute.trim().equals("!=")) {
                                comparator = Comparator.EQ;
                                isNot = true;
                            } else if (attribute.trim().equals(">")) {
                                comparator = Comparator.GT;
                            } else if (attribute.trim().equals(">=")) {
                                comparator = Comparator.GE;
                            } else if (attribute.trim().equals("<")) {
                                comparator = Comparator.LT;
                            } else if (attribute.trim().equals("<=")) {
                                comparator = Comparator.LE;
                            }
                        }
                        String value = element.getValue();
                        if (element.getAlternativeValue() != null) {
                            value = element.getAlternativeValue().getDBColumnRef();
                        }
                        if (value.indexOf(42) > -1) {
                            value.replace('*', '%');
                        }
                        if (value.indexOf(37) > -1) {
                            comparator = Comparator.LI;
                        }
                        aClause = aClause == null ? PresentationFactory.getInstance().createSimpleCondition(column.getDBColumnRef(), this.currentManifest.getName(), column.getType(), comparator, new Object[]{value}, isNot) : aClause.appendCondition(column.getDBColumnRef(), this.currentManifest.getName(), column.getType(), comparator, new Object[]{value}, QueryElement.Predicate.AND, isNot);
                    }
                    parameterMap.put("TemporaryConstraintAnd", aClause);
                }
                if (this.sortColumnDefinition != null) {
                    this.selection.addOrderByCondition(this.sortColumnDefinition.getDBColumnRef(), this.currentManifest.getName(), this.sortDirection == 128 ? Direction.ASC : Direction.DESC);
                } else {
                    this.selection.addOrderByCondition(ColumnDefinition.START.getDBColumnRef(), this.currentManifest.getName(), Direction.DESC);
                }
                if (this.currentDateToken != null && !(this.currentDateToken instanceof NullRangeDateCaveat)) {
                    this.selection.appendCondition(this.currentDateToken.getConstraint(null, true), QueryElement.Predicate.AND);
                    newDescription = String.valueOf(newDescription) + this.currentDateToken.getLabel() + this.relativeDateText();
                }
                if (this.isLinkedToSelection && !this.linkToSelection.isEmpty()) {
                    this.selection.appendCondition(ColumnDefinition.APPLID.getDBColumnRef(), this.currentManifest.getName(), ColumnDefinition.APPLID.getType(), Comparator.IN, this.linkToSelection.toArray(), QueryElement.Predicate.AND, false);
                    StringBuffer desc = new StringBuffer();
                    Object[] elements = this.linkToSelection.toArray();
                    int i = 0;
                    while (i < elements.length) {
                        if (i == 0) {
                            desc.append(ColumnDefinition.APPLID.getLabel(null));
                        } else {
                            desc.append(',');
                        }
                        desc.append(' ');
                        desc.append((String)elements[i]);
                        if (i == elements.length - 1) {
                            desc.append('.');
                        }
                        ++i;
                    }
                    newDescription = String.valueOf(newDescription) + ' ' + desc.toString();
                }
                this.setContentDescription(newDescription);
                this.command = new AlertsCommand(this, this.selection, this.defns, parameterMap);
                this.command.setAsync(false);
                this.command.addListener(new EngineShell.EngineListener(){
                    private int rows_returned = 0;

                    public void dataAvailable(Collection<Object> items) {
                        this.setRows_returned(this.getRows_returned() + items.size());
                        PerformanceAlerts.this.updateResults(PerformanceAlerts.this.viewer, items);
                    }

                    public void notifyResultCount(int count) {
                    }

                    public void statusUpdate(EngineShell.EngineStatus es) {
                        switch (es) {
                            case Cancelled: 
                            case Error: {
                                PerformanceAlerts.this.command.removeListener(this);
                                Display.getDefault().asyncExec(new Runnable(){

                                    @Override
                                    public void run() {
                                        ScrollLimitManager scrollLimitManager = PerformanceAlerts.this.getScrollLimitManager();
                                        if (scrollLimitManager != null) {
                                            scrollLimitManager.dispose();
                                        }
                                    }
                                });
                                break;
                            }
                            case Complete: {
                                PerformanceAlerts.this.command.removeListener(this);
                                try {
                                    Thread.sleep(250L);
                                }
                                catch (InterruptedException e) {
                                    Debug.error((Logger)logger, (String)this.getClass().getName(), (String)"tableSelected", (Throwable)e);
                                }
                                Display.getDefault().syncExec(new Runnable(){

                                    @Override
                                    public void run() {
                                        (this).PerformanceAlerts.this.scrollLimitManager = PerformanceAlerts.this.getScrollLimitManager();
                                        if ((this).PerformanceAlerts.this.scrollLimitManager != null) {
                                            (this).PerformanceAlerts.this.scrollLimitManager.dispose();
                                        }
                                        if ((this).PerformanceAlerts.this.filterControl != null) {
                                            (this).PerformanceAlerts.this.filterControl.revalidate();
                                        }
                                        if (!("Critical".isEmpty() && "Warning".isEmpty() && "Info".isEmpty())) {
                                            ViewHelper.setStatusInformationMessage((IWorkbenchPart)PerformanceAlerts.this, (String)MessageFormat.format(Messages.getString("CSVDataExtract.Rows"), this.getRows_returned()));
                                        } else {
                                            PerformanceAlerts.this.setContentDescription(String.valueOf(PerformanceAlerts.this.getContentDescription()) + ' ' + Messages.getString("PAX0103I.Results.NoData"));
                                            ViewHelper.setStatusInformationMessage((IWorkbenchPart)PerformanceAlerts.this, (String)"");
                                        }
                                    }
                                });
                                break;
                            }
                            case Paused: {
                                Display.getDefault().asyncExec(new Runnable(){

                                    @Override
                                    public void run() {
                                        ScrollLimitManager scrollLimitManager;
                                        if ((this).PerformanceAlerts.this.filterControl != null) {
                                            (this).PerformanceAlerts.this.filterControl.revalidate();
                                        }
                                        if ((scrollLimitManager = PerformanceAlerts.this.getScrollLimitManager()) != null && (this).PerformanceAlerts.this.command != null && (this).PerformanceAlerts.this.command.status() == 3) {
                                            scrollLimitManager.setCursor(null);
                                            scrollLimitManager.scrollLimitReached((Command)(this).PerformanceAlerts.this.command);
                                            scrollLimitManager.setTaskName(MessageFormat.format(Messages.getString("SheetView.collecting"), Messages.getString("Alerts")));
                                        }
                                    }
                                });
                                break;
                            }
                        }
                    }

                    public int getRows_returned() {
                        return this.rows_returned;
                    }

                    public void setRows_returned(int rows_returned) {
                        this.rows_returned = rows_returned;
                    }
                });
                Job job = new Job(MessageFormat.format(Messages.getString("AlertsView.collecting"), this.getContentDescription())){

                    protected IStatus run(IProgressMonitor monitor) {
                        if (PAConnectionTracker.getInstance().isConnected()) {
                            PerformanceAlerts.this.command.start();
                        }
                        return Status.OK_STATUS;
                    }
                };
                job.setPriority(30);
                IWorkbenchSiteProgressService siteService = (IWorkbenchSiteProgressService)this.getSite().getAdapter(IWorkbenchSiteProgressService.class);
                siteService.schedule(job);
            } else {
                ViewHelper.setStatusInformationMessage((IWorkbenchPart)this, (String)MessageFormat.format(Messages.getString("PAX0109I.Results.NoData.view"), this.getPartName()));
            }
        }
        Debug.exit((Logger)logger, (String)this.getClass().getName(), (String)"tableSelected");
    }

    @Override
    protected String getHelpContextId() {
        return "com.ibm.cics.pa.ui.performance_alertsview";
    }

    @Override
    public ColumnDefinition[] getFields() {
        return FIELDS;
    }

    @Override
    public String getPersistenceLabel() {
        return "CMFALERT";
    }

    @Override
    public void resetColumns() {
        int[] order = new int[this.getFields().length];
        int i = 0;
        while (i < this.getFields().length) {
            order[i] = i;
            ++i;
        }
        this.viewer.getTree().setColumnOrder(order);
        i = 0;
        while (i < this.getFields().length) {
            if (this.getFields()[i] == ColumnDefinition.APPLID) {
                this.viewer.getTree().getColumn(i).setWidth(80);
            } else if (this.getFields()[i] == ColumnDefinition.TRAN) {
                this.viewer.getTree().getColumn(i).setWidth(50);
            } else if (this.getFields()[i] == ColumnDefinition.ALT_FIELD_NAME) {
                this.viewer.getTree().getColumn(i).setWidth(100);
            } else if (this.getFields()[i] == ColumnDefinition.ALT_FIELD_TYPE) {
                this.viewer.getTree().getColumn(i).setWidth(100);
            } else if (this.getFields()[i] == ColumnDefinition.TRAN) {
                this.viewer.getTree().getColumn(i).setWidth(50);
            } else if (this.getFields()[i].getType() == ColumnReference.DataType.Timestamp) {
                this.viewer.getTree().getColumn(i).setWidth(270);
            } else if (this.getFields()[i].getType() == ColumnReference.DataType.String) {
                this.viewer.getTree().getColumn(i).setWidth(75);
                this.viewer.getTree().getColumn(i).setAlignment(0x1000000);
            } else {
                this.viewer.getTree().getColumn(i).setWidth(65);
                this.viewer.getTree().getColumn(i).setAlignment(131072);
            }
            ++i;
        }
        this.viewer.refresh();
    }

    @Override
    public void initialise() {
        Job job = new Job(Messages.getString("ExplorerViewContentProvider.initialization")){

            protected IStatus run(IProgressMonitor monitor) {
                final ManifestRecord manifest = PAConnectionTracker.getInstance().getPerformanceAlertManifest();
                if (manifest != null) {
                    while (!manifest.isPresent()) {
                        try {
                            Thread.yield();
                            Thread.sleep(1000L);
                        }
                        catch (InterruptedException e) {
                            Debug.error((Logger)logger, (String)PerformanceAlerts.class.getName(), (String)"initialise", (Throwable)e);
                        }
                    }
                    Display.getDefault().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            PerformanceAlerts.this.tableSelected(manifest);
                            Overview overview = (Overview)PerformanceAlerts.this.getSite().getPage().findView("com.ibm.cics.pa.ui.overview");
                            if (overview != null) {
                                PerformanceAlerts.this.selectionChanged((IWorkbenchPart)overview, overview.getSelection());
                            }
                        }
                    });
                }
                return Status.OK_STATUS;
            }
        };
        job.setPriority(30);
        IWorkbenchSiteProgressService siteService = (IWorkbenchSiteProgressService)this.getSite().getAdapter(IWorkbenchSiteProgressService.class);
        siteService.schedule(job);
    }
}

