/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.pa.ui.views;

import com.ibm.cics.core.comm.IConnectable;
import com.ibm.cics.core.comm.IConnection;
import com.ibm.cics.dbfunc.model.PresentationFactory;
import com.ibm.cics.pa.model.ChartingFile;
import com.ibm.cics.pa.model.GenericDataProvider;
import com.ibm.cics.pa.model.ManifestRecord;
import com.ibm.cics.pa.model.TreeElement;
import com.ibm.cics.pa.ui.Activator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.navigator.IDescriptionProvider;
import org.eclipse.ui.progress.PendingUpdateAdapter;

public class ExplorerViewLabelProvider
extends LabelProvider
implements IDescriptionProvider {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y23 (c) Copyright IBM Corp. 2009, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private Image csvFile = Activator.getDefault().getImage("table");
    private Image altFile = Activator.getDefault().getImage("dataSource");

    public String getText(Object obj) {
        String text = null;
        if (obj instanceof TreeElement) {
            text = ((TreeElement)obj).getTreeLabel();
        } else if (obj instanceof IResource) {
            text = ((IResource)obj).getName();
        } else {
            if (obj instanceof PendingUpdateAdapter) {
                return ((PendingUpdateAdapter)obj).getLabel(obj);
            }
            if (obj instanceof IConnectable) {
                return ((IConnectable)obj).getConnection().getConfiguration().getName();
            }
            if (obj instanceof IConnection) {
                return ((IConnection)obj).getConfiguration().getName();
            }
        }
        return text;
    }

    public Image getImage(Object obj) {
        if (obj instanceof IFile && ((IFile)obj).getFileExtension() != null) {
            String fileExtension = ((IFile)obj).getFileExtension();
            if (fileExtension.equalsIgnoreCase("csv")) {
                GenericDataProvider provider;
                String name;
                Image image;
                if (ChartingFile.referenceExists((IFile)obj) && (image = ManifestRecord.getImage(name = (provider = ChartingFile.getReference((IFile)obj)).getDataProviderKey().name())) != null) {
                    return image;
                }
                return this.csvFile;
            }
            if (fileExtension.equalsIgnoreCase("cpa")) {
                return this.altFile;
            }
            if (fileExtension.equalsIgnoreCase("xml")) {
                try {
                    if (PresentationFactory.getInstance().possibleSelectionObject(((IFile)obj).getContents())) {
                        return this.altFile;
                    }
                }
                catch (CoreException e) {
                    return null;
                }
            }
        } else {
            if (obj instanceof TreeElement) {
                return this.getExplorerViewModelImage((TreeElement)obj);
            }
            if (obj instanceof PendingUpdateAdapter) {
                return null;
            }
            if (obj instanceof TreeSelection && ((TreeSelection)obj).getFirstElement() instanceof TreeElement) {
                return this.getExplorerViewModelImage((TreeElement)((TreeSelection)obj).getFirstElement());
            }
        }
        return null;
    }

    public String getDescription(Object anElement) {
        if (anElement instanceof IResource) {
            return ((IResource)anElement).getFullPath().makeRelative().toString();
        }
        if (anElement instanceof TreeElement) {
            GenericDataProvider provider = ((TreeElement)anElement).getSourceProvider();
            String ref = provider != null ? provider.getFileReference() : "";
            ref = String.valueOf(ref) + ((TreeElement)anElement).getRelativeText();
            return ref;
        }
        if (anElement instanceof IConnection) {
            return ((IConnection)anElement).getConfiguration().getHost();
        }
        return this.getText(anElement);
    }

    public Image getExplorerViewModelImage(TreeElement model) {
        return Activator.getDefault().getImage(model.getColumn().getDBColumnRef());
    }
}

