/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.pa.ui.utilities;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.common.util.StringUtil;
import com.ibm.cics.pa.model.definitions.ColumnDefinition;
import com.ibm.cics.pa.ui.Activator;
import com.ibm.cics.pa.ui.Messages;
import com.ibm.cics.pa.ui.utilities.PredefinedTemplate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.osgi.service.prefs.BackingStoreException;

public class SheetViewPersistenceManager {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y23 (c) Copyright IBM Corp. 2008, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Debug debug = new Debug(SheetViewPersistenceManager.class);
    public static final int COLUMN_MIN_WIDTH = 70;
    private static final String COLUMN_WIDTH = "PA_PREFS.COLUMN_WIDTH.";
    private static final String COLUMN_ORDER = "PA_PREFS.COLUMN_ORDER.";
    private static final String TEMPLATE_COLUMN_WIDTH = "PA_TEMPLATE_PREFS.COLUMN_WIDTH.";
    private static final String TEMPLATE_COLUMN_ORDER = "PA_TEMPLATE_PREFS.COLUMN_ORDER.";
    private static final String TEMPLATE_APPLIED = "PA_TEMPLATE_APPLIED.";
    private static final String TEMPLATE_FILTER = "PA_TEMPLATE_PREFS.FILTER.";
    private static final Pattern DIGIT = Pattern.compile("\\d+");
    private static Map<String, SheetViewPersistenceManager> instances = new HashMap<String, SheetViewPersistenceManager>();
    public static final String[] predefined_templates_performance = new String[]{"", Messages.getString("Templates.CPU_analysis"), Messages.getString("Templates.Response_time_analysis")};
    private String tableRef;

    private SheetViewPersistenceManager(String tableRef) {
        this.tableRef = tableRef;
    }

    private static IEclipsePreferences getPreferenceStore() {
        return Activator.getDefault().getPluginInstancePreferences();
    }

    public static SheetViewPersistenceManager getInstance(String table) {
        if (!instances.containsKey(table)) {
            instances.put(table, new SheetViewPersistenceManager(table));
        }
        return instances.get(table);
    }

    public void setCombinedColumnOrder(int[] columnOrder, int[] widths, ColumnDefinition[] defns) {
        debug.enter("setCombinedColumnOrder", (Object)this.tableRef, (Object)columnOrder);
        StringBuffer columns = new StringBuffer();
        StringBuffer widthsBuffer = new StringBuffer();
        int i = 0;
        while (i < columnOrder.length && 1 < defns.length) {
            if (widths[columnOrder[i]] > -1) {
                columns.append(defns[columnOrder[i]].getDBColumnRef());
                columns.append(',');
                widthsBuffer.append(widths[columnOrder[i]]);
                widthsBuffer.append(',');
            }
            ++i;
        }
        SheetViewPersistenceManager.getPreferenceStore().put(COLUMN_ORDER + this.tableRef, columns.toString());
        SheetViewPersistenceManager.getPreferenceStore().put(COLUMN_WIDTH + this.tableRef, widthsBuffer.toString());
        debug.exit("setCombinedColumnOrder");
    }

    public void setColumnOrder(int[] columnOrder, ColumnDefinition[] defns) {
        debug.enter("setColumnOrder", (Object)this.tableRef, (Object)columnOrder);
        StringBuffer columns = new StringBuffer();
        int i = 0;
        while (i < columnOrder.length) {
            columns.append(defns[columnOrder[i]].getDBColumnRef());
            columns.append(',');
            ++i;
        }
        SheetViewPersistenceManager.getPreferenceStore().put(COLUMN_ORDER + this.tableRef, columns.toString());
        debug.exit("setColumnOrder");
    }

    private void flush() {
        try {
            SheetViewPersistenceManager.getPreferenceStore().flush();
        }
        catch (BackingStoreException e) {
            debug.error("flush", (Throwable)e);
        }
    }

    public int[] getColumnOrder(ColumnDefinition[] defns) {
        debug.enter("getColumnOrder");
        String tokens = SheetViewPersistenceManager.getPreferenceStore().get(COLUMN_ORDER + this.tableRef, "");
        ArrayList<String> al = new ArrayList<String>();
        StringTokenizer tokeniser = new StringTokenizer(tokens, ",");
        while (tokeniser.hasMoreElements()) {
            al.add(tokeniser.nextToken());
        }
        int[] result = new int[al.size()];
        if (al.isEmpty()) {
            PredefinedTemplate template = PredefinedTemplate.findDefaultTemplate(this.tableRef);
            if (template != null) {
                template.intialise(defns);
                result = template.getOrdering();
            }
        } else {
            int i = 0;
            while (i < al.size()) {
                String value = ((String)al.get(i)).trim();
                if (DIGIT.matcher(value).matches()) {
                    result[i] = Integer.parseInt(value);
                } else {
                    int j = 0;
                    while (j < defns.length) {
                        if (defns[j] != null && value.equals(defns[j].getDBColumnRef())) {
                            result[i] = j;
                            break;
                        }
                        ++j;
                    }
                }
                ++i;
            }
        }
        debug.exit("getColumnOrder", (Object)result);
        return result;
    }

    private int[] getColumnWidthsFrom(ColumnDefinition[] columnDefinitions) {
        debug.enter("getColumnWidths");
        String tokens = SheetViewPersistenceManager.getPreferenceStore().get(COLUMN_WIDTH + this.tableRef, "");
        ArrayList<String> al = new ArrayList<String>();
        StringTokenizer tokeniser = new StringTokenizer(tokens, ",");
        while (tokeniser.hasMoreElements()) {
            al.add(tokeniser.nextToken());
        }
        int[] result = new int[al.size()];
        if (al.isEmpty()) {
            PredefinedTemplate template = PredefinedTemplate.findDefaultTemplate(this.tableRef);
            if (template != null) {
                template.intialise(columnDefinitions);
                result = template.getWidths();
            }
        } else {
            int i = 0;
            while (i < al.size()) {
                result[i] = Integer.parseInt((String)al.get(i));
                ++i;
            }
        }
        debug.exit("getColumnWidths", (Object)result);
        return result;
    }

    public int[] getColumnWidths(ColumnDefinition[] defns) {
        debug.enter("getColumnWidths");
        int[] columns = this.getColumnWidthsFrom(defns);
        if (columns.length == 0 || defns.length > columns.length) {
            columns = new int[defns.length];
            int i = 0;
            while (i < defns.length) {
                columns[i] = 70;
                ++i;
            }
            this.setColumnWidths(columns, defns);
        }
        debug.exit("getColumnWidths", (Object)columns);
        return columns;
    }

    public void setColumnWidths(int[] widths, ColumnDefinition[] columnDefinitions) {
        debug.enter("setColumnWidths", (Object)this.tableRef);
        if (!Arrays.equals(widths, this.getColumnWidthsFrom(columnDefinitions))) {
            StringBuffer columns = new StringBuffer();
            int i = 0;
            while (i < widths.length) {
                columns.append(widths[i]);
                columns.append(',');
                ++i;
            }
            SheetViewPersistenceManager.getPreferenceStore().put(COLUMN_WIDTH + this.tableRef, columns.toString());
            this.flush();
        }
        debug.exit("setColumnWidths");
    }

    public int[] resetDisplayedColumnsWidth(ColumnDefinition[] columnDefinitions) {
        debug.enter("resetDisplayedColumnsWidth", (Object)this.tableRef);
        int[] columns = new int[]{};
        PredefinedTemplate template = PredefinedTemplate.findDefaultTemplate(this.tableRef);
        if (template != null) {
            template.intialise(columnDefinitions);
            columns = template.getWidths();
        } else {
            columns = this.getColumnWidths(columnDefinitions);
            int i = 0;
            while (i < columnDefinitions.length) {
                if (columns[i] != -1) {
                    columns[i] = 70;
                }
                ++i;
            }
        }
        this.setColumnWidths(columns, columnDefinitions);
        debug.exit("resetDisplayedColumnsWidth");
        return columns;
    }

    public void addDisplayColumn(int pos, ColumnDefinition[] columnDefinitions) {
        debug.enter("addDisplayColumn", (Object)this.tableRef, (Object)pos);
        int[] widths = this.getColumnWidthsFrom(columnDefinitions);
        widths[pos] = 70;
        this.setColumnWidths(widths, columnDefinitions);
        debug.exit("addDisplayColumn");
    }

    public void removeDisplayColumn(int i, ColumnDefinition[] columnDefinitions) {
        debug.enter("removeDisplayColumn", (Object)this.tableRef, (Object)i);
        int[] widths = this.getColumnWidthsFrom(columnDefinitions);
        if (widths.length == columnDefinitions.length) {
            widths[i] = -1;
            this.setColumnWidths(widths, null);
        }
        debug.exit("removeDisplayColumn");
    }

    public void saveAsTemplate(String templateName) {
        debug.enter("saveAsTemplate", (Object)this.tableRef, (Object)templateName);
        String tokens = SheetViewPersistenceManager.getPreferenceStore().get(COLUMN_ORDER + this.tableRef, "");
        if (tokens.length() > 0) {
            SheetViewPersistenceManager.getPreferenceStore().put(TEMPLATE_COLUMN_ORDER + this.tableRef + '.' + templateName, tokens);
        } else {
            SheetViewPersistenceManager.getPreferenceStore().remove(TEMPLATE_COLUMN_ORDER + this.tableRef + '.' + templateName);
        }
        tokens = SheetViewPersistenceManager.getPreferenceStore().get(COLUMN_WIDTH + this.tableRef, "");
        if (tokens.length() > 0) {
            SheetViewPersistenceManager.getPreferenceStore().put(TEMPLATE_COLUMN_WIDTH + this.tableRef + '.' + templateName, tokens);
        } else {
            SheetViewPersistenceManager.getPreferenceStore().remove(TEMPLATE_COLUMN_WIDTH + this.tableRef + '.' + templateName);
        }
        this.setLayoutLabel(templateName);
        this.flush();
        debug.exit("saveAsTemplate");
    }

    public Collection<String> getTemplates() {
        debug.enter("getTemplates", (Object)this.tableRef);
        HashSet<String> templates = new HashSet<String>();
        if (this.tableRef != null) {
            try {
                String[] stringArray = SheetViewPersistenceManager.getPreferenceStore().keys();
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String key_name = stringArray[n2];
                    String option1 = TEMPLATE_COLUMN_WIDTH + this.tableRef;
                    if (key_name.startsWith(option1)) {
                        templates.add(key_name.substring(option1.length() + 1));
                    }
                    ++n2;
                }
            }
            catch (BackingStoreException e) {
                debug.error("getTemplates", (Throwable)e);
            }
        }
        debug.exit("getTemplates", templates);
        return templates;
    }

    public Collection<String> getTemplates(String templateType, int length) {
        debug.enter("getTemplates", (Object)templateType);
        HashSet<String> templates = new HashSet<String>();
        if (templateType != null) {
            try {
                String[] stringArray = SheetViewPersistenceManager.getPreferenceStore().keys();
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String tokens;
                    StringTokenizer tokeniser;
                    String key_name = stringArray[n2];
                    String option1 = TEMPLATE_COLUMN_ORDER + templateType;
                    if (key_name.startsWith(option1) && (tokeniser = new StringTokenizer(tokens = SheetViewPersistenceManager.getPreferenceStore().get(key_name, ""), ",")).countTokens() == length) {
                        templates.add(key_name.substring(option1.length() + 1));
                    }
                    ++n2;
                }
            }
            catch (BackingStoreException e) {
                debug.error("getTemplates", (Throwable)e);
            }
        }
        debug.exit("getTemplates", templates);
        return templates;
    }

    public String getCurrentLayout() {
        debug.enter("getCurrentLayout", (Object)this.tableRef);
        String current = Messages.getString("Custom.template");
        String tokens1 = SheetViewPersistenceManager.getPreferenceStore().get(COLUMN_ORDER + this.tableRef, "");
        for (String name : this.getTemplates()) {
            String tokens2 = SheetViewPersistenceManager.getPreferenceStore().get(COLUMN_ORDER + this.tableRef, name);
            if (!tokens1.equals(tokens2)) continue;
            current = name;
            break;
        }
        debug.exit("getCurrentLayout", (Object)current);
        return current;
    }

    public boolean hasTemplatesForExport() {
        return !SheetViewPersistenceManager.getAllTemplates().isEmpty();
    }

    public static Map<String, String> getAllTemplates() {
        debug.enter("getAllTemplates");
        HashMap<String, String> templates = new HashMap<String, String>();
        try {
            String[] stringArray = SheetViewPersistenceManager.getPreferenceStore().keys();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String key_name = stringArray[n2];
                String[] stringArray2 = new String[]{TEMPLATE_COLUMN_WIDTH, TEMPLATE_COLUMN_ORDER, TEMPLATE_FILTER};
                int n3 = stringArray2.length;
                int n4 = 0;
                while (n4 < n3) {
                    String option1 = stringArray2[n4];
                    if (key_name.startsWith(option1)) {
                        templates.put(key_name, SheetViewPersistenceManager.getPreferenceStore().get(key_name, null));
                    }
                    ++n4;
                }
                ++n2;
            }
        }
        catch (BackingStoreException e) {
            debug.error("getAllTemplates", (Throwable)e);
        }
        debug.exit("getAllTemplates");
        return templates;
    }

    public void loadTemplate(String templateName, ColumnDefinition[] columnDefinitions) {
        debug.enter("loadTemplate", (Object)this.tableRef, (Object)templateName);
        String tokens = SheetViewPersistenceManager.getPreferenceStore().get(TEMPLATE_COLUMN_ORDER + this.tableRef + '.' + templateName, "");
        String tokens1 = SheetViewPersistenceManager.getPreferenceStore().get(TEMPLATE_COLUMN_WIDTH + this.tableRef + '.' + templateName, "");
        if (tokens.isEmpty()) {
            tokens = SheetViewPersistenceManager.getPreferenceStore().get(COLUMN_ORDER + this.tableRef, "");
            tokens1 = SheetViewPersistenceManager.getPreferenceStore().get(COLUMN_WIDTH + this.tableRef, "");
        }
        StringTokenizer tokeniser = new StringTokenizer(tokens, ",");
        ArrayList<ColumnDefinition> al1 = new ArrayList<ColumnDefinition>();
        while (tokeniser.hasMoreElements()) {
            ColumnDefinition def = ColumnDefinition.getByDBColumnRef(tokeniser.nextToken());
            al1.add(def);
        }
        tokeniser = new StringTokenizer(tokens1, ",");
        int total = tokeniser.countTokens();
        int[] al2 = new int[Math.max(total, al1.size())];
        int p = 0;
        while (p < al2.length) {
            al2[p] = p < al1.size() ? 70 : -1;
            ++p;
        }
        int currentCounter = 0;
        while (tokeniser.hasMoreElements()) {
            al2[currentCounter] = new Integer(tokeniser.nextToken());
            ++currentCounter;
        }
        this.initialise(al1.toArray(new ColumnDefinition[al1.size()]), al2, columnDefinitions);
        this.flush();
        debug.exit("loadTemplate");
    }

    public void loadPredefinedTemplate(PredefinedTemplate template, ColumnDefinition[] columnDefinitions) {
        debug.enter("loadPredefinedTemplate", (Object)this.tableRef, (Object)template);
        if (template != null) {
            template.intialise(columnDefinitions);
            this.setColumnOrder(template.getOrdering(), columnDefinitions);
            this.setColumnWidths(template.getWidths(), columnDefinitions);
        }
        debug.exit("loadPredefinedTemplate");
    }

    protected void initialise(ColumnDefinition[] definitions, int[] al2, ColumnDefinition[] columnDefinitions) {
        int[][] res = PredefinedTemplate.initialiser(definitions, al2, columnDefinitions);
        int[] modifiedOrdering = res[0];
        int[] modifiedWidths = res[1];
        StringBuffer columns = new StringBuffer();
        StringBuffer widthsBuffer = new StringBuffer();
        int i = 0;
        while (i < modifiedOrdering.length) {
            columns.append(columnDefinitions[modifiedOrdering[i]].getDBColumnRef());
            columns.append(',');
            widthsBuffer.append(modifiedWidths[i]);
            widthsBuffer.append(',');
            ++i;
        }
        SheetViewPersistenceManager.getPreferenceStore().put(COLUMN_ORDER + this.tableRef, columns.toString());
        SheetViewPersistenceManager.getPreferenceStore().put(COLUMN_WIDTH + this.tableRef, widthsBuffer.toString());
    }

    public void setColumnWidth(int position, int width, ColumnDefinition[] defns) {
        debug.enter("setColumnWidth", (Object)this.tableRef, (Object)position, (Object)width);
        int[] widths = this.getColumnWidthsFrom(defns);
        widths[position] = width;
        this.setColumnWidths(widths, defns);
        debug.exit("setColumnWidth");
    }

    public void saveTemplateFilter(String templateName, String filter) {
        if (StringUtil.hasContent((String)filter)) {
            SheetViewPersistenceManager.getPreferenceStore().put(TEMPLATE_FILTER + this.tableRef + '.' + templateName, filter);
        } else {
            SheetViewPersistenceManager.getPreferenceStore().remove(TEMPLATE_FILTER + this.tableRef + '.' + templateName);
        }
        this.flush();
    }

    public String getTemplateFilter(String templateName) {
        return SheetViewPersistenceManager.getPreferenceStore().get(TEMPLATE_FILTER + this.tableRef + '.' + templateName, "");
    }

    public void removeTemplateFilter(String templateName) {
        SheetViewPersistenceManager.getPreferenceStore().remove(TEMPLATE_COLUMN_WIDTH + this.tableRef + '.' + templateName);
        SheetViewPersistenceManager.getPreferenceStore().remove(TEMPLATE_COLUMN_ORDER + this.tableRef + '.' + templateName);
        this.flush();
    }

    public void setLayoutLabel(String label) {
        if (StringUtil.hasContent((String)label)) {
            SheetViewPersistenceManager.getPreferenceStore().put(TEMPLATE_APPLIED + this.tableRef, label);
        } else {
            SheetViewPersistenceManager.getPreferenceStore().remove(TEMPLATE_APPLIED + this.tableRef);
        }
    }

    public String getLayoutLabel() {
        String value = "";
        if (this.tableRef != null && (value = SheetViewPersistenceManager.getPreferenceStore().get(TEMPLATE_APPLIED + this.tableRef, Messages.getString("current.label"))) == null) {
            value = Messages.getString("Unknown");
        }
        return value;
    }
}

