/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.pa.ui.remote;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.dbfunc.DB2Host;
import com.ibm.cics.dbfunc.command.SQLCommand;
import com.ibm.cics.dbfunc.model.ColumnReference;
import com.ibm.cics.dbfunc.model.Selection;
import com.ibm.cics.dbfunc.model.SelectionObject;
import com.ibm.cics.pa.model.definitions.ColumnDefinition;
import com.ibm.cics.pa.ui.remote.ConnectivityToken;
import com.ibm.cics.pa.ui.utilities.DataTypeUtilities;
import com.ibm.cics.pa.ui.utilities.MessagePackage;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DatabaseCommand
extends SQLCommand {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y23 (c) Copyright IBM Corp. 2010, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Logger logger = Logger.getLogger(DatabaseCommand.class.getPackage().getName());
    private boolean buck = true;
    private int overridePageSize;
    private Selection selectionObject;
    private ConnectivityToken token;
    private Map<String, Object> parameterMap;

    public DatabaseCommand(Selection selectionObject, ConnectivityToken token, Map<String, Object> parameterMap, int pageSize) {
        this.connectionCategory = "com.ibm.cics.pa.connection";
        this.selectionObject = selectionObject;
        this.token = token;
        if (!parameterMap.containsKey(":schema")) {
            parameterMap.put(":schema", DB2Host.getDefault((String)"com.ibm.cics.pa.connection").getSchema());
        }
        this.parameterMap = parameterMap;
        this.overridePageSize = pageSize;
    }

    public SelectionObject getSelectionObject() {
        return this.selectionObject;
    }

    public Map<String, Object> getParameterMap() {
        return this.parameterMap;
    }

    public Object processRow(ResultSet resultSet) throws SQLException {
        if (resultSet.isClosed()) {
            Debug.warning((Logger)logger, (String)((Object)((Object)this)).getClass().getName(), (String)"processRow", (Object)"result set is closed, possible disconnection");
            return "";
        }
        if (this.buck) {
            this.token.update(this.getColumnNames(), this.selectionObject.getSelect().getTable());
            this.buck = false;
        }
        Object[] res = new Object[this.token.getHeaders().length];
        int i = 0;
        while (i < this.token.getColumnDefinitions().length) {
            if (ColumnDefinition.UNKNOWN.equals(this.token.getColumnDefinitions()[i])) {
                Debug.warning((Logger)logger, (String)((Object)((Object)this)).getClass().getName(), (String)"processRow", (Object)("Unknown header: " + this.token.getHeaders()[i]));
                try {
                    res[i] = resultSet.getObject(i + 1);
                }
                catch (SQLException e) {
                    logger.logp(Level.SEVERE, ((Object)((Object)this)).getClass().getName(), "processRow", MessagePackage.presentSQLException(e));
                }
            } else {
                try {
                    Object obj = "";
                    if (this.token.getColumnDefinitions()[i] != null) {
                        obj = this.token.getColumnDefinitions()[i].getType() == ColumnReference.DataType.Time ? resultSet.getTime(i + 1) : (this.token.getColumnDefinitions()[i].getType() == ColumnReference.DataType.Timestamp ? resultSet.getTimestamp(i + 1) : (this.token.getColumnDefinitions()[i].getType() == ColumnReference.DataType.Date ? resultSet.getDate(i + 1) : resultSet.getObject(i + 1)));
                        res[i] = DataTypeUtilities.assignAppropriateNonCSVBasedObject(obj, this.token.getColumnDefinitions()[i].getType());
                    } else {
                        res[i] = resultSet.getObject(i + 1);
                    }
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    Debug.error((Logger)logger, (String)((Object)((Object)this)).getClass().getName(), (String)"processRow", (Throwable)e);
                }
                catch (SQLException e) {
                    Debug.error((Logger)logger, (String)((Object)((Object)this)).getClass().getName(), (String)"processRow", (Throwable)e);
                }
            }
            ++i;
        }
        return res.length > 0 ? res : null;
    }

    protected void customiseEngine() {
        this.motor.setNotifyOnCount(true);
        if (this.overridePageSize > 0) {
            this.motor.setPageSize(this.overridePageSize);
        }
    }

    public void setSelectionObject(Selection selectionObject) {
        this.selectionObject = selectionObject;
    }
}

