/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.pa.ui.remote;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.core.connections.ConnectionProfile;
import com.ibm.cics.core.connections.ConnectionsPlugin;
import com.ibm.cics.dbfunc.model.Source;
import com.ibm.cics.pa.model.definitions.ColumnDefinition;
import com.ibm.cics.pa.model.definitions.DataProviderKey;
import com.ibm.cics.pa.ui.PAContextTracker;
import com.ibm.cics.pa.ui.remote.PAConnectionTracker;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.swt.widgets.Display;

public class ConnectivityToken {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y23 (c) Copyright IBM Corp. 2008, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Logger logger = Logger.getLogger("com.ibm.cics.pa.ui");
    private String[] headers = null;
    private ColumnDefinition[] columnDefinitions;
    private DataProviderKey structureKey = null;
    private String connectionId;
    private String connectionName;

    public ConnectivityToken(String id, String name) {
        this.connectionId = id;
        this.connectionName = name;
    }

    public ConnectivityToken(String id, String name, String[] headers, ColumnDefinition[] columnDefinitions, DataProviderKey structureKey) {
        this.connectionId = id;
        this.connectionName = name;
        this.headers = headers;
        this.columnDefinitions = columnDefinitions;
        this.structureKey = structureKey;
    }

    public synchronized ColumnDefinition[] getColumnDefinitions() {
        if (this.columnDefinitions == null) {
            if (this.isCurrentConnection()) {
                this.getThemAll();
            } else {
                this.refreshData();
            }
        }
        return this.columnDefinitions;
    }

    public int getColumnPosition(ColumnDefinition definition) {
        int i = 0;
        while (i < this.getColumnDefinitions().length) {
            if (this.getColumnDefinitions()[i] == definition) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public int[] getColumnPositions(DataProviderKey definition) {
        ColumnDefinition[] definitions = definition.getColumnDefinitions();
        int[] positions = new int[definitions.length];
        int i = 0;
        while (i < positions.length) {
            positions[i] = this.getColumnPosition(definitions[i]);
            ++i;
        }
        return positions;
    }

    public boolean isCurrentConnection() {
        return PAConnectionTracker.getInstance().isConnected(this.connectionId) && PAContextTracker.getInstance().isInitialised();
    }

    public void connect() {
        ConnectivityToken.connect(this.connectionId);
    }

    private static void connect(String ref) {
        if (ref != null) {
            String profileId = null;
            List profiles = ConnectionsPlugin.getDefault().getConnectionManager().getConnectionProfiles("com.ibm.cics.pa.connection.db");
            for (ConnectionProfile profile : profiles) {
                if (!profile.getName().equals(ref)) continue;
                profileId = profile.getId();
            }
            if (profileId != null) {
                ConnectionsPlugin.getDefault().getConnectionService().connectAsync(profileId);
            }
        }
    }

    public String[] getHeaders() {
        if (this.headers == null) {
            if (this.isCurrentConnection()) {
                this.getThemAll();
            } else {
                this.refreshData();
            }
        }
        return this.headers;
    }

    protected void refreshData() {
        Debug.enter((Logger)logger, (String)ConnectivityToken.class.getName(), (String)"refreshData");
        if (Display.getCurrent() != null) {
            Debug.warning((Logger)logger, (String)ConnectivityToken.class.getName(), (String)"refreshData", (Object)("Incorrect thread access in " + this.toString()));
        }
        if (this.isCurrentConnection() || PAConnectionTracker.getInstance().isConnected()) {
            this.getThemAll();
        }
        Debug.exit((Logger)logger, (String)ConnectivityToken.class.getName(), (String)"refreshData");
    }

    public DataProviderKey getStructureKey() {
        if (this.structureKey == null) {
            if (this.isCurrentConnection()) {
                this.getThemAll();
            } else {
                this.refreshData();
            }
        }
        return this.structureKey;
    }

    public String getId() {
        return this.connectionId;
    }

    public String getName() {
        return this.connectionName;
    }

    private void getThemAll() {
        this.headers = PAContextTracker.getInstance().getHeaders();
        this.columnDefinitions = PAContextTracker.getInstance().getColumnDefinitions();
        this.structureKey = PAContextTracker.getInstance().getStructureKey();
    }

    void update(String[] columnNames, Source source) {
        this.headers = new String[columnNames.length];
        String table = null;
        if (source.getLabels().size() == 1) {
            table = (String)source.getLabels().keySet().toArray()[0];
        }
        this.columnDefinitions = new ColumnDefinition[columnNames.length];
        int i = 0;
        while (i < columnNames.length) {
            this.columnDefinitions[i] = ColumnDefinition.getByDBColumnRef(columnNames[i]);
            if (this.columnDefinitions[i] != null) {
                this.headers[i] = this.columnDefinitions[i].getLabel(table);
            } else {
                this.columnDefinitions[i] = ColumnDefinition.UNKNOWN;
                this.headers[i] = columnNames[i];
                logger.log(Level.WARNING, this.getClass().getName(), "update missing header " + this.headers[i]);
            }
            ++i;
        }
        this.structureKey = DataProviderKey.matchOn(columnNames, true);
    }
}

