/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.pa.ui.preferences;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.eclipse.common.ui.TextInput;
import com.ibm.cics.pa.model.definitions.ChartCategorisation;
import com.ibm.cics.pa.ui.Activator;
import com.ibm.cics.pa.ui.Messages;
import java.text.Collator;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.logging.Logger;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.help.IWorkbenchHelpSystem;
import org.eclipse.ui.preferences.ScopedPreferenceStore;

public class Categorizations
extends PreferencePage
implements IWorkbenchPreferencePage {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y23 (c) Copyright IBM Corp. 2008, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    protected static final Logger logger = Logger.getLogger("com.ibm.cics.pa.ui");
    private Text descriptionText;
    CheckboxTableViewer checkboxViewer;

    public Categorizations() {
        this.setPreferenceStore((IPreferenceStore)new ScopedPreferenceStore(InstanceScope.INSTANCE, Activator.getDefault().getBundle().getSymbolicName()));
        this.setDescription(Messages.getString("PAMainPreferencePage.Categorizations_Descriptions"));
    }

    protected Control createContents(Composite parent) {
        Font font = parent.getFont();
        IWorkbenchHelpSystem helpSystem = PlatformUI.getWorkbench().getHelpSystem();
        helpSystem.setHelp((Control)parent, "com.ibm.cics.pa.ui.categorizations_preferences");
        Composite mainComposite = new Composite(parent, 0);
        mainComposite.setLayoutData((Object)new GridData(768));
        mainComposite.setFont(font);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.verticalSpacing = 10;
        mainComposite.setLayout((Layout)layout);
        this.createCategorizationsArea(mainComposite);
        this.createDescriptionArea(mainComposite);
        this.populateCategorizations();
        return mainComposite;
    }

    private void createCategorizationsArea(Composite mainComposite) {
        Font mainFont = mainComposite.getFont();
        Composite categorizationsComposite = new Composite(mainComposite, 0);
        categorizationsComposite.setLayoutData((Object)new GridData(1808));
        GridLayout categorizationsLayout = new GridLayout();
        categorizationsLayout.marginWidth = 0;
        categorizationsLayout.marginHeight = 0;
        categorizationsComposite.setLayout((Layout)categorizationsLayout);
        categorizationsComposite.setFont(mainFont);
        Label categorizationsLabel = new Label(categorizationsComposite, 0);
        categorizationsLabel.setText(Messages.getString("PAMainPreferencePage.Available"));
        categorizationsLabel.setFont(mainFont);
        this.checkboxViewer = CheckboxTableViewer.newCheckList((Composite)categorizationsComposite, (int)2180);
        this.checkboxViewer.getTable().setLayoutData((Object)new GridData(1808));
        this.checkboxViewer.getTable().setFont(categorizationsComposite.getFont());
        this.checkboxViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                return ((ChartCategorisation)((Object)element)).getLabel();
            }
        });
        this.checkboxViewer.getTable().setFont(mainFont);
        this.checkboxViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){
            private final Comparator comparer = new Comparator(){
                private Collator collator = Collator.getInstance();

                public int compare(Object arg0, Object arg1) {
                    String s1 = ((ChartCategorisation)((Object)arg0)).getLabel();
                    String s2 = ((ChartCategorisation)((Object)arg1)).getLabel();
                    return this.collator.compare(s1, s2);
                }
            };

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public Object[] getElements(Object inputElement) {
                Object[] elements = (Object[])inputElement;
                Object[] results = new Object[elements.length];
                System.arraycopy(elements, 0, results, 0, elements.length);
                Collections.sort(Arrays.asList(results), this.comparer);
                return results;
            }
        });
        this.checkboxViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (event.getSelection() instanceof IStructuredSelection) {
                    IStructuredSelection sel = (IStructuredSelection)event.getSelection();
                    ChartCategorisation definition = (ChartCategorisation)((Object)sel.getFirstElement());
                    if (definition == null) {
                        Categorizations.this.clearDescription();
                    } else {
                        Categorizations.this.showDescription(definition);
                    }
                }
            }
        });
        this.checkboxViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                Categorizations.this.checkboxViewer.setSelection((ISelection)new StructuredSelection(event.getElement()));
            }
        });
    }

    private void createDescriptionArea(Composite mainComposite) {
        Font mainFont = mainComposite.getFont();
        Composite textComposite = new Composite(mainComposite, 0);
        textComposite.setLayoutData((Object)new GridData(1808));
        GridLayout textLayout = new GridLayout();
        textLayout.marginWidth = 0;
        textLayout.marginHeight = 0;
        textComposite.setLayout((Layout)textLayout);
        textComposite.setFont(mainFont);
        Label descriptionLabel = new Label(textComposite, 0);
        descriptionLabel.setText(Messages.getString("PAMainPreferencePage.Description"));
        descriptionLabel.setFont(mainFont);
        this.descriptionText = new Text(textComposite, 2378);
        TextInput.setAccessibleLabel((Text)this.descriptionText, (Label)descriptionLabel);
        this.descriptionText.setLayoutData((Object)new GridData(1808));
        this.descriptionText.setFont(mainFont);
    }

    private void populateCategorizations() {
        Object[] definitions = EnumSet.allOf(ChartCategorisation.class).toArray();
        this.checkboxViewer.setInput((Object)definitions);
        int i = 0;
        while (i < definitions.length) {
            this.checkboxViewer.setChecked(definitions[i], this.getPreferenceStore().getBoolean(((ChartCategorisation)((Object)definitions[i])).name()));
            ++i;
        }
    }

    void showDescription(ChartCategorisation definition) {
        if (this.descriptionText == null || this.descriptionText.isDisposed()) {
            return;
        }
        String text = definition.getDescription();
        if (text == null || text.length() == 0) {
            this.descriptionText.setText("");
        } else {
            this.descriptionText.setText(text);
        }
    }

    void clearDescription() {
        if (this.descriptionText == null || this.descriptionText.isDisposed()) {
            return;
        }
        this.descriptionText.setText("");
    }

    protected void performDefaults() {
        Debug.enter((Logger)logger, (String)Categorizations.class.getName(), (String)"performDefaults");
        super.performDefaults();
        for (ChartCategorisation definition : EnumSet.allOf(ChartCategorisation.class)) {
            this.checkboxViewer.setChecked((Object)definition, this.getPreferenceStore().getDefaultBoolean(definition.name()));
        }
    }

    public boolean performOk() {
        Debug.enter((Logger)logger, (String)Categorizations.class.getName(), (String)"performOk");
        for (ChartCategorisation definition : EnumSet.allOf(ChartCategorisation.class)) {
            this.getPreferenceStore().setValue(definition.name(), this.checkboxViewer.getChecked((Object)definition));
        }
        Debug.exit((Logger)logger, (String)Categorizations.class.getName(), (String)"performOk");
        return super.performOk();
    }

    public void init(IWorkbench workbench) {
        for (ChartCategorisation catg : EnumSet.allOf(ChartCategorisation.class)) {
            this.getPreferenceStore().setDefault(catg.name(), true);
        }
    }
}

