/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.pa.ui.model.controller;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.dbfunc.command.Engine;
import com.ibm.cics.dbfunc.command.EngineShell;
import com.ibm.cics.dbfunc.command.RowProcessor;
import com.ibm.cics.dbfunc.model.ColumnReference;
import com.ibm.cics.dbfunc.model.Comparator;
import com.ibm.cics.dbfunc.model.PresentationFactory;
import com.ibm.cics.dbfunc.model.QueryElement;
import com.ibm.cics.dbfunc.model.Selection;
import com.ibm.cics.dbfunc.model.SelectionObject;
import com.ibm.cics.pa.model.DateCaveat;
import com.ibm.cics.pa.model.ManifestRecord;
import com.ibm.cics.pa.model.ProfilerBucket;
import com.ibm.cics.pa.model.ProfilerPairing;
import com.ibm.cics.pa.model.definitions.ColumnDefinition;
import com.ibm.cics.pa.model.definitions.ProfilerLayout;
import com.ibm.cics.pa.ui.Messages;
import com.ibm.cics.pa.ui.PAContextTracker;
import com.ibm.cics.pa.ui.remote.PAConnectionTracker;
import java.sql.ResultSet;
import java.sql.Time;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.IWorkbenchSiteProgressService;

public class ProfileBucketController {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y04 (c) Copyright IBM Corp. 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Debug debug = new Debug(ProfileBucketController.class);
    private static String tableused = "CMFPSUM";
    static ProfileBucketController instance = new ProfileBucketController();

    private ProfileBucketController() {
    }

    public static ProfileBucketController getInstance() {
        return instance;
    }

    public boolean getLaterData(ProfilerBucket existingBucket) {
        return false;
    }

    public boolean getPreviousData(ProfilerBucket existingBucket) {
        return false;
    }

    public ProfilerPairing createPairing(String baseApplid, String baseTransaction, Date baseDate, Time baseTime, String variantApplid, String variantTransaction, Date variantDate, Time variantTime) {
        DateCaveat preDateToken;
        DateCaveat postDateToken = preDateToken = DateCaveat.createSpecificDateCaveat(null, null);
        if (baseDate != null && baseTime != null) {
            preDateToken = DateCaveat.createRangeDateCaveat(null, DateCaveat.join(baseDate, baseTime, null, 1));
            postDateToken = DateCaveat.createRangeDateCaveat(DateCaveat.join(baseDate, baseTime, null, 1), null);
        }
        ProfilerPairing pairing = ProfilerPairing.createProfilePairing(baseApplid, baseTransaction, baseDate, baseTime, variantApplid, variantTransaction, variantDate, variantTime);
        pairing.initialiseStatus();
        Selection selectionObj = PresentationFactory.getInstance().createSelectForTable(new String[]{tableused}, new String[]{":schema"});
        int i = 0;
        while (i < ProfilerLayout.allColumns().length) {
            selectionObj.getSelect().addSelectionColumn(ProfilerLayout.allColumns()[i].getDBColumnRef(), tableused, ProfilerLayout.allColumns()[i].getType(), ColumnReference.Function.NONE);
            ++i;
        }
        selectionObj.appendCondition(ColumnDefinition.APPLID.getDBColumnRef(), tableused, ColumnDefinition.APPLID.getType(), Comparator.EQ, new Object[]{baseApplid}, QueryElement.Predicate.AND, false);
        selectionObj.appendCondition(ColumnDefinition.TRAN.getDBColumnRef(), tableused, ColumnDefinition.TRAN.getType(), Comparator.EQ, new Object[]{baseTransaction}, QueryElement.Predicate.AND, false);
        if (preDateToken.isSpecified()) {
            selectionObj.appendCondition(preDateToken.getConstraint(tableused, PAContextTracker.getInstance().getCurrentManifest().isPerformanceList()), QueryElement.Predicate.AND);
        }
        selectionObj.applyTableMapping(ManifestRecord.getAliasMapping());
        this.runDBQuery("Base Pre", selectionObj, pairing, pairing.getBaseBucket());
        selectionObj = PresentationFactory.getInstance().createSelectForTable(new String[]{tableused}, new String[]{":schema"});
        i = 0;
        while (i < ProfilerLayout.allColumns().length) {
            selectionObj.getSelect().addSelectionColumn(ProfilerLayout.allColumns()[i].getDBColumnRef(), tableused, ProfilerLayout.allColumns()[i].getType(), ColumnReference.Function.NONE);
            ++i;
        }
        selectionObj.appendCondition(ColumnDefinition.APPLID.getDBColumnRef(), tableused, ColumnDefinition.APPLID.getType(), Comparator.EQ, new Object[]{baseApplid}, QueryElement.Predicate.AND, false);
        selectionObj.appendCondition(ColumnDefinition.TRAN.getDBColumnRef(), tableused, ColumnDefinition.TRAN.getType(), Comparator.EQ, new Object[]{baseTransaction}, QueryElement.Predicate.AND, false);
        if (postDateToken.isSpecified()) {
            selectionObj.appendCondition(postDateToken.getConstraint(tableused, PAContextTracker.getInstance().getCurrentManifest().isPerformanceList()), QueryElement.Predicate.AND);
        }
        selectionObj.applyTableMapping(ManifestRecord.getAliasMapping());
        this.runDBQuery("Base Post", selectionObj, pairing, pairing.getBaseBucket());
        if (variantDate != null && variantTime != null) {
            preDateToken = DateCaveat.createRangeDateCaveat(null, DateCaveat.join(variantDate, variantTime, null, 1));
            postDateToken = DateCaveat.createRangeDateCaveat(DateCaveat.join(variantDate, variantTime, null, 1), null);
        }
        selectionObj = PresentationFactory.getInstance().createSelectForTable(new String[]{tableused}, new String[]{":schema"});
        i = 0;
        while (i < ProfilerLayout.allColumns().length) {
            selectionObj.getSelect().addSelectionColumn(ProfilerLayout.allColumns()[i].getDBColumnRef(), tableused, ProfilerLayout.allColumns()[i].getType(), ColumnReference.Function.NONE);
            ++i;
        }
        selectionObj.appendCondition(ColumnDefinition.APPLID.getDBColumnRef(), tableused, ColumnDefinition.APPLID.getType(), Comparator.EQ, new Object[]{variantApplid}, QueryElement.Predicate.AND, false);
        selectionObj.appendCondition(ColumnDefinition.TRAN.getDBColumnRef(), tableused, ColumnDefinition.TRAN.getType(), Comparator.EQ, new Object[]{variantTransaction}, QueryElement.Predicate.AND, false);
        if (preDateToken.isSpecified()) {
            selectionObj.appendCondition(preDateToken.getConstraint(tableused, PAContextTracker.getInstance().getCurrentManifest().isPerformanceList()), QueryElement.Predicate.AND);
        }
        selectionObj.applyTableMapping(ManifestRecord.getAliasMapping());
        this.runDBQuery("Variant Pre", selectionObj, pairing, pairing.getVariantBucket());
        selectionObj = PresentationFactory.getInstance().createSelectForTable(new String[]{tableused}, new String[]{":schema"});
        i = 0;
        while (i < ProfilerLayout.allColumns().length) {
            selectionObj.getSelect().addSelectionColumn(ProfilerLayout.allColumns()[i].getDBColumnRef(), tableused, ProfilerLayout.allColumns()[i].getType(), ColumnReference.Function.NONE);
            ++i;
        }
        selectionObj.appendCondition(ColumnDefinition.APPLID.getDBColumnRef(), tableused, ColumnDefinition.APPLID.getType(), Comparator.EQ, new Object[]{variantApplid}, QueryElement.Predicate.AND, false);
        selectionObj.appendCondition(ColumnDefinition.TRAN.getDBColumnRef(), tableused, ColumnDefinition.TRAN.getType(), Comparator.EQ, new Object[]{variantTransaction}, QueryElement.Predicate.AND, false);
        if (postDateToken.isSpecified()) {
            selectionObj.appendCondition(postDateToken.getConstraint(tableused, PAContextTracker.getInstance().getCurrentManifest().isPerformanceList()), QueryElement.Predicate.AND);
        }
        selectionObj.applyTableMapping(ManifestRecord.getAliasMapping());
        this.runDBQuery("Variant Post", selectionObj, pairing, pairing.getVariantBucket());
        return pairing;
    }

    private String runDBQuery(final String jobString, final Selection selectionObj, final ProfilerPairing pairing, final ProfilerBucket bucket) {
        debug.enter("runDBQuery", (Object)jobString);
        pairing.startStatus(jobString);
        String response = Messages.getString("SheetProxy.Initializing");
        if (PAConnectionTracker.getInstance().isConnected()) {
            Job job = new Job(jobString){

                protected IStatus run(IProgressMonitor monitor) {
                    final Engine engine = new Engine("com.ibm.cics.pa.connection", new RowProcessor(){

                        public Map<String, Object> getParameterMap() {
                            return new HashMap<String, Object>();
                        }

                        public SelectionObject getSelectionObject() {
                            return selectionObj;
                        }

                        public Object processRow(ResultSet resultSet) {
                            return bucket.processRow(resultSet);
                        }
                    });
                    engine.setPageSize(250);
                    engine.addListener(new EngineShell.EngineListener(){
                        private List<Object> res = new ArrayList<Object>();

                        public void dataAvailable(Collection<Object> items) {
                            this.getRes().addAll(items);
                        }

                        public void notifyResultCount(int count) {
                        }

                        public void statusUpdate(EngineShell.EngineStatus es) {
                            switch (es) {
                                case Cancelled: 
                                case Error: {
                                    engine.removeListener((EngineShell.EngineListener)this);
                                    Display.getDefault().asyncExec(new Runnable(){

                                        @Override
                                        public void run() {
                                            pairing.stopStatus(jobString);
                                        }
                                    });
                                    break;
                                }
                                case Paused: 
                                case Complete: {
                                    engine.removeListener((EngineShell.EngineListener)this);
                                    bucket.addAll(this.getRes());
                                    Display.getDefault().asyncExec(new Runnable(){

                                        @Override
                                        public void run() {
                                            pairing.stopStatus(jobString);
                                        }
                                    });
                                    break;
                                }
                            }
                        }

                        public List<Object> getRes() {
                            return this.res;
                        }
                    });
                    engine.setNotifyOnCount(false);
                    engine.start();
                    return Status.OK_STATUS;
                }
            };
            job.setPriority(20);
            IWorkbenchSiteProgressService siteService = (IWorkbenchSiteProgressService)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActivePart().getSite().getAdapter(IWorkbenchSiteProgressService.class);
            siteService.schedule(job, 0L, true);
        } else {
            response = Messages.getString("Resource.status.disconnected");
        }
        debug.exit("runDBQuery", (Object)response);
        return response;
    }
}

