/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.pa.ui.handlers;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.dbfunc.model.Clause;
import com.ibm.cics.dbfunc.model.ColumnReference;
import com.ibm.cics.dbfunc.model.Comparator;
import com.ibm.cics.dbfunc.model.ConstraintElement;
import com.ibm.cics.dbfunc.model.OrderBy;
import com.ibm.cics.dbfunc.model.Presentation;
import com.ibm.cics.dbfunc.model.PresentationFactory;
import com.ibm.cics.dbfunc.model.QueryElement;
import com.ibm.cics.dbfunc.model.Selection;
import com.ibm.cics.eclipse.common.Utilities;
import com.ibm.cics.eclipse.common.historical.IHistoricalApplid;
import com.ibm.cics.eclipse.common.historical.IHistoricalTransaction;
import com.ibm.cics.eclipse.common.historical.IHistoricalTransactionReference;
import com.ibm.cics.pa.comm.PASelectionContext;
import com.ibm.cics.pa.model.CSVDataExtract;
import com.ibm.cics.pa.model.ChartType;
import com.ibm.cics.pa.model.ChartingFile;
import com.ibm.cics.pa.model.DataKeyElement;
import com.ibm.cics.pa.model.DateCaveat;
import com.ibm.cics.pa.model.GenericDataProvider;
import com.ibm.cics.pa.model.IUniqueRecord;
import com.ibm.cics.pa.model.ManifestRecord;
import com.ibm.cics.pa.model.NullRangeDateCaveat;
import com.ibm.cics.pa.model.SpecificRowsFilter;
import com.ibm.cics.pa.model.TreeElement;
import com.ibm.cics.pa.model.definitions.AbstractChartDefinition;
import com.ibm.cics.pa.model.definitions.ChartSpecification;
import com.ibm.cics.pa.model.definitions.ColumnDefinition;
import com.ibm.cics.pa.model.definitions.DataProviderKey;
import com.ibm.cics.pa.ui.ChartManager;
import com.ibm.cics.pa.ui.Messages;
import com.ibm.cics.pa.ui.PAContextTracker;
import com.ibm.cics.pa.ui.QueryCache;
import com.ibm.cics.pa.ui.dialogs.TimelineAssistDialog;
import com.ibm.cics.pa.ui.figures.ChartSelectable;
import com.ibm.cics.pa.ui.handlers.CommonHandler;
import com.ibm.cics.pa.ui.remote.RemoteEditorInput;
import com.ibm.cics.pa.ui.utilities.DataTypeUtilities;
import com.ibm.cics.pa.ui.views.ChartView;
import com.ibm.cics.pa.ui.views.Overview;
import com.ibm.cics.pa.ui.views.SheetView;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.navigator.CommonNavigator;
import org.eclipse.ui.progress.IWorkbenchSiteProgressService;

public class VisualizationHandler
extends CommonHandler {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y23 (c) Copyright IBM Corp. 2008, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public Object execute(ExecutionEvent event) throws ExecutionException {
        Debug.enter((Logger)logger, (String)VisualizationHandler.class.getName(), (String)"execute");
        String resId = null;
        String chart = event.getParameter("com.ibm.cics.pa.ui.commandMenu");
        Presentation presentation = QueryCache.getInstance().getAppropriatePresentation(chart, null);
        boolean selectAll = new Boolean(event.getParameter("com.ibm.cics.pa.ui.commandSelectAll"));
        StructuredSelection selected = (StructuredSelection)HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        ChartSpecification chartReference = AbstractChartDefinition.getByName(chart);
        IWorkbenchPart part = HandlerUtil.getActivePart((ExecutionEvent)event);
        if (chart != null) {
            if (part instanceof SheetView) {
                DataProviderKey key = ((SheetView)part).getDataProvider().getDataProviderKey();
                if (key == DataProviderKey.STARTTIME_APPLID_TRAN) {
                    Debug.event((Logger)logger, (String)VisualizationHandler.class.getName(), (String)"execute", (Object)"instanceof SheetEditor");
                    GenericDataProvider provider1 = ((SheetView)part).getDataProvider();
                    ArrayList records1 = new ArrayList(selected.toList());
                    resId = this.priorPopulated(part, records1.toArray(new IUniqueRecord[records1.size()]), chartReference, provider1, selectAll);
                } else if (key.contains(ColumnDefinition.START_DATE) && key.contains(ColumnDefinition.START_TIME) && key.contains(ColumnDefinition.APPLID)) {
                    HashMap<String, Object> parameterMap1 = new HashMap<String, Object>();
                    Map requiredDefinitions = presentation.getInputColumns();
                    if (selected != null && !selected.isEmpty() && selected.getFirstElement() instanceof IUniqueRecord) {
                        Object[] input = selected.toArray();
                        int j = 0;
                        while (j < input.length) {
                            ColumnDefinition[] definitions = ((IUniqueRecord)input[j]).getSourceProvider().getColumnDefinitions();
                            Object[] row = ((IUniqueRecord)input[j]).getRow();
                            for (ColumnReference column : requiredDefinitions.keySet()) {
                                int i = 0;
                                while (i < definitions.length) {
                                    if (column.getColumnName().equals(definitions[i].getDBColumnRef())) {
                                        String parmKey = (String)requiredDefinitions.get(column);
                                        if (selected.size() > 1) {
                                            if (j == 0) {
                                                parameterMap1.put(parmKey, row[i]);
                                            }
                                            parmKey = String.valueOf(parmKey) + j;
                                        }
                                        parameterMap1.put(parmKey, row[i]);
                                    }
                                    ++i;
                                }
                            }
                            ++j;
                        }
                    }
                    boolean noTran = true;
                    for (String key1 : parameterMap1.keySet()) {
                        if (!key1.startsWith(String.valueOf(':') + ColumnDefinition.TRAN.getDBColumnRef())) continue;
                        noTran = false;
                        if (!((String)parameterMap1.get(key1)).startsWith(":")) continue;
                        parameterMap1.put(key1, "*");
                    }
                    if (noTran) {
                        parameterMap1.put(String.valueOf(':') + ColumnDefinition.TRAN.getDBColumnRef(), "*");
                    }
                    this.dbQuery(part, presentation.getSelection(), DataTypeUtilities.interpretSummaryDetails(parameterMap1, null), parameterMap1, chartReference, ManifestRecord.getAlias("CMFPSUM").getDescription(), ManifestRecord.getAlias("CMFPSUM"));
                }
            } else if (part instanceof ChartView) {
                Debug.event((Logger)logger, (String)VisualizationHandler.class.getName(), (String)"execute", (Object)"instanceof ChartView");
                GenericDataProvider provider1 = ((ChartView)part).getDataProvider();
                ArrayList<IUniqueRecord> records1 = new ArrayList<IUniqueRecord>(selected.toList());
                for (Object chartElement : selected.toList()) {
                    if (chartElement instanceof IUniqueRecord) {
                        records1.add((IUniqueRecord)chartElement);
                        continue;
                    }
                    if (!(chartElement instanceof ChartSelectable)) continue;
                    records1.add(((ChartSelectable)((Object)chartElement)).getUniqueRecord());
                }
                resId = this.priorPopulated(part, records1.toArray(new IUniqueRecord[records1.size()]), chartReference, provider1, selectAll);
            } else if (part instanceof CommonNavigator) {
                Debug.event((Logger)logger, (String)VisualizationHandler.class.getName(), (String)"execute", (Object)"instanceof CommonNavigator");
                TreeSelection selection = (TreeSelection)((CommonNavigator)part).getCommonViewer().getSelection();
                if (selection.getFirstElement() instanceof TreeElement) {
                    TreeElement element = (TreeElement)selection.getFirstElement();
                    GenericDataProvider provider1 = ChartingFile.adaptFor(element.getSourceProvider(), (StructuredSelection)selection, chartReference);
                    resId = this.priorPopulated(part, null, chartReference, provider1, true);
                }
            } else if (part instanceof Overview) {
                Debug.event((Logger)logger, (String)VisualizationHandler.class.getName(), (String)"execute", (Object)"instanceof Overview");
                PASelectionContext context = (PASelectionContext)((Overview)part).getCurrentContext();
                String performTable = PAContextTracker.getInstance().getPerformanceTableReference();
                if (Utilities.hasContent((String)performTable)) {
                    OrderBy order;
                    Selection selection = context.getSummarySelection(PAContextTracker.getInstance().getPerformanceTableReference());
                    if (presentation != null && (order = presentation.getSelection().getOrderBy()) != null) {
                        for (ColumnReference column : order.getColumns()) {
                            selection.addOrderByCondition(column.getColumnName(), column.getTable(), column.getDirection());
                        }
                    }
                    selection.applyTableMapping(ManifestRecord.getAliasMapping());
                    this.dbQuery(part, selection, context.getContentDescriptionLabel(), new HashMap<String, Object>(), chartReference, ManifestRecord.getAlias("CMFPSUM").getDescription(), ManifestRecord.getAlias("CMFPSUM"));
                }
            } else {
                Debug.event((Logger)logger, (String)VisualizationHandler.class.getName(), (String)"execute", (Object)"instanceof ChartEditor", (Object)part);
                this.outsidersTranJob(part, event, chartReference);
            }
        }
        Debug.exit((Logger)logger, (String)VisualizationHandler.class.getName(), (String)"execute", resId);
        return resId;
    }

    String display(IWorkbenchPart part, ChartType type, String id) {
        if (id.length() > 0) {
            try {
                switch (type) {
                    case HISTOGRAM: 
                    case COMBINEDHISTOGRAMLINE: 
                    case COMPACT_HISTOGRAM: {
                        IViewPart view = part.getSite().getPage().showView("com.ibm.cics.pa.ui.charteditor", id, 2);
                        part.getSite().getPage().bringToTop((IWorkbenchPart)view);
                        break;
                    }
                    case PIE: {
                        IViewPart view = part.getSite().getPage().showView("com.ibm.cics.pa.ui.pie_editor", id, 2);
                        part.getSite().getPage().bringToTop((IWorkbenchPart)view);
                    }
                }
            }
            catch (PartInitException ex) {
                logger.logp(Level.SEVERE, VisualizationHandler.class.getName(), "display", "unable to open editor", ex);
            }
        } else {
            logger.logp(Level.SEVERE, VisualizationHandler.class.getName(), "display", "unable to open editor the id was not provided");
        }
        return id;
    }

    private void outsidersTranJob(final IWorkbenchPart part, ExecutionEvent event, final ChartSpecification chartReference) {
        TimelineAssistDialog dialog = TimelineAssistDialog.getInstance();
        String table = PAContextTracker.getInstance().getPerformanceTableReference();
        final Selection selection = PresentationFactory.getInstance().createSelectAllForTable(table, ":schema");
        StructuredSelection currentSelection = (StructuredSelection)HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (currentSelection.isEmpty()) {
            return;
        }
        ArrayList<String> applids = new ArrayList<String>();
        ArrayList<String> resources = new ArrayList<String>();
        Iterator iterator = currentSelection.iterator();
        DateCaveat caveat = null;
        boolean specificDateCaveats = false;
        String description = "";
        while (iterator.hasNext()) {
            DataKeyElement key;
            Clause constraint;
            IHistoricalTransaction record;
            Object selectedObject = iterator.next();
            if (Platform.getAdapterManager().hasAdapter(selectedObject, IHistoricalTransaction.class.getName()) && (IHistoricalTransaction)Platform.getAdapterManager().getAdapter(selectedObject, IHistoricalTransaction.class) != null) {
                record = (IHistoricalTransaction)Platform.getAdapterManager().getAdapter(selectedObject, IHistoricalTransaction.class);
                if (description.length() > 0) {
                    description = String.valueOf(description) + " || ";
                }
                constraint = PresentationFactory.getInstance().createSimpleCondition(ColumnDefinition.APPLID.getDBColumnRef(), table, ColumnReference.DataType.String, Comparator.EQ, new Object[]{record.getApplid()}, false);
                description = String.valueOf(description) + ColumnDefinition.APPLID.getLabel(null) + '=' + record.getApplid();
                constraint = constraint.appendCondition(ColumnDefinition.TRAN.getDBColumnRef(), table, ColumnReference.DataType.String, Comparator.EQ, new Object[]{record.getTransactionName()}, QueryElement.Predicate.AND, false);
                description = String.valueOf(description) + " " + ColumnDefinition.TRAN.getLabel(null) + '=' + record.getTransactionName();
                if (selectedObject instanceof IUniqueRecord && (key = ((IUniqueRecord)selectedObject).getDataKey()) != null) {
                    specificDateCaveats = true;
                    caveat = DateCaveat.createSpecificDateCaveat(key.getACombinedDateReference());
                    constraint = constraint.appendCondition(caveat.getConstraint(null, false), QueryElement.Predicate.AND);
                    description = String.valueOf(description) + " " + caveat.getLabel();
                }
                selection.appendCondition((ConstraintElement)constraint, QueryElement.Predicate.OR);
                applids.add(record.getApplid());
                resources.add(record.getTransactionName());
                continue;
            }
            if (Platform.getAdapterManager().hasAdapter(selectedObject, IHistoricalTransactionReference.class.getName()) && (IHistoricalTransactionReference)Platform.getAdapterManager().getAdapter(selectedObject, IHistoricalTransactionReference.class) != null) {
                record = (IHistoricalTransactionReference)Platform.getAdapterManager().getAdapter(selectedObject, IHistoricalTransactionReference.class);
                constraint = PresentationFactory.getInstance().createSimpleCondition(ColumnDefinition.TRAN.getDBColumnRef(), table, ColumnReference.DataType.String, Comparator.EQ, new Object[]{record.getTransactionName()}, false);
                if (selectedObject instanceof IUniqueRecord && (key = ((IUniqueRecord)selectedObject).getDataKey()) != null) {
                    specificDateCaveats = true;
                    caveat = DateCaveat.createSpecificDateCaveat(key.getACombinedDateReference());
                    constraint.appendCondition(caveat.getConstraint(null, false), QueryElement.Predicate.AND);
                }
                selection.appendCondition((ConstraintElement)constraint, QueryElement.Predicate.OR);
                applids.add(record.getTransactionName());
                continue;
            }
            if (!Platform.getAdapterManager().hasAdapter(selectedObject, IHistoricalApplid.class.getName()) || (IHistoricalApplid)Platform.getAdapterManager().getAdapter(selectedObject, IHistoricalApplid.class) == null) continue;
            record = (IHistoricalApplid)Platform.getAdapterManager().getAdapter(selectedObject, IHistoricalApplid.class);
            constraint = PresentationFactory.getInstance().createSimpleCondition(ColumnDefinition.APPLID.getDBColumnRef(), table, ColumnReference.DataType.String, Comparator.EQ, new Object[]{record.getApplid()}, false);
            if (selectedObject instanceof IUniqueRecord && (key = ((IUniqueRecord)selectedObject).getDataKey()) != null) {
                specificDateCaveats = true;
                caveat = DateCaveat.createSpecificDateCaveat(key.getACombinedDateReference());
                constraint.appendCondition(caveat.getConstraint(null, false), QueryElement.Predicate.AND);
            }
            selection.appendCondition((ConstraintElement)constraint, QueryElement.Predicate.AND);
            applids.add(record.getApplid());
        }
        if (!specificDateCaveats) {
            if (caveat == null) {
                caveat = dialog.getDateCaveat();
                caveat = dialog.checkTransientDateDialog();
            }
            if (caveat != null && !(caveat instanceof NullRangeDateCaveat)) {
                selection.appendCondition(caveat.getConstraint(null, false), QueryElement.Predicate.AND);
            }
        }
        selection.applyTableMapping(ManifestRecord.getAliasMapping());
        final String desc = description.length() > 150 ? description.substring(0, 150) : description;
        Job job = new Job(Messages.getString("Locating.records")){

            protected IStatus run(IProgressMonitor monitor) {
                VisualizationHandler.this.dbQuery(part, selection, desc, new HashMap<String, Object>(), chartReference, null, ManifestRecord.getAlias("CMFPSUM"));
                return Status.OK_STATUS;
            }
        };
        job.setPriority(40);
        IWorkbenchSiteProgressService siteService = (IWorkbenchSiteProgressService)part.getSite().getAdapter(IWorkbenchSiteProgressService.class);
        siteService.schedule(job, 0L, true);
    }

    protected String priorPopulated(final IWorkbenchPart part, final IUniqueRecord[] records, final ChartSpecification chartReference, final GenericDataProvider dataMinor, final boolean selectAll) {
        Job job = new Job(Messages.getString("Locating.records")){

            protected IStatus run(final IProgressMonitor monitor) {
                GenericDataProvider dataStore = null;
                if (selectAll && chartReference.getType() != ChartType.COMBINEDHISTOGRAMLINE) {
                    dataStore = dataMinor;
                    dataStore.incrementUseCount();
                } else if (dataMinor.isRemote()) {
                    dataStore = RemoteEditorInput.createAlreadyPopulated(dataMinor, new StructuredSelection((Object[])records), chartReference);
                } else {
                    SpecificRowsFilter filter = SpecificRowsFilter.specificFilterFor(dataMinor, records);
                    dataStore = CSVDataExtract.getFor(dataMinor.getRootSource(), filter);
                }
                if (monitor != null && monitor.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
                final GenericDataProvider ds = dataStore;
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        String id = ChartManager.getInstance().createChart(chartReference, ds, null, null, monitor);
                        VisualizationHandler.this.display(part, chartReference.getType(), id);
                    }
                });
                return Status.OK_STATUS;
            }
        };
        job.setPriority(20);
        IWorkbenchSiteProgressService siteService = (IWorkbenchSiteProgressService)part.getSite().getAdapter(IWorkbenchSiteProgressService.class);
        siteService.schedule(job, 0L, true);
        return "";
    }
}

