/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.pa.ui.handlers;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.dbfunc.model.ColumnReference;
import com.ibm.cics.dbfunc.model.Comparator;
import com.ibm.cics.dbfunc.model.PresentationFactory;
import com.ibm.cics.dbfunc.model.QueryElement;
import com.ibm.cics.dbfunc.model.Selection;
import com.ibm.cics.pa.model.AlertElement;
import com.ibm.cics.pa.model.DateCaveat;
import com.ibm.cics.pa.model.IUniqueRecord;
import com.ibm.cics.pa.model.ManifestRecord;
import com.ibm.cics.pa.model.definitions.AppliedLayouts;
import com.ibm.cics.pa.model.definitions.ColumnDefinition;
import com.ibm.cics.pa.model.definitions.DataProviderKey;
import com.ibm.cics.pa.model.definitions.PerformanceListRecordDefinition;
import com.ibm.cics.pa.ui.handlers.CommonHandler;
import com.ibm.cics.pa.ui.handlers.IntervalTracker;
import com.ibm.cics.pa.ui.utilities.DataTypeUtilities;
import com.ibm.cics.pa.ui.utilities.PredefinedTemplate;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.handlers.HandlerUtil;

public class PerformanceRecordHandler
extends CommonHandler {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y23 (c) Copyright IBM Corp. 2013, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Debug debug = new Debug(IntervalTracker.class);

    public Object execute(ExecutionEvent event) throws ExecutionException {
        debug.enter("execute");
        IWorkbenchPart part = HandlerUtil.getActivePart((ExecutionEvent)event);
        StructuredSelection selected = (StructuredSelection)HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (selected.getFirstElement() instanceof AlertElement) {
            AlertElement element = (AlertElement)selected.getFirstElement();
            Selection sel = element.getSelection();
            String tabLabel = "";
            ManifestRecord rec = ManifestRecord.getAlias(element.getTableAlias());
            if (rec != null) {
                tabLabel = element.getLabel(ColumnDefinition.START);
            }
            if (sel != null) {
                sel.applyTableMapping(ManifestRecord.getAliasMapping());
                Map<String, Object> mapping = element.getRunableMapping();
                DateCaveat dateCaveat = null;
                String contentDescription = DataTypeUtilities.interpretStatsElement(mapping, dateCaveat, Arrays.asList(String.valueOf(':') + ColumnDefinition.TASKNO.getDBColumnRef()));
                String layout = element.getLabel(ColumnDefinition.ALT_FIELD_NAME);
                PredefinedTemplate template = AppliedLayouts.identifyLayout(layout);
                this.dbQuery(part, sel, contentDescription, mapping, PerformanceListRecordDefinition.createFor(template, element), tabLabel, rec);
            }
        } else if (selected.getFirstElement() instanceof IUniqueRecord && ((IUniqueRecord)selected.getFirstElement()).getSourceProvider().getDataProviderKey() == DataProviderKey.PERFORMANCE_LIST) {
            IUniqueRecord record = (IUniqueRecord)selected.getFirstElement();
            Map<ColumnDefinition, Object> initMap = record.getCompleteMapping(false);
            LinkedHashMap<String, Object> mapping = new LinkedHashMap<String, Object>();
            mapping.put(String.valueOf(':') + ColumnDefinition.START.getDBColumnRef(), initMap.get(ColumnDefinition.START));
            mapping.put(String.valueOf(':') + ColumnDefinition.STOP.getDBColumnRef(), initMap.get(ColumnDefinition.STOP));
            mapping.put(String.valueOf(':') + ColumnDefinition.APPLID.getDBColumnRef(), initMap.get(ColumnDefinition.APPLID));
            mapping.put(String.valueOf(':') + ColumnDefinition.TRAN.getDBColumnRef(), initMap.get(ColumnDefinition.TRAN));
            mapping.put(String.valueOf(':') + ColumnDefinition.TASKNO.getDBColumnRef(), initMap.get(ColumnDefinition.TASKNO));
            String contentDescription = DataTypeUtilities.interpretStatsElement(mapping, null, Arrays.asList(String.valueOf(':') + ColumnDefinition.TASKNO.getDBColumnRef()));
            Selection sel = this.getSelection();
            String tabLabel = "";
            ManifestRecord rec = ManifestRecord.getAlias("CMFPLST");
            if (rec != null) {
                tabLabel = DataTypeUtilities.getAsString(mapping.get(ColumnDefinition.START));
            }
            if (sel != null) {
                sel.applyTableMapping(ManifestRecord.getAliasMapping());
                PredefinedTemplate template = PredefinedTemplate.List_Response_time_analysis;
                this.dbQuery(part, sel, contentDescription, mapping, PerformanceListRecordDefinition.createFor(template, null), tabLabel, rec);
            }
        }
        debug.exit("execute");
        return null;
    }

    private Selection getSelection() {
        Selection selection = null;
        ManifestRecord record = ManifestRecord.getAlias("CMFPLST");
        if (record != null) {
            selection = PresentationFactory.getInstance().createSelectAllForTable("CMFPLST", null);
            selection.appendCondition(ColumnDefinition.START.getDBColumnRef(), "CMFPLST", ColumnReference.DataType.Timestamp, Comparator.EQ, new Object[]{String.valueOf(':') + ColumnDefinition.START.getDBColumnRef()}, QueryElement.Predicate.AND, false);
            selection.appendCondition(ColumnDefinition.STOP.getDBColumnRef(), "CMFPLST", ColumnReference.DataType.Timestamp, Comparator.EQ, new Object[]{String.valueOf(':') + ColumnDefinition.STOP.getDBColumnRef()}, QueryElement.Predicate.AND, false);
            selection.appendCondition(ColumnDefinition.APPLID.getDBColumnRef(), "CMFPLST", ColumnReference.DataType.String, Comparator.EQ, new Object[]{String.valueOf(':') + ColumnDefinition.APPLID.getDBColumnRef()}, QueryElement.Predicate.AND, false);
            selection.appendCondition(ColumnDefinition.TRAN.getDBColumnRef(), "CMFPLST", ColumnReference.DataType.String, Comparator.EQ, new Object[]{String.valueOf(':') + ColumnDefinition.TRAN.getDBColumnRef()}, QueryElement.Predicate.AND, false);
            selection.appendCondition(ColumnDefinition.TASKNO.getDBColumnRef(), "CMFPLST", ColumnReference.DataType.Integer, Comparator.EQ, new Object[]{String.valueOf(':') + ColumnDefinition.TASKNO.getDBColumnRef()}, QueryElement.Predicate.AND, false);
        }
        return selection;
    }
}

