/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.pa.ui.handlers;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.pa.model.definitions.ColumnDefinition;
import com.ibm.cics.pa.model.definitions.ReportStyle;
import com.ibm.cics.pa.model.definitions.TableCategorisationEnum;
import com.ibm.cics.pa.ui.Activator;
import com.ibm.cics.pa.ui.Messages;
import com.ibm.cics.pa.ui.handlers.CommonHandler;
import com.ibm.cics.pa.ui.utilities.DataTypeUtilities;
import com.ibm.cics.pa.ui.views.ReportList;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.logging.Logger;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.CheckedTreeSelectionDialog;
import org.eclipse.ui.dialogs.ListSelectionDialog;
import org.eclipse.ui.handlers.HandlerUtil;

public class LinkMenuHandler
extends CommonHandler {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y23 (c) Copyright IBM Corp. 2010, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Logger logger = Logger.getLogger(LinkMenuHandler.class.getPackage().getName());
    private static final String prefCat = "CategoryLimited.";
    private static final String prefType = "TypeLimited.";
    private static final String prefCol = "ColumnLimited.";
    ReportStyle[] types = new ReportStyle[]{ReportStyle.Ranging, ReportStyle.StatsLink, ReportStyle.Timeline, ReportStyle.Detail};

    public Object execute(ExecutionEvent event) throws ExecutionException {
        ReportList part = (ReportList)HandlerUtil.getActivePart((ExecutionEvent)event);
        Debug.enter((Logger)logger, (String)LinkMenuHandler.class.getName(), (String)"execute");
        MenuItem item = (MenuItem)((Event)event.getTrigger()).widget;
        ContributionItem data = (ContributionItem)item.getData();
        if (data.getId().equals("com.ibm.cics.pa.ui.hidecat")) {
            CheckedTreeSelectionDialog dialog = new CheckedTreeSelectionDialog(HandlerUtil.getActiveShell((ExecutionEvent)event), new ILabelProvider(){

                public Image getImage(Object element) {
                    return null;
                }

                public String getText(Object element) {
                    return element instanceof TableCategorisationEnum ? ((TableCategorisationEnum)((Object)element)).getLabel() : (String)element;
                }

                public void addListener(ILabelProviderListener listener) {
                }

                public void dispose() {
                }

                public boolean isLabelProperty(Object element, String property) {
                    return false;
                }

                public void removeListener(ILabelProviderListener listener) {
                }
            }, new ITreeContentProvider(){

                public Object[] getChildren(Object parentElement) {
                    ArrayList<TableCategorisationEnum> childElements = new ArrayList<TableCategorisationEnum>();
                    if (parentElement instanceof TableCategorisationEnum) {
                        Object[] objectArray = ((TableCategorisationEnum)((Object)parentElement)).getChildren();
                        int n = objectArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Object child = objectArray[n2];
                            if (child instanceof TableCategorisationEnum) {
                                childElements.add((TableCategorisationEnum)((Object)child));
                            }
                            ++n2;
                        }
                    }
                    return childElements.toArray();
                }

                public Object getParent(Object element) {
                    return null;
                }

                public boolean hasChildren(Object element) {
                    return element instanceof TableCategorisationEnum && (element == TableCategorisationEnum.Regions || element == TableCategorisationEnum.Root || element == TableCategorisationEnum.Server);
                }

                public Object[] getElements(Object inputElement) {
                    return ((TableCategorisationEnum)((Object)inputElement)).getChildren();
                }

                public void dispose() {
                }

                public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
                }
            }){

                public void create() {
                    super.create();
                    this.getTreeViewer().setCheckedElements(this.getInitialElementSelections().toArray());
                }
            };
            ArrayList<TableCategorisationEnum> selectedElements = new ArrayList<TableCategorisationEnum>();
            for (Object e : EnumSet.complementOf(EnumSet.of(TableCategorisationEnum.Root, TableCategorisationEnum.Regions, TableCategorisationEnum.Server))) {
                if (!Platform.getPreferencesService().getBoolean(Activator.getDefault().getBundle().getSymbolicName(), prefCat + ((TableCategorisationEnum)((Object)e)).getId(), true, null)) continue;
                selectedElements.add((TableCategorisationEnum)((Object)e));
            }
            dialog.setContainerMode(true);
            dialog.setHelpAvailable(true);
            dialog.setExpandedElements(new Object[]{TableCategorisationEnum.Regions, TableCategorisationEnum.Server});
            dialog.setTitle(Messages.getString("Inquiries.StatsCat"));
            dialog.setMessage(Messages.getString("Inquiries.StatsCatTooltip"));
            dialog.setInput((Object)TableCategorisationEnum.Root);
            dialog.setInitialElementSelections(selectedElements);
            dialog.create();
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)dialog.getShell(), "com.ibm.cics.pa.ui.hidecat");
            if (dialog.open() == 0) {
                for (Object e : EnumSet.complementOf(EnumSet.of(TableCategorisationEnum.Root))) {
                    Activator.getDefault().getPluginInstancePreferences().putBoolean(prefCat + ((TableCategorisationEnum)((Object)e)).getId(), false);
                }
                Object[] objectArray = dialog.getResult();
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object object = objectArray[n2];
                    Activator.getDefault().getPluginInstancePreferences().putBoolean(prefCat + ((TableCategorisationEnum)((Object)object)).getId(), true);
                    ++n2;
                }
                part.reassess();
            }
        } else if (data.getId().equals("com.ibm.cics.pa.ui.hidelim")) {
            ListSelectionDialog dialog = new ListSelectionDialog(HandlerUtil.getActiveShell((ExecutionEvent)event), (Object)this.types, new IStructuredContentProvider(){

                public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
                }

                public void dispose() {
                }

                public Object[] getElements(Object inputElement) {
                    return LinkMenuHandler.this.types;
                }
            }, new ILabelProvider(){

                public void removeListener(ILabelProviderListener listener) {
                }

                public boolean isLabelProperty(Object element, String property) {
                    return false;
                }

                public void dispose() {
                }

                public void addListener(ILabelProviderListener listener) {
                }

                public String getText(Object element) {
                    if (element instanceof ReportStyle) {
                        return ((ReportStyle)((Object)element)).getText();
                    }
                    return null;
                }

                public Image getImage(Object element) {
                    return null;
                }
            }, Messages.getString("Inquiries.Type.Tooltip"));
            ArrayList<ReportStyle> styleList = new ArrayList<ReportStyle>();
            Object[] objectArray = this.types;
            int n = this.types.length;
            int n3 = 0;
            while (n3 < n) {
                ReportStyle reportStyle = objectArray[n3];
                if (Platform.getPreferencesService().getBoolean(Activator.getDefault().getBundle().getSymbolicName(), prefType + reportStyle.name(), true, null)) {
                    styleList.add(reportStyle);
                }
                ++n3;
            }
            dialog.setInitialSelections(styleList.toArray());
            dialog.setHelpAvailable(true);
            dialog.setTitle(Messages.getString("Inquiries.Type"));
            dialog.create();
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)dialog.getShell(), "com.ibm.cics.pa.ui.hidelim");
            if (dialog.open() == 0) {
                objectArray = this.types;
                n = this.types.length;
                n3 = 0;
                while (n3 < n) {
                    ReportStyle reportStyle = objectArray[n3];
                    Activator.getDefault().getPluginInstancePreferences().putBoolean(prefType + reportStyle.name(), false);
                    ++n3;
                }
                objectArray = dialog.getResult();
                n = objectArray.length;
                n3 = 0;
                while (n3 < n) {
                    ReportStyle reportStyle = objectArray[n3];
                    if (reportStyle instanceof ReportStyle) {
                        Activator.getDefault().getPluginInstancePreferences().putBoolean(prefType + reportStyle.name(), true);
                    }
                    ++n3;
                }
                part.reassess();
            }
        } else if (data.getId().equals("com.ibm.cics.pa.ui.hideres")) {
            ListSelectionDialog dialog = new ListSelectionDialog(HandlerUtil.getActiveShell((ExecutionEvent)event), (Object)this.types, new IStructuredContentProvider(){

                public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
                }

                public void dispose() {
                }

                public Object[] getElements(Object inputElement) {
                    return DataTypeUtilities.significantColumns;
                }
            }, new ILabelProvider(){

                public void removeListener(ILabelProviderListener listener) {
                }

                public boolean isLabelProperty(Object element, String property) {
                    return false;
                }

                public void dispose() {
                }

                public void addListener(ILabelProviderListener listener) {
                }

                public String getText(Object element) {
                    if (element instanceof ColumnDefinition) {
                        return String.valueOf(((ColumnDefinition)element).getLabel(null)) + " (" + ((ColumnDefinition)element).getDBColumnRef() + ')';
                    }
                    return null;
                }

                public Image getImage(Object element) {
                    return null;
                }
            }, Messages.getString("Inquiries.resourcefilter.tooltip"));
            ArrayList<ColumnDefinition> limitList = new ArrayList<ColumnDefinition>();
            Object[] objectArray = DataTypeUtilities.significantColumns;
            int n = DataTypeUtilities.significantColumns.length;
            int n4 = 0;
            while (n4 < n) {
                ColumnDefinition columnDefinition = objectArray[n4];
                if (Platform.getPreferencesService().getBoolean(Activator.getDefault().getBundle().getSymbolicName(), prefCol + columnDefinition.getDBColumnRef(), true, null)) {
                    limitList.add(columnDefinition);
                }
                ++n4;
            }
            dialog.setInitialSelections(limitList.toArray());
            dialog.setHelpAvailable(true);
            dialog.setTitle(Messages.getString("Inquiries.resourcefilter"));
            dialog.create();
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)dialog.getShell(), "com.ibm.cics.pa.ui.hideres");
            if (dialog.open() == 0) {
                objectArray = DataTypeUtilities.significantColumns;
                n = DataTypeUtilities.significantColumns.length;
                n4 = 0;
                while (n4 < n) {
                    ColumnDefinition columnDefinition = objectArray[n4];
                    Activator.getDefault().getPluginInstancePreferences().putBoolean(prefCol + columnDefinition.getDBColumnRef(), false);
                    ++n4;
                }
                objectArray = dialog.getResult();
                n = objectArray.length;
                n4 = 0;
                while (n4 < n) {
                    Object object = objectArray[n4];
                    if (object instanceof ColumnDefinition) {
                        Activator.getDefault().getPluginInstancePreferences().putBoolean(prefCol + ((ColumnDefinition)object).getDBColumnRef(), true);
                    }
                    ++n4;
                }
                part.reassess();
            }
        }
        Debug.exit((Logger)logger, (String)LinkMenuHandler.class.getName(), (String)"execute");
        return null;
    }
}

