/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.pa.ui.figures;

import com.ibm.cics.pa.ui.Messages;
import com.ibm.cics.pa.ui.figures.CommonHistogram;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.ButtonBorder;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.SchemeBorder;
import org.eclipse.draw2d.ScrollBar;
import org.eclipse.ui.part.EditorPart;

public class ZoomBar
extends Figure {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y23 (c) Copyright IBM Corp. 2008, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    final ScrollBar bar = new ScrollBar();
    private final Label label = new Label(Messages.getString("ZoomBar.Zoom"));

    public ZoomBar(EditorPart chartEditor, final CommonHistogram figure) {
        this.label.setBorder((Border)new SchemeBorder((SchemeBorder.Scheme)ButtonBorder.SCHEMES.BUTTON_SCROLLBAR));
        this.bar.setHorizontal(false);
        this.bar.setMaximum(50);
        this.bar.setMinimum(0);
        this.bar.setExtent(1);
        this.bar.setPageIncrement(5);
        this.bar.setStepIncrement(1);
        this.bar.setPreferredSize(16, chartEditor.getSite().getShell().getBounds().height / 2);
        this.bar.setValue(50);
        this.add((IFigure)this.bar);
        this.bar.addPropertyChangeListener("value", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                int factor = 50 - ZoomBar.this.bar.getValue();
                figure.setZoom(factor);
            }
        });
        this.setToolTip((IFigure)this.label);
    }

    protected void paintFigure(Graphics g) {
        super.paintFigure(g);
        this.bar.setBounds(this.getParent().getBounds());
        this.bar.revalidate();
    }
}

