/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.pa.ui.figures;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.common.util.StringUtil;
import com.ibm.cics.pa.model.Column;
import com.ibm.cics.pa.model.PlotModel;
import com.ibm.cics.pa.model.PlotPoint;
import com.ibm.cics.pa.model.definitions.ColumnDefinition;
import com.ibm.cics.pa.ui.Activator;
import com.ibm.cics.pa.ui.Messages;
import com.ibm.cics.pa.ui.figures.IntervalFigureFactory;
import com.ibm.cics.pa.ui.utilities.DataTypeUtilities;
import java.text.MessageFormat;
import java.util.List;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.CompoundBorder;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.GridData;
import org.eclipse.draw2d.GridLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.ImageFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.LineBorder;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.Panel;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;

public class IntervalPlotTooltip
extends Panel {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y23 (c) Copyright IBM Corp. 2013, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Debug debug = new Debug(IntervalPlotTooltip.class);
    private static final Image mainIcon = Activator.getDefault().getImage("alert_icon");
    private static String FONT_NAME = Display.getCurrent().getSystemFont().getFontData()[0].getName();
    private static int FONT_SIZE = Display.getCurrent().getSystemFont().getFontData()[0].getHeight();
    private static Font STANDARD_BOLD = new Font((Device)Display.getDefault(), FONT_NAME, FONT_SIZE, 1);
    private Label labTot;

    public IntervalPlotTooltip(PlotModel.PlotModelElement element, Color aNiceColour, ColumnDefinition[] labels) {
        debug.enter("IntervalPlotTooltip", (Object)element);
        this.setBackgroundColor(aNiceColour);
        this.setForegroundColor(ColorConstants.darkGray);
        this.setOpaque(true);
        this.setBorder((Border)new CompoundBorder((Border)new LineBorder(ColorConstants.lightGray, 2), (Border)new MarginBorder(10)));
        GridLayout layout = new GridLayout(1, false);
        if (element.isAlert()) {
            layout = new GridLayout(2, false);
            this.add((IFigure)new ImageFigure(mainIcon));
        }
        this.createPane(new Panel(), element, labels);
        this.setLayoutManager((LayoutManager)layout);
        layout.setConstraint((IFigure)this, (Object)new GridData(4, 4, true, true));
        debug.exit("IntervalPlotTooltip", (Object)element);
    }

    public IntervalPlotTooltip(PlotModel.PlotModelElement element, Color aNiceColour, ColumnDefinition[] labels, String message) {
        debug.enter("IntervalPlotTooltip", (Object)element);
        this.setBackgroundColor(aNiceColour);
        this.setForegroundColor(ColorConstants.darkGray);
        this.setOpaque(true);
        this.setBorder((Border)new CompoundBorder((Border)new LineBorder(ColorConstants.lightGray, 2), (Border)new MarginBorder(10)));
        GridLayout layout = new GridLayout(1, false);
        if (element.isAlert()) {
            layout = new GridLayout(2, false);
            this.add((IFigure)new ImageFigure(mainIcon));
        }
        this.createPane(new Panel(), element, labels, message);
        this.setLayoutManager((LayoutManager)layout);
        layout.setConstraint((IFigure)this, (Object)new GridData(4, 4, true, true));
        debug.exit("IntervalPlotTooltip", (Object)element);
    }

    protected IntervalPlotTooltip(PlotModel.PlotModelElement element, ColumnDefinition[] columnDefinitions, long[] values, Color aNiceColour) {
        debug.enter("IntervalPlotTooltip SMS");
        this.setBackgroundColor(aNiceColour);
        this.setForegroundColor(ColorConstants.darkGray);
        this.setOpaque(true);
        this.setBorder((Border)new CompoundBorder((Border)new LineBorder(ColorConstants.lightGray, 2), (Border)new MarginBorder(10)));
        GridLayout layout = new GridLayout(1, false);
        this.createSMSPane(new Panel(), element, columnDefinitions, values);
        this.setLayoutManager((LayoutManager)layout);
        layout.setConstraint((IFigure)this, (Object)new GridData(4, 4, true, true));
        debug.exit("IntervalPlotTooltip SMS");
    }

    public IntervalPlotTooltip(PlotModel.PlotModelElement element, ColumnDefinition columnDefinition, PlotModel.PlotModelElement.DSAPacket packet, String totals, Color aNiceColour) {
        debug.enter("IntervalPlotTooltip DSA");
        this.setBackgroundColor(aNiceColour);
        this.setForegroundColor(ColorConstants.darkGray);
        this.setOpaque(true);
        this.setBorder((Border)new CompoundBorder((Border)new LineBorder(ColorConstants.lightGray, 2), (Border)new MarginBorder(10)));
        GridLayout layout = new GridLayout(1, false);
        this.createDSAPane(new Panel(), element, columnDefinition, packet, totals);
        this.setLayoutManager((LayoutManager)layout);
        layout.setConstraint((IFigure)this, (Object)new GridData(4, 4, true, true));
        debug.exit("IntervalPlotTooltip DSA");
    }

    private void createDSAPane(Panel contentPane, PlotModel.PlotModelElement element, ColumnDefinition plot, PlotModel.PlotModelElement.DSAPacket packet, String totals) {
        debug.enter("createDSAPane");
        GridLayout layout = new GridLayout(3, false);
        contentPane.setLayoutManager((LayoutManager)layout);
        if (plot != ColumnDefinition.TOTALS) {
            Color colour = Column.getFor(plot).getColor();
            ColouredFigure figure = new ColouredFigure(0, null);
            figure = new ColouredFigure(0, colour);
            figure.setSize(16, 16);
            contentPane.add((IFigure)figure);
            Label plotLabel = new Label(plot.getLabel(null));
            plotLabel.setFont(STANDARD_BOLD);
            if (colour != null) {
                plotLabel.setForegroundColor(colour);
            }
            contentPane.add((IFigure)plotLabel);
            if (packet != null) {
                String nr = MessageFormat.format(Messages.getString("PlotView.packet.tooltipinfo"), packet.getUsed(), packet.getSize(), packet.getPercent());
                contentPane.add((IFigure)new Label(nr));
            }
        } else if (StringUtil.hasContent((String)totals)) {
            this.labTot = new Label(totals);
            GridData gridData = new GridData();
            gridData.horizontalAlignment = 4;
            gridData.grabExcessHorizontalSpace = true;
            gridData.horizontalSpan = 3;
            contentPane.add((IFigure)this.labTot);
            contentPane.setConstraint((IFigure)this.labTot, (Object)gridData);
        }
        this.add((IFigure)contentPane);
        layout.setConstraint((IFigure)this, (Object)new GridData(4, 4, true, false));
        debug.exit("createDSAPane");
    }

    private void createSMSPane(Panel contentPane, PlotModel.PlotModelElement element, ColumnDefinition[] labels, long[] values) {
        debug.enter("createSMSPane");
        GridLayout layout = new GridLayout(3, false);
        contentPane.setLayoutManager((LayoutManager)layout);
        int i = 0;
        while (i < labels.length) {
            ColumnDefinition plot = labels[i];
            Color colour = Column.getFor(plot).getColor();
            ColouredFigure figure = new ColouredFigure(0, null);
            int percent = 0;
            figure = plot == ColumnDefinition.DSA_TOTAL_PEAK || plot == ColumnDefinition.EDSA_TOTAL_PEAK || plot == ColumnDefinition.PEAK_GDSA_ACTIVE ? new ColouredFigure(5, colour) : (plot == ColumnDefinition.DSA_CURRENT_TOTAL || plot == ColumnDefinition.EDSA_CURRENT_TOTAL || plot == ColumnDefinition.CURRENT_ACTIV_GDSA ? new ColouredFigure(4, colour) : (plot == ColumnDefinition.DSA_SIZE_PGMS || plot == ColumnDefinition.EDSA_SIZE_PGMS ? new ColouredFigure(7, colour) : (plot == ColumnDefinition.DSA_SIZE_USED || plot == ColumnDefinition.EDSA_SIZE_USED || plot == ColumnDefinition.GDSA_SIZE_USED ? new ColouredFigure(6, colour) : new ColouredFigure(0, colour))));
            List<PlotPoint> plotpoints = element.getParent().getPlotPoints();
            int j = 0;
            while (j < plotpoints.size()) {
                if (plot == plotpoints.get(j).getPlotReference()) {
                    percent = (int)element.get(j);
                    figure.setSize(16, 16);
                    contentPane.add((IFigure)figure);
                    Label plotLabel = new Label(plot.getLabel(null));
                    plotLabel.setFont(STANDARD_BOLD);
                    if (colour != null) {
                        plotLabel.setForegroundColor(colour);
                    }
                    contentPane.add((IFigure)plotLabel);
                    String nr = "";
                    if (element.getValueMap().containsKey(plot)) {
                        nr = DataTypeUtilities.getAsString(element.getValueMap().get(plot));
                    }
                    if (element.isPercentage()) {
                        nr = String.valueOf(nr) + ' ';
                        nr = String.valueOf(nr) + MessageFormat.format(Messages.getString("PlotView.relative.percentage"), percent);
                    }
                    contentPane.add((IFigure)new Label(nr));
                }
                ++j;
            }
            ++i;
        }
        this.add((IFigure)contentPane);
        layout.setConstraint((IFigure)this, (Object)new GridData(4, 4, true, false));
        debug.exit("createSMSPane");
    }

    private void createPane(Panel contentPane, PlotModel.PlotModelElement element, ColumnDefinition[] labels, String message) {
        debug.enter("createPane");
        GridLayout layout = new GridLayout(3, false);
        contentPane.setLayoutManager((LayoutManager)layout);
        boolean noColour = false;
        if (StringUtil.hasContent((String)message)) {
            if (message.equals(Messages.getString("Threshold.title"))) {
                noColour = true;
            }
            Label messageLabel = new Label(message);
            GridData gridData = new GridData();
            gridData.horizontalAlignment = 4;
            gridData.grabExcessHorizontalSpace = true;
            gridData.horizontalSpan = 3;
            contentPane.add((IFigure)messageLabel);
            contentPane.setConstraint((IFigure)messageLabel, (Object)gridData);
        }
        if (labels != null) {
            List<PlotPoint> plotpoints = element.getParent().getPlotPoints();
            int i = 0;
            while (i < labels.length) {
                ColumnDefinition plot = labels[i];
                if (element.getValueMap().containsKey(plot) && !this.applicableCheck(plot)) {
                    Color colour = element.getParent().getColour(plot);
                    ColouredFigure figure = new ColouredFigure(0, null);
                    int percent = 0;
                    int j = 0;
                    while (j < plotpoints.size()) {
                        if (plot == plotpoints.get(j).getPlotReference()) {
                            figure = plot == ColumnDefinition.DSA_TOTAL_PEAK || plot == ColumnDefinition.EDSA_TOTAL_PEAK || plot == ColumnDefinition.PEAK_GDSA_ACTIVE ? new ColouredFigure(5, element.getParent().getColour(plot)) : (plot == ColumnDefinition.DSA_CURRENT_TOTAL || plot == ColumnDefinition.EDSA_CURRENT_TOTAL || plot == ColumnDefinition.CURRENT_ACTIV_GDSA ? new ColouredFigure(4, element.getParent().getColour(plot)) : new ColouredFigure(j, element.getParent().getColour(plot)));
                            percent = (int)element.get(j);
                        }
                        ++j;
                    }
                    figure.setSize(16, 16);
                    contentPane.add((IFigure)figure);
                    Label plotLabel = new Label(plot.getLabel(element.getParent().getTable()));
                    if (!noColour && colour != null) {
                        plotLabel.setForegroundColor(colour);
                        plotLabel.setFont(STANDARD_BOLD);
                    }
                    contentPane.add((IFigure)plotLabel);
                    String nr = "";
                    if (element.getValueMap().containsKey(plot)) {
                        nr = DataTypeUtilities.getAsString(element.getValueMap().get(plot));
                    }
                    if (element.isPercentage() && !element.getParent().getPercentagesOf().contains(plot)) {
                        nr = String.valueOf(nr) + ' ';
                        nr = String.valueOf(nr) + MessageFormat.format(Messages.getString("PlotView.relative.percentage"), percent);
                    }
                    contentPane.add((IFigure)new Label(nr));
                }
                ++i;
            }
        }
        this.add((IFigure)contentPane);
        layout.setConstraint((IFigure)this, (Object)new GridData(4, 4, true, false));
        debug.exit("createPane");
    }

    private void createPane(Panel contentPane, PlotModel.PlotModelElement element, ColumnDefinition[] labels) {
        debug.enter("createPane");
        GridLayout layout = new GridLayout(3, false);
        contentPane.setLayoutManager((LayoutManager)layout);
        if (!element.getDSAPackets().isEmpty() || element.getParent().isSMTRecord()) {
            this.performDSAAlternative(contentPane, element);
        } else if (labels != null) {
            List<PlotPoint> plotpoints = element.getParent().getPlotPoints();
            int i = 0;
            while (i < labels.length) {
                ColumnDefinition plot = labels[i];
                if (element.getValueMap().containsKey(plot) && !this.applicableCheck(plot)) {
                    Color colour = element.getParent().getColour(plot);
                    ColouredFigure figure = new ColouredFigure(0, null);
                    int percent = 0;
                    int j = 0;
                    while (j < plotpoints.size()) {
                        if (plot == plotpoints.get(j).getPlotReference()) {
                            figure = plot == ColumnDefinition.DSA_TOTAL_PEAK || plot == ColumnDefinition.EDSA_TOTAL_PEAK || plot == ColumnDefinition.PEAK_GDSA_ACTIVE ? new ColouredFigure(5, element.getParent().getColour(plot)) : (plot == ColumnDefinition.DSA_CURRENT_TOTAL || plot == ColumnDefinition.EDSA_CURRENT_TOTAL || plot == ColumnDefinition.CURRENT_ACTIV_GDSA ? new ColouredFigure(4, element.getParent().getColour(plot)) : new ColouredFigure(j, element.getParent().getColour(plot)));
                            percent = (int)element.get(j);
                        }
                        ++j;
                    }
                    figure.setSize(16, 16);
                    contentPane.add((IFigure)figure);
                    Label plotLabel = new Label(plot.getLabel(element.getParent().getTable()));
                    plotLabel.setFont(STANDARD_BOLD);
                    if (colour != null) {
                        plotLabel.setForegroundColor(colour);
                    }
                    contentPane.add((IFigure)plotLabel);
                    String nr = "";
                    if (element.getValueMap().containsKey(plot)) {
                        nr = DataTypeUtilities.getAsString(element.getValueMap().get(plot));
                    }
                    if (element.isPercentage() && !element.getParent().getPercentagesOf().contains(plot)) {
                        nr = String.valueOf(nr) + ' ';
                        nr = String.valueOf(nr) + MessageFormat.format(Messages.getString("PlotView.relative.percentage"), percent);
                    }
                    contentPane.add((IFigure)new Label(nr));
                }
                ++i;
            }
        }
        this.add((IFigure)contentPane);
        layout.setConstraint((IFigure)this, (Object)new GridData(4, 4, true, false));
        debug.exit("createPane");
    }

    private boolean applicableCheck(ColumnDefinition plot) {
        return IntervalFigureFactory.DISPLAY_AS_COLUMNS.contains(plot) || IntervalFigureFactory.DISPLAY_AS_LEVEL.contains(plot);
    }

    private void performDSAAlternative(Panel contentPane, PlotModel.PlotModelElement element) {
        int i = 0;
        while (i < PlotModel.XMGTooltipB.length) {
            ColumnDefinition plot = PlotModel.XMGTooltipB[i];
            Color colour = element.getParent().getColour(plot);
            if (i == 0) {
                contentPane.add((IFigure)new Label());
            } else {
                ColouredFigure figure = new ColouredFigure(i - 1, colour);
                figure.setSize(16, 16);
                contentPane.add((IFigure)figure);
            }
            if (element.getValueMap().containsKey(plot)) {
                Label plotLabel = new Label(plot.getLabel(null));
                plotLabel.setFont(STANDARD_BOLD);
                if (colour != null) {
                    plotLabel.setForegroundColor(colour);
                }
                contentPane.add((IFigure)plotLabel);
                Label value = new Label();
                value.setText(((Integer)element.getValueMap().get(plot)).toString());
                contentPane.add((IFigure)value);
            }
            ++i;
        }
    }

    public void forceRepaint() {
    }

    class ColouredFigure
    extends Figure {
        private int shape;
        private Color colour;

        public ColouredFigure(int j, Color color) {
            this.shape = j;
            this.colour = color;
        }

        public void paint(Graphics graphics) {
            this.setBackgroundColor(ColorConstants.blue);
            super.paint(graphics);
            if (this.colour != null) {
                graphics.setForegroundColor(this.colour);
                graphics.setBackgroundColor(this.colour);
                switch (this.shape) {
                    case 0: {
                        graphics.fillRectangle(this.getBounds().x + 4, this.getBounds().y + 4, this.getBounds().width - 8, this.getBounds().height - 8);
                        break;
                    }
                    case 1: {
                        graphics.fillOval(this.getBounds().x + 4, this.getBounds().y + 4, this.getBounds().width - 8, this.getBounds().height - 8);
                        break;
                    }
                    case 2: {
                        graphics.fillPolygon(new int[]{this.getBounds().x + 8, this.getBounds().y + 4, this.getBounds().x + 8 + 4, this.getBounds().y + 8, this.getBounds().x + 8, this.getBounds().y + 4 + 8, this.getBounds().x + 4, this.getBounds().y + 8});
                        break;
                    }
                    case 3: {
                        graphics.fillArc(this.getBounds().x, this.getBounds().y, this.getBounds().width, this.getBounds().height, 180, 90);
                        break;
                    }
                    case 4: {
                        graphics.drawLine(this.getBounds().x, this.getBounds().y + this.getBounds().height / 2, this.getBounds().x + this.getBounds().width, this.getBounds().y + this.getBounds().height / 2);
                        break;
                    }
                    case 5: {
                        graphics.fillRectangle(this.getBounds().x, this.getBounds().y, this.getBounds().width, this.getBounds().height);
                        break;
                    }
                    case 6: {
                        Rectangle clientArea1 = this.getBounds().getCopy();
                        clientArea1.x += 2;
                        clientArea1.y += 2;
                        clientArea1.width -= 4;
                        clientArea1.height -= 4;
                        graphics.drawRoundRectangle(clientArea1, 4, 4);
                        break;
                    }
                    case 7: {
                        Rectangle clientArea2 = this.getBounds().getCopy();
                        clientArea2.x += 2;
                        clientArea2.y += 2;
                        clientArea2.width -= 4;
                        clientArea2.height -= 4;
                        graphics.setLineWidth(2);
                        graphics.setLineStyle(2);
                        graphics.drawRoundRectangle(clientArea2, 4, 4);
                        break;
                    }
                    default: {
                        graphics.fillArc(this.getBounds().x, this.getBounds().y, this.getBounds().width, this.getBounds().height, 270, 90);
                    }
                }
            }
        }
    }
}

