/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.pa.ui.figures;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.pa.model.PlotModel;
import com.ibm.cics.pa.model.definitions.ColumnDefinition;
import com.ibm.cics.pa.ui.Activator;
import com.ibm.cics.pa.ui.Messages;
import com.ibm.cics.pa.ui.figures.IIntervalColumnFigure;
import com.ibm.cics.pa.ui.figures.IntervalPlotFigure;
import com.ibm.cics.pa.ui.figures.IntervalPlotTooltip;
import com.ibm.cics.pa.ui.figures.SingleIntervalFigure;
import com.ibm.cics.pa.ui.figures.StackingColumnFigure;
import com.ibm.cics.pa.ui.utilities.DataTypeUtilities;
import java.text.MessageFormat;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Color;

public class DSASingleIntervalFigure
extends SingleIntervalFigure {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y23 (c) Copyright IBM Corp. 2013, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Debug debug = new Debug(DSASingleIntervalFigure.class);
    private double memoryLimit = -1.0;
    private boolean isSMT;

    public DSASingleIntervalFigure(IntervalPlotFigure parent, PlotModel.PlotModelElement plotModelElement, Color aNiceColour, ColumnDefinition[] labels) {
        super(parent, plotModelElement, aNiceColour, labels);
        debug.enter("DSASingleIntervalFigure");
        if (this.memoryLimit == -1.0) {
            for (PlotModel.PlotModelElement.DSAPacket packet : this.getElement().getDSAPackets().values()) {
                this.memoryLimit = packet.getMemlimit();
            }
        }
        this.isSMT = this.getElement().getParent().isSMTRecord();
        if (labels != null) {
            String totals = this.calculateTooltipTotal(labels);
            ColumnDefinition[] columnDefinitionArray = labels;
            int n = labels.length;
            int n2 = 0;
            while (n2 < n) {
                ColumnDefinition defn = columnDefinitionArray[n2];
                PlotModel.PlotModelElement.DSAPacket packet = this.getElement().getDSAPackets().get(defn);
                StackingColumnFigure figure = new StackingColumnFigure(packet, defn, defn == ColumnDefinition.TOTALS);
                figure.setToolTip((IFigure)new IntervalPlotTooltip(this.getElement(), defn, packet, totals, aNiceColour));
                this.add(figure);
                ++n2;
            }
        }
        this.setBackgroundColor(ColorConstants.white);
        debug.exit("DSASingleIntervalFigure", (Object)this);
    }

    @Override
    public void paintBody(Graphics graphics) {
        super.paintBody(graphics);
        Rectangle clientArea = this.getBounds().getCopy();
        clientArea.height -= 64;
        clientArea.y += 64;
        graphics.setBackgroundColor(this.plot.isSelected(this) && this.plot.hasFocusColumn() ? ColorConstants.lightGray : ColorConstants.white);
        graphics.setForegroundColor(this.colour);
        graphics.fillGradient(clientArea, true);
        graphics.setForegroundColor(ColorConstants.lightBlue);
        graphics.setLineStyle(3);
        if (this.plot.isSelected(this)) {
            graphics.setForegroundColor(this.plot.hasFocusColumn() ? ColorConstants.darkGray : ColorConstants.gray);
            graphics.setLineWidth(this.plot.hasFocusColumn() ? 2 : 2);
            graphics.setLineStyle(1);
        } else {
            graphics.setForegroundColor(ColorConstants.lightBlue);
            graphics.setLineWidth(1);
            graphics.setLineStyle(3);
        }
        graphics.drawLine(clientArea.x + 1, clientArea.y, clientArea.x + 1, clientArea.y + clientArea.height - 2);
        graphics.drawLine(clientArea.x + clientArea.width - 1, clientArea.y, clientArea.x + clientArea.width - 1, clientArea.y + clientArea.height - 1);
        clientArea.y += clientArea.height - this.positionT;
        clientArea.height = this.positionT;
        Rectangle rectangle = new Rectangle(clientArea.x + 4, clientArea.y, clientArea.width - 8, clientArea.height);
        if (!this.isSMT) {
            graphics.setBackgroundPattern(Activator.getDefault().altlightgreyPattern);
            graphics.fillRoundRectangle(rectangle, 4, 4);
        }
        graphics.setForegroundColor(ColorConstants.gray);
        graphics.drawRoundRectangle(rectangle, 4, 4);
        graphics.setLineStyle(1);
        this.rangeFactor = this.memoryLimit / (double)clientArea.height;
        for (Object figure : this.getChildren()) {
            if (!(figure instanceof IIntervalColumnFigure)) continue;
            Rectangle nbounds = ((IIntervalColumnFigure)figure).calculateBounds(clientArea, this.rangeFactor);
            ((IIntervalColumnFigure)figure).setBounds(nbounds);
            clientArea.height -= nbounds.height;
        }
    }

    private String calculateTooltipTotal(ColumnDefinition[] labels) {
        String nr = "";
        if (!this.isSMT && labels != null) {
            long sizeAcummulator = 0L;
            long total = 0L;
            int i = 0;
            while (i < labels.length) {
                ColumnDefinition plot = labels[i];
                if (plot != ColumnDefinition.TOTALS) {
                    PlotModel.PlotModelElement.DSAPacket packet = this.element.getDSAPackets().get(plot);
                    if (packet != null) {
                        if (total == 0L) {
                            total = packet.getMemlimit();
                        }
                        sizeAcummulator += (long)packet.getSize();
                    }
                } else {
                    String prefix = this.element.getParent().getDSAType().name();
                    String percent1 = DataTypeUtilities.getPercentageAsInteger(total - sizeAcummulator, total);
                    nr = MessageFormat.format(Messages.getString("PlotView.packet.tooltipinfo.total"), prefix, total - sizeAcummulator, total, percent1);
                }
                ++i;
            }
        }
        return nr;
    }
}

