/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.pa.ui.figures;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.pa.model.ChartType;
import com.ibm.cics.pa.model.Pie;
import com.ibm.cics.pa.model.definitions.CategorisationHelper;
import com.ibm.cics.pa.model.definitions.ChartSpecification;
import com.ibm.cics.pa.ui.editors.PieEditorItem;
import com.ibm.cics.pa.ui.figures.AbstractPieFigure;
import com.ibm.cics.pa.ui.figures.PieSector;
import com.ibm.cics.pa.ui.figures.PieSlice;
import com.ibm.cics.pa.ui.figures.SectorAndSegments;
import com.ibm.cics.pa.ui.views.PerformanceListRecordFormsView;
import com.ibm.cics.pa.ui.views.PieView;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.MouseEvent;
import org.eclipse.draw2d.MouseListener;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.ui.parts.ScrollingGraphicalViewer;
import org.eclipse.ui.IViewPart;

public class BigPie
extends AbstractPieFigure {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y23 (c) Copyright IBM Corp. 2008, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private Map<ChartSpecification, SectorAndSegments> components = new HashMap<ChartSpecification, SectorAndSegments>();
    private Logger logger = Logger.getLogger("com.ibm.cics.pa.ui");
    SectorAndSegments currentSelection;

    public BigPie(final IViewPart pieView, ScrollingGraphicalViewer graphicalViewer, Pie startModel) {
        super(pieView, (GraphicalViewer)graphicalViewer, startModel);
        Debug.enter((Logger)this.logger, (String)BigPie.class.getName(), (String)"BigPie");
        if (pieView instanceof PieView || pieView instanceof PerformanceListRecordFormsView) {
            this.addMouseListener(new MouseListener(){

                public void mouseDoubleClicked(MouseEvent me) {
                }

                public void mousePressed(MouseEvent me) {
                    boolean oneSelected = false;
                    if (BigPie.this.currentSelection != null && BigPie.this.currentSelection.getAllElements() != null) {
                        for (PieSlice pieSlice : BigPie.this.currentSelection.getAllElements()) {
                            if (pieSlice.isSelected()) {
                                pieSlice.setSelected(false);
                                pieSlice.repaint();
                            }
                            if (!pieSlice.containsPoint(me.x, me.y)) continue;
                            oneSelected = true;
                            pieSlice.setSelected(true);
                            pieSlice.repaint();
                            if (pieView instanceof PieView) {
                                ((PieView)BigPie.this.viewPart).adjustTreeSelection(pieSlice.getColumnDefinition());
                                continue;
                            }
                            ((PerformanceListRecordFormsView)BigPie.this.viewPart).adjustTreeSelection(pieSlice.getColumnDefinition());
                        }
                    }
                    if (BigPie.this.currentSelection != null && BigPie.this.currentSelection.getSectors() != null) {
                        for (PieSector pieSector : BigPie.this.currentSelection.getSectors()) {
                            if (pieSector.isSelected()) {
                                pieSector.setSelected(false);
                                pieSector.repaint();
                            }
                            if (oneSelected || !pieSector.containsPoint(me.x, me.y)) continue;
                            oneSelected = true;
                            pieSector.setSelected(true);
                            pieSector.repaint();
                            if (pieView instanceof PieView) {
                                ((PieView)BigPie.this.viewPart).adjustTreeSelection(pieSector.getColumnContainment());
                                continue;
                            }
                            ((PerformanceListRecordFormsView)BigPie.this.viewPart).adjustTreeSelection(pieSector.getColumnContainment());
                        }
                    }
                }

                public void mouseReleased(MouseEvent me) {
                }
            });
        }
        Debug.exit((Logger)this.logger, (String)BigPie.class.getName(), (String)"BigPie");
    }

    public void initialiseComponents(Pie model) {
        Debug.enter((Logger)this.logger, (String)BigPie.class.getName(), (String)"initialiseComponents");
        this.startModel = model;
        this.components.clear();
        this.currentSelection = null;
        for (ChartSpecification chartDefinition : CategorisationHelper.getPossibleSingleSelections(model.getDataProvider())) {
            if (!chartDefinition.getType().equals((Object)ChartType.PIE)) continue;
            SectorAndSegments figures = this.singlePie(chartDefinition);
            for (PieSlice pieSlice : figures.getAllElements()) {
                this.add((IFigure)pieSlice);
            }
            for (PieSector pieSector : figures.getSectors()) {
                this.add((IFigure)pieSector);
            }
            this.components.put(chartDefinition, this.singlePie(chartDefinition));
            if (this.currentSelection != null) continue;
            this.currentSelection = this.components.get(chartDefinition);
        }
        Debug.exit((Logger)this.logger, (String)BigPie.class.getName(), (String)"initialiseComponents");
    }

    public void initialiseSingleComponent(Pie model) {
        Debug.enter((Logger)this.logger, (String)BigPie.class.getName(), (String)"initialiseSingleComponent");
        this.startModel = model;
        this.currentSelection = this.singlePie(this.startModel.getChartReference());
        this.components.put(this.startModel.getChartReference(), this.currentSelection);
        this.setSelected(model);
        Debug.exit((Logger)this.logger, (String)BigPie.class.getName(), (String)"initialiseSingleComponent");
    }

    public void paintFigure(Graphics g) {
        super.paintFigure(g);
        g.setForegroundColor(ColorConstants.darkGray);
        Rectangle boundary1 = this.getBounds().getCopy();
        for (Object figure : this.getChildren()) {
            ((IFigure)figure).setBounds(boundary1);
        }
    }

    public void setSelected(Pie model) {
        this.removeAll();
        this.currentSelection = this.components.get(model.getChartReference());
        if (this.viewPart != null && this.viewPart instanceof PieView) {
            ((PieView)this.viewPart).setSelectedChart(model);
        }
        if (this.currentSelection != null) {
            for (PieSector portion : this.currentSelection.getSectors()) {
                portion.setSelected(false);
                this.add((IFigure)portion);
            }
        }
        if (this.currentSelection != null) {
            for (PieSlice slice : this.currentSelection.getAllElements()) {
                slice.setSelected(false);
                this.add((IFigure)slice);
            }
        }
    }

    public String getDescription() {
        return this.currentSelection == null ? "" : this.currentSelection.getModel().getPrimaryLabel();
    }

    public void setSelection(PieEditorItem pieEditorItem) {
        if (pieEditorItem != null) {
            for (PieSector sector : this.currentSelection.getSectors()) {
                sector.setSelected(sector.getColumnContainment().equals(pieEditorItem.getColumnContainment()));
            }
            for (PieSlice slice : this.currentSelection.getAllElements()) {
                slice.setSelected(slice.getColumnDefinition().equals(pieEditorItem.getColumnDefinition()));
            }
        }
        this.repaint();
    }
}

