/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.pa.ui.figures;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.eclipse.common.ViewHelper;
import com.ibm.cics.pa.model.Chart;
import com.ibm.cics.pa.model.Column;
import com.ibm.cics.pa.model.Pie;
import com.ibm.cics.pa.model.definitions.ChartSpecification;
import com.ibm.cics.pa.model.definitions.ColumnContainment;
import com.ibm.cics.pa.model.definitions.ColumnDefinition;
import com.ibm.cics.pa.model.definitions.PieChartSpecificDefinitions;
import com.ibm.cics.pa.ui.ChartManager;
import com.ibm.cics.pa.ui.figures.PieSector;
import com.ibm.cics.pa.ui.figures.PieSlice;
import com.ibm.cics.pa.ui.figures.SectorAndSegments;
import java.util.ArrayList;
import java.util.logging.Logger;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.IFigure;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPart;

public class AbstractPieFigure
extends Figure
implements IAdaptable {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y23 (c) Copyright IBM Corp. 2008, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Debug debug = new Debug(AbstractPieFigure.class);
    protected GraphicalViewer graphicalViewer;
    protected IViewPart viewPart;
    protected Pie startModel;
    protected Logger logger = Logger.getLogger("com.ibm.cics.pa.ui");

    public AbstractPieFigure(IViewPart pieView, GraphicalViewer graphicalViewer, Pie model) {
        debug.enter("AbstractPieFigure");
        this.startModel = model;
        this.viewPart = pieView;
        this.graphicalViewer = graphicalViewer;
        debug.exit("AbstractPieFigure");
    }

    public Object getAdapter(Class type) {
        if (type == GraphicalViewer.class) {
            return this.graphicalViewer;
        }
        return null;
    }

    protected SectorAndSegments singlePie(ChartSpecification chartDefinition) {
        ColumnContainment contain;
        debug.enter("singlePie");
        String id = ChartManager.getInstance().createChart(chartDefinition, this.startModel.getDataProvider(), this.startModel.getElementName(), this.startModel.getUniqueRecord(), null);
        Pie model = (Pie)Chart.getReference(id);
        ArrayList<PieSector> sectors = new ArrayList<PieSector>();
        ArrayList<PieSlice> allElements = new ArrayList<PieSlice>();
        double total = 0.0;
        int sectorStartAngle = 0;
        int sliceStartAngle = 0;
        if (model.isDonut()) {
            sectorStartAngle = 90;
            ColumnContainment[] columnContainmentArray = ((PieChartSpecificDefinitions)chartDefinition.getSpecificType()).getContainments();
            int n = columnContainmentArray.length;
            int n2 = 0;
            while (n2 < n) {
                contain = columnContainmentArray[n2];
                Object value = model.getCompleteValues().get(contain.getPrimary());
                PieSector secto = new PieSector(sectorStartAngle, 120, contain.getPrimaryLabel(), contain, true);
                sectors.add(secto);
                this.add((IFigure)secto);
                if (value != null && value instanceof Number && ((Number)value).doubleValue() > 0.0) {
                    sliceStartAngle = sectorStartAngle;
                    ArrayList<PieSlice> slices = new ArrayList<PieSlice>();
                    int sliceEndAngle = 0;
                    ColumnDefinition[] columnDefinitionArray = contain.getColumnRef();
                    int n3 = columnDefinitionArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        ColumnDefinition coldefn = columnDefinitionArray[n4];
                        Object elementValue = model.getCompleteValues().get(coldefn);
                        Column column = Column.getFor(coldefn);
                        if (elementValue != null && elementValue instanceof Number && ((Number)elementValue).doubleValue() > 0.0) {
                            sliceEndAngle = Math.round(Math.round(((Number)elementValue).doubleValue() * 120.0 / ((Number)value).doubleValue()));
                            String name = coldefn.getLabel(null);
                            PieSlice sli = new PieSlice(sliceStartAngle, sliceEndAngle, name, column, (IFigure)this, model.isDonut());
                            this.add((IFigure)sli);
                            slices.add(sli);
                            sliceStartAngle += sliceEndAngle;
                        }
                        ++n4;
                    }
                    secto.updateSliceAngles(120);
                    secto.addSlices(slices);
                    allElements.addAll(slices);
                }
                sectorStartAngle += 120;
                ++n2;
            }
        } else {
            Object value;
            ColumnContainment[] columnContainmentArray = ((PieChartSpecificDefinitions)chartDefinition.getSpecificType()).getContainments();
            int n = columnContainmentArray.length;
            int n5 = 0;
            while (n5 < n) {
                contain = columnContainmentArray[n5];
                value = model.getCompleteValues().get(contain.getPrimary());
                if (value != null && value instanceof Number) {
                    total += ((Number)value).doubleValue();
                }
                ++n5;
            }
            columnContainmentArray = ((PieChartSpecificDefinitions)chartDefinition.getSpecificType()).getContainments();
            n = columnContainmentArray.length;
            n5 = 0;
            while (n5 < n) {
                contain = columnContainmentArray[n5];
                value = model.getCompleteValues().get(contain.getPrimary());
                Column primary = Column.getFor(contain.getPrimary());
                if (value != null && value instanceof Number && ((Number)value).doubleValue() > 0.0) {
                    int sectorEndAngle = Math.round(Math.round(((Number)value).doubleValue() * 360.0 / total));
                    if (value instanceof Double && (double)((Number)value).intValue() == ((Number)value).doubleValue()) {
                        value = ((Number)value).intValue();
                    }
                    PieSector secto = new PieSector(sectorStartAngle, sectorEndAngle, contain.getPrimaryLabel(), contain, model.isDonut());
                    sectors.add(secto);
                    this.add((IFigure)secto);
                    sliceStartAngle = sectorStartAngle;
                    ArrayList<PieSlice> slices = new ArrayList<PieSlice>();
                    int sliceEndAngle = 0;
                    ColumnDefinition[] columnDefinitionArray = contain.getColumnRef();
                    int n6 = columnDefinitionArray.length;
                    int n7 = 0;
                    while (n7 < n6) {
                        ColumnDefinition coldefn = columnDefinitionArray[n7];
                        Object elementValue = model.getCompleteValues().get(coldefn);
                        Column column = Column.getFor(coldefn);
                        if (elementValue != null && elementValue instanceof Number && ((Number)elementValue).doubleValue() > 0.0) {
                            sliceEndAngle = Math.round(Math.round(((Number)elementValue).doubleValue() * 360.0 / total));
                            String name = coldefn.getLabel(null);
                            PieSlice sli = new PieSlice(sliceStartAngle, sliceEndAngle, name, column, (IFigure)this, model.isDonut());
                            this.add((IFigure)sli);
                            slices.add(sli);
                            sliceStartAngle += sliceEndAngle;
                        }
                        ++n7;
                    }
                    if (slices.isEmpty()) {
                        PieSlice sli = new PieSlice(sectorStartAngle, sectorEndAngle, contain.getPrimaryLabel(), primary, (IFigure)this, model.isDonut());
                        this.add((IFigure)sli);
                        slices.add(sli);
                    } else {
                        secto.updateSliceAngles(sectorEndAngle);
                    }
                    secto.addSlices(slices);
                    allElements.addAll(slices);
                    sectorStartAngle += sectorEndAngle;
                }
                ++n5;
            }
        }
        if (sectors.isEmpty()) {
            PieSector secto = new PieSector(sectorStartAngle, 360, "", new ColumnContainment(ColumnDefinition.UNKNOWN, new ColumnDefinition[0]), model.isDonut());
            sectors.add(secto);
            this.add((IFigure)secto);
        }
        debug.exit("singlePie");
        return new SectorAndSegments(sectors, allElements, model);
    }

    public Pie getModel() {
        return this.startModel;
    }

    protected void setStatusMessage(String message) {
        if (this.viewPart != null) {
            ViewHelper.setStatusInformationMessage((IWorkbenchPart)this.viewPart, (String)message);
        }
    }
}

