/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.pa.ui.editors;

import com.ibm.cics.pa.ui.utilities.DataTypeUtilities;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.TableItem;

public class PAEditingSupport
extends EditingSupport {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y23 (c) Copyright IBM Corp. 2009, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static TextCellEditor textEditor = null;
    int position;
    boolean accessible = false;
    static int accessibleOverride = -1;
    TableViewer viewer;

    public PAEditingSupport(final TableViewer viewer, final int position) {
        super((ColumnViewer)viewer);
        this.getCellEditor();
        this.viewer = viewer;
        this.position = position;
        viewer.getTable().addListener(3, new Listener(){

            public void handleEvent(Event event) {
                PAEditingSupport.this.accessible = false;
            }
        });
        viewer.getTable().addListener(8, new Listener(){

            public void handleEvent(Event event) {
                TableItem[] selection = viewer.getTable().getSelection();
                if (selection.length != 1) {
                    return;
                }
                TableItem item = viewer.getTable().getSelection()[0];
                if (item.getBounds(position).contains(event.x, event.y)) {
                    PAEditingSupport.this.accessible = true;
                    viewer.editElement(item.getData(), position);
                    PAEditingSupport.this.accessible = false;
                }
            }
        });
        if (position == 0) {
            viewer.getTable().addKeyListener(new KeyListener(){

                public void keyReleased(KeyEvent e) {
                }

                public void keyPressed(KeyEvent e) {
                    if (e.keyCode == 13) {
                        if (PAEditingSupport.this.accessible) {
                            PAEditingSupport.this.accessible = false;
                            return;
                        }
                        TableItem[] selection = viewer.getTable().getSelection();
                        if (selection.length != 1) {
                            return;
                        }
                        TableItem item = viewer.getTable().getSelection()[0];
                        PAEditingSupport.this.accessible = true;
                        viewer.editElement(item.getData(), position);
                        PAEditingSupport.this.accessible = false;
                    } else if (e.keyCode == 27) {
                        PAEditingSupport.this.accessible = false;
                    }
                }
            });
        } else {
            viewer.getTable().addKeyListener(new KeyListener(){

                public void keyReleased(KeyEvent e) {
                }

                public void keyPressed(KeyEvent e) {
                    if (e.keyCode == 27) {
                        PAEditingSupport.this.accessible = false;
                    }
                }
            });
        }
    }

    protected boolean canEdit(Object element) {
        return this.accessible || this.position == accessibleOverride;
    }

    protected CellEditor getCellEditor(Object element) {
        return this.getCellEditor();
    }

    public TextCellEditor getCellEditor() {
        if (textEditor == null) {
            textEditor = new TextCellEditor((Composite)((TableViewer)this.getViewer()).getTable()){

                public boolean isCutEnabled() {
                    return false;
                }

                public boolean isPasteEnabled() {
                    return false;
                }

                public boolean isDeleteEnabled() {
                    return false;
                }

                public boolean isSaveAllEnabled() {
                    return false;
                }
            };
            textEditor.getControl().addTraverseListener(new TraverseListener(){

                public void keyTraversed(TraverseEvent e) {
                    switch (e.detail) {
                        case 16: {
                            e.doit = true;
                            PAEditingSupport.this.viewer.cancelEditing();
                            accessibleOverride = PAEditingSupport.this.position + 1;
                            PAEditingSupport.this.viewer.editElement(PAEditingSupport.this.viewer.getTable().getSelection()[0].getData(), accessibleOverride);
                            accessibleOverride = -1;
                            break;
                        }
                        case 8: {
                            e.doit = true;
                            PAEditingSupport.this.viewer.cancelEditing();
                            accessibleOverride = PAEditingSupport.this.position - 1;
                            PAEditingSupport.this.viewer.editElement(PAEditingSupport.this.viewer.getTable().getSelection()[0].getData(), accessibleOverride);
                            accessibleOverride = -1;
                        }
                    }
                }
            });
        }
        return textEditor;
    }

    protected Object getValue(Object element) {
        if (element instanceof String) {
            return element;
        }
        return DataTypeUtilities.getAsString(((Object[])element)[this.position]);
    }

    protected void setValue(Object element, Object value) {
    }
}

