/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.pa.ui.dialogs;

import com.ibm.cics.common.util.StringUtil;
import com.ibm.cics.eclipse.common.ui.TextInput;
import com.ibm.cics.pa.ui.Activator;
import com.ibm.cics.pa.ui.Messages;
import com.ibm.cics.pa.ui.utilities.SheetViewPersistenceManager;
import java.text.MessageFormat;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.PlatformUI;

public class SaveTemplateDialog
extends Dialog
implements ISelectionChangedListener,
ModifyListener,
IDoubleClickListener {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y23 (c) Copyright IBM Corp. 2008, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private Text text;
    TableViewer list;
    private Button okButton;
    private String templateName;
    private boolean ignoreSelection = false;
    String templateType;
    IViewPart view;
    private Button includeFilters;
    private String filterpresent;
    private String description;
    private static final int LIST_WIDTH = 40;
    private static final int TEXT_WIDTH = 40;
    private static final int LIST_HEIGHT = 14;

    public SaveTemplateDialog(IViewPart sheetView, String templateType, String filterText, String description) {
        super(sheetView.getSite().getShell());
        this.view = sheetView;
        this.templateType = templateType;
        this.filterpresent = filterText;
        this.description = description;
        this.setShellStyle(this.getShellStyle() | 0x10000000);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(Messages.getString("SaveTemplate_shellTitle"));
        shell.setImage(this.view.getTitleImage());
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)shell, "com.ibm.cics.pa.ui.sheetview_template_dialog");
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.okButton = this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
        this.updateButtons();
        this.text.setFocus();
    }

    protected Control createDialogArea(Composite parent) {
        Font font = parent.getFont();
        Composite composite = (Composite)super.createDialogArea(parent);
        Label descLabel = new Label(composite, 64);
        descLabel.setText(MessageFormat.format(Messages.getString("SaveTemplateDialog_description"), this.description));
        descLabel.setFont(parent.getFont());
        Label label = new Label(composite, 0);
        GridData data = new GridData();
        data.heightHint = 8;
        label.setLayoutData((Object)data);
        Composite nameGroup = new Composite(composite, 0);
        nameGroup.setLayoutData((Object)new GridData(768));
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        nameGroup.setLayout((Layout)layout);
        label = new Label(nameGroup, 0);
        label.setText(Messages.getString("SaveTemplate_name"));
        label.setFont(font);
        this.text = new Text(nameGroup, 2048);
        TextInput.setAccessibleLabel((Text)this.text, (Label)label);
        this.text.setFocus();
        data = new GridData(768);
        data.widthHint = this.convertWidthInCharsToPixels(40);
        this.text.setLayoutData((Object)data);
        this.text.setFont(font);
        this.text.addModifyListener((ModifyListener)this);
        label = new Label(composite, 0);
        data = new GridData();
        data.heightHint = 5;
        label.setLayoutData((Object)data);
        label = new Label(composite, 0);
        label.setText(Messages.getString("SaveTemplate_existing"));
        label.setFont(font);
        this.list = new TableViewer(composite, 2816);
        this.list.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public Image getImage(Object element) {
                return SaveTemplateDialog.this.view.getTitleImage();
            }
        });
        this.list.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public Object[] getElements(Object inputElement) {
                return SheetViewPersistenceManager.getInstance(SaveTemplateDialog.this.templateType).getTemplates().toArray();
            }
        });
        this.list.setComparator(new ViewerComparator());
        this.list.addSelectionChangedListener((ISelectionChangedListener)this);
        this.list.getTable().setFont(font);
        this.list.setInput(SheetViewPersistenceManager.getInstance(this.templateType).getTemplates());
        this.list.addDoubleClickListener((IDoubleClickListener)this);
        Control ctrl = this.list.getControl();
        GridData spec = new GridData(1808);
        spec.widthHint = this.convertWidthInCharsToPixels(40);
        spec.heightHint = this.convertHeightInCharsToPixels(14);
        ctrl.setLayoutData((Object)spec);
        if (StringUtil.hasContent((String)this.filterpresent)) {
            this.includeFilters = new Button(composite, 32);
            this.includeFilters.setText(Messages.getString("SaveTemplate.include.filters"));
        }
        this.text.selectAll();
        final IAction delete = this.deleteAction();
        MenuManager menuManager = new MenuManager();
        Menu popUpMenu = menuManager.createContextMenu(this.list.getControl());
        menuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                if (SaveTemplateDialog.this.list.getSelection().isEmpty()) {
                    return;
                }
                manager.add(delete);
            }
        });
        menuManager.setRemoveAllWhenShown(true);
        this.list.getTable().setMenu(popUpMenu);
        this.list.getTable().addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent e) {
                if (e.keyCode == 127) {
                    SaveTemplateDialog.this.doDelete();
                }
            }

            public void keyPressed(KeyEvent e) {
            }
        });
        return composite;
    }

    private IAction deleteAction() {
        Action deleteItem = new Action(Messages.getString("SaveTemplate.delete.template")){

            public void run() {
                SaveTemplateDialog.this.doDelete();
            }

            public ImageDescriptor getImageDescriptor() {
                return Activator.getDefault().getImageDescriptor("delete");
            }
        };
        return deleteItem;
    }

    protected void doDelete() {
        String message = NLS.bind((String)Messages.getString("SaveTemplate_deleteQuestion"), (Object)this.templateName);
        String[] buttons = new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL, IDialogConstants.CANCEL_LABEL};
        MessageDialog d = new MessageDialog(this.getShell(), Messages.getString("SaveTemplate_confirmDelete"), null, message, 3, buttons, 0){

            protected int getShellStyle() {
                return super.getShellStyle() | 0x10000000;
            }
        };
        if (d.open() == 0) {
            SheetViewPersistenceManager.getInstance(this.templateType).removeTemplateFilter(this.templateName);
            this.templateName = "";
            this.text.setText(this.templateName);
            this.list.setInput(SheetViewPersistenceManager.getInstance(this.templateType).getTemplates());
        }
    }

    public String getTemplateName() {
        return this.templateName;
    }

    public void modifyText(ModifyEvent e) {
        this.templateName = this.text.getText();
        this.ignoreSelection = true;
        if (this.templateName == null) {
            StructuredSelection sel = new StructuredSelection();
            this.list.setSelection((ISelection)sel);
        } else {
            StructuredSelection sel = new StructuredSelection((Object)this.templateName);
            this.list.setSelection((ISelection)sel);
        }
        this.ignoreSelection = false;
        this.updateButtons();
    }

    protected void okPressed() {
        this.templateName = this.text.getText();
        if (this.templateName != null && SheetViewPersistenceManager.getInstance(this.templateType).getTemplates().contains(this.templateName)) {
            String message = NLS.bind((String)Messages.getString("SaveTemplate_overwriteQuestion"), (Object)this.templateName);
            String[] buttons = new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL, IDialogConstants.CANCEL_LABEL};
            MessageDialog d = new MessageDialog(this.getShell(), Messages.getString("SaveTemplate_overwriteTitle"), null, message, 3, buttons, 0){

                protected int getShellStyle() {
                    return super.getShellStyle() | 0x10000000;
                }
            };
            switch (d.open()) {
                case 0: {
                    break;
                }
                case 1: {
                    return;
                }
                case 2: {
                    this.cancelPressed();
                    return;
                }
                default: {
                    return;
                }
            }
        }
        SheetViewPersistenceManager.getInstance(this.templateType).saveAsTemplate(this.templateName);
        SheetViewPersistenceManager.getInstance(this.templateType).saveTemplateFilter(this.templateName, this.includeFilters != null && this.includeFilters.getSelection() ? this.filterpresent : null);
        super.okPressed();
    }

    public void selectionChanged(SelectionChangedEvent event) {
        if (this.ignoreSelection) {
            return;
        }
        IStructuredSelection sel = (IStructuredSelection)this.list.getSelection();
        if (!sel.isEmpty()) {
            this.templateName = (String)sel.getFirstElement();
            this.text.setText(this.templateName);
        }
        this.updateButtons();
    }

    private void updateButtons() {
        if (this.okButton != null) {
            String label = this.text.getText();
            this.okButton.setEnabled(!StringUtil.isEmpty((String)label));
        }
    }

    public void doubleClick(DoubleClickEvent event) {
        if (!StringUtil.isEmpty((String)this.text.getText())) {
            this.setReturnCode(0);
            this.close();
        }
    }
}

