/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.pa.ui.dialogs;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.dbfunc.model.ColumnReference;
import com.ibm.cics.dbfunc.model.Selection;
import com.ibm.cics.eclipse.common.ui.TextInput;
import com.ibm.cics.eclipse.common.ui.Utilities;
import com.ibm.cics.pa.model.DateCaveat;
import com.ibm.cics.pa.model.ManifestRecord;
import com.ibm.cics.pa.model.PostRangeDateCaveat;
import com.ibm.cics.pa.model.PreRangeDateCaveat;
import com.ibm.cics.pa.model.RangeDateCaveat;
import com.ibm.cics.pa.model.definitions.ColumnDefinition;
import com.ibm.cics.pa.model.definitions.ReportStyle;
import com.ibm.cics.pa.ui.Activator;
import com.ibm.cics.pa.ui.Messages;
import com.ibm.cics.pa.ui.PluginConstants;
import com.ibm.cics.pa.ui.utilities.DataTypeUtilities;
import java.sql.Date;
import java.sql.Time;
import java.text.MessageFormat;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Map;
import java.util.logging.Logger;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DateTime;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.SelectionStatusDialog;

public class ParameterSolicitingDialog
extends SelectionStatusDialog {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y23 (c) Copyright IBM Corp. 2010, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private IEclipsePreferences pluginPreferences = Activator.getDefault().getPluginInstancePreferences();
    private Composite parameterGroup;
    private Selection selection;
    Map<ColumnDefinition, Object> references;
    Calendar afterCalendar = Calendar.getInstance();
    Calendar exactCalendar = Calendar.getInstance();
    Calendar beforeCalendar = Calendar.getInstance();
    private DateCaveat[] date;
    private Button fromtoDate;
    private Button exactDate;
    GridData explicitData;
    GridData rangeData;
    private Button fromDate;
    private Button toDate;
    private Button noDate;
    private String id;
    private ReportStyle style;
    boolean doOnlyOnce = false;
    DateTime after_date;
    DateTime after_time;
    DateTime before_date;
    DateTime before_time;
    Text intervalNumber;
    DateTime[] afterDateTime;
    DateTime[] beforeDateTime;
    static final Logger logger = Logger.getLogger("com.ibm.cics.pa.ui");
    private static final String BUTTON_TYPE = "button_type";
    private static final String FROM = "from";
    private static final String FROMTO = "fromto";
    private static final String TO = "to";
    private static final String EXACT = "exact";
    private static final String NONE = "none";

    public ParameterSolicitingDialog(Shell parent, Selection selection, ReportStyle style, Map<ColumnDefinition, Object> references, DateCaveat[] date) {
        super(parent);
        Debug.enter((Logger)logger, (String)((Object)((Object)this)).getClass().getName(), (String)"ParameterSolicitingDialog");
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.selection = selection;
        this.style = style;
        this.references = references;
        this.date = date;
        IWorkbenchPart currentPart = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActivePart();
        this.id = currentPart.getSite().getId();
        this.initialiseDateCaveat();
        Object value = references.get(ColumnDefinition.START_DATE);
        if (value != null) {
            try {
                if (value instanceof String) {
                    value = DataTypeUtilities.assignAppropriateCSVBasedObject(ColumnDefinition.START_DATE, (String)value);
                }
                this.exactCalendar.setTime((Date)value);
                value = references.get(ColumnDefinition.START_TIME);
                if (value != null) {
                    if (value instanceof String) {
                        value = DataTypeUtilities.assignAppropriateCSVBasedObject(ColumnDefinition.START_TIME, (String)value);
                    }
                    Calendar tempCalendar = Calendar.getInstance();
                    tempCalendar.setTime((Time)value);
                    this.exactCalendar.set(11, tempCalendar.get(11));
                    this.exactCalendar.set(12, tempCalendar.get(12));
                    this.exactCalendar.set(13, tempCalendar.get(13));
                }
            }
            catch (ParseException pe) {
                Debug.error((Logger)logger, (String)((Object)((Object)this)).getClass().getName(), (String)"ParameterSolicitingDialog", (Throwable)pe);
            }
        }
        this.setHelpAvailable(true);
        Debug.exit((Logger)logger, (String)((Object)((Object)this)).getClass().getName(), (String)"ParameterSolicitingDialog");
    }

    private DateCaveat initialiseDateCaveat() {
        this.afterCalendar = Calendar.getInstance();
        this.afterCalendar.add(6, -1);
        this.beforeCalendar = Calendar.getInstance();
        long alltime = Platform.getPreferencesService().getLong(Activator.getDefault().getBundle().getSymbolicName(), String.valueOf(this.id) + PluginConstants.AFTER_CALENDAR, 0L, null);
        if (alltime > 0L) {
            this.afterCalendar.setTimeInMillis(alltime);
        }
        if ((alltime = Platform.getPreferencesService().getLong(Activator.getDefault().getBundle().getSymbolicName(), String.valueOf(this.id) + PluginConstants.BEFORE_CALENDAR, 0L, null)) > 0L) {
            this.beforeCalendar.setTimeInMillis(alltime);
        }
        DateCaveat dateCaveat = DateCaveat.createRangeDateCaveat(this.afterCalendar.getTime(), this.beforeCalendar.getTime());
        return dateCaveat;
    }

    protected Control createContents(Composite parent) {
        Control control = super.createContents(parent);
        if (this.style == ReportStyle.Timeline) {
            this.fromtoDate.setSelection(true);
            this.explicitData.heightHint = 0;
            this.rangeData.heightHint = -1;
        } else {
            this.doOnlyOnce = true;
            this.fromtoDate.setSelection(false);
            this.exactDate.setSelection(true);
            this.explicitData.heightHint = -1;
            this.rangeData.heightHint = 0;
        }
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "com.ibm.cics.pa.ui.input_dialog");
        return control;
    }

    protected void configureShell(Shell shell) {
        Debug.enter((Logger)logger, (String)((Object)((Object)this)).getClass().getName(), (String)"configureShell");
        ManifestRecord record = ManifestRecord.getAlias((String)this.selection.getSelect().getTable().getLabels().keySet().toArray()[0]);
        shell.setText(MessageFormat.format(Messages.getString("ParameterDialog.table"), record.getDescription()));
        this.setImage(Activator.getDefault().getImage("table"));
        super.configureShell(shell);
        Debug.exit((Logger)logger, (String)((Object)((Object)this)).getClass().getName(), (String)"configureShell");
    }

    protected Control createDialogArea(Composite parent) {
        Debug.enter((Logger)logger, (String)((Object)((Object)this)).getClass().getName(), (String)"createDialogArea");
        ColumnReference[] columns = this.selection.getInputColumns().keySet().toArray(new ColumnReference[this.selection.getInputColumns().keySet().size()]);
        DataTypeUtilities.statColumnSorter(columns);
        final ColumnDefinition[] input = ColumnDefinition.convert(columns);
        this.createDateControl(parent, input);
        this.parameterGroup = (Composite)super.createDialogArea(parent);
        this.parameterGroup.setLayout((Layout)new GridLayout(1, false));
        this.parameterGroup.setLayoutData((Object)new GridData(1, 128, true, false));
        Control[] controlArray = this.parameterGroup.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control child = controlArray[n2];
            child.dispose();
            ++n2;
        }
        Composite pg1 = new Composite(this.parameterGroup, 0);
        pg1.setLayout((Layout)new GridLayout(3, false));
        pg1.setLayoutData((Object)new GridData(4, 128, true, false));
        GridData commentData = new GridData();
        commentData.widthHint = 200;
        commentData.grabExcessHorizontalSpace = true;
        GridData supplementalData = new GridData();
        supplementalData.grabExcessHorizontalSpace = true;
        GridData textData = new GridData();
        textData.widthHint = 75;
        textData.grabExcessHorizontalSpace = false;
        int i = 0;
        while (i < input.length) {
            if (input[i] != ColumnDefinition.START_DATE && input[i] != ColumnDefinition.START_TIME) {
                final int iteration = i;
                String label = input[iteration].getDBColumnRef();
                if (input[iteration] != ColumnDefinition.UNKNOWN) {
                    label = ColumnDefinition.getByDBColumnRef(label).getLabel(null);
                }
                Object value = this.references.get(input[iteration]);
                if (input[i] == ColumnDefinition.INTERVAL_TYPE) {
                    new Label(pg1, 0).setText(label);
                    final Combo text = new Combo(pg1, 12);
                    text.setLayoutData((Object)textData);
                    text.setItems(new String[]{"*", "INT", "EOD", "USS", "REQ", "RRT"});
                    if (value == null) {
                        text.setText("*");
                        this.references.put(input[iteration], text.getText());
                    } else {
                        text.setText(DataTypeUtilities.getAsString(value));
                    }
                    text.setData((Object)input[i]);
                    final Label extra1 = new Label(pg1, 0);
                    extra1.setText("");
                    text.addListener(24, new Listener(){

                        public void handleEvent(Event e) {
                            ParameterSolicitingDialog.this.references.put(input[iteration], text.getText());
                            extra1.setText(text.getText().equals("*") ? "" : Messages.getString("ParameterDialog.wildcard"));
                            extra1.redraw();
                        }
                    });
                } else {
                    switch (input[iteration].getType()) {
                        case Time: {
                            new Label(pg1, 0).setText(label);
                            final DateTime timedt = new DateTime(pg1, 2176);
                            final Calendar cal = Calendar.getInstance();
                            if (value != null) {
                                cal.setTime((Time)value);
                            }
                            timedt.setTime(cal.get(11), cal.get(12), cal.get(13));
                            timedt.addSelectionListener((SelectionListener)new SelectionAdapter(){

                                public void widgetSelected(SelectionEvent e) {
                                    cal.set(11, timedt.getHours());
                                    cal.set(12, timedt.getMinutes());
                                    cal.set(13, timedt.getSeconds());
                                    ParameterSolicitingDialog.this.references.put(input[iteration], new Time(cal.getTime().getTime()));
                                    ParameterSolicitingDialog.this.assessButtonReadiness();
                                }
                            });
                            timedt.setData((Object)input[i]);
                            Label extra2 = new Label(pg1, 0);
                            extra2.setText(Messages.getString("ParameterDialog.timeformat"));
                            break;
                        }
                        case Date: {
                            new Label(pg1, 0).setText(label);
                            final DateTime ddt = new DateTime(pg1, 2080);
                            final Calendar cal1 = Calendar.getInstance();
                            if (value != null) {
                                cal1.setTime((Date)value);
                            }
                            ddt.setDate(cal1.get(1), cal1.get(2), cal1.get(5));
                            ddt.addSelectionListener((SelectionListener)new SelectionAdapter(){

                                public void widgetSelected(SelectionEvent e) {
                                    cal1.set(1, ddt.getYear());
                                    cal1.set(2, ddt.getMonth());
                                    cal1.set(5, ddt.getDay());
                                    ParameterSolicitingDialog.this.references.put(input[iteration], new Date(cal1.getTime().getTime()));
                                    ParameterSolicitingDialog.this.assessButtonReadiness();
                                }
                            });
                            Label extra3 = new Label(pg1, 0);
                            extra3.setText(Messages.getString("ParameterDialog.dateformat"));
                            break;
                        }
                        case Timestamp: {
                            new Label(pg1, 0).setText(label);
                            final DateTime tsdt = new DateTime(pg1, 2080);
                            final Calendar cal2 = Calendar.getInstance();
                            if (value != null) {
                                cal2.setTime((Date)value);
                            }
                            tsdt.setDate(cal2.get(1), cal2.get(2), cal2.get(5));
                            tsdt.setDate(cal2.get(11), cal2.get(12), cal2.get(13));
                            tsdt.addSelectionListener((SelectionListener)new SelectionAdapter(){

                                public void widgetSelected(SelectionEvent e) {
                                    cal2.set(11, tsdt.getHours());
                                    cal2.set(12, tsdt.getMinutes());
                                    cal2.set(13, tsdt.getSeconds());
                                    cal2.set(1, tsdt.getYear());
                                    cal2.set(2, tsdt.getMonth());
                                    cal2.set(5, tsdt.getDay());
                                    ParameterSolicitingDialog.this.references.put(input[iteration], new Date(cal2.getTime().getTime()));
                                    ParameterSolicitingDialog.this.assessButtonReadiness();
                                }
                            });
                            Label extra4 = new Label(pg1, 0);
                            extra4.setText(Messages.getString("ParameterDialog.timestampformat"));
                            break;
                        }
                        case Double: 
                        case Integer: 
                        case Float: 
                        case BigDecimal: {
                            final Label extra6 = new Label(pg1, 0);
                            extra6.setText(label);
                            final Text numerictext = new Text(pg1, 133124);
                            TextInput.setAccessibleLabel((Text)numerictext, (Label)extra6);
                            numerictext.setLayoutData((Object)textData);
                            if (value != null) {
                                numerictext.setText(DataTypeUtilities.getAsString(value));
                            }
                            numerictext.addListener(25, new Listener(){

                                public void handleEvent(Event e) {
                                    String string = e.text;
                                    char[] chars = new char[string.length()];
                                    string.getChars(0, chars.length, chars, 0);
                                    int i = 0;
                                    while (i < chars.length) {
                                        if (chars[i] != '*' && ('0' > chars[i] || chars[i] > '9')) {
                                            e.doit = false;
                                            return;
                                        }
                                        ++i;
                                    }
                                }
                            });
                            final Label extra5 = new Label(pg1, 0);
                            extra5.setLayoutData((Object)supplementalData);
                            extra5.setText(Utilities.hasContent((Text)numerictext) ? "" : Messages.getString("ParameterDialog.wildcard"));
                            numerictext.addListener(24, new Listener(){

                                public void handleEvent(Event e) {
                                    try {
                                        ParameterSolicitingDialog.this.references.put(input[iteration], DataTypeUtilities.assignAppropriateCSVBasedObject(input[iteration], numerictext.getText()));
                                    }
                                    catch (ParseException e1) {
                                        Debug.error((Logger)logger, (String)this.getClass().getName(), (String)"tableSelected ", (Throwable)e1);
                                    }
                                    ParameterSolicitingDialog.this.assessButtonReadiness();
                                    extra5.setText(Utilities.hasContent((Text)numerictext) ? "" : Messages.getString("ParameterDialog.wildcard"));
                                }
                            });
                            if (input[iteration] == ColumnDefinition.INTERVAL_NUMBER) {
                                this.intervalNumber = numerictext;
                            }
                            numerictext.setData((Object)input[i]);
                            numerictext.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

                                public void getName(AccessibleEvent e) {
                                    e.result = Utilities.hasContent((Text)numerictext) ? String.valueOf(extra5.getText()) + ' ' + numerictext.getText() : (Utilities.hasContent((Text)numerictext) ? String.valueOf(extra6.getText()) + ' ' + numerictext.getText() : String.valueOf(extra6.getText()) + ' ' + numerictext.getText() + Messages.getString("Jaws.blank") + Messages.getString("ParameterDialog.wildcard"));
                                }
                            });
                            break;
                        }
                        case Boolean: {
                            Label lb = new Label(pg1, 0);
                            lb.setText(label);
                            Text bool = new Text(pg1, 2052);
                            TextInput.setAccessibleLabel((Text)bool, (Label)lb);
                            bool.setData((Object)input[i]);
                            new Label(pg1, 0);
                            break;
                        }
                        default: {
                            final Label l3 = new Label(pg1, 0);
                            l3.setText(label);
                            final Text text = new Text(pg1, 2052);
                            TextInput.setAccessibleLabel((Text)text, (Label)l3);
                            text.setLayoutData((Object)textData);
                            if (value != null) {
                                text.setText(DataTypeUtilities.getAsString(value));
                            }
                            text.setData((Object)input[i]);
                            final Label l2 = new Label(pg1, 0);
                            l2.setLayoutData((Object)supplementalData);
                            l2.setText(Utilities.hasContent((Text)text) ? "" : Messages.getString("ParameterDialog.wildcard"));
                            text.addListener(24, new Listener(){

                                public void handleEvent(Event e) {
                                    ParameterSolicitingDialog.this.references.put(input[iteration], text.getText());
                                    ParameterSolicitingDialog.this.assessButtonReadiness();
                                    l2.setText(Utilities.hasContent((Text)text) ? "" : Messages.getString("ParameterDialog.wildcard"));
                                }
                            });
                            text.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

                                public void getName(AccessibleEvent e) {
                                    e.result = Utilities.hasContent((Text)text) ? String.valueOf(l3.getText()) + ' ' + text.getText() : String.valueOf(l3.getText()) + ' ' + Messages.getString("Jaws.blank") + Messages.getString("ParameterDialog.wildcard");
                                }
                            });
                        }
                    }
                }
            }
            ++i;
        }
        pg1.layout();
        this.parameterGroup.layout();
        this.parameterGroup.getParent().layout();
        this.parameterGroup.getParent().getShell().layout();
        Debug.exit((Logger)logger, (String)((Object)((Object)this)).getClass().getName(), (String)"createDialogArea", (Object)this.parameterGroup);
        return this.parameterGroup;
    }

    private DateTime[] dateSpecific(Composite parent, final Calendar cal1, String text) {
        Debug.enter((Logger)logger, (String)((Object)((Object)this)).getClass().getName(), (String)"dateSpecific");
        new Label(parent, 0).setText(text);
        final DateTime ddt = new DateTime(parent, 2080);
        ddt.setDate(cal1.get(1), cal1.get(2), cal1.get(5));
        ddt.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                cal1.set(1, ddt.getYear());
                cal1.set(2, ddt.getMonth());
                cal1.set(5, ddt.getDay());
                ParameterSolicitingDialog.this.assessButtonReadiness();
            }
        });
        final DateTime tdt = new DateTime(parent, 2176);
        tdt.setTime(cal1.get(11), cal1.get(12), cal1.get(13));
        tdt.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                cal1.set(11, tdt.getHours());
                cal1.set(12, tdt.getMinutes());
                cal1.set(13, tdt.getSeconds());
            }
        });
        Debug.exit((Logger)logger, (String)((Object)((Object)this)).getClass().getName(), (String)"dateSpecific");
        return new DateTime[]{ddt, tdt};
    }

    private void timelineSpecific(Composite parent) {
        Debug.enter((Logger)logger, (String)((Object)((Object)this)).getClass().getName(), (String)"timelineSpecific");
        new Label(parent, 0).setText(Messages.getString("PostRangeDateCaveat_records_after"));
        this.after_date = new DateTime(parent, 2080);
        if (this.afterCalendar != null) {
            this.after_date.setDate(this.afterCalendar.get(1), this.afterCalendar.get(2), this.afterCalendar.get(5));
        }
        this.after_date.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ParameterSolicitingDialog.this.afterCalendar.set(1, ParameterSolicitingDialog.this.after_date.getYear());
                ParameterSolicitingDialog.this.afterCalendar.set(2, ParameterSolicitingDialog.this.after_date.getMonth());
                ParameterSolicitingDialog.this.afterCalendar.set(5, ParameterSolicitingDialog.this.after_date.getDay());
                ParameterSolicitingDialog.this.assessButtonReadiness();
            }
        });
        this.after_time = new DateTime(parent, 2176);
        if (this.afterCalendar != null) {
            this.after_time.setTime(this.afterCalendar.get(11), this.afterCalendar.get(12), this.afterCalendar.get(13));
        }
        this.after_time.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ParameterSolicitingDialog.this.afterCalendar.set(11, ParameterSolicitingDialog.this.after_time.getHours());
                ParameterSolicitingDialog.this.afterCalendar.set(12, ParameterSolicitingDialog.this.after_time.getMinutes());
                ParameterSolicitingDialog.this.afterCalendar.set(13, ParameterSolicitingDialog.this.after_time.getSeconds());
                ParameterSolicitingDialog.this.assessButtonReadiness();
            }
        });
        new Label(parent, 0).setText(Messages.getString("PreRangeDateCaveat_Prior"));
        this.before_date = new DateTime(parent, 2080);
        if (this.beforeCalendar != null) {
            this.before_date.setDate(this.beforeCalendar.get(1), this.beforeCalendar.get(2), this.beforeCalendar.get(5));
        }
        this.before_date.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ParameterSolicitingDialog.this.beforeCalendar.set(1, ParameterSolicitingDialog.this.before_date.getYear());
                ParameterSolicitingDialog.this.beforeCalendar.set(2, ParameterSolicitingDialog.this.before_date.getMonth());
                ParameterSolicitingDialog.this.beforeCalendar.set(5, ParameterSolicitingDialog.this.before_date.getDay());
                ParameterSolicitingDialog.this.assessButtonReadiness();
            }
        });
        this.before_time = new DateTime(parent, 2176);
        if (this.beforeCalendar != null) {
            this.before_time.setTime(this.beforeCalendar.get(11), this.beforeCalendar.get(12), this.beforeCalendar.get(13));
        }
        this.before_time.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ParameterSolicitingDialog.this.beforeCalendar.set(11, ParameterSolicitingDialog.this.before_time.getHours());
                ParameterSolicitingDialog.this.beforeCalendar.set(12, ParameterSolicitingDialog.this.before_time.getMinutes());
                ParameterSolicitingDialog.this.beforeCalendar.set(13, ParameterSolicitingDialog.this.before_time.getSeconds());
                ParameterSolicitingDialog.this.assessButtonReadiness();
            }
        });
        Debug.exit((Logger)logger, (String)((Object)((Object)this)).getClass().getName(), (String)"timelineSpecific");
    }

    void assessButtonReadiness() {
        Debug.enter((Logger)logger, (String)((Object)((Object)this)).getClass().getName(), (String)"assessButtonReadiness");
        boolean isGood = true;
        boolean validDate = true;
        boolean allAsterisk = true;
        Control[] controlArray = this.parameterGroup.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control child = controlArray[n2];
            if (child instanceof Composite) {
                Control[] controlArray2 = ((Composite)child).getChildren();
                int n3 = controlArray2.length;
                int n4 = 0;
                while (n4 < n3) {
                    Control child1 = controlArray2[n4];
                    if (child1 instanceof Text) {
                        if (!Utilities.hasContent((Text)((Text)child1))) {
                            isGood = false;
                        } else if (!((Text)child1).getText().equals("*")) {
                            allAsterisk = false;
                        }
                    }
                    ++n4;
                }
            }
            ++n2;
        }
        if (this.fromtoDate.getSelection() && this.beforeCalendar.before(this.afterCalendar)) {
            validDate = false;
        }
        Status status = isGood ? (validDate ? (allAsterisk ? new Status(2, "com.ibm.cics.pa.ui", Messages.getString("Inquiries.noCriteria")) : Status.OK_STATUS) : new Status(4, "com.ibm.cics.pa.ui", Messages.getString("Inquiries.invalidDate"))) : new Status(4, "com.ibm.cics.pa.ui", Messages.getString("Inquiries.notAllEntryFields"));
        this.updateStatus((IStatus)status);
        Debug.exit((Logger)logger, (String)((Object)((Object)this)).getClass().getName(), (String)"assessButtonReadiness");
    }

    public void create() {
        super.create();
        this.assessButtonReadiness();
    }

    protected void okPressed() {
        super.okPressed();
    }

    private Composite createDateControl(final Composite parent, ColumnDefinition[] input) {
        Composite control = new Composite(parent, 0);
        GridLayout lay1 = new GridLayout(1, true);
        lay1.marginHeight = 0;
        control.setLayout((Layout)lay1);
        control.setLayoutData((Object)new GridData(1, 128, true, false));
        final Group radioGroup = new Group(control, 0);
        radioGroup.setText(Messages.getString("ParameterDialog.DateRange"));
        radioGroup.setLayout((Layout)new GridLayout(1, false));
        Composite radioComposite = new Composite((Composite)radioGroup, 0);
        radioComposite.setLayout((Layout)new GridLayout(3, true));
        radioComposite.setLayoutData((Object)new GridData(1, 128, true, false));
        Composite range = new Composite((Composite)radioGroup, 0);
        this.rangeData = new GridData(4, 128, true, true);
        this.rangeData.heightHint = -1;
        GridLayout layout = new GridLayout(3, true);
        layout.marginHeight = 0;
        range.setLayout((Layout)layout);
        range.setLayoutData((Object)this.rangeData);
        this.timelineSpecific(range);
        Composite explicit = new Composite((Composite)radioGroup, 0);
        this.explicitData = new GridData(4, 128, true, true);
        layout = new GridLayout(3, true);
        layout.marginHeight = 0;
        explicit.setLayout((Layout)layout);
        explicit.setLayoutData((Object)this.explicitData);
        this.explicitData.heightHint = 0;
        this.dateSpecific(explicit, this.exactCalendar, Messages.getString("ParameterDialog.exactDate"));
        Composite from = new Composite((Composite)radioGroup, 0);
        final GridData fromData = new GridData(4, 128, true, true);
        layout = new GridLayout(3, true);
        layout.marginHeight = 0;
        from.setLayout((Layout)layout);
        from.setLayoutData((Object)fromData);
        fromData.heightHint = 0;
        this.afterDateTime = this.dateSpecific(from, this.afterCalendar, Messages.getString("ParameterDialog.fromDate"));
        Composite to = new Composite((Composite)radioGroup, 0);
        final GridData toData = new GridData(4, 128, true, true);
        layout = new GridLayout(3, true);
        layout.marginHeight = 0;
        to.setLayout((Layout)layout);
        to.setLayoutData((Object)toData);
        toData.heightHint = 0;
        this.beforeDateTime = this.dateSpecific(to, this.beforeCalendar, Messages.getString("ParameterDialog.toDate"));
        SelectionAdapter adapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ParameterSolicitingDialog.this.explicitData.heightHint = 0;
                ParameterSolicitingDialog.this.rangeData.heightHint = 0;
                fromData.heightHint = 0;
                toData.heightHint = 0;
                if (((Button)e.getSource()).getSelection()) {
                    String ref = (String)((Button)e.getSource()).getData(ParameterSolicitingDialog.BUTTON_TYPE);
                    if (ref.equals(ParameterSolicitingDialog.EXACT)) {
                        ParameterSolicitingDialog.this.explicitData.heightHint = -1;
                    } else if (ref.equals(ParameterSolicitingDialog.FROM)) {
                        if (ParameterSolicitingDialog.this.doOnlyOnce) {
                            ParameterSolicitingDialog.this.doOnlyOnce = false;
                            ParameterSolicitingDialog.this.afterCalendar.setTime(ParameterSolicitingDialog.this.exactCalendar.getTime());
                            ParameterSolicitingDialog.this.afterCalendar.add(11, -6);
                            ParameterSolicitingDialog.this.afterDateTime[0].setDate(ParameterSolicitingDialog.this.afterCalendar.get(1), ParameterSolicitingDialog.this.afterCalendar.get(2), ParameterSolicitingDialog.this.afterCalendar.get(5));
                            ParameterSolicitingDialog.this.afterDateTime[1].setTime(ParameterSolicitingDialog.this.afterCalendar.get(11), ParameterSolicitingDialog.this.afterCalendar.get(12), ParameterSolicitingDialog.this.afterCalendar.get(13));
                            if (ParameterSolicitingDialog.this.intervalNumber != null) {
                                ParameterSolicitingDialog.this.intervalNumber.setText("*");
                            }
                            ParameterSolicitingDialog.this.after_date.layout();
                            ParameterSolicitingDialog.this.after_time.layout();
                        }
                        fromData.heightHint = -1;
                    } else if (ref.equals(ParameterSolicitingDialog.TO)) {
                        if (ParameterSolicitingDialog.this.doOnlyOnce) {
                            ParameterSolicitingDialog.this.doOnlyOnce = false;
                            ParameterSolicitingDialog.this.beforeCalendar.setTime(ParameterSolicitingDialog.this.exactCalendar.getTime());
                            ParameterSolicitingDialog.this.beforeCalendar.add(11, 6);
                            ParameterSolicitingDialog.this.beforeDateTime[0].setDate(ParameterSolicitingDialog.this.beforeCalendar.get(1), ParameterSolicitingDialog.this.beforeCalendar.get(2), ParameterSolicitingDialog.this.beforeCalendar.get(5));
                            ParameterSolicitingDialog.this.beforeDateTime[1].setTime(ParameterSolicitingDialog.this.beforeCalendar.get(11), ParameterSolicitingDialog.this.beforeCalendar.get(12), ParameterSolicitingDialog.this.beforeCalendar.get(13));
                            if (ParameterSolicitingDialog.this.intervalNumber != null) {
                                ParameterSolicitingDialog.this.intervalNumber.setText("*");
                            }
                        }
                        toData.heightHint = -1;
                    } else if (ref.equals(ParameterSolicitingDialog.FROMTO)) {
                        if (ParameterSolicitingDialog.this.doOnlyOnce) {
                            ParameterSolicitingDialog.this.doOnlyOnce = false;
                            ParameterSolicitingDialog.this.afterCalendar.setTime(ParameterSolicitingDialog.this.exactCalendar.getTime());
                            ParameterSolicitingDialog.this.afterCalendar.add(11, -6);
                            ParameterSolicitingDialog.this.after_date.setDate(ParameterSolicitingDialog.this.afterCalendar.get(1), ParameterSolicitingDialog.this.afterCalendar.get(2), ParameterSolicitingDialog.this.afterCalendar.get(5));
                            ParameterSolicitingDialog.this.after_time.setTime(ParameterSolicitingDialog.this.afterCalendar.get(11), ParameterSolicitingDialog.this.afterCalendar.get(12), ParameterSolicitingDialog.this.afterCalendar.get(13));
                            ParameterSolicitingDialog.this.beforeCalendar.setTime(ParameterSolicitingDialog.this.exactCalendar.getTime());
                            ParameterSolicitingDialog.this.beforeCalendar.add(11, 6);
                            ParameterSolicitingDialog.this.before_date.setDate(ParameterSolicitingDialog.this.beforeCalendar.get(1), ParameterSolicitingDialog.this.beforeCalendar.get(2), ParameterSolicitingDialog.this.beforeCalendar.get(5));
                            ParameterSolicitingDialog.this.before_time.setTime(ParameterSolicitingDialog.this.beforeCalendar.get(11), ParameterSolicitingDialog.this.beforeCalendar.get(12), ParameterSolicitingDialog.this.beforeCalendar.get(13));
                            if (ParameterSolicitingDialog.this.intervalNumber != null) {
                                ParameterSolicitingDialog.this.intervalNumber.setText("*");
                            }
                        }
                        ParameterSolicitingDialog.this.rangeData.heightHint = -1;
                    } else if (ref.equals(ParameterSolicitingDialog.NONE) && ParameterSolicitingDialog.this.doOnlyOnce && ParameterSolicitingDialog.this.intervalNumber != null) {
                        ParameterSolicitingDialog.this.doOnlyOnce = false;
                        ParameterSolicitingDialog.this.intervalNumber.setText("*");
                    }
                    radioGroup.layout();
                    parent.layout();
                    parent.getParent().pack();
                    ParameterSolicitingDialog.this.assessButtonReadiness();
                }
            }
        };
        this.fromDate = new Button(radioComposite, 16);
        this.fromDate.setData(BUTTON_TYPE, (Object)FROM);
        this.fromDate.setText(Messages.getString("ParameterDialog.fromDate"));
        this.fromDate.addSelectionListener((SelectionListener)adapter);
        this.toDate = new Button(radioComposite, 16);
        this.toDate.setData(BUTTON_TYPE, (Object)TO);
        this.toDate.setText(Messages.getString("ParameterDialog.toDate"));
        this.toDate.addSelectionListener((SelectionListener)adapter);
        this.fromtoDate = new Button(radioComposite, 16);
        this.fromtoDate.setData(BUTTON_TYPE, (Object)FROMTO);
        this.fromtoDate.setText(Messages.getString("ParameterDialog.fromtoDate"));
        this.fromtoDate.addSelectionListener((SelectionListener)adapter);
        this.exactDate = new Button(radioComposite, 16);
        this.exactDate.setData(BUTTON_TYPE, (Object)EXACT);
        this.exactDate.setText(Messages.getString("ParameterDialog.exactDate"));
        this.exactDate.addSelectionListener((SelectionListener)adapter);
        this.noDate = new Button(radioComposite, 16);
        this.noDate.setData(BUTTON_TYPE, (Object)NONE);
        this.noDate.setText(Messages.getString("ParameterDialog.noDate"));
        this.noDate.addSelectionListener((SelectionListener)adapter);
        if (this.style == ReportStyle.Detail) {
            this.noDate.setEnabled(false);
            this.fromtoDate.setEnabled(false);
            this.toDate.setEnabled(false);
            this.fromDate.setEnabled(false);
        } else if (this.style == ReportStyle.Timeline) {
            this.exactDate.setEnabled(false);
        }
        control.layout();
        parent.getShell().layout();
        return control;
    }

    protected void computeResult() {
        this.date[0] = this.noDate.getSelection() ? DateCaveat.createRangeDateCaveat(null, null) : (this.exactDate.getSelection() ? DateCaveat.createSpecificDateCaveat(this.exactCalendar.getTime()) : (this.fromDate.getSelection() ? DateCaveat.createRangeDateCaveat(this.afterCalendar.getTime(), null) : (this.toDate.getSelection() ? DateCaveat.createRangeDateCaveat(null, this.beforeCalendar.getTime()) : DateCaveat.createRangeDateCaveat(this.afterCalendar.getTime(), this.beforeCalendar.getTime()))));
        if (this.date[0] instanceof PostRangeDateCaveat || this.date[0] instanceof RangeDateCaveat) {
            this.pluginPreferences.putLong(String.valueOf(this.id) + PluginConstants.AFTER_CALENDAR, this.date[0].getStartTimeInMillis());
        }
        if (this.date[0] instanceof PreRangeDateCaveat || this.date[0] instanceof RangeDateCaveat) {
            this.pluginPreferences.putLong(String.valueOf(this.id) + PluginConstants.BEFORE_CALENDAR, this.date[0].getEndTimeInMillis());
        }
    }
}

