/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.pa.ui;

import com.ibm.cics.common.util.StringUtil;
import com.ibm.cics.dbfunc.model.Presentation;
import com.ibm.cics.dbfunc.model.PresentationFactory;
import com.ibm.cics.pa.model.AlertElement;
import com.ibm.cics.pa.model.ChartType;
import com.ibm.cics.pa.model.IUniqueRecord;
import com.ibm.cics.pa.model.ManifestRecord;
import com.ibm.cics.pa.model.definitions.CategorisationHelper;
import com.ibm.cics.pa.model.definitions.ColumnDefinition;
import com.ibm.cics.pa.model.definitions.DataProviderKey;
import com.ibm.cics.pa.ui.PAContextTracker;
import com.ibm.cics.pa.ui.menus.Stats;
import com.ibm.cics.pa.ui.remote.PAConnectionTracker;
import com.ibm.cics.pa.ui.remote.RemoteUniqueRecord;
import com.ibm.cics.pa.ui.views.SheetView;
import java.util.List;
import java.util.Set;
import org.eclipse.core.expressions.PropertyTester;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;

public class SelectionTester
extends PropertyTester {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y23 (c) Copyright IBM Corp. 2010, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean test(Object receiver, String property, Object[] args, Object expectedValue) {
        if (property.equals("hasintervaltracker") && receiver instanceof List && ((List)receiver).size() > 0 && ((List)receiver).get(0) instanceof AlertElement) {
            AlertElement element = (AlertElement)((List)receiver).get(0);
            String alias1 = element.getTableAlias();
            if (!StringUtil.hasContent((String)alias1)) return false;
            ManifestRecord record = ManifestRecord.getAlias(alias1);
            if (record == null) return false;
            String manifest = record.getAlias();
            for (String alias : CategorisationHelper.getPossibleIntervalTables()) {
                if (!manifest.startsWith(alias)) continue;
                return true;
            }
            return false;
        } else if (property.equals("parsable") && receiver instanceof IFile) {
            try {
                if (!PresentationFactory.getInstance().possibleSelectionObject(((IFile)receiver).getContents())) return false;
                return true;
            }
            catch (CoreException element) {
                return false;
            }
        } else {
            if (property.equals("alert")) {
                if (!(receiver instanceof AlertElement)) return false;
                if (!((AlertElement)receiver).canBeOpened()) return false;
                return true;
            }
            if (property.equals("stats")) {
                return PAContextTracker.getInstance().isStatsManifest();
            }
            if (property.equals("timeline")) {
                if (!(receiver instanceof Presentation)) return false;
                if (ChartType.deriveFrom(((Presentation)receiver).getImplType()) != ChartType.COMPACT_HISTOGRAM) return false;
                return true;
            }
            if (property.equals("isconnected")) {
                return PAConnectionTracker.getInstance().isConnected();
            }
            if (!(receiver instanceof List)) return false;
            if (((List)receiver).size() <= 0) return false;
            if (!(((List)receiver).get(0) instanceof IUniqueRecord)) return false;
            if (property.equals("performance")) {
                if (!(((List)receiver).get(0) instanceof IUniqueRecord)) return false;
                if (((IUniqueRecord)((List)receiver).get(0)).getSourceProvider().getDataProviderKey() == DataProviderKey.STARTTIME_APPLID_TRAN) return true;
                if (((IUniqueRecord)((List)receiver).get(0)).getSourceProvider().getDataProviderKey() != DataProviderKey.STARTTIME_APPLICATION) return false;
                return true;
            }
            if (property.equals("performance_list")) {
                if (!(((List)receiver).get(0) instanceof IUniqueRecord)) return false;
                if (((IUniqueRecord)((List)receiver).get(0)).getSourceProvider().getDataProviderKey() != DataProviderKey.PERFORMANCE_LIST) return false;
                return true;
            }
            if (property.equals("hasintervaltracker") && ((List)receiver).get(0) instanceof RemoteUniqueRecord) {
                ManifestRecord currentManifest = PAContextTracker.getInstance().getCurrentManifest();
                if (currentManifest == null) {
                    return false;
                }
                String manifest = currentManifest.getAlias();
                IUniqueRecord record = (IUniqueRecord)((List)receiver).get(0);
                return CategorisationHelper.validateIntervalTrackerTable(manifest, record);
            }
            if (!(((List)receiver).get(0) instanceof RemoteUniqueRecord)) return false;
            if (ColumnDefinition.getByDBColumnRef(property) == null) return false;
            RemoteUniqueRecord record = (RemoteUniqueRecord)((List)receiver).get(0);
            IWorkbenchPart part = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActivePart();
            if (part == null) return false;
            if (!(part instanceof SheetView)) {
                return false;
            }
            Set<ColumnDefinition> columnDefs = record.getCompleteMapping(false).keySet();
            if (!columnDefs.contains(ColumnDefinition.getByDBColumnRef(property))) return false;
            if (PAContextTracker.getInstance().getCurrentManifest() == null) return false;
            if (PAContextTracker.getInstance().getCurrentManifest().getKey() == DataProviderKey.STARTTIME_APPLID_TRAN) return false;
            if (PAContextTracker.getInstance().getCurrentManifest().getKey() == DataProviderKey.STARTTIME_APPLICATION) return false;
            if (!Stats.findLinks(part, property).isEmpty()) return true;
            return false;
        }
    }
}

