/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.pa.model.definitions;

import com.ibm.cics.pa.model.ChartType;
import com.ibm.cics.pa.model.definitions.ChartSpecificDefinitions;
import com.ibm.cics.pa.model.definitions.ColumnContainment;
import com.ibm.cics.pa.model.definitions.ColumnDefinition;
import com.ibm.cics.pa.ui.utilities.MessagePackage;
import java.util.ArrayList;
import java.util.List;

public class HistogramChartSpecificDefinitions
implements ChartSpecificDefinitions {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y23 (c) Copyright IBM Corp. 2009, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private ColumnDefinition[] primaryColumnElements;
    private ColumnDefinition[] secondaryColumnElements;
    private String leftVerticalLabel;
    private String rightVerticalLabel;
    private String title;
    private ColumnContainment componentColumns;
    private MessagePackage columnLabel;
    public final int defaultBarIncrementWidth = 40;
    public final int defaultBarWidth = 30;

    @Override
    public ChartType getChartType() {
        return ChartType.HISTOGRAM;
    }

    public HistogramChartSpecificDefinitions(ColumnContainment componentColumn, String leftVerticalLabel, String rightVerticalLabel, String title, MessagePackage columnLabel) {
        this.leftVerticalLabel = leftVerticalLabel;
        this.rightVerticalLabel = rightVerticalLabel;
        this.columnLabel = columnLabel;
        this.title = title;
        this.componentColumns = componentColumn;
        this.primaryColumnElements = componentColumn.getColumnRef();
        this.secondaryColumnElements = new ColumnDefinition[0];
    }

    public HistogramChartSpecificDefinitions(ColumnDefinition[] primaryColumnElements, ColumnDefinition[] secondaryColumnElements, String leftVerticalLabel, String rightVerticalLabel, String title, MessagePackage columnLabel) {
        this.leftVerticalLabel = leftVerticalLabel;
        this.rightVerticalLabel = rightVerticalLabel;
        this.columnLabel = columnLabel;
        this.title = title;
        this.primaryColumnElements = primaryColumnElements;
        this.secondaryColumnElements = secondaryColumnElements;
    }

    public ColumnDefinition[] getPrimaryReqts() {
        return this.primaryColumnElements;
    }

    public ColumnDefinition[] getSecondaryReqts() {
        return this.secondaryColumnElements;
    }

    public String getAxisy1() {
        return this.leftVerticalLabel;
    }

    public String getAxisy2() {
        return this.rightVerticalLabel;
    }

    public String getPrimaryDescription() {
        return this.title;
    }

    public ColumnContainment getContainment() {
        return this.componentColumns;
    }

    public MessagePackage getPkg() {
        return this.columnLabel;
    }

    @Override
    public List<ColumnDefinition> getAllColumns() {
        ArrayList<ColumnDefinition> results = new ArrayList<ColumnDefinition>();
        int i = 0;
        while (i < this.primaryColumnElements.length) {
            if (!results.contains(this.primaryColumnElements[i])) {
                results.add(this.primaryColumnElements[i]);
            }
            ++i;
        }
        i = 0;
        while (i < this.secondaryColumnElements.length) {
            if (!results.contains(this.secondaryColumnElements[i])) {
                results.add(this.secondaryColumnElements[i]);
            }
            ++i;
        }
        if (this.componentColumns != null) {
            results.add(this.componentColumns.getPrimary());
            ColumnDefinition[] columnDefinitionArray = this.componentColumns.getColumnRef();
            int n = columnDefinitionArray.length;
            int n2 = 0;
            while (n2 < n) {
                ColumnDefinition defn = columnDefinitionArray[n2];
                if (!results.contains(defn)) {
                    results.add(defn);
                }
                ++n2;
            }
        }
        return results;
    }

    @Override
    public int getDefaultIncrementWidth() {
        return 40;
    }

    @Override
    public int getDefaultWidth() {
        return 30;
    }
}

