/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.pa.model.definitions;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.common.util.StringUtil;
import com.ibm.cics.dbfunc.model.ColumnReference;
import com.ibm.cics.dbfunc.model.Presentation;
import com.ibm.cics.pa.model.ChartType;
import com.ibm.cics.pa.model.GenericDataProvider;
import com.ibm.cics.pa.model.IUniqueRecord;
import com.ibm.cics.pa.model.ManifestRecord;
import com.ibm.cics.pa.model.TreeElement;
import com.ibm.cics.pa.model.definitions.AbstractChartDefinition;
import com.ibm.cics.pa.model.definitions.ChartCategorisation;
import com.ibm.cics.pa.model.definitions.ChartSpecification;
import com.ibm.cics.pa.model.definitions.ColumnAssociationMapper;
import com.ibm.cics.pa.model.definitions.ColumnDefinition;
import com.ibm.cics.pa.model.definitions.PersistedChartDefinition;
import com.ibm.cics.pa.ui.Activator;
import com.ibm.cics.pa.ui.PAContextTracker;
import com.ibm.cics.pa.ui.QueryCache;
import com.ibm.cics.pa.ui.utilities.PredefinedTemplate;
import com.ibm.cics.pa.ui.views.ChartView;
import com.ibm.cics.pa.ui.views.PieView;
import com.ibm.cics.pa.ui.views.SheetView;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.navigator.CommonNavigator;

public class CategorisationHelper {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y23 (c) Copyright IBM Corp. 2008, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Logger logger = Logger.getLogger(CategorisationHelper.class.getPackage().getName());
    private static Map<ColumnDefinition, ChartCategorisation> propertyCategorization = null;

    public static List<ChartSpecification> getChartsForCategorisation(ChartCategorisation categorisation) {
        Debug.enter((Logger)logger, (String)CategorisationHelper.class.getName(), (String)"getChartsForCategorisation");
        ArrayList<ChartSpecification> results = new ArrayList<ChartSpecification>();
        for (ChartSpecification chartSpecification : AbstractChartDefinition.getDefinitions()) {
            ChartCategorisation[] chartCategorisationArray = chartSpecification.getCategorisation();
            int n = chartCategorisationArray.length;
            int n2 = 0;
            while (n2 < n) {
                ChartCategorisation cat = chartCategorisationArray[n2];
                if (cat == categorisation && !results.contains(chartSpecification)) {
                    results.add(chartSpecification);
                }
                ++n2;
            }
        }
        Debug.exit((Logger)logger, (String)CategorisationHelper.class.getName(), (String)"getChartsForCategorisation", results);
        return results;
    }

    public static ChartSpecification getNextChartFor(ChartSpecification currentChart) {
        Presentation presentation = QueryCache.getInstance().getAppropriatePresentation("HST_CPU_time_pie", null);
        return PersistedChartDefinition.getDefinition(presentation);
    }

    public static List<ChartSpecification> getPossibleMultipleSelections(GenericDataProvider dataProvider, String tableAlias) {
        List<ChartSpecification> result = new ArrayList<ChartSpecification>();
        if (dataProvider != null && dataProvider.isValid()) {
            result = CategorisationHelper.getPossibleMultipleSelections(tableAlias);
        }
        return result;
    }

    public static List<ChartSpecification> getPossibleSingleSelections(GenericDataProvider dataProvider) {
        dataProvider.getDataProviderKey();
        List<ChartSpecification> result = new ArrayList<ChartSpecification>();
        if (dataProvider.isValid()) {
            result = CategorisationHelper.getPossibleSingleSelections(Arrays.asList(dataProvider.getColumnDefinitions()));
        }
        return result;
    }

    private static List<ChartSpecification> getPossibleSingleSelections(List<ColumnDefinition> columnDefns) {
        LinkedList<ChartSpecification> result = new LinkedList<ChartSpecification>();
        for (ChartCategorisation catg : EnumSet.allOf(ChartCategorisation.class)) {
            if (!CategorisationHelper.isTicked(catg.name())) continue;
            Presentation[] presentationArray = QueryCache.getInstance().getAllPresentations();
            int n = presentationArray.length;
            int n2 = 0;
            while (n2 < n) {
                Presentation presentation = presentationArray[n2];
                if (catg == ChartCategorisation.getByName(presentation.getParameter("categorisation")) && ChartType.deriveFrom(presentation.getImplType()) != ChartType.HISTOGRAM && ChartType.deriveFrom(presentation.getImplType()) != ChartType.COMPACT_HISTOGRAM && ChartType.deriveFrom(presentation.getImplType()) != ChartType.LINE && ChartType.deriveFrom(presentation.getImplType()) != ChartType.INTERVAL_PLOT && ChartType.deriveFrom(presentation.getImplType()) != ChartType.COMBINEDHISTOGRAMLINE) {
                    PersistedChartDefinition pcd;
                    ColumnReference[] columns = presentation.getInputColumns().keySet().toArray(new ColumnReference[presentation.getInputColumns().keySet().size()]);
                    List<ColumnDefinition> input = Arrays.asList(ColumnDefinition.convert(columns));
                    if ((columnDefns == null || columnDefns.containsAll(input)) && !result.contains(pcd = PersistedChartDefinition.getDefinition(presentation))) {
                        if (presentation.getMenu().equals("ChartDefinition.CPU_TIME_ANALYSIS_PIE")) {
                            result.add(1, PersistedChartDefinition.getDefinition(presentation));
                        } else {
                            result.add(PersistedChartDefinition.getDefinition(presentation));
                        }
                    }
                }
                ++n2;
            }
        }
        return result;
    }

    private static List<ChartSpecification> getPossibleSingleSelections() {
        ArrayList<ChartSpecification> result = new ArrayList<ChartSpecification>();
        for (ChartCategorisation catg : EnumSet.allOf(ChartCategorisation.class)) {
            if (!CategorisationHelper.isTicked(catg.name())) continue;
            Presentation[] presentationArray = QueryCache.getInstance().getAllPresentations();
            int n = presentationArray.length;
            int n2 = 0;
            while (n2 < n) {
                Presentation presentation = presentationArray[n2];
                if (catg == ChartCategorisation.getByName(presentation.getParameter("categorisation")) && ChartType.deriveFrom(presentation.getImplType()) != ChartType.HISTOGRAM && ChartType.deriveFrom(presentation.getImplType()) != ChartType.COMPACT_HISTOGRAM && ChartType.deriveFrom(presentation.getImplType()) != ChartType.LINE && ChartType.deriveFrom(presentation.getImplType()) != ChartType.COMBINEDHISTOGRAMLINE) {
                    result.add(PersistedChartDefinition.getDefinition(presentation));
                }
                ++n2;
            }
        }
        return result;
    }

    private static List<ChartSpecification> getPossibleTimelineSelections(GenericDataProvider dataProvider) {
        ArrayList<ChartSpecification> result = new ArrayList<ChartSpecification>();
        if (dataProvider != null && dataProvider.isValid()) {
            return CategorisationHelper.getPossibleTimelineSelections();
        }
        return result;
    }

    private static List<ChartSpecification> getPossibleTimelineSelections() {
        ArrayList<ChartSpecification> result = new ArrayList<ChartSpecification>();
        for (ChartCategorisation catg : EnumSet.allOf(ChartCategorisation.class)) {
            if (!CategorisationHelper.isTicked(catg.name())) continue;
            for (ChartSpecification chart : CategorisationHelper.getChartsForCategorisation(ChartCategorisation.getByName(catg.name()))) {
                if (chart.getType() != ChartType.COMPACT_HISTOGRAM) continue;
                result.add(chart);
            }
        }
        return result;
    }

    public static ChartSpecification getFirstPossibleSingleSelection(GenericDataProvider dataProvider) {
        Iterator<ChartSpecification> set;
        Iterator<ChartSpecification> iterator = set = dataProvider == null ? CategorisationHelper.getPossibleSingleSelections().iterator() : CategorisationHelper.getPossibleSingleSelections(dataProvider).iterator();
        if (set.hasNext()) {
            return set.next();
        }
        return null;
    }

    public static boolean isTicked(String menuItem) {
        return Platform.getPreferencesService().getBoolean(Activator.getDefault().getBundle().getSymbolicName(), menuItem, false, null);
    }

    public static boolean toggle(String menuItem) {
        boolean res = !Activator.getDefault().getPluginInstancePreferences().getBoolean(menuItem, false);
        Activator.getDefault().getPluginInstancePreferences().putBoolean(menuItem, res);
        return res;
    }

    public static ColumnDefinition[] appropriateColumnsFor(ChartCategorisation categorisation) {
        ArrayList<ColumnDefinition> columns = new ArrayList<ColumnDefinition>();
        for (ChartSpecification chart : CategorisationHelper.getChartsForCategorisation(categorisation)) {
            columns.addAll(chart.getAllColumnDefinitions());
        }
        HashSet tempSet = new HashSet(columns);
        ColumnDefinition[] defns = tempSet.toArray(new ColumnDefinition[tempSet.size()]);
        Arrays.sort(defns, new Comparator<ColumnDefinition>(){

            @Override
            public int compare(ColumnDefinition a, ColumnDefinition b) {
                if (a != null && b != null) {
                    return a.getLabel(null).compareTo(b.getLabel(null));
                }
                return -1;
            }
        });
        return defns;
    }

    public static List<ChartSpecification> getPossibleMultipleSelections(String tableAlias) {
        ArrayList<ChartSpecification> result = new ArrayList<ChartSpecification>();
        for (ChartCategorisation catg : EnumSet.allOf(ChartCategorisation.class)) {
            if (!CategorisationHelper.isTicked(catg.name())) continue;
            Presentation[] presentationArray = QueryCache.getInstance().getAllPresentations();
            int n = presentationArray.length;
            int n2 = 0;
            while (n2 < n) {
                Presentation presentation = presentationArray[n2];
                if (!(StringUtil.hasContent((String)tableAlias) && !tableAlias.equals(presentation.getTargetTables().iterator().next()) || catg != ChartCategorisation.getByName(presentation.getParameter("categorisation")) || ChartType.deriveFrom(presentation.getImplType()) != ChartType.HISTOGRAM && ChartType.deriveFrom(presentation.getImplType()) != ChartType.COMBINEDHISTOGRAMLINE)) {
                    result.add(PersistedChartDefinition.getDefinition(presentation));
                }
                ++n2;
            }
        }
        return result;
    }

    public static Map<ColumnDefinition, ChartCategorisation> getPropertyCategorization() {
        if (propertyCategorization == null) {
            propertyCategorization = new HashMap<ColumnDefinition, ChartCategorisation>();
            for (ChartCategorisation categorisation : EnumSet.allOf(ChartCategorisation.class)) {
                for (ChartSpecification ChartSpecification2 : CategorisationHelper.getChartsForCategorisation(categorisation)) {
                    for (ColumnDefinition columnDefinition : ChartSpecification2.getAllColumnDefinitions()) {
                        propertyCategorization.put(columnDefinition, categorisation);
                        ColumnDefinition counter = ColumnAssociationMapper.getTimeToCount(columnDefinition);
                        if (counter == null) continue;
                        propertyCategorization.put(counter, categorisation);
                    }
                }
            }
        }
        return propertyCategorization;
    }

    public static List<ChartSpecification> getPossibleTimelineSelections(IWorkbenchPart part) {
        GenericDataProvider provider = null;
        if (part instanceof SheetView) {
            provider = ((SheetView)part).getDataProvider();
        } else if (part instanceof ChartView) {
            provider = ((ChartView)part).getDataProvider();
        } else if (part instanceof CommonNavigator) {
            TreeSelection selection = (TreeSelection)((CommonNavigator)part).getCommonViewer().getSelection();
            if (selection.size() > 1) {
                provider = ((TreeElement)selection.getFirstElement()).getSourceProvider();
            }
        } else if (part instanceof PieView) {
            ((PieView)part).getModel().getDataProvider();
        }
        return provider == null ? CategorisationHelper.getPossibleTimelineSelections() : CategorisationHelper.getPossibleTimelineSelections(provider);
    }

    public static Collection<String> getPossibleIntervalTables() {
        HashSet<String> result = new HashSet<String>();
        Presentation[] presentationArray = QueryCache.getInstance().getAllPresentations();
        int n = presentationArray.length;
        int n2 = 0;
        while (n2 < n) {
            Presentation presentation = presentationArray[n2];
            if (ChartCategorisation.INTERVAL == ChartCategorisation.getByName(presentation.getParameter("categorisation"))) {
                result.add((String)presentation.getTargetTables().toArray()[0]);
            }
            ++n2;
        }
        return result;
    }

    public static Collection<String> getAllDetailPies() {
        return Arrays.asList("HST_Response_time_plist_pie", "HST_CPU_time_plist_pie", "HST_Wait_time_plist_pie", "HST_RMI_plist_pie", "HST_Storage_plist_pie", "HST_File_usage_plist_pie", "HST_ProgramRequest_plist_pie", "HST_Transient_data_plist_pie");
    }

    public static boolean validateIntervalTrackerTable(String tableAlias, IUniqueRecord record) {
        ManifestRecord currentManifest = PAContextTracker.getInstance().getCurrentManifest();
        if (currentManifest == null) {
            return false;
        }
        for (String alias : CategorisationHelper.getPossibleIntervalTables()) {
            if (!tableAlias.startsWith(alias)) continue;
            int position = record.getSourceProvider().getColumnPosition(ColumnDefinition.TCLASS_NAME);
            if (position > -1 && record.getRow()[position] == null) {
                return false;
            }
            position = record.getSourceProvider().getColumnPosition(ColumnDefinition.INTERVAL_DURATION);
            if (position <= -1 || record.getRow()[position] == null) continue;
            return true;
        }
        return false;
    }

    public static Presentation findBestIntervalPresentationForTable(String tableAlias, String vrm) {
        Presentation presentation = null;
        if (tableAlias != null) {
            presentation = tableAlias.equals("HST011A") ? CategorisationHelper.getPresentationBasedUpon(new String[]{"HST011A", "HST010A", "HST012A"}, vrm) : (tableAlias.equals("HST010A") ? CategorisationHelper.getPresentationBasedUpon(new String[]{"HST010A", "HST012A", "HST081A"}, vrm) : (tableAlias.equals("HST012A") ? CategorisationHelper.getPresentationBasedUpon(new String[]{"HST012A", "HST011A", "HST010A"}, vrm) : (tableAlias.equals("HST060A") ? CategorisationHelper.getPresentationBasedUpon(new String[]{"HST060A", "HST010A", "HST081A", "HST060B"}, vrm) : (tableAlias.equals("HST006A") ? CategorisationHelper.getPresentationBasedUpon(new String[]{"HST006A", "HST010A", "HST014A", "HST014B"}, vrm) : (tableAlias.equals("HST014B") ? CategorisationHelper.getPresentationBasedUpon(new String[]{"HST014B", "HST014A", "HST010A"}, vrm) : (tableAlias.equals("HST014A") ? CategorisationHelper.getPresentationBasedUpon(new String[]{"HST014A", "HST010A", "HST014B"}, vrm) : (tableAlias.equals("HST081A") ? CategorisationHelper.getPresentationBasedUpon(new String[]{"HST081A", "HST010A"}, vrm) : (tableAlias.equals("HST030A") ? CategorisationHelper.getPresentationBasedUpon(new String[]{"HST030A", "HST010A", "HST014A", "HST005A"}, vrm) : (tableAlias.equals("HST030B") ? CategorisationHelper.getPresentationBasedUpon(new String[]{"HST030B", "HST014A", "HST014B", "HST010A", "HST005A"}, vrm) : CategorisationHelper.getPresentationBasedUpon(new String[]{tableAlias}, vrm))))))))));
        }
        return presentation;
    }

    private static Presentation getPresentationBasedUpon(String[] tableList, String vrm) {
        Debug.enter((Logger)logger, (String)CategorisationHelper.class.getName(), (String)"getPresentationBasedUpon");
        Presentation presentation = null;
        Collection<String> possibles = ManifestRecord.getAliasList();
        StringBuffer resultantStream = new StringBuffer();
        boolean done = false;
        int i = 0;
        while (i < tableList.length && !done) {
            if (possibles.contains(tableList[i])) {
                resultantStream.append(tableList[i]);
                resultantStream.append('-');
            } else {
                done = true;
            }
            ++i;
        }
        if (resultantStream.length() > 0) {
            resultantStream.append("Interval");
            presentation = QueryCache.getInstance().getAppropriatePresentation(resultantStream.toString(), vrm);
        }
        Debug.exit((Logger)logger, (String)CategorisationHelper.class.getName(), (String)"getPresentationBasedUpon", presentation);
        return presentation;
    }

    public static String lookupPie(PredefinedTemplate layout) {
        String layoutLabel;
        if (layout != null && StringUtil.hasContent((String)(layoutLabel = layout.name()))) {
            if (layoutLabel.equals(PredefinedTemplate.List_Response_time_analysis.name())) {
                return "HST_Response_time_plist_pie";
            }
            if (layoutLabel.equals(PredefinedTemplate.List_Response_time_analysis.name()) || layoutLabel.equals(PredefinedTemplate.List_Dispatch_and_CPU_time_analysis.name())) {
                return "HST_CPU_time_plist_pie";
            }
            if (layoutLabel.equals(PredefinedTemplate.List_Suspend_time_analysis.name())) {
                return "HST_Wait_time_plist_pie";
            }
            if (layoutLabel.equals(PredefinedTemplate.List_Resource_Manager_analysis.name())) {
                return "HST_RMI_plist_pie";
            }
            if (layoutLabel.equals(PredefinedTemplate.List_Task_and_Shared_storage_analysis.name())) {
                return "HST_Storage_plist_pie";
            }
            if (layoutLabel.equals(PredefinedTemplate.List_File_analysis.name())) {
                return "HST_File_usage_plist_pie";
            }
            if (layoutLabel.equals(PredefinedTemplate.List_Program_activity_analysis.name())) {
                return "HST_ProgramRequest_plist_pie";
            }
            if (layoutLabel.equals(PredefinedTemplate.List_Temporary_storage_and_Transient_data_analysis.name())) {
                return "HST_Transient_data_plist_pie";
            }
        }
        return null;
    }
}

