/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.pa.model.definitions;

import com.ibm.cics.dbfunc.model.Presentation;
import com.ibm.cics.pa.model.ChartType;
import com.ibm.cics.pa.model.definitions.ChartSpecification;
import com.ibm.cics.pa.model.definitions.PersistedChartDefinition;
import com.ibm.cics.pa.model.definitions.SheetViewDefinition;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public abstract class AbstractChartDefinition
implements ChartSpecification {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y23 (c) Copyright IBM Corp. 2008, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    protected static Map<String, AbstractChartDefinition> definitions = null;
    private String id;

    public static Collection<AbstractChartDefinition> getDefinitions() {
        if (definitions == null) {
            definitions = new HashMap<String, AbstractChartDefinition>();
        }
        return definitions.values();
    }

    public static ChartSpecification getByName(String inlabel) {
        for (AbstractChartDefinition reference : AbstractChartDefinition.getDefinitions()) {
            if (reference == null || !reference.name().equals(inlabel)) continue;
            return reference;
        }
        return null;
    }

    @Override
    public String name() {
        return this.id;
    }

    public AbstractChartDefinition(String id) {
        this.id = id;
        if (definitions == null) {
            definitions = new HashMap<String, AbstractChartDefinition>();
        }
        definitions.put(id, this);
    }

    public static AbstractChartDefinition getChartDefinition(Presentation presentation) {
        return (AbstractChartDefinition)(ChartType.deriveFrom(presentation.getImplType()) == ChartType.SHEET ? SheetViewDefinition.createForPresentation(presentation) : PersistedChartDefinition.getDefinition(presentation));
    }
}

