/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.pa.model;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.dbfunc.model.Presentation;
import com.ibm.cics.pa.model.AlertElement;
import com.ibm.cics.pa.model.Chart;
import com.ibm.cics.pa.model.GenericDataProvider;
import com.ibm.cics.pa.model.IUniqueRecord;
import com.ibm.cics.pa.model.Pie;
import com.ibm.cics.pa.model.definitions.CategorisationHelper;
import com.ibm.cics.pa.model.definitions.ChartCategorisation;
import com.ibm.cics.pa.model.definitions.ChartSpecification;
import com.ibm.cics.pa.model.definitions.ColumnDefinition;
import com.ibm.cics.pa.model.definitions.PerformanceListRecordDefinition;
import com.ibm.cics.pa.model.definitions.PersistedChartDefinition;
import com.ibm.cics.pa.ui.QueryCache;
import com.ibm.cics.pa.ui.remote.RemoteEditorInput;
import com.ibm.cics.pa.ui.utilities.PredefinedTemplate;
import com.ibm.cics.pa.ui.views.internal.IPerformanceListRecordViewVariance;
import com.ibm.cics.pa.ui.views.internal.PerformanceListRecordViewVariance;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class TransactionPerformanceListModel
extends Chart {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y23 (c) Copyright IBM Corp. 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Debug debug = new Debug(TransactionPerformanceListModel.class);
    private Map<ColumnDefinition, Object> completeValues;
    private List<Pie> detailPies = new ArrayList<Pie>();
    private IUniqueRecord record;
    private Pie primaryPie;
    private static Collection<String> possibleDetailPies = CategorisationHelper.getAllDetailPies();
    private IPerformanceListRecordViewVariance variance = null;

    public TransactionPerformanceListModel(ChartSpecification chartDefinition, GenericDataProvider dataProvider, Map<ColumnDefinition, Object> map, String contentDesc) {
        super(chartDefinition, dataProvider);
        debug.enter("TransactionPerformanceListModel");
        this.setChartId(String.valueOf(chartDefinition.name()) + '-' + ((Timestamp)map.get(ColumnDefinition.START)).getTime());
        this.setToolTipText(contentDesc);
        this.completeValues = map;
        Collection<IUniqueRecord> results = ((RemoteEditorInput)dataProvider).getAllResults();
        ArrayList<String> myPies = new ArrayList<String>(possibleDetailPies);
        PredefinedTemplate layout = ((PerformanceListRecordDefinition)chartDefinition).getLayout();
        String firstPie = CategorisationHelper.lookupPie(layout);
        Iterator pies = myPies.iterator();
        if (results.isEmpty()) {
            debug.event("TransactionPerformanceListModel", "No performance list record found");
        } else {
            this.record = results.iterator().next();
            while (pies.hasNext()) {
                Presentation pres = QueryCache.getInstance().getAppropriatePresentation((String)pies.next(), "680");
                Pie currentPie = new Pie(PersistedChartDefinition.getDefinition(pres), dataProvider, map, "", results.iterator().next());
                if (pres.getCode().equals(firstPie)) {
                    this.primaryPie = currentPie;
                }
                this.detailPies.add(currentPie);
            }
            references.put(this.getChartId(), this);
        }
        if (this.getAlert() != null) {
            this.completeValues.put(ColumnDefinition.ALT_DEF_NAME, this.getAlert().getPropertyValue(ColumnDefinition.ALT_DEF_NAME));
            this.completeValues.put(ColumnDefinition.ALT_FIELD_NAME, this.getAlert().getPropertyValue(ColumnDefinition.ALT_FIELD_NAME));
            this.completeValues.put(ColumnDefinition.RES_NAME1, this.getAlert().getPropertyValue(ColumnDefinition.RES_NAME1));
            this.completeValues.put(ColumnDefinition.RES_NAME2, this.getAlert().getPropertyValue(ColumnDefinition.RES_NAME2));
            this.completeValues.put(ColumnDefinition.RES_NAME3, this.getAlert().getPropertyValue(ColumnDefinition.RES_NAME3));
            this.completeValues.put(ColumnDefinition.SEVERITY, this.getAlert().getPropertyValue(ColumnDefinition.SEVERITY));
            this.completeValues.put(ColumnDefinition.ALT_FIELD_VALUE, this.getAlert().getPropertyValue(ColumnDefinition.ALT_FIELD_VALUE));
            this.completeValues.put(ColumnDefinition.RES_VALUE1, this.getAlert().getPropertyValue(ColumnDefinition.RES_VALUE1));
            this.completeValues.put(ColumnDefinition.RES_VALUE2, this.getAlert().getPropertyValue(ColumnDefinition.RES_VALUE2));
            this.completeValues.put(ColumnDefinition.RES_VALUE3, this.getAlert().getPropertyValue(ColumnDefinition.RES_VALUE3));
            this.completeValues.put(ColumnDefinition.THRESHOLD, this.getAlert().getPropertyValue(ColumnDefinition.THRESHOLD));
            this.completeValues.put(ColumnDefinition.ALT_FIELD_TYPE, this.getAlert().getPropertyValue(ColumnDefinition.ALT_FIELD_TYPE));
        }
        this.chartTitle = "" + map.get(ColumnDefinition.TRAN) + '-' + map.get(ColumnDefinition.TASKNO);
        debug.exit("TransactionPerformanceListModel");
    }

    public Map<ColumnDefinition, Object> getCompleteValues() {
        return this.completeValues;
    }

    public IPerformanceListRecordViewVariance establishVariance() {
        debug.enter("establishVariance");
        if (this.variance == null && ChartCategorisation.STORAGE != this.getChartReference().getCategorisation()[0]) {
            this.variance = new PerformanceListRecordViewVariance(this);
        }
        debug.exit("establishVariance", (Object)this.variance);
        return this.variance;
    }

    public List<Pie> getDetailPies() {
        return this.detailPies;
    }

    public Pie getPrimaryPie() {
        if (this.primaryPie == null) {
            this.primaryPie = this.detailPies.get(0);
        }
        return this.primaryPie;
    }

    public IUniqueRecord getRecord() {
        return this.record;
    }

    public String getAlertDescription() {
        return ((PerformanceListRecordDefinition)this.getChartReference()).getAlertDescription();
    }

    public AlertElement getAlert() {
        return ((PerformanceListRecordDefinition)this.getChartReference()).getAlert();
    }

    public boolean isReliable() {
        return this.record != null;
    }

    @Override
    public String getChartId() {
        if (this.isReliable()) {
            return super.getChartId();
        }
        return null;
    }

    @Override
    public String getToolTipText() {
        return String.valueOf(ColumnDefinition.TRAN.getLabel(null)) + ' ' + this.completeValues.get(ColumnDefinition.TRAN) + ' ' + ColumnDefinition.TASKNO.getLabel(null) + ' ' + this.completeValues.get(ColumnDefinition.TASKNO);
    }
}

