/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.pa.model;

import com.ibm.cics.dbfunc.model.Clause;
import com.ibm.cics.dbfunc.model.ColumnReference;
import com.ibm.cics.dbfunc.model.Comparator;
import com.ibm.cics.dbfunc.model.ConstraintElement;
import com.ibm.cics.dbfunc.model.PresentationFactory;
import com.ibm.cics.dbfunc.model.QueryElement;
import com.ibm.cics.pa.model.DateCaveat;
import com.ibm.cics.pa.model.definitions.ColumnDefinition;
import com.ibm.cics.pa.ui.Messages;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.util.Date;

public class RangeDateCaveat
extends DateCaveat {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y23 (c) Copyright IBM Corp. 2008, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    protected RangeDateCaveat(Date startdate, Date enddate) {
        super(startdate, enddate);
    }

    @Override
    public String getLabel() {
        if (this.startdate != null && this.enddate != null) {
            return MessageFormat.format(Messages.getString("RangeDateCaveat_range"), sdf.format(this.startdate), sdf.format(this.enddate));
        }
        return null;
    }

    public String[] getLabelAsArray() {
        if (this.startdate != null && this.enddate != null) {
            return new String[]{String.valueOf(Messages.getString("PostRangeDateCaveat_records_after")) + ' ' + sdf.format(this.startdate), String.valueOf(Messages.getString("PreRangeDateCaveat_Prior")) + ' ' + sdf.format(this.enddate)};
        }
        return null;
    }

    @Override
    public String getAsWhereClause(String prepend) {
        String dateWhere = prepend;
        if (this.startdate != null && this.enddate != null) {
            Time sqlTime = new Time(this.startdate.getTime());
            java.sql.Date sqlDate = new java.sql.Date(this.startdate.getTime());
            if ((dateWhere = String.valueOf(dateWhere) + "((" + ColumnDefinition.START_DATE.getDBColumnRef() + " > '" + sqlDate.toString() + "') OR ((" + ColumnDefinition.START_DATE.getDBColumnRef() + " = '" + sqlDate.toString() + "') AND (" + ColumnDefinition.START_TIME.getDBColumnRef() + " >= '" + sqlTime.toString() + "'))) ").length() > 0) {
                dateWhere = String.valueOf(dateWhere) + " AND ";
            }
            sqlTime = new Time(this.enddate.getTime());
            sqlDate = new java.sql.Date(this.enddate.getTime());
            dateWhere = String.valueOf(dateWhere) + "((" + ColumnDefinition.START_DATE.getDBColumnRef() + " < '" + sqlDate.toString() + "') OR ((" + ColumnDefinition.START_DATE.getDBColumnRef() + " = '" + sqlDate.toString() + "') AND (" + ColumnDefinition.START_TIME.getDBColumnRef() + " <= '" + sqlTime.toString() + "')))";
        }
        return dateWhere;
    }

    @Override
    public ConstraintElement getConstraint(String databaseTable, boolean isTimestamp) {
        Clause constraint1 = null;
        Clause constraint2 = null;
        if (isTimestamp) {
            Timestamp sqlTimestamp = new Timestamp(this.startdate.getTime());
            constraint1 = PresentationFactory.getInstance().createSimpleCondition(ColumnDefinition.START.getDBColumnRef(), databaseTable, ColumnReference.DataType.Timestamp, Comparator.GE, new Object[]{sqlTimestamp}, false);
            sqlTimestamp = new Timestamp(this.enddate.getTime());
            constraint2 = PresentationFactory.getInstance().createSimpleCondition(ColumnDefinition.START.getDBColumnRef(), databaseTable, ColumnReference.DataType.Timestamp, Comparator.LE, new Object[]{sqlTimestamp}, false);
        } else {
            Time sqlTime = new Time(this.startdate.getTime());
            java.sql.Date sqlDate = new java.sql.Date(this.startdate.getTime());
            constraint1 = PresentationFactory.getInstance().createSimpleCondition(ColumnDefinition.START_TIME.getDBColumnRef(), databaseTable, ColumnReference.DataType.Date, Comparator.GE, new Object[]{sqlTime}, false);
            constraint1 = constraint1.appendCondition(ColumnDefinition.START_DATE.getDBColumnRef(), databaseTable, ColumnReference.DataType.Date, Comparator.EQ, new Object[]{sqlDate}, QueryElement.Predicate.AND, false);
            constraint1 = constraint1.appendCondition(ColumnDefinition.START_DATE.getDBColumnRef(), databaseTable, ColumnReference.DataType.Date, Comparator.GT, new Object[]{sqlDate}, QueryElement.Predicate.OR, false);
            sqlTime = new Time(this.enddate.getTime());
            sqlDate = new java.sql.Date(this.enddate.getTime());
            constraint2 = PresentationFactory.getInstance().createSimpleCondition(ColumnDefinition.START_TIME.getDBColumnRef(), databaseTable, ColumnReference.DataType.Date, Comparator.LE, new Object[]{sqlTime}, false);
            constraint2 = constraint2.appendCondition(ColumnDefinition.START_DATE.getDBColumnRef(), databaseTable, ColumnReference.DataType.Date, Comparator.EQ, new Object[]{sqlDate}, QueryElement.Predicate.AND, false);
            constraint2 = constraint2.appendCondition(ColumnDefinition.START_DATE.getDBColumnRef(), databaseTable, ColumnReference.DataType.Date, Comparator.LT, new Object[]{sqlDate}, QueryElement.Predicate.OR, false);
        }
        return constraint1.appendCondition((ConstraintElement)constraint2, QueryElement.Predicate.AND);
    }
}

