/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.pa.model;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.dbfunc.model.Comparator;
import com.ibm.cics.pa.model.AlertElement;
import com.ibm.cics.pa.model.Chart;
import com.ibm.cics.pa.model.Column;
import com.ibm.cics.pa.model.GenericDataProvider;
import com.ibm.cics.pa.model.IModelChangeListener;
import com.ibm.cics.pa.model.PlotPoint;
import com.ibm.cics.pa.model.definitions.ChartSpecification;
import com.ibm.cics.pa.model.definitions.ColumnDefinition;
import com.ibm.cics.pa.model.definitions.ColumnDefinitionHelper;
import com.ibm.cics.pa.model.definitions.DataProviderKey;
import com.ibm.cics.pa.model.definitions.IntervalSpecificDefinitions;
import com.ibm.cics.pa.ui.Messages;
import com.ibm.cics.pa.ui.PluginConstants;
import com.ibm.cics.pa.ui.remote.RemoteEditorInput;
import com.ibm.cics.pa.ui.utilities.DataTypeUtilities;
import com.ibm.cics.pa.ui.views.internal.DSAPlotViewVariance;
import com.ibm.cics.pa.ui.views.internal.IPlotViewVariance;
import com.ibm.cics.pa.ui.views.internal.LDGDSAPlotViewVariance;
import com.ibm.cics.pa.ui.views.internal.PlotViewVariance;
import com.ibm.cics.pa.ui.views.internal.SMTPlotViewVariance;
import java.sql.Time;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.Vector;
import org.eclipse.swt.graphics.Color;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;

public class PlotModel
extends Chart {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y23 (c) Copyright IBM Corp. 2013, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Debug debug = new Debug(PlotModel.class);
    public static final int ELEMENT_TARGET = 12;
    public static final int INTERVAL_INCREMENT_DIV16 = 4;
    public static final int INTERVAL_INCREMENT_DIV8 = 8;
    public static final int INTERVAL_INCREMENT_DIV4 = 16;
    public static final int INTERVAL_INCREMENT_IMAGE_DISPLACEMENT = 24;
    public static final int INTERVAL_INCREMENT_DIV2 = 32;
    public static final int INTERVAL_INCREMENT = 64;
    public static final int INTERVAL_INCREMENT_DIV3 = 21;
    public static final DecimalFormat DECIMAL_FORMAT = new DecimalFormat("#.##");
    private static final int MB_Multiplier = 0x100000;
    protected static final ColumnDefinition[] XMGTooltipA = new ColumnDefinition[]{ColumnDefinition.TRAN_TIMES_AT_MXT, ColumnDefinition.TRAN_PEAK_QUEUED};
    public static final ColumnDefinition[] XMGTooltipB = new ColumnDefinition[]{ColumnDefinition.TRAN_CUR_ACTIVE, ColumnDefinition.TRAN_PEAK_ACTIVE, ColumnDefinition.TRAN_MXT};
    protected static final ColumnDefinition[] XMCTooltipA = new ColumnDefinition[]{ColumnDefinition.TRANS_ACTIVE_CUR, ColumnDefinition.ACTIVE_TRANS_MAX, ColumnDefinition.AT_MAXACTIVE, ColumnDefinition.TRANS_QUEUED_PEAK};
    protected static final ColumnDefinition[] XMCTooltipB = new ColumnDefinition[]{ColumnDefinition.TRANS_ACTIVE_CUR, ColumnDefinition.ACTIVE_TRANS_MAX, ColumnDefinition.TRANS_ACTIVE_PEAK};
    protected static final ColumnDefinition[] XMRTooltipA = new ColumnDefinition[]{ColumnDefinition.STORAGE_VIOLATIONS, ColumnDefinition.ATTACHES_TRANSACTION, ColumnDefinition.TRANSACTIONS, ColumnDefinition.TRAN_PEAK_ACTIVE, ColumnDefinition.ATTACHES_TRANSACTION_CLASS};
    protected static final ColumnDefinition[] XMRTooltipB = new ColumnDefinition[]{ColumnDefinition.ATTACHES_TRANSACTION, ColumnDefinition.TRANSACTIONS, ColumnDefinition.TRAN_PEAK_ACTIVE, ColumnDefinition.ATTACHES_TRANSACTION_CLASS};
    protected static final ColumnDefinition[] StorageTooltipA = new ColumnDefinition[]{ColumnDefinition.TRAN_CUR_ACTIVE, ColumnDefinition.TRAN_PEAK_ACTIVE, ColumnDefinition.TRAN_MXT, ColumnDefinition.DSA_CURRENT_TOTAL, ColumnDefinition.DSA_TOTAL_PEAK, ColumnDefinition.EDSA_CURRENT_TOTAL, ColumnDefinition.EDSA_TOTAL_PEAK, ColumnDefinition.CURRENT_ACTIV_GDSA, ColumnDefinition.PEAK_GDSA_ACTIVE};
    protected static final ColumnDefinition[] DispatcherTooltipA = new ColumnDefinition[]{ColumnDefinition.TASKS, ColumnDefinition.TASKS_PEAK, ColumnDefinition.TRAN_CUR_ACTIVE, ColumnDefinition.TRAN_PEAK_ACTIVE, ColumnDefinition.TRAN_MXT};
    protected static final ColumnDefinition[] DispatcherTooltipB = new ColumnDefinition[]{ColumnDefinition.TASKS, ColumnDefinition.TASKS_PEAK, ColumnDefinition.TRAN_CUR_ACTIVE, ColumnDefinition.TRAN_PEAK_ACTIVE};
    protected static final List<ColumnDefinition> STORAGE_EXPAND_BAR = Arrays.asList(ColumnDefinition.STORAGE_PROT_ACT, ColumnDefinition.TRAN_ISOLATION_ACT, ColumnDefinition.REENT_PGMS_PROTECT);
    protected static final List<ColumnDefinition> DISPATCHER_EXPAND_BAR = Arrays.asList(ColumnDefinition.ICV_TIME, ColumnDefinition.ICVR_TIME, ColumnDefinition.ICVTSD_TIME, ColumnDefinition.PRTYAGE_TIME, ColumnDefinition.TCB_SUBTSKS_VALUE, ColumnDefinition.MRO_QR_BATCHING);
    protected static final List<ColumnDefinition> DISPATCHER_EXPAND_MNG = Arrays.asList(ColumnDefinition.WLM_MODE, ColumnDefinition.WLM_STATUS, ColumnDefinition.WLM_ADDRSPACE_GOAL, ColumnDefinition.WLM_OWNING_WORKLOD, ColumnDefinition.WLM_SERVICE_CLASS, ColumnDefinition.WLM_REPORT_CLASS, ColumnDefinition.WLM_RESOURCE_GROUP, ColumnDefinition.WLM_GOAL_TYPE, ColumnDefinition.WLM_GOAL_VALUE, ColumnDefinition.WLM_GOAL_IMPORTNCE, ColumnDefinition.WLM_CPU_CRITICAL, ColumnDefinition.WLM_STG_CRITICAL);
    protected static final List<ColumnDefinition> MONITORING_EXPAND_MNG = Arrays.asList(ColumnDefinition.PERFORM_RECORDS, ColumnDefinition.PERFORM_REC_SUPPR, ColumnDefinition.EXCEPT_RECORDS, ColumnDefinition.EXCEPT_REC_SUPPR, ColumnDefinition.RESOURCE_RECORDS, ColumnDefinition.RESOURCE_REC_SUPPR, ColumnDefinition.IDENTITY_RECORDS, ColumnDefinition.IDENTITY_REC_SUPPR, ColumnDefinition.SMF_RECORDS, ColumnDefinition.SMF_ERRORS);
    protected static final List<ColumnDefinition> DSA_REFERENCES = Arrays.asList(PluginConstants.DSA);
    protected static final List<ColumnDefinition> EDSA_REFERENCES = Arrays.asList(PluginConstants.EDSA);
    protected static final List<ColumnDefinition> GDSA_REFERENCES = Arrays.asList(PluginConstants.GDSA);
    IntervalSpecificDefinitions intervalDefinitions;
    private String contentDescription;
    private PlotModelElement[] elements;
    List<PlotPoint> plotPoints;
    List<ColumnDefinition> plotLines;
    private Time time;
    private ColumnDefinition[] headers;
    private IPlotViewVariance specificImplementation;
    private Set<ColumnDefinition> percentageReferences = null;
    SimpleDateFormat sdf = new SimpleDateFormat("HH:mm:ss.SSS", Locale.getDefault());
    DSAType dsaType = null;
    private String lastLDGDSARecord_dsaName;
    private int lastLDGDSARecord_intervalNumber;

    public PlotModel(ChartSpecification chartDefinition, GenericDataProvider dataProvider, String contentDesc) {
        super(chartDefinition, dataProvider);
        debug.enter("PlotModel");
        this.sdf.setTimeZone(TimeZone.getTimeZone("GMT"));
        this.setChartId(PlotModel.calculateReference(this.getChartReference(), contentDesc));
        references.put(this.getChartId(), this);
        this.intervalDefinitions = (IntervalSpecificDefinitions)chartDefinition.getSpecificType();
        this.contentDescription = contentDesc;
        this.elements = new PlotModelElement[dataProvider.getData().length];
        this.plotPoints = this.intervalDefinitions.getPlotPoints();
        this.plotLines = this.intervalDefinitions.getPlotLines();
        this.headers = dataProvider.getColumnDefinitions();
        if (!this.intervalDefinitions.getAltColumnDefinitions().isEmpty()) {
            int j = 0;
            int i = 0;
            while (j < this.intervalDefinitions.getRenameColumnDefinitions().size() && i < dataProvider.getColumnDefinitions().length) {
                if (dataProvider.getColumnDefinitions()[i] == this.intervalDefinitions.getRenameColumnDefinitions().get(j)) {
                    dataProvider.getColumnDefinitions()[i] = this.intervalDefinitions.getAltColumnDefinitions().get(j);
                    ++j;
                }
                ++i;
            }
        }
        int counter = 0;
        Date start = null;
        HashMap<String, Object[]> subMap1 = new HashMap<String, Object[]>();
        Vector<PlotModelElement> el1 = new Vector<PlotModelElement>();
        Object[][] objectArray = dataProvider.getData();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object tranPeak;
            Object edsaLimit;
            Object dsaLimit;
            Object trans_class;
            Object trans_total;
            int originalLength;
            Object[] aRow = objectArray[n2];
            boolean reject = false;
            HashMap<ColumnDefinition, Object> valueMap = new HashMap<ColumnDefinition, Object>();
            int i = 0;
            while (i < dataProvider.getColumnDefinitions().length) {
                ColumnDefinition header = dataProvider.getColumnDefinitions()[i];
                valueMap.put(header, aRow[i]);
                ++i;
            }
            if (this.isXMRRecord()) {
                originalLength = dataProvider.getColumnDefinitions().length;
                trans_total = valueMap.get(ColumnDefinition.TRANSACTIONS);
                trans_class = valueMap.get(ColumnDefinition.ATTACHES_TRANSACTION_CLASS);
                Object trans = valueMap.get(ColumnDefinition.ATTACHES_TRANSACTION);
                this.headers = Arrays.copyOf(dataProvider.getColumnDefinitions(), originalLength + (trans_class != null ? 3 : 2));
                this.headers[originalLength] = ColumnDefinition.ATTACHES_PERCENT_TRANSACTION_CLASS;
                this.headers[originalLength + 1] = ColumnDefinition.ATTACHES_PERCENT_TOTAL_TRANSACTIONS;
                if (trans_class != null) {
                    this.headers[originalLength + 2] = ColumnDefinition.ATTACHES_TRANSACTION_CLASS_PERCENT_TOTAL_TRANSACTIONS;
                }
                valueMap.put(ColumnDefinition.ATTACHES_PERCENT_TRANSACTION_CLASS, DataTypeUtilities.getPercentageAsInteger(trans, trans_class));
                valueMap.put(ColumnDefinition.ATTACHES_PERCENT_TOTAL_TRANSACTIONS, DataTypeUtilities.getPercentageAsInteger(trans, trans_total));
                valueMap.put(ColumnDefinition.ATTACHES_TRANSACTION_CLASS_PERCENT_TOTAL_TRANSACTIONS, DataTypeUtilities.getPercentageAsInteger(trans_class, trans_total));
            } else if (this.isXMCRecord()) {
                originalLength = dataProvider.getColumnDefinitions().length;
                trans_total = valueMap.get(ColumnDefinition.TRANSACTIONS);
                trans_class = valueMap.get(ColumnDefinition.ATTACHES_TRANSACTION_CLASS);
                Object accepted_immediate = valueMap.get(ColumnDefinition.ACCEPT_IMMED);
                Object accepted_queued = valueMap.get(ColumnDefinition.ACCEPT_QUEUED);
                if (trans_class != null && trans_total != null) {
                    if (accepted_immediate != null && accepted_queued != null) {
                        this.headers = Arrays.copyOf(dataProvider.getColumnDefinitions(), originalLength + 3);
                        this.headers[originalLength + 1] = ColumnDefinition.ACCEPT_IMMED_PERCENT;
                        this.headers[originalLength + 2] = ColumnDefinition.ACCEPT_QUEUED_PERCENT;
                        valueMap.put(ColumnDefinition.ACCEPT_IMMED_PERCENT, DataTypeUtilities.getPercentageAsInteger(accepted_immediate, trans_class));
                        valueMap.put(ColumnDefinition.ACCEPT_QUEUED_PERCENT, DataTypeUtilities.getPercentageAsInteger(accepted_queued, trans_class));
                    } else {
                        this.headers = Arrays.copyOf(dataProvider.getColumnDefinitions(), originalLength + 1);
                    }
                    this.headers[originalLength] = ColumnDefinition.ATTACHES_TRANSACTION_CLASS_PERCENT_TOTAL_TRANSACTIONS;
                    valueMap.put(ColumnDefinition.ATTACHES_TRANSACTION_CLASS_PERCENT_TOTAL_TRANSACTIONS, DataTypeUtilities.getPercentageAsInteger(trans_class, trans_total));
                }
            } else if (this.isXMGRecord()) {
                originalLength = dataProvider.getColumnDefinitions().length;
                trans_total = valueMap.get(ColumnDefinition.TRANSACTIONS);
                Object trans_active = valueMap.get(ColumnDefinition.TRAN_TOTAL_ACTIVE);
                Object trans_delayed = valueMap.get(ColumnDefinition.TRAN_TOTAL_DELAYED);
                Object tranPeak2 = valueMap.get(ColumnDefinition.TRAN_PEAK_ACTIVE);
                Object maxtask = valueMap.get(ColumnDefinition.TRAN_MXT);
                if (trans_active != null && trans_total != null && trans_delayed != null) {
                    this.headers = Arrays.copyOf(dataProvider.getColumnDefinitions(), originalLength + 3);
                    this.headers[originalLength] = ColumnDefinition.TRAN_TOTAL_ACTIVE_PERCENT_TOTAL_TRANSACTIONS;
                    this.headers[originalLength + 1] = ColumnDefinition.TRAN_TOTAL_DELAYED_PERCENT_TOTAL_TRANSACTIONS;
                    this.headers[originalLength + 2] = ColumnDefinition.TRAN_PEAK_ACTIVE_PERCENT;
                    valueMap.put(ColumnDefinition.TRAN_TOTAL_ACTIVE_PERCENT_TOTAL_TRANSACTIONS, DataTypeUtilities.getPercentageAsInteger(trans_active, trans_total));
                    valueMap.put(ColumnDefinition.TRAN_TOTAL_DELAYED_PERCENT_TOTAL_TRANSACTIONS, DataTypeUtilities.getPercentageAsInteger(trans_delayed, trans_total));
                    valueMap.put(ColumnDefinition.TRAN_PEAK_ACTIVE_PERCENT, DataTypeUtilities.getPercentageAsInteger(tranPeak2, maxtask));
                }
            } else if (this.isSMSRecord()) {
                originalLength = dataProvider.getColumnDefinitions().length;
                dsaLimit = valueMap.get(ColumnDefinition.DSA_LIMIT);
                edsaLimit = valueMap.get(ColumnDefinition.EDSA_LIMIT);
                Object gdsaLimit = valueMap.get(ColumnDefinition.MEMLIMIT_SIZE);
                Object peakDSA = valueMap.get(ColumnDefinition.DSA_TOTAL_PEAK);
                Object cDSA = valueMap.get(ColumnDefinition.DSA_CURRENT_TOTAL);
                Object peakEDSA = valueMap.get(ColumnDefinition.EDSA_TOTAL_PEAK);
                Object cEDSA = valueMap.get(ColumnDefinition.EDSA_CURRENT_TOTAL);
                Object peakGDSA = valueMap.get(ColumnDefinition.PEAK_GDSA_ACTIVE);
                Object caGDSA = valueMap.get(ColumnDefinition.CURRENT_ACTIV_GDSA);
                Object tranPeak3 = valueMap.get(ColumnDefinition.TRAN_PEAK_ACTIVE);
                Object maxtask = valueMap.get(ColumnDefinition.TRAN_MXT);
                Object trans_active = valueMap.get(ColumnDefinition.TRAN_TOTAL_ACTIVE);
                Object trans_total2 = valueMap.get(ColumnDefinition.TRANSACTIONS);
                this.headers = Arrays.copyOf(dataProvider.getColumnDefinitions(), originalLength + 14);
                this.headers[originalLength] = ColumnDefinition.DSA_TOTAL_PEAK_PERCENT;
                this.headers[originalLength + 1] = ColumnDefinition.DSA_CURRENT_TOTAL_PERCENT;
                this.headers[originalLength + 2] = ColumnDefinition.EDSA_TOTAL_PEAK_PERCENT;
                this.headers[originalLength + 3] = ColumnDefinition.EDSA_CURRENT_TOTAL_PERCENT;
                this.headers[originalLength + 4] = ColumnDefinition.PEAK_GDSA_ACTIVE_PERCENT;
                this.headers[originalLength + 5] = ColumnDefinition.CURRENT_ACTIV_GDSA_PERCENT;
                this.headers[originalLength + 6] = ColumnDefinition.TRAN_PEAK_ACTIVE_PERCENT;
                this.headers[originalLength + 7] = ColumnDefinition.TRAN_TOTAL_ACTIVE_PERCENT_TOTAL_TRANSACTIONS;
                this.headers[originalLength + 8] = ColumnDefinition.DSA_SIZE_USED;
                this.headers[originalLength + 9] = ColumnDefinition.DSA_SIZE_USED_PERCENT;
                this.headers[originalLength + 10] = ColumnDefinition.EDSA_SIZE_USED;
                this.headers[originalLength + 11] = ColumnDefinition.EDSA_SIZE_USED_PERCENT;
                this.headers[originalLength + 12] = ColumnDefinition.GDSA_SIZE_USED;
                this.headers[originalLength + 13] = ColumnDefinition.GDSA_SIZE_USED_PERCENT;
                valueMap.put(ColumnDefinition.DSA_TOTAL_PEAK_PERCENT, DataTypeUtilities.getPercentageAsInteger(peakDSA, dsaLimit));
                valueMap.put(ColumnDefinition.DSA_CURRENT_TOTAL_PERCENT, DataTypeUtilities.getPercentageAsInteger(cDSA, dsaLimit));
                valueMap.put(ColumnDefinition.EDSA_TOTAL_PEAK_PERCENT, DataTypeUtilities.getPercentageAsInteger(peakEDSA, edsaLimit));
                valueMap.put(ColumnDefinition.EDSA_CURRENT_TOTAL_PERCENT, DataTypeUtilities.getPercentageAsInteger(cEDSA, edsaLimit));
                valueMap.put(ColumnDefinition.PEAK_GDSA_ACTIVE_PERCENT, DataTypeUtilities.getPercentageAsInteger(peakGDSA, gdsaLimit));
                valueMap.put(ColumnDefinition.CURRENT_ACTIV_GDSA_PERCENT, DataTypeUtilities.getPercentageAsInteger(caGDSA, gdsaLimit));
                valueMap.put(ColumnDefinition.TRAN_PEAK_ACTIVE_PERCENT, DataTypeUtilities.getPercentageAsInteger(tranPeak3, maxtask));
                valueMap.put(ColumnDefinition.TRAN_TOTAL_ACTIVE_PERCENT_TOTAL_TRANSACTIONS, DataTypeUtilities.getPercentageAsInteger(trans_active, trans_total2));
            } else if (this.isLDGRecord()) {
                originalLength = dataProvider.getColumnDefinitions().length;
                dsaLimit = valueMap.get(ColumnDefinition.DSA_LIMIT);
                edsaLimit = valueMap.get(ColumnDefinition.EDSA_LIMIT);
                Object peakDSA = valueMap.get(ColumnDefinition.DSA_TOTAL_PEAK);
                Object cDSA = valueMap.get(ColumnDefinition.DSA_CURRENT_TOTAL);
                Object peakEDSA = valueMap.get(ColumnDefinition.EDSA_TOTAL_PEAK);
                Object cEDSA = valueMap.get(ColumnDefinition.EDSA_CURRENT_TOTAL);
                Object tranPeak4 = valueMap.get(ColumnDefinition.TRAN_PEAK_ACTIVE);
                Object maxtask = valueMap.get(ColumnDefinition.TRAN_MXT);
                Object trans_active = valueMap.get(ColumnDefinition.TRAN_TOTAL_ACTIVE);
                Object trans_total3 = valueMap.get(ColumnDefinition.TRANSACTIONS);
                Object program_uses = valueMap.get(ColumnDefinition.PROGRAM_USES);
                this.headers = Arrays.copyOf(dataProvider.getColumnDefinitions(), originalLength + 15);
                this.headers[originalLength] = ColumnDefinition.DSA_TOTAL_PEAK_PERCENT;
                this.headers[originalLength + 1] = ColumnDefinition.DSA_CURRENT_TOTAL_PERCENT;
                this.headers[originalLength + 2] = ColumnDefinition.EDSA_TOTAL_PEAK_PERCENT;
                this.headers[originalLength + 3] = ColumnDefinition.EDSA_CURRENT_TOTAL_PERCENT;
                this.headers[originalLength + 4] = ColumnDefinition.TRAN_PEAK_ACTIVE_PERCENT;
                this.headers[originalLength + 5] = ColumnDefinition.TRAN_TOTAL_ACTIVE_PERCENT_TOTAL_TRANSACTIONS;
                this.headers[originalLength + 6] = ColumnDefinition.DSA_SIZE_PGMS;
                this.headers[originalLength + 7] = ColumnDefinition.DSA_SIZE_PGMS_PERCENT;
                this.headers[originalLength + 8] = ColumnDefinition.EDSA_SIZE_PGMS;
                this.headers[originalLength + 9] = ColumnDefinition.EDSA_SIZE_PGMS_PERCENT;
                this.headers[originalLength + 10] = ColumnDefinition.DSA_SIZE_USED;
                this.headers[originalLength + 11] = ColumnDefinition.DSA_SIZE_USED_PERCENT;
                this.headers[originalLength + 12] = ColumnDefinition.EDSA_SIZE_USED;
                this.headers[originalLength + 13] = ColumnDefinition.EDSA_SIZE_USED_PERCENT;
                this.headers[originalLength + 14] = ColumnDefinition.PROGRAM_USES_AVERAGE;
                valueMap.put(ColumnDefinition.DSA_TOTAL_PEAK_PERCENT, DataTypeUtilities.getPercentageAsInteger(peakDSA, dsaLimit));
                valueMap.put(ColumnDefinition.DSA_CURRENT_TOTAL_PERCENT, DataTypeUtilities.getPercentageAsInteger(cDSA, dsaLimit));
                valueMap.put(ColumnDefinition.EDSA_TOTAL_PEAK_PERCENT, DataTypeUtilities.getPercentageAsInteger(peakEDSA, edsaLimit));
                valueMap.put(ColumnDefinition.EDSA_CURRENT_TOTAL_PERCENT, DataTypeUtilities.getPercentageAsInteger(cEDSA, edsaLimit));
                valueMap.put(ColumnDefinition.TRAN_PEAK_ACTIVE_PERCENT, DataTypeUtilities.getPercentageAsInteger(tranPeak4, maxtask));
                valueMap.put(ColumnDefinition.TRAN_TOTAL_ACTIVE_PERCENT_TOTAL_TRANSACTIONS, DataTypeUtilities.getPercentageAsInteger(trans_active, trans_total3));
                valueMap.put(ColumnDefinition.PROGRAM_USES_AVERAGE, DataTypeUtilities.getRatio(program_uses, trans_active));
            } else if (this.isSMTRecord()) {
                originalLength = dataProvider.getColumnDefinitions().length;
                tranPeak = valueMap.get(ColumnDefinition.TRAN_PEAK_ACTIVE);
                Object maxtask = valueMap.get(ColumnDefinition.TRAN_MXT);
                if (tranPeak != null && maxtask != null) {
                    this.headers = Arrays.copyOf(dataProvider.getColumnDefinitions(), originalLength + 1);
                    this.headers[originalLength] = ColumnDefinition.TRAN_PEAK_ACTIVE_PERCENT;
                }
                valueMap.put(ColumnDefinition.TRAN_PEAK_ACTIVE_PERCENT, DataTypeUtilities.getPercentageAsInteger(tranPeak, maxtask));
            } else if (this.isDSGRecord()) {
                originalLength = dataProvider.getColumnDefinitions().length;
                tranPeak = valueMap.get(ColumnDefinition.TRAN_PEAK_ACTIVE);
                Object trans_total4 = valueMap.get(ColumnDefinition.TRANSACTIONS);
                Object maxtask = valueMap.get(ColumnDefinition.TRAN_MXT);
                Object trans_active = valueMap.get(ColumnDefinition.TRAN_TOTAL_ACTIVE);
                if (tranPeak != null && trans_total4 != null && maxtask != null) {
                    this.headers = Arrays.copyOf(dataProvider.getColumnDefinitions(), originalLength + 2);
                    this.headers[originalLength] = ColumnDefinition.TRAN_PEAK_ACTIVE_PERCENT;
                    this.headers[originalLength + 1] = ColumnDefinition.TRAN_TOTAL_ACTIVE_PERCENT_TOTAL_TRANSACTIONS;
                }
                valueMap.put(ColumnDefinition.TRAN_PEAK_ACTIVE_PERCENT, DataTypeUtilities.getPercentageAsInteger(tranPeak, maxtask));
                valueMap.put(ColumnDefinition.TRAN_TOTAL_ACTIVE_PERCENT_TOTAL_TRANSACTIONS, DataTypeUtilities.getPercentageAsInteger(trans_active, trans_total4));
            } else if (this.isLDGDSARecord()) {
                int intervalNumber = (Integer)valueMap.get(ColumnDefinition.INTERVAL_NUMBER);
                String dsaName1 = (String)valueMap.get(ColumnDefinition.DSA_NAME);
                String dsaName2 = (String)valueMap.get(ColumnDefinition.MODE_NAME);
                if (dsaName1.endsWith("UDSA") || dsaName1.endsWith("TDSA")) {
                    if (dsaName1.equals(this.lastLDGDSARecord_dsaName) && intervalNumber == this.lastLDGDSARecord_intervalNumber) {
                        reject = true;
                    }
                } else {
                    boolean bl = reject = !dsaName1.equals(dsaName2);
                }
                if (!reject) {
                    int originalLength2 = dataProvider.getColumnDefinitions().length;
                    Object pgms = valueMap.get(ColumnDefinition.PGMS_REMOVED_DPSC);
                    Object niu_tot = valueMap.get(ColumnDefinition.NIU_TIME_TOT);
                    if (pgms != null && niu_tot != null) {
                        this.headers = Arrays.copyOf(dataProvider.getColumnDefinitions(), originalLength2 + 1);
                        this.headers[originalLength2] = ColumnDefinition.NIU_TIME_AVG;
                    }
                    valueMap.put(ColumnDefinition.TRAN_PEAK_ACTIVE_PERCENT, DataTypeUtilities.getRatio(niu_tot, pgms));
                }
                this.lastLDGDSARecord_intervalNumber = intervalNumber;
                this.lastLDGDSARecord_dsaName = dsaName1;
            }
            if (!reject) {
                if (this.intervalDefinitions.getSubColumnDefinitions().isEmpty()) {
                    el1.add(counter, new PlotModelElement(valueMap, subMap1));
                    ++counter;
                } else {
                    ColumnDefinition label0 = this.intervalDefinitions.getSubColumnDefinitions().get(0);
                    if (this.dsaType == null && (this.isDSARecord() || this.isSMTRecord() || this.isLDGDSARecord())) {
                        this.dsaType = this.identifyDSAType((String)valueMap.get(label0));
                    }
                    Time measuredTime = (Time)valueMap.get(ColumnDefinition.START_TIME);
                    Object[] remap = this.getWithPercent(valueMap, label0, this.getSubMapping(valueMap));
                    if (start == null || start.getTime() != measuredTime.getTime()) {
                        start = measuredTime;
                        subMap1 = new LinkedHashMap<String, Object[]>();
                        subMap1.put(DataTypeUtilities.getAsString(valueMap.get(label0)), remap);
                        el1.add(counter, new PlotModelElement(valueMap, subMap1));
                        ++counter;
                    } else {
                        subMap1.put(DataTypeUtilities.getAsString(valueMap.get(label0)), remap);
                    }
                }
            }
            ++n2;
        }
        this.elements = el1.toArray(new PlotModelElement[el1.size()]);
        if (this.elements.length > 12) {
            int displacement = (this.elements.length - 12) / 2;
            int i = 0;
            while (i < displacement) {
                this.elements[i] = this.elements[i + 1];
                ++i;
            }
            this.elements = Arrays.copyOfRange(this.elements, displacement, displacement + 12);
        }
        debug.exit("PlotModel", (Object)this.elements);
    }

    private DSAType identifyDSAType(String dsaLabel) {
        ColumnDefinition ref = ColumnDefinition.getByDBColumnRef(dsaLabel);
        DSAType dsaType1 = DSAType.DSA;
        if (EDSA_REFERENCES.contains(ref)) {
            dsaType1 = DSAType.EDSA;
        } else if (GDSA_REFERENCES.contains(ref)) {
            dsaType1 = DSAType.GDSA;
        }
        return dsaType1;
    }

    private Object[] getSubMapping(Map<ColumnDefinition, Object> valueMap) {
        Object[] maps = new Object[this.intervalDefinitions.getSubColumnValueDefinitions().size()];
        int i = 0;
        while (i < maps.length) {
            ColumnDefinition value0 = this.intervalDefinitions.getSubColumnValueDefinitions().get(i);
            maps[i] = valueMap.get(value0);
            ++i;
        }
        return maps;
    }

    public ColumnDefinition[] getColumnDefinitions() {
        return this.headers;
    }

    public PlotModelElement[] getElements() {
        return this.elements;
    }

    public String getContentDescription() {
        return this.contentDescription;
    }

    public String getApplid() {
        return (String)this.getElements()[0].valueMap.get(ColumnDefinition.APPLID);
    }

    public List<PlotPoint> getPlotPoints() {
        return this.plotPoints;
    }

    public List<ColumnDefinition> getPlotLines() {
        return this.plotLines;
    }

    public ColumnDefinition getTextNumber() {
        return this.intervalDefinitions.getTextValueColumn();
    }

    public String getVRM() {
        return this.intervalDefinitions.getVRM();
    }

    private double getMaximum(ColumnDefinition defn) {
        double max = 0.0;
        PlotModelElement[] plotModelElementArray = this.elements;
        int n = this.elements.length;
        int n2 = 0;
        while (n2 < n) {
            PlotModelElement element = plotModelElementArray[n2];
            Object tempValue = element.getValueMap().get(defn);
            if (tempValue == null) {
                tempValue = 0.0;
            } else if (tempValue instanceof Integer) {
                tempValue = ((Integer)tempValue).doubleValue();
            } else if (tempValue instanceof Float) {
                tempValue = ((Float)tempValue).doubleValue();
            }
            max = Math.max(max, (Double)tempValue);
            ++n2;
        }
        return max;
    }

    public double getThreshold() {
        double max = 0.0;
        if (this.plotPoints.size() > 0) {
            if (this.plotPoints.get(0).isPercentReference()) {
                max = 100.0;
            } else {
                max = this.getMaximum(this.plotPoints.get(0).getPlotReference());
                if (this.plotLines.size() > 0) {
                    max = Math.max(this.getMaximum(this.plotLines.get(0)), max);
                }
            }
        }
        return max;
    }

    public void setSelectionInterval(Time time) {
        this.time = time;
    }

    public int getInitialSelection() {
        int i = 0;
        while (i < this.elements.length) {
            if (this.elements[i].getValueMap().get(ColumnDefinition.START_TIME).equals(this.time)) {
                return i;
            }
            ++i;
        }
        return 0;
    }

    public Color getPlotPointColour(int i) {
        return Column.getFor(this.plotPoints.get(i).getPlotReference()).getColor();
    }

    public Color getPlotLineColour(int i) {
        return Column.getFor(this.plotLines.get(i)).getColor();
    }

    public String getCheatSheetReference() {
        return this.intervalDefinitions.getCheatSheet();
    }

    public boolean hasSubElements() {
        return !this.intervalDefinitions.getSubColumnDefinitions().isEmpty() && !this.isSMSRecord() && !this.isLDGRecord();
    }

    public ColumnDefinition getSubColumnLabel() {
        if (this.intervalDefinitions.getSubColumnDefinitions().isEmpty()) {
            return null;
        }
        return this.intervalDefinitions.getSubColumnDefinitions().get(0);
    }

    public List<ColumnDefinition> getSubColumnValueLabel() {
        return this.intervalDefinitions.getSubColumnValueDefinitions();
    }

    public boolean isPartOfKey(ColumnDefinition defn) {
        return defn == ColumnDefinition.APPLID || defn == ColumnDefinition.TCLASS_NAME || !this.hasSubElements() && defn == ColumnDefinition.TRAN_ID;
    }

    public ColumnDefinition[] getNext() {
        if (this.getChartReference().getTitle().startsWith("XMC")) {
            return new ColumnDefinition[]{ColumnDefinition.APPLID};
        }
        if (this.getChartReference().getTitle().startsWith("XMR")) {
            return new ColumnDefinition[]{ColumnDefinition.TCLASS_NAME, ColumnDefinition.APPLID};
        }
        return new ColumnDefinition[0];
    }

    public boolean canLink(ColumnDefinition defn) {
        if (this.isXMCRecord()) {
            return defn == ColumnDefinition.APPLID;
        }
        if (this.isXMRRecord()) {
            return defn == ColumnDefinition.APPLID || defn == ColumnDefinition.TCLASS_NAME || defn == ColumnDefinition.TRAN_ID;
        }
        return false;
    }

    public boolean isXMCRecord() {
        return this.getTable().equals("HST012A");
    }

    public boolean isXMGRecord() {
        return this.getTable().equals("HST010A");
    }

    public boolean isXMRRecord() {
        return this.getTable().equals("HST011A");
    }

    public boolean isLDGRecord() {
        return this.getTable().equals("HST030A");
    }

    public boolean isMNGRecord() {
        return this.getTable().equals("HST081A");
    }

    public boolean isSMSRecord() {
        return this.getTable().equals("HST014A");
    }

    public boolean isSMTRecord() {
        return this.getTable().equals("HST006A");
    }

    public boolean isDSARecord() {
        return this.getTable().equals("HST014B");
    }

    public boolean isLDGDSARecord() {
        return this.getTable().equals("HST030B");
    }

    public boolean isDSGRecord() {
        return this.getTable().equals("HST060A");
    }

    public Color getColour(ColumnDefinition plot) {
        for (PlotPoint point : this.plotPoints) {
            if (point.getPlotReference() != plot) continue;
            return Column.getFor(plot).getColor();
        }
        if (this.plotLines.contains(plot)) {
            return Column.getFor(plot).getColor();
        }
        if (this.getPercentagesOf().contains(plot)) {
            return Column.getFor(plot).getColor();
        }
        if (this.getTextNumber() == plot) {
            return Column.getFor(plot).getColor();
        }
        return null;
    }

    public String getHelpId() {
        if (this.isXMCRecord()) {
            return "com.ibm.cics.pa.ui.plotview_guidance_XMC";
        }
        if (this.isXMRRecord()) {
            return "com.ibm.cics.pa.ui.plotview_guidance_XMR";
        }
        if (this.isXMGRecord()) {
            return "com.ibm.cics.pa.ui.plotview_guidance_XMG";
        }
        return "com.ibm.cics.pa.ui.plotview";
    }

    public String getHyperlinkToolTip(ColumnDefinition defn) {
        if (this.isXMRRecord() && defn == ColumnDefinition.TRAN_ID) {
            return Messages.getString("PlotModel.hyperlink.tran_id");
        }
        if ((this.isDSARecord() || this.isSMTRecord()) && defn == ColumnDefinition.APPLID) {
            return Messages.getString("PlotModel.hyperlink.SMSApplid");
        }
        if (this.isLDGDSARecord() && defn == ColumnDefinition.APPLID) {
            return Messages.getString("PlotModel.hyperlink.LDG.SMSApplid");
        }
        if (defn == ColumnDefinition.TRAN_ID) {
            return Messages.getString("PlotModel.hyperlink.transaction");
        }
        if (defn == ColumnDefinition.TCLASS_NAME) {
            return Messages.getString("PlotModel.hyperlink.tclass_name");
        }
        if (defn == ColumnDefinition.APPLID) {
            return Messages.getString("PlotModel.hyperlink.applid");
        }
        if (defn == ColumnDefinition.SUBPOOLS_CUR) {
            return Messages.getString("PlotModel.hyperlink.subpools");
        }
        if (defn == ColumnDefinition.UDSA || defn == ColumnDefinition.EUDSA || defn == ColumnDefinition.UDSA) {
            return Messages.getString("PlotModel.hyperlink.tasksubpools");
        }
        return defn.getLabel(null);
    }

    private Object[] getWithPercent(Map<ColumnDefinition, Object> valueMap, ColumnDefinition defn, Object[] objects) {
        String result = DataTypeUtilities.getAsString(objects[0]);
        if ((this.isXMCRecord() || this.isXMGRecord()) && objects[0] instanceof Number) {
            int divisor = ((Number)valueMap.get(this.isXMCRecord() ? ColumnDefinition.ATTACHES_TRANSACTION_CLASS : ColumnDefinition.TRANSACTIONS)).intValue();
            result = String.valueOf(result) + ' ';
            result = String.valueOf(result) + DataTypeUtilities.getPercentageAsInteger(objects[0], divisor);
        }
        objects[0] = result;
        return objects;
    }

    public IPlotViewVariance getApplicableImplementation() {
        if (this.specificImplementation == null) {
            this.specificImplementation = this.isDSARecord() ? new DSAPlotViewVariance(this) : (this.isLDGDSARecord() ? new LDGDSAPlotViewVariance(this) : (this.isSMTRecord() ? new SMTPlotViewVariance(this) : new PlotViewVariance(this)));
        }
        return this.specificImplementation;
    }

    public List<ColumnDefinition> getSettingsDefinitionsB() {
        debug.enter("getSettingsDefinitionsB");
        List<ColumnDefinition> def = Collections.emptyList();
        if (this.isDSGRecord()) {
            def = DISPATCHER_EXPAND_BAR;
        } else if (this.isSMSRecord() || this.isLDGRecord()) {
            def = STORAGE_EXPAND_BAR;
        } else if (this.isMNGRecord()) {
            def = DISPATCHER_EXPAND_MNG;
        }
        debug.exit("getSettingsDefinitionsB", def);
        return def;
    }

    public List<ColumnDefinition> getSettingsDefinitionsA() {
        debug.enter("getSettingsDefinitionsA");
        List<ColumnDefinition> def = Collections.emptyList();
        if (this.isDSGRecord()) {
            def = DISPATCHER_EXPAND_MNG;
        } else if (this.isMNGRecord()) {
            def = MONITORING_EXPAND_MNG;
        }
        debug.exit("getSettingsDefinitionsA", def);
        return def;
    }

    public String getSettingsTextA() {
        if (this.isDSGRecord()) {
            return Messages.getString("Visualisation.Settings.Dispatcher.MNG");
        }
        if (this.isMNGRecord()) {
            return Messages.getString("Visualisation.Settings.Monitoring.MNG");
        }
        return "";
    }

    public String getSettingsTextB() {
        if (this.isDSGRecord()) {
            return Messages.getString("Visualisation.Settings.Dispatcher");
        }
        if (this.isSMSRecord() || this.isLDGRecord()) {
            return Messages.getString("Visualisation.Settings.SMS");
        }
        if (this.isMNGRecord()) {
            return Messages.getString("Visualisation.Settings.Dispatcher.MNG");
        }
        return "";
    }

    public String getTable() {
        if (this.getDataProvider().isRemote()) {
            return ((RemoteEditorInput)this.getDataProvider()).getTable();
        }
        DataProviderKey dk = this.getDataProvider().getDataProviderKey();
        if (dk.name().startsWith("HST")) {
            return dk.name();
        }
        return null;
    }

    public Collection<ColumnDefinition> getPercentagesOf() {
        if (this.percentageReferences == null) {
            this.percentageReferences = new HashSet<ColumnDefinition>();
            for (PlotPoint point : this.getPlotPoints()) {
                if (point.getPercentReference() == null) continue;
                this.percentageReferences.add(point.getPercentReference());
            }
        }
        return this.percentageReferences;
    }

    public boolean isPercentages() {
        return !this.getPercentagesOf().isEmpty();
    }

    public DSAType getDSAType() {
        return this.dsaType;
    }

    public void augmentWith(PlotModel modelAdditional) {
        Object[] additionalRow;
        Object[] currentRow;
        PlotModelElement currentElement;
        int n;
        int n2;
        PlotModelElement[] plotModelElementArray;
        PlotModelElement additionalElement;
        int n3;
        int n4;
        PlotModelElement[] plotModelElementArray2;
        boolean isDirty = false;
        if (this.isLDGDSARecord() && modelAdditional.isLDGDSARecord()) {
            plotModelElementArray2 = modelAdditional.getElements();
            n4 = plotModelElementArray2.length;
            n3 = 0;
            while (n3 < n4) {
                additionalElement = plotModelElementArray2[n3];
                plotModelElementArray = this.getElements();
                n2 = plotModelElementArray.length;
                n = 0;
                while (n < n2) {
                    currentElement = plotModelElementArray[n];
                    if (currentElement.matches(additionalElement)) {
                        for (ColumnDefinition packetDef : additionalElement.getDSAPackets().keySet()) {
                            if (currentElement.getDSAPackets().containsKey(packetDef)) continue;
                            currentElement.getDSAPackets().put(packetDef, additionalElement.getDSAPackets().get(packetDef));
                        }
                        for (String label : additionalElement.getSubMap1().keySet()) {
                            currentRow = currentElement.getSubMap1().get(label);
                            additionalRow = additionalElement.getSubMap1().get(label);
                            if (currentRow != null) continue;
                            currentElement.getSubMap1().put(label, additionalRow);
                            isDirty = true;
                        }
                    }
                    ++n;
                }
                ++n3;
            }
        } else if (this.isLDGRecord() && modelAdditional.isSMSRecord()) {
            plotModelElementArray2 = modelAdditional.getElements();
            n4 = plotModelElementArray2.length;
            n3 = 0;
            while (n3 < n4) {
                additionalElement = plotModelElementArray2[n3];
                plotModelElementArray = this.getElements();
                n2 = plotModelElementArray.length;
                n = 0;
                while (n < n2) {
                    currentElement = plotModelElementArray[n];
                    if (currentElement.matches(additionalElement)) {
                        additionalElement.resolveSMSSubValues(ColumnDefinition.DSA_SIZE_USED);
                        currentElement.valueMap.put(ColumnDefinition.DSA_SIZE_USED, additionalElement.valueMap.get(ColumnDefinition.DSA_SIZE_USED));
                        currentElement.valueMap.put(ColumnDefinition.DSA_SIZE_USED_PERCENT, additionalElement.valueMap.get(ColumnDefinition.DSA_SIZE_USED_PERCENT));
                        currentElement.valueMap.put(ColumnDefinition.EDSA_SIZE_USED, additionalElement.valueMap.get(ColumnDefinition.EDSA_SIZE_USED));
                        currentElement.valueMap.put(ColumnDefinition.EDSA_SIZE_USED_PERCENT, additionalElement.valueMap.get(ColumnDefinition.EDSA_SIZE_USED_PERCENT));
                        for (ColumnDefinition packetDef : additionalElement.getDSAPackets().keySet()) {
                            if (currentElement.getDSAPackets().containsKey(packetDef)) continue;
                            currentElement.getDSAPackets().put(packetDef, additionalElement.getDSAPackets().get(packetDef));
                            isDirty = true;
                        }
                        for (String label : currentElement.getSubMap1().keySet()) {
                            currentRow = currentElement.getSubMap1().get(label);
                            additionalRow = additionalElement.getSubMap1().get(label);
                            additionalRow = Arrays.copyOf(additionalRow, additionalRow.length + 1);
                            additionalRow[additionalRow.length - 1] = currentRow[currentRow.length - 1];
                            currentElement.getSubMap1().put(label, additionalRow);
                            isDirty = true;
                        }
                    }
                    ++n;
                }
                ++n3;
            }
        }
        if (isDirty) {
            for (IModelChangeListener aListener : this.modelListeners) {
                aListener.modelStateChanged();
            }
        }
    }

    public static enum DSAType {
        GDSA,
        EDSA,
        DSA;

    }

    public class PlotModelElement
    implements IPropertySource {
        Map<ColumnDefinition, Object> valueMap;
        private Map<String, Object[]> subMap1;
        private boolean isPercent = false;
        private boolean doneCalculations = false;
        private ColumnDefinition[] headings = null;
        private Map<ColumnDefinition, DSAPacket> dsaPackets = new HashMap<ColumnDefinition, DSAPacket>();
        private AlertElement alert;

        PlotModelElement(Map<ColumnDefinition, Object> map, Map<String, Object[]> subMap1) {
            this.valueMap = map;
            this.subMap1 = subMap1;
        }

        public Map<ColumnDefinition, Object> getValueMap() {
            return this.valueMap;
        }

        public Map<ColumnDefinition, DSAPacket> getDSAPackets() {
            if (this.dsaPackets.isEmpty()) {
                if (PlotModel.this.isSMTRecord()) {
                    this.getSMTSpecificMappings();
                } else if (PlotModel.this.isDSARecord()) {
                    this.getDSASpecificMappings();
                } else if (PlotModel.this.isSMSRecord() || PlotModel.this.isLDGRecord()) {
                    this.getSMSSpecificMappings();
                } else if (PlotModel.this.isLDGDSARecord()) {
                    this.getLDGDSASpecificMappings();
                }
            }
            return this.dsaPackets;
        }

        public ColumnDefinition[] getDSAHeadings() {
            return this.headings;
        }

        private long getDSAHeadingsAndSizeLimit() {
            ColumnDefinition definition;
            Long sizeLimit = 0L;
            ColumnDefinition[] columnDefinitionArray = PluginConstants.DSA;
            int n = PluginConstants.DSA.length;
            int n2 = 0;
            while (n2 < n) {
                definition = columnDefinitionArray[n2];
                if (this.subMap1.keySet().contains(definition.getLabel(null))) {
                    this.headings = PluginConstants.DSA;
                    sizeLimit = this.valueMap.get(ColumnDefinition.DSA_LIMIT) == null ? 0L : ((Number)this.valueMap.get(ColumnDefinition.DSA_LIMIT)).longValue();
                    break;
                }
                ++n2;
            }
            if (this.headings == null) {
                columnDefinitionArray = PluginConstants.GDSA;
                n = PluginConstants.GDSA.length;
                n2 = 0;
                while (n2 < n) {
                    definition = columnDefinitionArray[n2];
                    if (this.subMap1.keySet().contains(definition.getLabel(null))) {
                        this.headings = PluginConstants.GDSA;
                        sizeLimit = this.valueMap.get(ColumnDefinition.MEMLIMIT_SIZE) == null ? 0L : ((Number)this.valueMap.get(ColumnDefinition.MEMLIMIT_SIZE)).longValue();
                        Double limit = (double)sizeLimit.longValue() * 1048576.0;
                        sizeLimit = limit.longValue();
                        break;
                    }
                    ++n2;
                }
            }
            if (this.headings == null) {
                this.headings = PluginConstants.EDSA;
                sizeLimit = this.valueMap.get(ColumnDefinition.EDSA_LIMIT) == null ? 0L : ((Number)this.valueMap.get(ColumnDefinition.EDSA_LIMIT)).longValue();
            }
            return sizeLimit;
        }

        public Map<String, Object[]> getSubMap1() {
            if (PlotModel.this.isDSARecord() && !this.doneCalculations) {
                this.getDSASpecificMappings();
            } else if (PlotModel.this.isLDGDSARecord() && !this.doneCalculations) {
                this.getLDGDSASpecificMappings();
            } else if (PlotModel.this.isSMTRecord() && !this.doneCalculations) {
                this.getSMTSpecificMappings();
            }
            return this.subMap1;
        }

        private void getLDGDSASpecificMappings() {
            long sizeLimit = this.getDSAHeadingsAndSizeLimit();
            this.headings = PlotModel.this.dsaType == DSAType.DSA ? PluginConstants.DSA : PluginConstants.EDSA;
            this.doneCalculations = true;
            int i = PlotModel.this.getSubColumnValueLabel().indexOf(ColumnDefinition.DSA_SIZE_CUR);
            int j = PlotModel.this.getSubColumnValueLabel().indexOf(ColumnDefinition.FREE_STORAGE);
            int k = PlotModel.this.getSubColumnValueLabel().indexOf(ColumnDefinition.DSA_SIZE_USED);
            int l = PlotModel.this.getSubColumnValueLabel().indexOf(ColumnDefinition.DSA_SIZE_USED_PERCENT);
            int m = PlotModel.this.getSubColumnValueLabel().indexOf(ColumnDefinition.DSA_SIZE_PEAK_USED);
            int n = PlotModel.this.getSubColumnValueLabel().indexOf(ColumnDefinition.FREE_AREA_LARGEST_PERCENT);
            int q = PlotModel.this.getSubColumnValueLabel().indexOf(ColumnDefinition.FREE_STORAGE);
            int r = PlotModel.this.getSubColumnValueLabel().indexOf(ColumnDefinition.DSA_SIZE_PEAK);
            int s = PlotModel.this.getSubColumnValueLabel().indexOf(ColumnDefinition.FREE_AREA_LARGEST);
            int t = PlotModel.this.getSubColumnValueLabel().indexOf(ColumnDefinition.PGMS_REMOVED_DPSC);
            int u = PlotModel.this.getSubColumnValueLabel().indexOf(ColumnDefinition.NIU_TIME_TOT);
            int v = PlotModel.this.getSubColumnValueLabel().indexOf(ColumnDefinition.NIU_TIME_AVG);
            int w = PlotModel.this.getSubColumnValueLabel().indexOf(ColumnDefinition.NIU_RECLAIMS);
            int x = PlotModel.this.getSubColumnValueLabel().indexOf(ColumnDefinition.NIU_PROGRAMS);
            int y = PlotModel.this.getSubColumnValueLabel().indexOf(ColumnDefinition.NIU_STORAGE);
            for (String key : this.subMap1.keySet()) {
                ColumnDefinition[] columnDefinitionArray = this.headings;
                int n2 = this.headings.length;
                int n3 = 0;
                while (n3 < n2) {
                    ColumnDefinition defn = columnDefinitionArray[n3];
                    if (defn.getLabel(null).equals(key)) {
                        Object[] row = this.subMap1.get(key);
                        row[k] = (Integer)row[i] - (Integer)row[j];
                        row[l] = DataTypeUtilities.getPercentageAsInteger(row[k], row[i]);
                        row[m] = (Integer)row[r] - (Integer)row[q];
                        row[n] = DataTypeUtilities.getPercentageAsInteger(row[s], row[i]);
                        if (key.endsWith("UDSA") || key.endsWith("TDSA")) {
                            row[t] = "";
                            row[u] = "";
                            row[v] = "";
                            row[w] = "";
                            row[x] = "";
                            row[y] = "";
                        } else {
                            row[v] = DataTypeUtilities.getAverageRatio(row[u], row[t]);
                        }
                        this.dsaPackets.put(defn, new DSAPacket(sizeLimit, key, (Integer)row[i], (Integer)row[k], (String)row[l]));
                    }
                    ++n3;
                }
            }
        }

        private void getDSASpecificMappings() {
            long sizeLimit = this.getDSAHeadingsAndSizeLimit();
            this.doneCalculations = true;
            int rowlength = 0;
            int accumulatorDSA_SIZE_CUR = 0;
            int accumulatorDSA_SIZE_USED = 0;
            int accumulatorCURRENT_EXTENTS = 0;
            int accumulatorSUBPOOLS_CUR = 0;
            int accumulatorCUSHION_RELEASES = 0;
            int accumulatorSOS_COUNT = 0;
            int i = PlotModel.this.getSubColumnValueLabel().indexOf(ColumnDefinition.DSA_SIZE_CUR);
            int j = PlotModel.this.getSubColumnValueLabel().indexOf(ColumnDefinition.FREE_STORAGE);
            int k = PlotModel.this.getSubColumnValueLabel().indexOf(ColumnDefinition.DSA_SIZE_USED);
            int l = PlotModel.this.getSubColumnValueLabel().indexOf(ColumnDefinition.DSA_SIZE_USED_PERCENT);
            int m = PlotModel.this.getSubColumnValueLabel().indexOf(ColumnDefinition.DSA_SIZE_PEAK_USED);
            int n = PlotModel.this.getSubColumnValueLabel().indexOf(ColumnDefinition.FREE_AREA_LARGEST_PERCENT);
            int o = PlotModel.this.getSubColumnValueLabel().indexOf(ColumnDefinition.FREE_AREA_FREE);
            int p = PlotModel.this.getSubColumnValueLabel().indexOf(ColumnDefinition.SOS_TIME_AVERAGE);
            int q = PlotModel.this.getSubColumnValueLabel().indexOf(ColumnDefinition.FREE_STORAGE);
            int r = PlotModel.this.getSubColumnValueLabel().indexOf(ColumnDefinition.DSA_SIZE_PEAK);
            int s = PlotModel.this.getSubColumnValueLabel().indexOf(ColumnDefinition.FREE_AREA_LARGEST);
            int t = PlotModel.this.getSubColumnValueLabel().indexOf(ColumnDefinition.SOS_TIME_TOTAL);
            int u = PlotModel.this.getSubColumnValueLabel().indexOf(ColumnDefinition.SOS_COUNT);
            int v = PlotModel.this.getSubColumnValueLabel().indexOf(ColumnDefinition.CURRENT_EXTENTS);
            int w = PlotModel.this.getSubColumnValueLabel().indexOf(ColumnDefinition.SUBPOOLS_CUR);
            int x = PlotModel.this.getSubColumnValueLabel().indexOf(ColumnDefinition.CUSHION_RELEASES);
            for (String key : this.subMap1.keySet()) {
                ColumnDefinition[] columnDefinitionArray = this.headings;
                int n2 = this.headings.length;
                int n3 = 0;
                while (n3 < n2) {
                    ColumnDefinition defn = columnDefinitionArray[n3];
                    if (defn.getLabel(null).equals(key)) {
                        Object[] row = this.subMap1.get(key);
                        rowlength = row.length;
                        row[k] = (Integer)row[i] - (Integer)row[j];
                        row[l] = DataTypeUtilities.getPercentageAsInteger(row[k], row[i]);
                        row[m] = (Integer)row[r] - (Integer)row[q];
                        row[n] = DataTypeUtilities.getPercentageAsInteger(row[s], row[i]);
                        row[o] = ((Number)row[q]).intValue() == 0 || ((Number)row[s]).intValue() == 0 ? "0.00" : DECIMAL_FORMAT.format(((Number)row[s]).doubleValue() / ((Number)row[q]).doubleValue());
                        row[p] = ((Number)row[u]).intValue() == 0 || ((Number)row[t]).intValue() == 0 ? 0.0 : ((Number)row[t]).doubleValue() / ((Number)row[u]).doubleValue();
                        Time time = new Time(new Double(((Number)row[t]).doubleValue() * 1000.0).longValue());
                        row[t] = PlotModel.this.sdf.format(time);
                        time = new Time(new Double(((Number)row[p]).doubleValue() * 1000.0).longValue());
                        row[p] = PlotModel.this.sdf.format(time);
                        accumulatorDSA_SIZE_CUR += ((Integer)row[i]).intValue();
                        accumulatorDSA_SIZE_USED += ((Integer)row[k]).intValue();
                        accumulatorCURRENT_EXTENTS += ((Integer)row[v]).intValue();
                        accumulatorSUBPOOLS_CUR += ((Integer)row[w]).intValue();
                        accumulatorCUSHION_RELEASES += ((Integer)row[x]).intValue();
                        accumulatorSOS_COUNT += ((Integer)row[u]).intValue();
                        this.dsaPackets.put(defn, new DSAPacket(sizeLimit, key, (Integer)row[i], (Integer)row[k], (String)row[l]));
                    }
                    ++n3;
                }
            }
            Object[] row = new Object[rowlength];
            int ai = 0;
            while (ai < rowlength) {
                row[ai] = "";
                ++ai;
            }
            row[i] = accumulatorDSA_SIZE_CUR;
            row[k] = accumulatorDSA_SIZE_USED;
            row[v] = accumulatorCURRENT_EXTENTS;
            row[w] = accumulatorSUBPOOLS_CUR;
            row[x] = accumulatorCUSHION_RELEASES;
            row[u] = accumulatorSOS_COUNT;
            this.subMap1.put(ColumnDefinition.TOTALS.getLabel(null), row);
        }

        private void getSMTSpecificMappings() {
            long sizeLimit = this.getDSAHeadingsAndSizeLimit();
            this.headings = Arrays.copyOf(this.headings, 2);
            this.doneCalculations = true;
            int i = PlotModel.this.getSubColumnValueLabel().indexOf(ColumnDefinition.DSA_SIZE_CUR);
            int j = PlotModel.this.getSubColumnValueLabel().indexOf(ColumnDefinition.FREE_STORAGE);
            int k = PlotModel.this.getSubColumnValueLabel().indexOf(ColumnDefinition.DSA_SIZE_USED);
            int l = PlotModel.this.getSubColumnValueLabel().indexOf(ColumnDefinition.DSA_SIZE_USED_PERCENT);
            int m = PlotModel.this.getSubColumnValueLabel().indexOf(ColumnDefinition.ELEMENT_STORAGE_AVERAGE);
            int n = PlotModel.this.getSubColumnValueLabel().indexOf(ColumnDefinition.ELEMENT_STORAGE);
            int p = PlotModel.this.getSubColumnValueLabel().indexOf(ColumnDefinition.ELEMENTS);
            int q = PlotModel.this.getSubColumnValueLabel().indexOf(ColumnDefinition.PAGE_STORAGE);
            int r = PlotModel.this.getSubColumnValueLabel().indexOf(ColumnDefinition.PAGE_STORAGE_PERCENT);
            for (String key : this.subMap1.keySet()) {
                ColumnDefinition[] columnDefinitionArray = this.headings;
                int n2 = this.headings.length;
                int n3 = 0;
                while (n3 < n2) {
                    ColumnDefinition defn = columnDefinitionArray[n3];
                    if (defn.getLabel(null).equals(key)) {
                        Object[] row = this.subMap1.get(key);
                        row[k] = (Integer)row[i] - (Integer)row[j];
                        row[l] = DataTypeUtilities.getPercentageAsInteger(row[k], row[i]);
                        row[r] = DataTypeUtilities.getPercentageAsInteger(row[q], row[i]);
                        this.dsaPackets.put(defn, new DSAPacket(sizeLimit, key, (Integer)row[i], (Integer)row[k], (String)row[l]));
                        if ((Integer)row[n] > 0 && (Integer)row[p] > 0) {
                            row[m] = Math.round((Integer)row[n] / (Integer)row[p]);
                        }
                    }
                    ++n3;
                }
            }
        }

        private void getSMSSpecificMappings() {
            long sizeLimit = this.getDSAHeadingsAndSizeLimit();
            this.headings = Arrays.copyOf(this.headings, 5);
            this.doneCalculations = true;
            int i = PlotModel.this.getSubColumnValueLabel().indexOf(ColumnDefinition.DSA_SIZE_CUR);
            int j = PlotModel.this.getSubColumnValueLabel().indexOf(ColumnDefinition.FREE_STORAGE);
            for (String key : this.subMap1.keySet()) {
                ColumnDefinition[] columnDefinitionArray = this.headings;
                int n = this.headings.length;
                int n2 = 0;
                while (n2 < n) {
                    ColumnDefinition defn = columnDefinitionArray[n2];
                    if (defn.getLabel(null).equals(key)) {
                        Object[] row = this.subMap1.get(key);
                        int actualInUse = (Integer)row[i] - (Integer)row[j];
                        String inUseAsPercent = DataTypeUtilities.getPercentageAsInteger(actualInUse, row[i]);
                        this.dsaPackets.put(defn, new DSAPacket(sizeLimit, key, (Integer)row[i], actualInUse, inUseAsPercent));
                    }
                    ++n2;
                }
            }
        }

        public long get(int position) {
            double number = 0.0;
            PlotPoint point = PlotModel.this.plotPoints.get(position);
            ColumnDefinition defn1 = PlotModel.this.plotPoints.get(position).getPlotReference();
            if (this.valueMap.containsKey(defn1)) {
                number = ((Number)this.valueMap.get(defn1)).intValue();
                if (point.isPercentReference()) {
                    ColumnDefinition defn2 = PlotModel.this.plotPoints.get(position).getPercentReference();
                    int divisor = ((Number)this.valueMap.get(defn2)).intValue();
                    number = Math.round(((Number)number).floatValue() / ((Number)divisor).floatValue() * 100.0f);
                    this.isPercent = true;
                }
            }
            return Double.valueOf(number).longValue();
        }

        public boolean isAlert() {
            boolean isA = false;
            if (PlotModel.this.isXMRRecord()) {
                Object strg = this.valueMap.get(ColumnDefinition.STORAGE_VIOLATIONS);
                isA = strg != null && (Integer)strg > 0;
            } else if (PlotModel.this.isSMSRecord() || PlotModel.this.isDSARecord() || PlotModel.this.isSMTRecord() || PlotModel.this.isLDGRecord() || PlotModel.this.isLDGDSARecord()) {
                isA = this.get(1) >= 100L;
            } else if (PlotModel.this.isDSGRecord()) {
                isA = this.getPlotLineArray().length > 0 && this.getPlotLineArray()[0] <= this.get(2);
            } else if (PlotModel.this.plotPoints.size() > 0 && PlotModel.this.plotLines.size() > 0) {
                isA = this.getPlotLineArray()[0] <= this.get(0);
            }
            return isA;
        }

        public Object[] getPlotHeaderData() {
            return new Object[]{this.isAlert(), this.valueMap.get(ColumnDefinition.INTERVAL_NUMBER), this.valueMap.get(ColumnDefinition.START_TIME)};
        }

        public String getTextNumber() {
            Object value = this.valueMap.get(PlotModel.this.intervalDefinitions.getTextValueColumn());
            if (value != null && value instanceof Integer && (Integer)value > 0) {
                return DataTypeUtilities.getAsString(value);
            }
            return null;
        }

        public ColumnDefinition[] getToolTipLabels() {
            if (PlotModel.this.isXMGRecord() || PlotModel.this.isSMTRecord() || PlotModel.this.isMNGRecord()) {
                if (this.isAlert()) {
                    return XMGTooltipA;
                }
                return XMGTooltipB;
            }
            if (PlotModel.this.isXMCRecord()) {
                if (this.isAlert()) {
                    return XMCTooltipA;
                }
                return XMCTooltipB;
            }
            if (PlotModel.this.isXMRRecord()) {
                if (this.isAlert()) {
                    return XMRTooltipA;
                }
                return XMRTooltipB;
            }
            if (PlotModel.this.isDSGRecord()) {
                if (this.isAlert()) {
                    return DispatcherTooltipA;
                }
                return DispatcherTooltipB;
            }
            if (PlotModel.this.isDSARecord() || PlotModel.this.isLDGDSARecord()) {
                return XMGTooltipB;
            }
            if (PlotModel.this.isSMSRecord() || PlotModel.this.isLDGRecord()) {
                return StorageTooltipA;
            }
            return new ColumnDefinition[0];
        }

        public long[] getPlotPointArray() {
            long[] resultset = new long[PlotModel.this.plotPoints.size()];
            int i = 0;
            while (i < PlotModel.this.plotPoints.size()) {
                resultset[i] = this.get(i);
                ++i;
            }
            return resultset;
        }

        public long[] getPlotLineArray() {
            long[] resultset = new long[PlotModel.this.plotLines.size()];
            int i = 0;
            while (i < PlotModel.this.plotLines.size()) {
                resultset[i] = ((Integer)this.getValueMap().get(PlotModel.this.plotLines.get(i))).longValue();
                ++i;
            }
            return resultset;
        }

        public Color getTextNumberColour() {
            return Column.getFor(PlotModel.this.intervalDefinitions.getTextValueColumn()).getColor();
        }

        public PlotModel getParent() {
            return PlotModel.this;
        }

        public AlertElement createElement(ColumnDefinition resource, String columnValue, Comparator comparator, String tableRef) {
            if (resource != null) {
                this.valueMap.put(ColumnDefinition.VRM, PlotModel.this.getVRM());
                return new AlertElement(this.valueMap, resource, columnValue, comparator, tableRef);
            }
            return null;
        }

        public AlertElement createElement(ColumnDefinition resource, Comparator comparator, String tableRef) {
            this.valueMap.put(ColumnDefinition.VRM, PlotModel.this.getVRM());
            return new AlertElement(this.valueMap, resource, this.valueMap.get(resource).toString(), comparator, tableRef);
        }

        public AlertElement createElement() {
            ColumnDefinition[] defns = PlotModel.this.getNext();
            int i = 0;
            while (i < defns.length) {
                if (this.valueMap.get(defns[i]) != null) {
                    return this.createElement(defns[i], (String)this.valueMap.get(defns[i]), Comparator.EQ, defns[i].tableLookup((String)this.valueMap.get(defns[i])));
                }
                ++i;
            }
            return null;
        }

        public String getAccessibleLabel() {
            StringBuffer buffy = new StringBuffer();
            ColumnDefinition[] columnDefinitionArray = this.getParent().getColumnDefinitions();
            int n = columnDefinitionArray.length;
            int n2 = 0;
            while (n2 < n) {
                ColumnDefinition defn = columnDefinitionArray[n2];
                if (buffy.length() > 0) {
                    buffy.append(',');
                    buffy.append(' ');
                }
                buffy.append(defn.getLabel(null));
                buffy.append(' ');
                buffy.append('=');
                buffy.append(' ');
                if (this.getValueMap().containsKey(defn)) {
                    buffy.append(DataTypeUtilities.getAsString(this.getValueMap().get(defn)));
                    buffy.append('.');
                    buffy.append(' ');
                }
                ++n2;
            }
            return buffy.toString();
        }

        public AlertElement getTranAlert() {
            String value = (String)this.valueMap.get(ColumnDefinition.TRAN_ID);
            return new AlertElement(this.valueMap, ColumnDefinition.TRAN_ID, value, Comparator.EQ, ColumnDefinition.TRAN_ID.tableLookup(value));
        }

        public boolean isPercentage() {
            return this.isPercent;
        }

        public Object getEditableValue() {
            return null;
        }

        public IPropertyDescriptor[] getPropertyDescriptors() {
            return ColumnDefinitionHelper.createPropertyDescriptors(this.getParent().getColumnDefinitions());
        }

        public Object getPropertyValue(Object id) {
            ColumnDefinition defn = ColumnDefinition.getByDBColumnRef((String)id);
            return this.getValueMap().get(defn);
        }

        public boolean isPropertySet(Object id) {
            return false;
        }

        public void resetPropertyValue(Object id) {
        }

        public void setPropertyValue(Object id, Object value) {
        }

        public void setNextAlert(AlertElement nextAlert) {
            this.alert = nextAlert;
        }

        public AlertElement getNextAlert() {
            return this.alert;
        }

        public Object resolveSMSSubValues(ColumnDefinition columnDefinition) {
            if (this.valueMap.get(ColumnDefinition.DSA_SIZE_USED) == null || this.valueMap.get(ColumnDefinition.EDSA_SIZE_USED) == null) {
                for (String location : this.getSubMap1().keySet()) {
                    Double used;
                    double j;
                    double i;
                    Object[] values;
                    if (location.equals(PluginConstants.BELOW)) {
                        values = this.getSubMap1().get(location);
                        i = (Double)values[1];
                        j = ((Number)values[2]).doubleValue();
                        used = i - j;
                        this.valueMap.put(ColumnDefinition.DSA_SIZE_USED, used);
                        this.valueMap.put(ColumnDefinition.DSA_SIZE_USED_PERCENT, DataTypeUtilities.getPercentageAsInteger(used, i));
                        continue;
                    }
                    if (location.equals(PluginConstants.ABOVE)) {
                        values = this.getSubMap1().get(location);
                        i = (Double)values[1];
                        j = ((Number)values[2]).doubleValue();
                        used = i - j;
                        this.valueMap.put(ColumnDefinition.EDSA_SIZE_USED, used);
                        this.valueMap.put(ColumnDefinition.EDSA_SIZE_USED_PERCENT, DataTypeUtilities.getPercentageAsInteger(used, i));
                        continue;
                    }
                    if (!location.equals(PluginConstants.ABOVEBAR)) continue;
                    values = this.getSubMap1().get(location);
                    i = (Double)values[1];
                    if (i / (j = ((Number)values[2]).doubleValue()) > 1048576.0 && values[2] instanceof Integer) {
                        j *= 1048576.0;
                    }
                    used = i - j;
                    this.valueMap.put(ColumnDefinition.GDSA_SIZE_USED_PERCENT, DataTypeUtilities.getPercentageAsInteger(used, i));
                    used = used / 1048576.0;
                    Math.round(used);
                    this.valueMap.put(ColumnDefinition.GDSA_SIZE_USED, Math.round(Math.round(used)));
                }
            }
            return this.valueMap.get(columnDefinition);
        }

        public Object resolveLDGSubValues(ColumnDefinition columnDefinition) {
            if (this.valueMap.get(ColumnDefinition.DSA_SIZE_PGMS) == null || this.valueMap.get(ColumnDefinition.EDSA_SIZE_PGMS) == null) {
                for (String location : this.getSubMap1().keySet()) {
                    Double used;
                    double j;
                    double i;
                    Number total;
                    Object[] values;
                    if (location.equals(PluginConstants.BELOW)) {
                        values = this.getSubMap1().get(location);
                        total = (Number)this.valueMap.get(ColumnDefinition.DSA_CURRENT_TOTAL);
                        this.valueMap.put(ColumnDefinition.DSA_SIZE_PGMS, values[values.length - 1]);
                        this.valueMap.put(ColumnDefinition.DSA_SIZE_PGMS_PERCENT, DataTypeUtilities.getPercentageAsInteger(values[values.length - 1], total));
                        if (values.length <= 3) continue;
                        i = (Double)values[1];
                        j = ((Number)values[2]).doubleValue();
                        used = i - j;
                        this.valueMap.put(ColumnDefinition.DSA_SIZE_USED, used);
                        this.valueMap.put(ColumnDefinition.DSA_SIZE_USED_PERCENT, DataTypeUtilities.getPercentageAsInteger(used, i));
                        continue;
                    }
                    if (!location.equals(PluginConstants.ABOVE)) continue;
                    values = this.getSubMap1().get(location);
                    total = (Number)this.valueMap.get(ColumnDefinition.EDSA_CURRENT_TOTAL);
                    this.valueMap.put(ColumnDefinition.EDSA_SIZE_PGMS, values[values.length - 1]);
                    this.valueMap.put(ColumnDefinition.EDSA_SIZE_PGMS_PERCENT, DataTypeUtilities.getPercentageAsInteger(values[values.length - 1], total));
                    if (values.length <= 3) continue;
                    i = (Double)values[1];
                    j = ((Number)values[2]).doubleValue();
                    used = i - j;
                    this.valueMap.put(ColumnDefinition.EDSA_SIZE_USED, used);
                    this.valueMap.put(ColumnDefinition.EDSA_SIZE_USED_PERCENT, DataTypeUtilities.getPercentageAsInteger(used, i));
                }
            }
            return this.valueMap.get(columnDefinition);
        }

        public boolean matches(PlotModelElement compareElement) {
            return this.valueMap.get(ColumnDefinition.START_DATE).equals(compareElement.valueMap.get(ColumnDefinition.START_DATE)) && this.valueMap.get(ColumnDefinition.START_TIME).equals(compareElement.valueMap.get(ColumnDefinition.START_TIME)) && this.valueMap.get(ColumnDefinition.INTERVAL_NUMBER).equals(compareElement.valueMap.get(ColumnDefinition.INTERVAL_NUMBER)) && this.valueMap.get(ColumnDefinition.APPLID).equals(compareElement.valueMap.get(ColumnDefinition.APPLID)) && this.valueMap.get(ColumnDefinition.MVSID).equals(compareElement.valueMap.get(ColumnDefinition.MVSID)) && this.valueMap.get(ColumnDefinition.VRM).equals(compareElement.valueMap.get(ColumnDefinition.VRM)) && this.valueMap.get(ColumnDefinition.INTERVAL_DURATION).equals(compareElement.valueMap.get(ColumnDefinition.INTERVAL_DURATION)) && this.valueMap.get(ColumnDefinition.INTERVAL_TYPE).equals(compareElement.valueMap.get(ColumnDefinition.INTERVAL_TYPE));
        }

        public class DSAPacket {
            long memlimit;
            String defn;
            int size;
            int used;
            String percent;

            public DSAPacket(long memlimit, String label, int size, int used, String percent) {
                this.memlimit = memlimit;
                this.defn = label;
                this.size = size;
                this.used = used;
                this.percent = percent;
            }

            public String toString() {
                return String.valueOf(this.defn) + " size " + this.size + " used " + this.used + " limit " + this.memlimit;
            }

            public long getMemlimit() {
                return this.memlimit;
            }

            public String getDefnlabel() {
                return this.defn;
            }

            public int getSize() {
                return this.size;
            }

            public int getUsed() {
                return this.used;
            }

            public String getPercent() {
                return this.percent;
            }
        }
    }
}

